/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class SimpleMapper
extends AttributeMapper {
    private IAttribute fAttribute;

    public SimpleMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    protected abstract Object findValue(String var1);

    protected abstract boolean isAccurate(BugzillaMapping.ValueMapping var1, String var2);

    protected IAttribute getAttribute() {
        return this.fAttribute;
    }

    public XMLString copy(IWorkItem workItem, ReportData data, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fAttribute == null || !this.fAttribute.getProjectArea().sameItemId((IItemHandle)workItem.getProjectArea())) {
            this.fAttribute = this.getAttributeMapping().resolveTargetAttribute(workItem.getProjectArea(), monitor);
        }
        if (this.fAttribute == null) {
            return null;
        }
        String sourceValue = data.getString(this.getAttributeMapping().getSourceId());
        if (sourceValue == null) {
            return null;
        }
        BugzillaMapping.ValueMapping valueMapping = this.getValueMapping(sourceValue);
        String targetValueId = valueMapping != null ? valueMapping.getTargetId() : sourceValue;
        Object targetValue = this.findValue(targetValueId);
        if (!workItem.hasAttribute(this.fAttribute)) {
            workItem.addCustomAttribute(this.fAttribute);
        }
        workItem.setValue(this.fAttribute, targetValue);
        if (!this.isAccurate(valueMapping, targetValueId)) {
            return XMLString.createFromPlainText((String)NLS.bind((String)Messages.getString(localization, "EnumerationMapper_ATTRIBUTE_WAS_VALUE"), (Object[])new Object[]{this.fAttribute.getDisplayName(), sourceValue}));
        }
        return null;
    }
}

