/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.importer;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemOperation;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.model.Comment;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.DependenciesResolver;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.Messages;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaBugNumbersResolver {
    public static final String COMMENT_DUPOF_BEGIN_PATTERN = "*** This bug has been marked as a duplicate of ";
    public static final String COMMENT_DUPOF_END_PATTERN = " ***";
    public static final String COMMENT_HASDUPS_BEGIN_PATTERN = "*** Bug ";
    public static final String COMMENT_HASDUPS_END_PATTERN = " has been marked as a duplicate of this bug. ***";
    private Pattern BUG_IMPORT_PATTERN = Pattern.compile("([Bb][Uu][Gg]#?\\s)(\\d+)");
    private Pattern INTEGER_BUGNUMBER = Pattern.compile("(\\d+)");
    private Pattern DUPOF = Pattern.compile("\\Q*** This bug has been marked as a duplicate of \\E(bug)? (.+)\\Q ***\\E");
    private Pattern HASDUP = Pattern.compile("\\Q*** Bug \\E(.+)\\Q has been marked as a duplicate of this bug. ***\\E");
    private Map fBugIdWorkItemIdMap = new HashMap();
    private Map<String, Set<IWorkItemHandle>> fWorkItemsThatHaveReferencesMap = new HashMap<String, Set<IWorkItemHandle>>();
    private ITeamRepository fTeamRepository;
    private String fServerUrl = null;

    public BugzillaBugNumbersResolver(ITeamRepository teamRepository, String serverUrl) {
        this.fTeamRepository = teamRepository;
        this.fServerUrl = serverUrl;
    }

    private String getServerUrl() throws BugzillaException {
        return this.fServerUrl;
    }

    public void addToCache(WorkItemWorkingCopy workingCopy, Set<String> unresolvedIds) throws TeamRepositoryException {
        this.addToWaiting(workingCopy.getWorkItem(), unresolvedIds);
        IWorkItemClient workItemClient = (IWorkItemClient)this.fTeamRepository.getClientLibrary(IWorkItemClient.class);
        String id = DependenciesResolver.getAttributeValue(workingCopy, workItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), "com.ibm.team.workitem.rcp.core.url", null));
        this.fBugIdWorkItemIdMap.put(id, new Long(workingCopy.getWorkItem().getId()));
        if (this.hasWaiting(id)) {
            this.resolveWaiting(id);
        }
    }

    private void resolveWaiting(final String id) throws TeamRepositoryException {
        if (this.fWorkItemsThatHaveReferencesMap.containsKey(id)) {
            Set<IWorkItemHandle> handles = this.fWorkItemsThatHaveReferencesMap.get(id);
            ItemProfile profile = ItemProfile.createFullProfile((IItemType)IWorkItem.ITEM_TYPE);
            WorkItemOperation operation = new WorkItemOperation(Messages.BugzillaBugNumbersResolver_RESOLVING_WORK_ITEM_IDS, profile){

                protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
                    BugzillaBugNumbersResolver.this.rewriteAbsoluteBugzillaIds(workingCopy.getWorkItem(), id);
                }
            };
            operation.run(handles.toArray(new IWorkItemHandle[handles.size()]), null);
        }
    }

    private boolean hasWaiting(String id) {
        return this.fWorkItemsThatHaveReferencesMap.containsKey(id);
    }

    public String rewriteBugzillaIds(Set<String> unresolvedIds, IWorkItem item, String text) throws TeamRepositoryException, BugzillaException {
        text = this.preFormatDuplicateCommentForRewriting(text);
        Matcher matcher = this.BUG_IMPORT_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String bugNrString = text.substring(matcher.start(1), matcher.end(1));
            String stringId = text.substring(matcher.start(2), matcher.end(2));
            String newId = this.rewriteId(stringId);
            matcher.appendReplacement(sb, String.valueOf(bugNrString) + newId);
            if (!this.isUnresolvedBugzillaId(newId)) continue;
            unresolvedIds.add(newId);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private void rewriteAbsoluteBugzillaIds(IWorkItem item, String id) throws TeamRepositoryException {
        String newId = String.valueOf(this.getWorkitemId(id));
        IComment[] comments = item.getComments().getContents();
        int i = 0;
        while (i < comments.length) {
            IComment comment = comments[i];
            String commentString = comment.getHTMLContent().getXMLText();
            if (commentString.indexOf(id) != -1) {
                String newCommentString = this.replace(id, newId, commentString);
                ((Comment)comment).setContent(newCommentString);
            }
            ++i;
        }
        String summary = item.getHTMLSummary().getXMLText();
        item.setHTMLSummary(XMLString.createFromXMLText((String)this.replace(id, newId, summary)));
        String description = item.getHTMLDescription().getXMLText();
        item.setHTMLDescription(XMLString.createFromXMLText((String)this.replace(id, newId, description)));
    }

    private String replace(String id, String newId, String text) {
        String tempId = id.replaceAll("\\Q?\\Eid=", "id=");
        String tempComment = text.replaceAll("\\Q?\\Eid=", "id=");
        String newCommentString = tempComment.replaceAll(tempId, newId);
        newCommentString = newCommentString.replaceAll("id=", "?id=");
        return newCommentString;
    }

    private void addToWaiting(IWorkItem item, Set<String> unresolvedIds) throws TeamRepositoryException {
        IWorkItemHandle handle = (IWorkItemHandle)item.getItemHandle();
        for (String id : unresolvedIds) {
            ItemHandleAwareHashSet handles = this.fWorkItemsThatHaveReferencesMap.get(id);
            if (handles == null) {
                handles = new ItemHandleAwareHashSet();
                this.fWorkItemsThatHaveReferencesMap.put(id, (Set<IWorkItemHandle>)handles);
            }
            handles.add((IWorkItemHandle)handle);
        }
    }

    private String rewriteId(String stringId) throws BugzillaException {
        Long workitemId = this.getWorkitemId(String.valueOf(this.getServerUrl()) + stringId);
        if (workitemId != null) {
            return String.valueOf(workitemId);
        }
        return String.valueOf(this.getServerUrl()) + stringId;
    }

    private boolean isUnresolvedBugzillaId(String id) throws BugzillaException {
        return id.startsWith(this.getServerUrl());
    }

    private Long getWorkitemId(String bugzillaID) {
        if (this.fBugIdWorkItemIdMap.containsKey(bugzillaID)) {
            return (Long)this.fBugIdWorkItemIdMap.get(bugzillaID);
        }
        return null;
    }

    private String preFormatDuplicateCommentForRewriting(String text) {
        int index = text.indexOf(COMMENT_DUPOF_BEGIN_PATTERN);
        if (index >= 0) {
            String searchFor = "duplicate of";
            String replaceWith = String.valueOf(searchFor) + " bug";
            text = text.replaceAll(searchFor, replaceWith);
        }
        return text;
    }

    public String getDuplicateBugId(IComment[] comments) throws TeamRepositoryException {
        String isDupOf = null;
        int i = 0;
        while (i < comments.length) {
            IComment comment = comments[i];
            String commentString = comment.getHTMLContent().getPlainText();
            if (commentString.lastIndexOf(COMMENT_DUPOF_BEGIN_PATTERN) >= 0) {
                Matcher matcher = this.DUPOF.matcher(commentString);
                while (matcher.find()) {
                    isDupOf = this.getBugzillaId(commentString.substring(matcher.start(2), matcher.end(2)));
                }
            }
            ++i;
        }
        return isDupOf;
    }

    private String getBugzillaId(String id) {
        Matcher matcher = this.INTEGER_BUGNUMBER.matcher(id);
        if (matcher.matches()) {
            return this.getBugzillaId(Long.valueOf(id));
        }
        return id;
    }

    public String getBugzillaId(Long workItemID) {
        if (this.fBugIdWorkItemIdMap.containsValue(workItemID)) {
            for (String key : this.fBugIdWorkItemIdMap.keySet()) {
                Long value = (Long)this.fBugIdWorkItemIdMap.get(key);
                if (!value.equals(workItemID)) continue;
                return key;
            }
        }
        return null;
    }

    public String getDuplicatesOfBug(IComment[] comments) {
        LinkedHashSet<String> dups = new LinkedHashSet<String>();
        int i = 0;
        while (i < comments.length) {
            IComment comment = comments[i];
            String commentString = comment.getHTMLContent().getPlainText();
            if (commentString.lastIndexOf(COMMENT_HASDUPS_BEGIN_PATTERN) >= 0) {
                String tempComment = commentString.replaceAll("\\Q?\\Eid=", "id=");
                Matcher matcher = this.HASDUP.matcher(tempComment);
                while (matcher.find()) {
                    String newCommentString = tempComment.substring(matcher.start(1), matcher.end(1)).replaceAll("id=", "?id=");
                    dups.add(this.getBugzillaId(newCommentString));
                }
            }
            ++i;
        }
        return this.createSpaceSeparatedStringFromSet(dups);
    }

    private String createSpaceSeparatedStringFromSet(Set urlids) {
        String duplicates = null;
        Iterator iter = urlids.iterator();
        if (iter.hasNext()) {
            duplicates = "";
        }
        while (iter.hasNext()) {
            duplicates = String.valueOf(duplicates) + (String)iter.next();
            if (!iter.hasNext()) continue;
            duplicates = String.valueOf(duplicates) + " ";
        }
        return duplicates;
    }

    public void setServerUrl(String serverUrl) {
        this.fServerUrl = serverUrl;
    }
}

