/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.http;

import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Base64Encoder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.IProgressMonitor;

public class HTTPConnection {
    private static final String HTTP_STATUS_AUTH_REQUIRED = "401";
    private String fContentType;
    private BugzillaConfiguration fConfiguration;

    public HTTPConnection(BugzillaConfiguration conf) {
        this.fConfiguration = conf;
    }

    public String getString(IProgressMonitor monitor, String url) throws BugzillaException {
        try {
            try {
                return this.getString(url, HttpUtil.CharsetEncoding.UTF8.toString(), monitor);
            }
            catch (CharConversionException charConversionException) {
                return this.getString(url, HttpUtil.CharsetEncoding.ISO8859.toString(), monitor);
            }
        }
        catch (IOException e) {
            HTTPConnection.handleError(e);
            return null;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getString(String url, String charset, IProgressMonitor monitor) throws UnsupportedEncodingException, BugzillaException, IOException {
        StringWriter stringWriter = new StringWriter();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getInputStream(url), charset));
        PrintWriter writer = new PrintWriter(stringWriter);
        try {
            block6: {
                String line;
                block5: {
                    if (!true) break block5;
                    line = in.readLine();
                    if (line == null) return stringWriter.toString();
                    if (monitor.isCanceled()) break block6;
                }
                do {
                    writer.println(line);
                    line = in.readLine();
                    if (line == null) return stringWriter.toString();
                } while (!monitor.isCanceled());
            }
            return stringWriter.toString();
        }
        finally {
            in.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytes(IProgressMonitor monitor, String url) throws BugzillaException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = this.getInputStream(url);
        try {
            try {
                while (true) {
                    int c = in.read();
                    if (c == -1) return out.toByteArray();
                    if (monitor.isCanceled()) {
                        return out.toByteArray();
                    }
                    out.write(c);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            HTTPConnection.handleError(e);
        }
        return out.toByteArray();
    }

    public InputStream getInputStream(String url) throws BugzillaException {
        URL urlObj = null;
        URLConnection urlCon = null;
        try {
            urlObj = new URL(url);
            urlCon = urlObj.openConnection();
        }
        catch (IOException e) {
            HTTPConnection.handleError(e);
        }
        HTTPConnection.setupLazySSLSupport(urlCon);
        urlCon.setRequestProperty("Accept-Encoding", "gzip, *");
        if (this.fConfiguration.isNeedsAuthentication()) {
            if (!this.fConfiguration.isBasicHTTPAuthentication()) {
                urlCon.setRequestProperty("Cookie", this.fConfiguration.getLoginCookie());
            } else {
                String authValue = String.valueOf(this.fConfiguration.getUsername()) + ":" + this.fConfiguration.getPassword();
                String encodedAuthValue = new String(Base64Encoder.encode(authValue.getBytes()));
                urlCon.setRequestProperty("Authorization", "Basic " + encodedAuthValue);
            }
        }
        try {
            urlCon.connect();
            InputStream stream = urlCon.getInputStream();
            String status = urlCon.getHeaderField(0);
            if (this.fConfiguration.isBasicHTTPAuthentication() && status != null && status.indexOf(HTTP_STATUS_AUTH_REQUIRED) >= 0) {
                throw new BugzillaException(101, com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Messages.CookieLoginOperation_LOGIN_FAILED);
            }
            this.setContentType(urlCon.getContentType());
            return HTTPConnection.compressConnection(urlCon, stream);
        }
        catch (IOException e) {
            HTTPConnection.handleError(e);
            return null;
        }
    }

    public String getContentType() {
        return this.fContentType;
    }

    public void setContentType(String type) {
        this.fContentType = type;
    }

    public static void setupLazySSLSupport(URLConnection urlConnection) {
        if (!(urlConnection instanceof HttpsURLConnection)) {
            return;
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostname, SSLSession sslSession) {
                return true;
            }
        };
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {}
        if (sc != null) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sc.getSocketFactory());
        }
        ((HttpsURLConnection)urlConnection).setHostnameVerifier(hv);
    }

    private static InputStream compressConnection(URLConnection urlCon, InputStream inputStream) throws BugzillaException {
        String contentEncoding = urlCon.getHeaderField("Content-Encoding") != null ? urlCon.getHeaderField("Content-Encoding") : null;
        boolean isGzipStream = false;
        if (!(contentEncoding != null && contentEncoding.equals("gzip") || inputStream != null && inputStream.markSupported())) {
            return inputStream;
        }
        if (contentEncoding != null && contentEncoding.equals("gzip")) {
            isGzipStream = true;
        } else if (inputStream != null && inputStream.markSupported()) {
            inputStream.mark(2);
            int id1 = 0;
            int id2 = 0;
            try {
                id1 = inputStream.read();
                id2 = inputStream.read();
                inputStream.reset();
            }
            catch (IOException e) {
                HTTPConnection.handleError(e);
            }
            if (id1 == 31 && id2 == 139) {
                isGzipStream = true;
            }
        }
        if (isGzipStream) {
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (IOException e) {
                HTTPConnection.handleError(e);
            }
        }
        return inputStream;
    }

    private static void handleError(Exception e) throws BugzillaException {
        if (e instanceof MalformedURLException) {
            throw new BugzillaException(101, e.getLocalizedMessage(), e);
        }
        if (e instanceof UnknownHostException) {
            throw new BugzillaException(101, e.getLocalizedMessage(), e);
        }
        if (e instanceof FileNotFoundException) {
            throw new BugzillaException(101, e.getLocalizedMessage(), e);
        }
        throw new BugzillaException(101, Messages.Messages_EXCEPTION_CONTACTING_BUGZILLA, e);
    }
}

