/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.http;

import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.HTTPConnection;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.QueryData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentDescription;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.Parser;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.QueryHandler;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.QueryURL;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaOperations {
    public static BugzillaOperations getOperations() {
        return new BugzillaOperations();
    }

    public String downloadReportData(IProgressMonitor monitor, BugzillaConfiguration configuration, String id) throws BugzillaException, IOException {
        monitor.subTask(com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Messages.BugzillaOperations_RETRIEVING_BUG);
        try {
            String xml;
            String url = String.valueOf(configuration.getBaseURL()) + "xml.cgi?id=" + id.trim();
            HTTPConnection connection = new HTTPConnection(configuration);
            String string = xml = connection.getString(monitor, url);
            return string;
        }
        finally {
            monitor.done();
        }
    }

    public ReportData parseReport(Integer nr, String xml) throws BugzillaException {
        if (!xml.contains("<bugzilla")) {
            throw new BugzillaException(Messages.getBugMessage(nr, com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.Messages.Parser_UNEXPECTED_CONTENT), null);
        }
        ReportHandler handler = new ReportHandler();
        new Parser(false, false).parse(nr, xml, handler);
        return handler.getReportData();
    }

    public AttachmentData getAttachment(IProgressMonitor monitor, BugzillaConfiguration configuration, AttachmentDescription desc) throws BugzillaException, IOException {
        monitor.subTask(com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Messages.BugzillaOperations_RETRIEVING_ATTACHMENT);
        try {
            String id = desc.getString("0").trim();
            String url = this.getAttachmentURL(configuration, id);
            HTTPConnection connection = new HTTPConnection(configuration);
            AttachmentData attachment = new AttachmentData();
            attachment.data = connection.getBytes(monitor, url);
            this.parse(connection.getContentType(), attachment);
            AttachmentData attachmentData = attachment;
            return attachmentData;
        }
        finally {
            monitor.done();
        }
    }

    private String parse(String contentType, AttachmentData data) throws BugzillaException {
        String charset;
        String name;
        Map<String, String> map = BugzillaOperations.readContentType(contentType);
        String mime = map.get(null);
        if (mime == null) {
            mime = "";
        }
        if ((name = map.get("name")) == null) {
            name = "";
        }
        if ((charset = map.get("charset")) == null) {
            charset = "";
        }
        data.set("1", mime);
        data.set("0", name);
        data.set("2", charset);
        return name;
    }

    /*
     * Unable to fully structure code
     */
    private static Map<String, String> readContentType(String contentType) {
        block7: {
            map = new HashMap<String, String>();
            keyBegin = contentType.indexOf(59);
            mime = keyBegin != -1 ? contentType.substring(0, keyBegin) : contentType;
            map.put(null, mime);
            if (keyBegin == -1) break block7;
            ++keyBegin;
            ** GOTO lbl35
            {
                if (++keyBegin >= contentType.length()) {
                    return map;
                }
                do {
                    if (Character.isWhitespace(contentType.charAt(keyBegin))) continue block0;
                    keyEnd = keyBegin;
                    while (contentType.charAt(keyEnd) != '=') {
                        if (++keyEnd < contentType.length()) continue;
                        return map;
                    }
                    valueBegin = keyEnd + 1;
                    valueEndChar = ';';
                    if (valueBegin < contentType.length() && contentType.charAt(valueBegin) == '\"') {
                        valueEndChar = '\"';
                    }
                    valueEnd = ++valueBegin;
                    while (valueEnd < contentType.length() && contentType.charAt(valueEnd) != valueEndChar) {
                        ++valueEnd;
                    }
                    key = contentType.substring(keyBegin, keyEnd);
                    value = contentType.substring(valueBegin, valueEnd);
                    map.put(key, value);
                    keyBegin = valueEnd;
                    while (keyBegin < contentType.length() && contentType.charAt(keyBegin) != ';') {
                        ++keyBegin;
                    }
                    if (keyBegin >= contentType.length()) continue;
                    ++keyBegin;
lbl35:
                    // 3 sources

                } while (keyBegin < contentType.length());
            }
        }
        return map;
    }

    public String getReportURL(BugzillaConfiguration configuration, String reportID) {
        return String.valueOf(configuration.getBaseURL()) + "show_bug.cgi?id=" + reportID.trim();
    }

    public String getAttachmentURL(BugzillaConfiguration configuration, String attachmentID) {
        return String.valueOf(configuration.getBaseURL()) + "attachment.cgi?id=" + attachmentID;
    }

    public QueryData getQueryData(IProgressMonitor monitor, BugzillaConfiguration configuration, QueryURL queryURL) throws BugzillaException {
        QueryHandler handler = new QueryHandler();
        if (queryURL.isNamedQuery() && configuration.getLoginCookie() == null) {
            throw new BugzillaException(105, com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Messages.BugzillaOperations_PLEASE_LOG_IN);
        }
        HTTPConnection connection = new HTTPConnection(configuration);
        String xml = connection.getString(monitor, queryURL.getUrl(configuration));
        new Parser(false, false).parse(null, xml, handler);
        return handler.getQueryData();
    }
}

