/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal;

import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.ClientModelRoot;
import com.ibm.team.workitem.rcp.core.CoreFactory;
import com.ibm.team.workitem.rcp.core.CorePackage;
import com.ibm.team.workitem.rcp.core.internal.activation.WorkItemActivationManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.framework.BundleContext;

public class WorkItemRCPCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.ibm.team.workitem.rcp.core";
    private static final String DB_FILE = "clientdb.xml";
    private static final int INTERNAL_ERROR = 1;
    private static WorkItemRCPCorePlugin fgDefault;
    private ClientModelRoot fClientModelRoot;
    private boolean fIsStopped;
    private Object fStoreMutex = new Object();

    public static WorkItemRCPCorePlugin getDefault() {
        return fgDefault;
    }

    public WorkItemRCPCorePlugin() {
        if (fgDefault != null) {
            try {
                throw new Exception("Constructor of WorkItemRCPCorePlugin is called more than once");
            }
            catch (Exception e) {
                this.log(e);
            }
        } else {
            fgDefault = this;
        }
    }

    public void stop(BundleContext context) throws Exception {
        WorkItemActivationManager manager = WorkItemActivationManager.getInstance();
        manager.saveActivationHistory();
        manager.saveActiveWorkItem();
        this.fIsStopped = true;
        this.storeClientModel();
        fgDefault = null;
        ClientModel.dispose();
    }

    public boolean isStopped() {
        return this.fIsStopped;
    }

    public ClientModelRoot getModelRoot() {
        if (this.fClientModelRoot == null) {
            this.fClientModelRoot = this.load(this.getURI());
        }
        return this.fClientModelRoot;
    }

    private java.net.URI getURI() {
        return WorkItemRCPCorePlugin.getURI(DB_FILE);
    }

    public static java.net.URI getURI(String fileName) {
        URL location = Platform.getInstanceLocation().getURL();
        try {
            if (location != null) {
                StringBuffer buffer = new StringBuffer(256);
                buffer.append(location.getPath());
                if (buffer.charAt(buffer.length() - 1) != '/') {
                    buffer.append("/");
                }
                buffer.append(fileName);
                return new java.net.URI("file", buffer.toString(), null);
            }
        }
        catch (URISyntaxException x) {
            throw new RuntimeException(x);
        }
        return null;
    }

    public ClientModelRoot load(java.net.URI uri) {
        ClientModelRoot modelRoot = null;
        Assert.isNotNull((Object)CorePackage.eINSTANCE);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)uri.toString()));
        try {
            resource.load(null);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException x) {
            WorkItemRCPCorePlugin.getDefault().log(x);
        }
        catch (ClassCastException x) {
            WorkItemRCPCorePlugin.getDefault().log(x);
        }
        EList contents = resource.getContents();
        if (contents.size() > 0 && contents.get(0) instanceof ClientModelRoot) {
            modelRoot = (ClientModelRoot)contents.get(0);
        }
        CoreFactory factory = CoreFactory.eINSTANCE;
        if (modelRoot == null) {
            modelRoot = factory.createClientModelRoot();
        }
        this.initialize(factory, modelRoot);
        return modelRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeClientModel() {
        try {
            Object object = this.fStoreMutex;
            synchronized (object) {
                this.store(this.getURI(), this.getModelRoot());
            }
        }
        catch (IOException e) {
            this.log("Could not save ClientModel", e);
        }
    }

    public void store(java.net.URI uri, ClientModelRoot root) throws IOException {
        if (ClientModel.isQueriesManagerInitialized()) {
            ClientModel.getQueriesManager().prepareStore();
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)uri.toString()));
        Assert.isTrue((boolean)(root instanceof EObject));
        resource.getContents().add((Object)((EObject)root));
        HashMap<String, String> options = new HashMap<String, String>(1);
        options.put("ENCODING", "UTF-8");
        resource.save(options);
    }

    public void wipe() {
        CoreFactory factory = CoreFactory.eINSTANCE;
        this.fClientModelRoot = factory.createClientModelRoot();
        this.initialize(factory, this.fClientModelRoot);
    }

    private void initialize(CoreFactory factory, ClientModelRoot modelRoot) {
        if (modelRoot.getWorkItemEditorHistory() == null) {
            modelRoot.setWorkItemEditorHistory(factory.createWorkItemEditorHistory());
        }
        if (modelRoot.getQueries() == null) {
            modelRoot.setQueries(factory.createQueries());
        }
        if (modelRoot.getQueryViews() == null) {
            modelRoot.setQueryViews(factory.createQueryViews());
        }
    }

    public void log(Throwable x) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 1, "Internal Error", x));
    }

    public void log(IStatus status) {
        FoundationLog.log((IStatus)status);
    }

    public void log(String message, Throwable x) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 0, message, x));
    }

    public void reloadClientModel(java.net.URI uri) {
        this.fClientModelRoot = this.load(uri);
    }
}

