/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.lang.reflect.Method;
import org.eclipse.core.internal.runtime.CompatibilityHelper$$Cold;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class CompatibilityHelper {
    private static final String OPTION_DEBUG_COMPATIBILITY = "org.eclipse.core.runtime/compatibility/debug";
    public static final boolean DEBUG = Boolean.TRUE.toString().equalsIgnoreCase(InternalPlatform.getDefault().getOption("org.eclipse.core.runtime/compatibility/debug"));
    public static final String PI_RUNTIME_COMPATIBILITY = "org.eclipse.core.runtime.compatibility";
    private static Bundle compatibility = null;
    static Class class$0;
    static Class class$1;

    public static synchronized void nullCompatibility() {
        compatibility = null;
    }

    public static synchronized Bundle initializeCompatibility() {
        if (compatibility == null || (compatibility.getState() & 0x13) != 0) {
            compatibility = InternalPlatform.getDefault().getBundle(PI_RUNTIME_COMPATIBILITY);
        }
        return compatibility;
    }

    public static void setPlugin(IPluginDescriptor iPluginDescriptor, Plugin plugin) throws  {
        CompatibilityHelper$$Cold.setPlugin(iPluginDescriptor, plugin);
    }

    public static synchronized IPluginDescriptor getPluginDescriptor(String string) {
        CompatibilityHelper.initializeCompatibility();
        if (compatibility == null) {
            throw (Throwable)new IllegalStateException();
        }
        Class clazz = null;
        try {
            clazz = compatibility.loadClass("org.eclipse.core.internal.plugins.InternalPlatform");
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("getPluginDescriptor", classArray);
            return (IPluginDescriptor)method.invoke((Object)clazz, string);
        }
        catch (Exception exception) {
            if (DEBUG) {
                String string2 = "Error running compatibility code";
                Status status = new Status(4, "org.eclipse.core.runtime", 1, string2, (Throwable)exception);
                InternalPlatform.getDefault().log((IStatus)status);
            }
            return null;
        }
    }

    public static synchronized void setActive(IPluginDescriptor iPluginDescriptor) {
        CompatibilityHelper.initializeCompatibility();
        if (compatibility == null) {
            throw (Throwable)new IllegalStateException();
        }
        try {
            Method method = iPluginDescriptor.getClass().getMethod("setActive", null);
            method.invoke((Object)iPluginDescriptor, null);
        }
        catch (Exception exception) {}
    }

    public static synchronized boolean hasPluginObject(IPluginDescriptor iPluginDescriptor) {
        CompatibilityHelper.initializeCompatibility();
        if (compatibility == null) {
            throw (Throwable)new IllegalStateException();
        }
        Boolean bl = Boolean.FALSE;
        try {
            Method method = iPluginDescriptor.getClass().getMethod("hasPluginObject", null);
            bl = (Boolean)method.invoke((Object)iPluginDescriptor, null);
        }
        catch (Exception exception) {}
        return bl;
    }
}

