/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.util;

import com.ibm.team.filesystem.common.IChangeSetSummary;
import com.ibm.team.filesystem.common.IChangeSummary;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeSummaryUtil {
    public static StateId getAfterState(IChangeSummary change) {
        IVersionableHandle afterState = change.afterState();
        if (afterState == null) {
            return new StateId(change.item().getItemType(), change.item().getItemId(), StateId.STATE_DELETED);
        }
        return new StateId((IItemHandle)afterState);
    }

    public static StateId getBeforeState(IChangeSummary summary) {
        if (summary.beforeState() != null) {
            return new StateId((IItemHandle)summary.beforeState());
        }
        return StateId.getDeletedState((IItemType)summary.item().getItemType(), (UUID)summary.item().getItemId());
    }

    public static ItemId getItem(IChangeSummary changeSummary) {
        return new ItemId((IItemHandle)changeSummary.item());
    }

    public static SiloedItemId<IVersionable> getSiloedItem(IChangeSummary changeSummary) {
        return SiloedItemId.create((IVersionableHandle)changeSummary.item(), (IComponentHandle)changeSummary.component());
    }

    public static ItemId<IChangeSet> getChangeSet(IChangeSetSummary nextSummary) {
        return ChangeSetUtil.getChangeSet(nextSummary.underlyingChange());
    }
}

