/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;

public final class RuntimeLog {
    private static ArrayList logListeners = new ArrayList(5);
    private static ArrayList queuedMessages = new ArrayList(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogListener(ILogListener iLogListener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            boolean bl = logListeners.size() == 0;
            ((AbstractCollection)logListeners).remove(iLogListener);
            logListeners.add(iLogListener);
            if (bl) {
                Iterator iterator = ((AbstractList)queuedMessages).iterator();
                while (iterator.hasNext()) {
                    try {
                        IStatus iStatus = (IStatus)iterator.next();
                        iLogListener.logging(iStatus, "org.eclipse.core.runtime");
                    }
                    catch (Exception exception) {
                        RuntimeLog.handleException(exception);
                    }
                    catch (LinkageError linkageError) {
                        RuntimeLog.handleException(linkageError);
                    }
                }
                queuedMessages.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogListener(ILogListener iLogListener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            ((AbstractCollection)logListeners).remove(iLogListener);
        }
    }

    private static void handleException(Throwable throwable) {
        if (!(throwable instanceof OperationCanceledException)) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(ILogListener iLogListener) {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            return logListeners.contains(iLogListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(IStatus iStatus) {
        ILogListener[] iLogListenerArray;
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            iLogListenerArray = logListeners.toArray(new ILogListener[logListeners.size()]);
            if (iLogListenerArray.length == 0) {
                queuedMessages.add(iStatus);
                return;
            }
        }
        int n = 0;
        while (n < iLogListenerArray.length) {
            try {
                iLogListenerArray[n].logging(iStatus, "org.eclipse.core.runtime");
            }
            catch (Exception exception) {
                RuntimeLog.handleException(exception);
            }
            catch (LinkageError linkageError) {
                RuntimeLog.handleException(linkageError);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty() {
        ArrayList arrayList = logListeners;
        synchronized (arrayList) {
            return logListeners.size() == 0;
        }
    }
}

