/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.jface.internal.util.TextViewerDecorator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;

public abstract class TextDecorator
extends TextViewerDecorator {
    private String fTemporaryCategory = String.valueOf(((Object)((Object)this)).toString()) + "_temporary";
    private IPositionUpdater fTemporaryUpdater = new DefaultPositionUpdater(this.fTemporaryCategory);
    private ITextViewer fTextViewer;
    private InternalListener fInternalListener = new InternalListener();

    public void install(TextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fTextViewer.addTextInputListener((ITextInputListener)this.fInternalListener);
        if (this.fTextViewer.getDocument() != null) {
            this.install(this.fTextViewer.getDocument());
            try {
                this.update((IStyledDocument)this.fTextViewer.getDocument(), (IRegion)new Region(0, this.fTextViewer.getDocument().getLength()));
            }
            catch (BadLocationException x) {
                FoundationIDEUIPlugin.getDefault().log("Exception while updating TextDecorator", x);
            }
        }
    }

    public void uninstall() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeTextInputListener((ITextInputListener)this.fInternalListener);
            if (this.fTextViewer.getDocument() != null) {
                this.uninstall(this.fTextViewer.getDocument());
            }
            this.fTextViewer = null;
        }
    }

    protected void install(IDocument document) {
        if (!(document instanceof IStyledDocument)) {
            return;
        }
        document.addPositionUpdater(this.fTemporaryUpdater);
        document.addPositionCategory(this.fTemporaryCategory);
        document.addPrenotifiedDocumentListener((IDocumentListener)this.fInternalListener);
        if (document instanceof IDocumentExtension4) {
            ((IDocumentExtension4)document).addDocumentRewriteSessionListener((IDocumentRewriteSessionListener)this.fInternalListener);
        }
    }

    protected void uninstall(IDocument document) {
        if (!(document instanceof IStyledDocument)) {
            return;
        }
        try {
            document.removePositionCategory(this.fTemporaryCategory);
            document.removePositionUpdater(this.fTemporaryUpdater);
        }
        catch (BadPositionCategoryException x) {
            FoundationIDEUIPlugin.getDefault().log("Unexpected Exception", x);
        }
        document.removePrenotifiedDocumentListener((IDocumentListener)this.fInternalListener);
        if (document instanceof IDocumentExtension4) {
            ((IDocumentExtension4)document).removeDocumentRewriteSessionListener((IDocumentRewriteSessionListener)this.fInternalListener);
        }
    }

    protected abstract void update(IStyledDocument var1, IRegion var2) throws BadLocationException;

    private class InternalListener
    implements IDocumentListener,
    ITextInputListener,
    IDocumentRewriteSessionListener {
        private boolean fSuspended = false;

        private InternalListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                TextDecorator.this.uninstall(oldInput);
            }
            if (newInput != null) {
                TextDecorator.this.install(newInput);
                try {
                    TextDecorator.this.update((IStyledDocument)newInput, (IRegion)new Region(0, newInput.getLength()));
                }
                catch (BadLocationException x) {
                    FoundationIDEUIPlugin.getDefault().log("Exception while updating TextDecorator", x);
                }
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (this.fSuspended) {
                try {
                    Position position = this.findTemporaryPosition(event.getDocument());
                    if (position == null) {
                        position = new Position(event.getOffset(), event.getText().length());
                        event.getDocument().addPosition(TextDecorator.this.fTemporaryCategory, position);
                    } else {
                        if (position.getOffset() > event.getOffset()) {
                            position.setLength(position.getLength() + position.getOffset() - event.getOffset());
                            position.setOffset(event.getOffset());
                        }
                        int length = event.getOffset() + event.getText().length() - position.getOffset();
                        if (position.getLength() < length) {
                            position.setLength(length);
                        }
                    }
                }
                catch (BadLocationException x) {
                    FoundationIDEUIPlugin.getDefault().log("Unexpected Exception", x);
                }
                catch (BadPositionCategoryException x) {
                    FoundationIDEUIPlugin.getDefault().log("Unexpected Exception", x);
                }
                return;
            }
            try {
                int offset = event.getOffset();
                int length = event.getText() != null ? event.getText().length() : 0;
                TextDecorator.this.update((IStyledDocument)event.getDocument(), (IRegion)new Region(offset, length));
            }
            catch (BadLocationException x) {
                FoundationIDEUIPlugin.getDefault().log("Exception while updating TextDecorator", x);
            }
        }

        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent event) {
            boolean suspended = event.getChangeType() == DocumentRewriteSessionEvent.SESSION_START;
            boolean resuming = this.fSuspended && event.getChangeType() == DocumentRewriteSessionEvent.SESSION_STOP;
            this.fSuspended = suspended;
            if (resuming) {
                try {
                    IDocument document = event.getDocument();
                    Position position = this.findTemporaryPosition(document);
                    this.removeTemporaryPositions(document);
                    if (position != null) {
                        Region region = new Region(position.getOffset(), position.getLength());
                        TextDecorator.this.update((IStyledDocument)document, (IRegion)region);
                        if (TextDecorator.this.fTextViewer instanceof ITextViewerExtension2) {
                            ((ITextViewerExtension2)TextDecorator.this.fTextViewer).invalidateTextPresentation(region.getOffset(), region.getLength());
                        } else {
                            TextDecorator.this.fTextViewer.invalidateTextPresentation();
                        }
                    }
                }
                catch (BadLocationException x) {
                    FoundationIDEUIPlugin.getDefault().log("Exception while updating TextDecorator", x);
                }
                catch (BadPositionCategoryException x) {
                    FoundationIDEUIPlugin.getDefault().log("Unexpected Exception", x);
                }
            }
        }

        private Position findTemporaryPosition(IDocument document) throws BadPositionCategoryException {
            Position[] positions;
            Position[] positionArray = positions = document.getPositions(TextDecorator.this.fTemporaryCategory);
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                Position position = positionArray[n2];
                if (!position.isDeleted()) {
                    return position;
                }
                ++n2;
            }
            return null;
        }

        private void removeTemporaryPositions(IDocument document) throws BadPositionCategoryException {
            Position[] positions;
            Position[] positionArray = positions = document.getPositions(TextDecorator.this.fTemporaryCategory);
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                Position current = positionArray[n2];
                document.removePosition(current);
                ++n2;
            }
        }
    }
}

