/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.foundation.rcp.core.text.StylePosition;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ConfigurableRepairer
implements IPresentationRepairer {
    private ResourceManager fResourceManager;
    private TextAttribute fDefaultTextAttribute;
    private TextAttribute fReferenceTextAttribute;
    private String fStylePositionCategory;
    private String[] fReferencePositionCategories;
    private IDocument fDocument;

    public ConfigurableRepairer(ResourceManager resourceManager, TextAttribute defaultAttribute, String stylePositionCategory, String[] referencePositionCategories, TextAttribute referenceAttribute) {
        this.fResourceManager = resourceManager;
        this.fDefaultTextAttribute = defaultAttribute;
        this.fStylePositionCategory = stylePositionCategory;
        this.fReferencePositionCategories = referencePositionCategories;
        this.fReferenceTextAttribute = referenceAttribute;
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion damage) {
        presentation.addStyleRange(this.createStyleRange(damage.getOffset(), damage.getLength(), this.fDefaultTextAttribute));
        try {
            if (this.fStylePositionCategory != null) {
                Position[] positions = this.fDocument.getPositions(this.fStylePositionCategory);
                int i = 0;
                int n = positions.length;
                while (i < n) {
                    StyleRange styleRange;
                    if (positions[i].overlapsWith(damage.getOffset(), damage.getLength()) && (styleRange = this.createStyleRange((StylePosition)positions[i])) != null) {
                        presentation.mergeStyleRange(styleRange);
                    }
                    ++i;
                }
            }
            if (this.fReferencePositionCategories != null) {
                int i = 0;
                while (i < this.fReferencePositionCategories.length) {
                    Position[] positions = this.fDocument.getPositions(this.fReferencePositionCategories[i]);
                    int j = 0;
                    int n = positions.length;
                    while (j < n) {
                        StyleRange styleRange;
                        if (positions[j].overlapsWith(damage.getOffset(), damage.getLength()) && (styleRange = this.createStyleRange((ReferencePosition)positions[j])) != null) {
                            presentation.mergeStyleRange(styleRange);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (BadPositionCategoryException x) {
            FoundationIDEUIPlugin.getDefault().log(x.getMessage(), x);
        }
    }

    private StyleRange createStyleRange(ReferencePosition position) {
        return this.createStyleRange(position.getOffset(), position.getLength(), this.fReferenceTextAttribute);
    }

    private StyleRange createStyleRange(StylePosition position) {
        int fontStyle = 0;
        if (position.isBold()) {
            fontStyle |= 1;
        }
        if (position.isItalic()) {
            fontStyle |= 2;
        }
        Color foreground = null;
        if (position.getForeground() != null) {
            foreground = this.getColor(position.getForeground());
        } else if (this.fDefaultTextAttribute != null) {
            foreground = this.fDefaultTextAttribute.getForeground();
        }
        Color background = null;
        if (position.getBackground() != null) {
            background = this.getColor(position.getBackground());
        } else if (this.fDefaultTextAttribute != null) {
            background = this.fDefaultTextAttribute.getBackground();
        }
        StyleRange styleRange = new StyleRange(position.getOffset(), position.getLength(), foreground, background, fontStyle);
        styleRange.strikeout = position.isStrikethrough();
        styleRange.underline = position.isUnderline();
        return styleRange;
    }

    private Color getColor(int[] rgb) {
        return this.fResourceManager.createColor(new RGB(rgb[0], rgb[1], rgb[2]));
    }

    private StyleRange createStyleRange(int offset, int length, TextAttribute textAttribute) {
        int style = textAttribute.getStyle() & 0x9FFFFFFF;
        StyleRange styleRange = new StyleRange(offset, length, textAttribute.getForeground(), textAttribute.getBackground(), style);
        styleRange.strikeout = (textAttribute.getStyle() & 0x20000000) != 0;
        styleRange.underline = (textAttribute.getStyle() & 0x40000000) != 0;
        return styleRange;
    }
}

