/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.util;

import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IContributorInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.util.IterationClient;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentAwareTeamAreaComparator
implements Comparator<ITeamArea> {
    private boolean fIsInitialized;
    private ItemMap<ITeamArea, Integer> fTeamArea2Assignment = new ItemHashMap(CMode.CURRENT_HANDLEONLY);

    public AssignmentAwareTeamAreaComparator init(IContributorHandle contributorHandle, IProjectAreaHandle projectAreaHandle, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fIsInitialized = false;
        this.fTeamArea2Assignment.clear();
        PlanningClientPlugin.getWorkItemClient((IItemHandle)contributorHandle);
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)contributorHandle);
        IterationPlanClient iterationPlanClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)contributorHandle);
        ResourcePlanningManager resourceManager = PlanningClientPlugin.getResourcePlanningClient((IItemHandle)contributorHandle).getResourcePlanningManager();
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)contributorHandle).itemManager();
        IContributor contributor = (IContributor)itemManager.fetchCompleteItem((IItemHandle)contributorHandle, 0, monitor);
        IProjectArea projectArea = (IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, monitor);
        ITeamArea[] teamAreas = iterationPlanClient.getAssociatedTeamAreas(contributor, projectArea, monitor);
        IContributorInfo info = resourceManager.getTeamInfo((ItemCollection<ITeamAreaHandle>)new ItemArrayList((Collection)Arrays.asList(teamAreas)), monitor);
        ITeamArea[] iTeamAreaArray = teamAreas;
        int n = teamAreas.length;
        int n2 = 0;
        while (n2 < n) {
            IIteration iteration;
            IDevelopmentLine line;
            ITeamArea teamArea = iTeamAreaArray[n2];
            if (!(!includeArchived && teamArea.isArchived() || (line = auditableClient.getDevelopmentLine((ITeamAreaHandle)teamArea, monitor)) == null || !includeArchived && line.isArchived() || (iteration = IterationClient.getCurrentPlanLeafIteration((IDevelopmentLineHandle)line, monitor)) == null || !includeArchived && iteration.isArchived())) {
                int assignment = info.getWorkAssignment((IContributorHandle)contributor, (IProcessAreaHandle)teamArea, (IDevelopmentLineHandle)line);
                this.fTeamArea2Assignment.put((IItemHandle)teamArea, (Object)assignment);
            }
            ++n2;
        }
        this.fIsInitialized = true;
        return this;
    }

    @Override
    public int compare(ITeamArea o1, ITeamArea o2) {
        if (!this.fIsInitialized) {
            throw new IllegalStateException();
        }
        if (this.fTeamArea2Assignment.containsKey((IItemHandle)o1)) {
            if (this.fTeamArea2Assignment.containsKey((IItemHandle)o2)) {
                return (Integer)this.fTeamArea2Assignment.get((IItemHandle)o2) - (Integer)this.fTeamArea2Assignment.get((IItemHandle)o1);
            }
            return -1;
        }
        if (this.fTeamArea2Assignment.containsKey((IItemHandle)o2)) {
            return 1;
        }
        return 0;
    }
}

