/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.problems.AttributeProblem;
import com.ibm.team.apt.internal.client.problems.GeneralProblem;
import com.ibm.team.apt.internal.client.problems.Messages;
import com.ibm.team.apt.internal.client.problems.PlanItemCheck;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAttributeCheck
extends PlanItemCheck {
    static final List<Attribute> sIgnoredAttributes = new ArrayList<Attribute>();

    public RequiredAttributeCheck() {
        sIgnoredAttributes.add(PlanItem.SCHEDULED_TIME);
        sIgnoredAttributes.add(PlanItem.MARKED_READ);
    }

    @Override
    public Collection<PlanItem> computeItemsToCheck(PlanItem item, IPlanElementDelta delta) {
        if (!delta.isChanged()) {
            return Collections.emptyList();
        }
        IPlanAttributeDelta[] deltas = delta.getAttributeDeltas();
        int length = deltas.length;
        if (length == 0 || length == 1 && sIgnoredAttributes.contains(deltas[0].getAttribute())) {
            return Collections.emptyList();
        }
        return Collections.singletonList(item);
    }

    @Override
    public void run(PlanProblemReport report, Collection<? extends PlanItem> planItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (planItems.isEmpty()) {
            return;
        }
        this.checkCanceled(monitor);
        monitor.beginTask("", planItems.size() * 4);
        HashMap<String, IAttribute> property2Attribute = new HashMap<String, IAttribute>();
        ITeamRepository teamRepository = report.getPlan().getTeamRepository();
        IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient(teamRepository);
        IWorkItemClient workItemClient = PlanningClientPlugin.getWorkItemClient(teamRepository);
        RequiredPropertiesCache requiredProperties = new RequiredPropertiesCache(workItemClient);
        for (PlanItem planItem : planItems) {
            this.checkCanceled(monitor);
            if (!planItem.isConnected()) continue;
            PlanItemProblemReport planItemReport = report.createReport(planItem);
            monitor.setTaskName(NLS.bind((String)Messages.RequiredAttributeCheck_MONITOR_CHECKING_WORK_ITEM, (Object[])new Object[]{String.valueOf(planItem.getId())}));
            RequiredPropertiesInfo info = requiredProperties.get(planItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            Problem.Severity problemLevel = Problem.Severity.FATAL_ERROR;
            int i = 0;
            while (i < info.properties.size()) {
                Object nullValue;
                Object value;
                String property = info.properties.get(i);
                IAttribute attribute = RequiredAttributeCheck.getAttribute(property2Attribute, workItemClient, (IProjectAreaHandle)planItem.getPlan().getProjectArea(), property, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (planItem.isAttributeSet(attribute) && RequiredAttributeCheck.equals(value = planItem.getAttributeValue(attribute), nullValue = attribute.getNullValue((IAuditableCommon)auditableClient, (IProgressMonitor)new SubProgressMonitor(monitor, 1)))) {
                    Attribute planAttribute = planItem.getAttribute(property);
                    String message = NLS.bind((String)Messages.RequiredAttributeCheck_MESSAGE, (Object[])new Object[]{attribute.getDisplayName()});
                    if (planAttribute != null) {
                        planItemReport.addProblem(new AttributeProblem(problemLevel, 1, message, planItem, planAttribute, RequiredAttributeCheck.class));
                    } else {
                        planItemReport.addProblem(new GeneralProblem(problemLevel, 1, message, planItem, RequiredAttributeCheck.class));
                    }
                }
                ++i;
            }
        }
        monitor.done();
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static final boolean equals(Object left, Object right) {
        return left == null ? right == null : right != null && left.equals(right);
    }

    private static IAttribute getAttribute(Map<String, IAttribute> cache, IWorkItemClient client, IProjectAreaHandle projectArea, String property, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute result = cache.get(property);
        if (result != null) {
            return result;
        }
        result = client.findAttribute(projectArea, property, monitor);
        cache.put(property, result);
        return result;
    }

    private static class RequiredPropertiesCache {
        private IWorkItemClient fWorkItemClient;
        private ItemMap<IProcessAreaHandle, Map<String, RequiredPropertiesInfo>> fCache = new ItemHashMap();

        public RequiredPropertiesCache(IWorkItemClient workItemClient) {
            this.fWorkItemClient = workItemClient;
        }

        public RequiredPropertiesInfo get(PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
            String workItemType;
            RequiredPropertiesInfo result;
            monitor.beginTask("", 2);
            IProcessAreaHandle processArea = this.fWorkItemClient.findProcessArea((IWorkItemHandle)planItem.getWorkItem(false), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            HashMap<String, RequiredPropertiesInfo> map = (HashMap<String, RequiredPropertiesInfo>)this.fCache.get((IItemHandle)processArea);
            if (map == null) {
                map = new HashMap<String, RequiredPropertiesInfo>();
                this.fCache.put((IItemHandle)processArea, map);
            }
            if ((result = (RequiredPropertiesInfo)map.get(workItemType = planItem.getItemType())) == null) {
                result = new RequiredPropertiesInfo(planItem.findRequiredProperties((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                map.put(workItemType, result);
            }
            monitor.done();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequiredPropertiesInfo {
        public List<String> properties;

        public RequiredPropertiesInfo(List<String> p) {
            this.properties = p;
        }
    }
}

