/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.problems.AttributeProblem;
import com.ibm.team.apt.internal.client.problems.PlanCheck;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.client.problems.ProblemReport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanItemProblemReport
extends ProblemReport {
    private PlanItem fPlanItem;
    private Map<Class<? extends PlanCheck>, List<Problem>> fProblems;
    private Problem fMostSevereProblem;

    public PlanItemProblemReport(PlanItem planItem) {
        this.fPlanItem = planItem;
    }

    public PlanItemProblemReport(PlanItemProblemReport report) {
        this.fPlanItem = report.fPlanItem;
        if (report.fProblems != null) {
            this.fProblems = new HashMap<Class<? extends PlanCheck>, List<Problem>>(report.fProblems);
        }
        this.fMostSevereProblem = report.fMostSevereProblem;
    }

    @Override
    public PlanElement getPlanElement() {
        return this.fPlanItem;
    }

    public PlanItem getPlanItem() {
        return this.fPlanItem;
    }

    public List<Problem> getProblems() {
        if (this.fProblems == null) {
            return Collections.emptyList();
        }
        ArrayList<Problem> result = new ArrayList<Problem>();
        for (List<Problem> problems : this.fProblems.values()) {
            result.addAll(problems);
        }
        return result;
    }

    public Problem getMostSevereProblem() {
        return this.fMostSevereProblem;
    }

    public void addProblem(Problem problem) {
        List<Problem> problems;
        if (this.fProblems == null) {
            this.fProblems = new HashMap<Class<? extends PlanCheck>, List<Problem>>();
        }
        if ((problems = this.fProblems.get(problem.getChecker())) == null) {
            problems = new ArrayList<Problem>(2);
            this.fProblems.put(problem.getChecker(), problems);
        }
        problems.add(problem);
        this.updateMostSevereProblem(problem);
    }

    private void updateMostSevereProblem(Problem problem) {
        if (this.fMostSevereProblem == null) {
            this.fMostSevereProblem = problem;
        } else if (this.fMostSevereProblem.getSeverity().compareTo(problem.getSeverity()) < 0) {
            this.fMostSevereProblem = problem;
        }
    }

    public boolean hasProblems() {
        if (this.fProblems == null) {
            return false;
        }
        return !this.fProblems.isEmpty();
    }

    public boolean isSeverity(Problem.Severity severirty) {
        if (this.fProblems == null) {
            return false;
        }
        for (List<Problem> problems : this.fProblems.values()) {
            for (Problem problem : problems) {
                if (!problem.isSeverity(severirty)) continue;
                return true;
            }
        }
        return false;
    }

    public AttributeProblem getAttributeProblem(Attribute attribute) {
        if (this.fProblems == null) {
            return null;
        }
        for (List<Problem> problems : this.fProblems.values()) {
            for (Problem element : problems) {
                if (!(element instanceof AttributeProblem) || !((AttributeProblem)element).getAttribute().equals(attribute)) continue;
                return (AttributeProblem)element;
            }
        }
        return null;
    }

    public void clearProblems() {
        if (this.fProblems == null) {
            return;
        }
        this.fProblems.clear();
        this.fMostSevereProblem = null;
    }

    public void clearProblems(Class<? extends PlanCheck> checker) {
        if (this.fProblems == null) {
            return;
        }
        List<Problem> problems = this.fProblems.remove(checker);
        if (problems != null && problems.contains(this.fMostSevereProblem)) {
            this.fMostSevereProblem = null;
            this.computeMostSevereProblem();
        }
    }

    public void clearProblems(Class<? extends PlanCheck> ... checkers) {
        if (this.fProblems == null) {
            return;
        }
        Class<? extends PlanCheck>[] classArray = checkers;
        int n = checkers.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends PlanCheck> checker = classArray[n2];
            List<Problem> problems = this.fProblems.remove(checker);
            if (problems != null && problems.contains(this.fMostSevereProblem)) {
                this.fMostSevereProblem = null;
            }
            ++n2;
        }
        if (this.fMostSevereProblem == null) {
            this.computeMostSevereProblem();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void clearProblems(Iterator<Class<? extends PlanCheck>> checkers) {
        if (this.fProblems != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            problems = this.fProblems.remove(checkers.next());
            if (problems == null || !problems.contains(this.fMostSevereProblem)) continue;
            this.fMostSevereProblem = null;
lbl6:
            // 3 sources

            ** while (checkers.hasNext())
        }
lbl7:
        // 1 sources

        if (this.fMostSevereProblem == null) {
            this.computeMostSevereProblem();
        }
    }

    private void computeMostSevereProblem() {
        for (List<Problem> problems : this.fProblems.values()) {
            for (Problem problem : problems) {
                this.updateMostSevereProblem(problem);
                if (this.fMostSevereProblem.getSeverity() != Problem.Severity.ERROR) continue;
                return;
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fPlanItem.hashCode();
        if (this.fProblems != null) {
            result = 31 * result + this.fProblems.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlanItemProblemReport other = (PlanItemProblemReport)obj;
        if (!this.fPlanItem.getWorkItemId().equals((Object)other.fPlanItem.getWorkItemId())) {
            return false;
        }
        if (this.fProblems != null) {
            return this.fProblems.equals(other.fProblems);
        }
        return other.fProblems == null || other.fProblems.isEmpty();
    }
}

