/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.nodes;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IAttributeDelta;
import com.ibm.team.apt.internal.client.nodes.AttributeDelta;
import com.ibm.team.apt.internal.client.nodes.ElementNode;
import com.ibm.team.apt.internal.client.nodes.IElementNodeDelta;
import com.ibm.team.apt.internal.client.nodes.IElementNodeDeltaVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNodeDelta<T extends ElementNode<T>, D extends ElementNodeDelta<T, D>>
implements IElementNodeDelta<T, D> {
    private static int KIND_MASK = 255;
    private int fStatus;
    private final D fParentDelta;
    private T fElement;
    private Map<Attribute, IAttributeDelta> fAttributeDeltas;
    private List<D> fChildren;
    private T fMoveParent;
    private D fOtherMoveDelta;

    public ElementNodeDelta(D parentDelta, T element) {
        this.fParentDelta = parentDelta;
        this.fElement = element;
        this.fStatus = 0;
    }

    @Override
    public D getParentDelta() {
        return this.fParentDelta;
    }

    @Override
    public T getElement() {
        return this.fElement;
    }

    public boolean isNoChange() {
        return (this.fStatus & KIND_MASK) == 0;
    }

    @Override
    public boolean isAdded() {
        return (this.fStatus & 1) != 0;
    }

    public void setAdded() {
        this.fStatus = this.getFlags() | 1;
    }

    @Override
    public boolean isRemoved() {
        return (this.fStatus & 2) != 0;
    }

    public void setRemoved() {
        this.fStatus = this.getFlags() | 2;
    }

    @Override
    public boolean isDeleted() {
        return this.isRemoved() && this.getMovedTo() == null;
    }

    @Override
    public boolean isChanged() {
        return (this.fStatus & 4) != 0;
    }

    public void setChanged() {
        this.fStatus = this.getFlags() | 4;
    }

    @Override
    public boolean isContentChange() {
        return (this.fStatus & 0x100) != 0;
    }

    public void setContentChange() {
        this.fStatus |= 0x100;
    }

    @Override
    public boolean isStructuralChange() {
        return (this.fStatus & 0x200) != 0;
    }

    public void setStructuralChange() {
        this.fStatus |= 0x200;
    }

    @Override
    public boolean isMoveChange() {
        return this.fMoveParent != null;
    }

    public void setOtherMoveDelta(D otherDelta) {
        this.fOtherMoveDelta = otherDelta;
    }

    @Override
    public D getOtherMoveDelta() {
        return this.fOtherMoveDelta;
    }

    public void setMoveParent(T element) {
        this.fMoveParent = element;
    }

    @Override
    public T getMovedFrom() {
        if (!this.isAdded()) {
            return null;
        }
        return this.fMoveParent;
    }

    @Override
    public T getMovedTo() {
        if (!this.isRemoved()) {
            return null;
        }
        return this.fMoveParent;
    }

    public void addChild(D delta) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<D>(2);
        }
        this.fChildren.add(delta);
    }

    public D getChild(T element) {
        if (this.fChildren == null) {
            return null;
        }
        for (ElementNodeDelta child : this.fChildren) {
            if (child.getElement() != element) continue;
            return (D)child;
        }
        return null;
    }

    @Override
    public List<D> getChildren() {
        if (this.fChildren == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.fChildren);
    }

    @Override
    public List<D> getChildren(int status) {
        if (this.fChildren == null) {
            return Collections.emptyList();
        }
        ArrayList<ElementNodeDelta> result = new ArrayList<ElementNodeDelta>();
        for (ElementNodeDelta delta : this.fChildren) {
            if ((delta.fStatus & status) == 0) continue;
            result.add(delta);
        }
        return Collections.unmodifiableList(result);
    }

    public boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    @Override
    public void accept(IElementNodeDeltaVisitor visitor) {
        if (visitor.visit(this) && this.fChildren != null) {
            for (ElementNodeDelta delta : this.fChildren) {
                delta.accept(visitor);
            }
        }
    }

    public void addAttribute(IAttributeDelta delta) {
        if (this.fAttributeDeltas == null) {
            this.fAttributeDeltas = new HashMap<Attribute, IAttributeDelta>();
        } else {
            IAttributeDelta oldDelta = this.fAttributeDeltas.get(delta.getAttribute());
            if (oldDelta != null) {
                delta = new AttributeDelta(delta.getAttribute(), oldDelta.getOldValue(), delta.getNewValue());
            }
        }
        this.fAttributeDeltas.put(delta.getAttribute(), delta);
    }

    @Override
    public boolean affectsAttribute(Attribute attribute) {
        return this.fAttributeDeltas != null && this.fAttributeDeltas.containsKey(attribute);
    }

    @Override
    public List<IAttributeDelta> getAttributeDeltas() {
        if (this.fAttributeDeltas == null) {
            return Collections.emptyList();
        }
        Collection<IAttributeDelta> values = this.fAttributeDeltas.values();
        return new ArrayList<IAttributeDelta>(values);
    }

    @Override
    public IAttributeDelta getAttributeDelta(Attribute attribute) {
        if (this.fAttributeDeltas == null) {
            return null;
        }
        return this.fAttributeDeltas.get(attribute);
    }

    private int getFlags() {
        return this.fStatus & ~KIND_MASK;
    }
}

