/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.nodes;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.BooleanAttribute;
import com.ibm.team.apt.internal.client.GetterKind;
import com.ibm.team.apt.internal.client.IntegerAttribute;
import com.ibm.team.apt.internal.client.SetterKind;
import com.ibm.team.apt.internal.client.nodes.IElementNodeVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementNode<T extends ElementNode<T>> {
    public static final Attribute CHILDREN = new BooleanAttribute("children", ElementNode.class, GetterKind.HAS, SetterKind.NONE);
    public static final Attribute CHILDREN_COUNT = new IntegerAttribute("childrenCount", ElementNode.class, GetterKind.GET, SetterKind.NONE);
    private T fParent;
    private static final List EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    private List<T> fChildren = EMPTY_LIST;

    public ElementNode() {
        this(null);
    }

    public ElementNode(T parent) {
        this.fParent = parent;
        if (this.fParent != null) {
            this.fParent.addChild((ElementNode)this);
        }
    }

    public T getParent() {
        return this.fParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getChildren() {
        List<T> list = this.fChildren;
        synchronized (list) {
            if (this.fChildren == EMPTY_LIST) {
                return Collections.emptyList();
            }
            ArrayList<T> result = new ArrayList<T>(this.fChildren);
            return Collections.unmodifiableList(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildrenCount() {
        List<T> list = this.fChildren;
        synchronized (list) {
            return this.fChildren.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        List<T> list = this.fChildren;
        synchronized (list) {
            return !this.fChildren.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildIndex(T child) {
        List<T> list = this.fChildren;
        synchronized (list) {
            return this.fChildren.indexOf(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(IElementNodeVisitor<T> visitor) {
        if (visitor.visit(this)) {
            ArrayList<T> toVisit = null;
            List<T> list = this.fChildren;
            synchronized (list) {
                toVisit = new ArrayList<T>(this.fChildren);
            }
            for (ElementNode element : toVisit) {
                element.accept(visitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(T element) {
        Assert.isTrue((((ElementNode)element).fParent == null || ((ElementNode)element).fParent == this ? 1 : 0) != 0);
        List<T> list = this.fChildren;
        synchronized (list) {
            if (this.fChildren == EMPTY_LIST) {
                this.fChildren = new ArrayList<T>(2);
            }
            ((ElementNode)element).fParent = this;
            this.fChildren.add(element);
        }
        this.childAdded(this, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(int index, T element) {
        Assert.isTrue((((ElementNode)element).fParent == null || ((ElementNode)element).fParent == this ? 1 : 0) != 0);
        List<T> list = this.fChildren;
        synchronized (list) {
            if (this.fChildren == EMPTY_LIST) {
                this.fChildren = new ArrayList<T>(2);
            }
            ((ElementNode)element).fParent = this;
            this.fChildren.add(index, element);
        }
        this.childAdded(this, element);
    }

    public void remove() {
        this.fParent.removeChild((ElementNode)this);
    }

    public boolean removeChild(T element) {
        if (this.fChildren.remove(element)) {
            this.childRemoved(this, element);
            ((ElementNode)element).fParent = null;
            return true;
        }
        return false;
    }

    protected abstract void doChildAdded(T var1, T var2);

    protected abstract void doChildRemoved(T var1, T var2);

    private void childAdded(T parent, T child) {
        this.doChildAdded(parent, child);
    }

    private void childRemoved(T parent, T child) {
        this.doChildRemoved(parent, child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearChildren() {
        List<T> list = this.fChildren;
        synchronized (list) {
            if (this.fChildren == EMPTY_LIST) {
                return;
            }
            for (ElementNode child : this.fChildren) {
                child.clearChildren();
            }
            this.fChildren.clear();
        }
    }
}

