/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.security.AccessController;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.AppPersistence;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.EclipseAppHandle;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.condpermadmin.BundleSignerCondition;
import org.osgi.service.condpermadmin.ConditionInfo;

public class EclipseAppDescriptor
extends ApplicationDescriptor {
    static final String APP_TYPE = "eclipse.application.type";
    static final String APP_DEFAULT = "eclipse.application.default";
    static final String APP_TYPE_MAIN_THREAD = "main.thread";
    static final String APP_TYPE_ANY_THREAD = "any.thread";
    static final int FLAG_VISIBLE = 1;
    static final int FLAG_CARD_SINGLETON_GLOGAL = 2;
    static final int FLAG_CARD_SINGLETON_SCOPED = 4;
    static final int FLAG_CARD_UNLIMITED = 8;
    static final int FLAG_CARD_LIMITED = 16;
    static final int FLAG_TYPE_MAIN_THREAD = 32;
    static final int FLAG_TYPE_ANY_THREAD = 64;
    static final int FLAG_DEFAULT_APP = 128;
    private long instanceID = 0L;
    private ServiceRegistration sr;
    private Boolean locked = Boolean.FALSE;
    private final EclipseAppContainer appContainer;
    private final Bundle contributor;
    private final int flags;
    private final int cardinality;
    private final String name;
    static Class class$0;
    static Class class$1;
    static Class class$2;

    protected EclipseAppDescriptor(Bundle bundle, String string, String string2, int n, int n2, EclipseAppContainer eclipseAppContainer) {
        super(string);
        this.name = string2;
        this.contributor = bundle;
        this.appContainer = eclipseAppContainer;
        this.locked = AppPersistence.isLocked(this) ? Boolean.TRUE : Boolean.FALSE;
        this.flags = n;
        this.cardinality = n2;
    }

    protected Map getPropertiesSpecific(String string) {
        return this.getServiceProperties();
    }

    protected ApplicationHandle launchSpecific(Map map) throws Exception {
        if (this.getLocked().booleanValue()) {
            throw (Throwable)new IllegalStateException("Cannot launch a locked application.");
        }
        EclipseAppHandle eclipseAppHandle = this.createAppHandle(map);
        try {
            this.appContainer.launch(eclipseAppHandle);
        }
        catch (Throwable throwable) {
            try {
                ((ApplicationHandle)eclipseAppHandle).destroy();
            }
            catch (Throwable throwable2) {}
            if (throwable instanceof Exception) {
                throw throwable;
            }
            throw throwable;
        }
        return eclipseAppHandle;
    }

    protected synchronized void lockSpecific() {
        this.locked = Boolean.TRUE;
        this.refreshProperties();
    }

    protected synchronized void unlockSpecific() {
        this.locked = Boolean.FALSE;
        this.refreshProperties();
    }

    void refreshProperties() {
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration != null) {
            try {
                serviceRegistration.setProperties((Dictionary)this.getServiceProperties());
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    synchronized void setServiceRegistration(ServiceRegistration serviceRegistration) {
        this.sr = serviceRegistration;
    }

    private synchronized ServiceRegistration getServiceRegistration() {
        return this.sr;
    }

    private synchronized Boolean getLocked() {
        return this.locked;
    }

    Hashtable getServiceProperties() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(10);
        hashtable.put("service.pid", this.getApplicationId());
        if (this.name != null) {
            hashtable.put("application.name", this.name);
        }
        hashtable.put("application.container", "org.eclipse.equinox.app");
        hashtable.put("application.location", this.getLocation());
        Boolean bl = this.appContainer.isLocked(this) == 0 ? Boolean.TRUE : Boolean.FALSE;
        hashtable.put("application.launchable", bl);
        hashtable.put("application.locked", this.getLocked());
        Boolean bl2 = (this.flags & 1) != 0 ? Boolean.TRUE : Boolean.FALSE;
        hashtable.put("application.visible", bl2);
        hashtable.put(APP_TYPE, this.getThreadTypeString());
        if ((this.flags & 0x80) != 0) {
            hashtable.put(APP_DEFAULT, Boolean.TRUE);
        }
        return hashtable;
    }

    private String getLocation() {
        if (this.contributor == null) {
            return "";
        }
        return Activator.getLocation(this.contributor);
    }

    private EclipseAppHandle createAppHandle(Map map) {
        EclipseAppHandle eclipseAppHandle = new EclipseAppHandle(this.getInstanceID(), map, this);
        String[] stringArray = new String[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.application.ApplicationHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.app.IApplicationContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        ServiceRegistration serviceRegistration = (ServiceRegistration)AccessController.doPrivileged(this.appContainer.getRegServiceAction(stringArray, eclipseAppHandle, eclipseAppHandle.getServiceProperties()));
        eclipseAppHandle.setServiceRegistration(serviceRegistration);
        return eclipseAppHandle;
    }

    EclipseAppContainer getContainerManager() {
        return this.appContainer;
    }

    public boolean matchDNChain(String string) {
        if (this.contributor == null) {
            return false;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.condpermadmin.BundleSignerCondition");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        return BundleSignerCondition.getCondition((Bundle)this.contributor, (ConditionInfo)new ConditionInfo(clazz.getName(), new String[]{string})).isSatisfied();
    }

    protected boolean isLaunchableSpecific() {
        return true;
    }

    public synchronized void unregister() {
        ServiceRegistration serviceRegistration = this.sr;
        if (serviceRegistration != null) {
            this.sr = null;
            serviceRegistration.unregister();
        }
    }

    String getThreadTypeString() {
        if ((this.flags & 0x40) != 0) {
            return APP_TYPE_ANY_THREAD;
        }
        return APP_TYPE_MAIN_THREAD;
    }

    int getThreadType() {
        return this.flags & 0x60;
    }

    int getCardinalityType() {
        return this.flags & 0x1E;
    }

    int getCardinality() {
        return this.cardinality;
    }

    private synchronized String getInstanceID() {
        if (this.instanceID == Long.MAX_VALUE) {
            this.instanceID = 0L;
        }
        return String.valueOf(this.getApplicationId()) + "." + this.instanceID++;
    }
}

