/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.client;

import com.ibm.team.process.client.AdvisorProblemResolution;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.repository.common.util.ExtensionReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class AdvisorProblemResolutionManager {
    private static AdvisorProblemResolutionManager fgManager;
    private ProblemResolutionRegistry fResolutionRegistry = new ProblemResolutionRegistry();

    public static AdvisorProblemResolutionManager getDefault() {
        if (fgManager == null) {
            fgManager = new AdvisorProblemResolutionManager();
        }
        return fgManager;
    }

    private AdvisorProblemResolutionManager() {
    }

    public AdvisorProblemResolution[] getResolutions(IAdvisorInfo problem) {
        List problemResolutions;
        IProcessReport parentReport = problem.getProcessReport();
        IOperationReport operationReport = parentReport instanceof IParticipantReport ? ((IParticipantReport)parentReport).getOperationReport() : (IOperationReport)parentReport;
        ArrayList<AdvisorProblemResolution> resolutions = new ArrayList<AdvisorProblemResolution>();
        int severity = problem.getSeverity();
        if (!(operationReport.wasRun() || severity != 4 && severity != 2 || (problemResolutions = this.fResolutionRegistry.getProblemResolution(problem.getIdentifier())) == null)) {
            Iterator iter = problemResolutions.listIterator();
            while (iter.hasNext()) {
                AdvisorProblemResolution resolution = (AdvisorProblemResolution)iter.next();
                if (!resolution.mayBeApplicable(problem)) continue;
                resolutions.add(resolution);
            }
        }
        return resolutions.toArray(new AdvisorProblemResolution[resolutions.size()]);
    }

    private static class ProblemResolutionRegistry
    extends ExtensionReader {
        private static final String ATTR_PROBLEM_TYPE = "problemType";
        private Map fContributedResolutions = new HashMap();

        public ProblemResolutionRegistry() {
            super("com.ibm.team.process.client", "advisorProblemResolutions");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean handleExtensionAdded(IConfigurationElement element) {
            ProblemResolutionRegistry problemResolutionRegistry = this;
            synchronized (problemResolutionRegistry) {
                block5: {
                    String problemType = element.getAttribute(ATTR_PROBLEM_TYPE);
                    if (problemType == null) break block5;
                    ArrayList<AdvisorProblemResolution> list = (ArrayList<AdvisorProblemResolution>)this.fContributedResolutions.get(problemType);
                    if (list == null) {
                        list = new ArrayList<AdvisorProblemResolution>();
                        this.fContributedResolutions.put(problemType, list);
                    }
                    AdvisorProblemResolution resolution = new AdvisorProblemResolution(element);
                    list.add(resolution);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getProblemResolution(String problemType) {
            this.start();
            ProblemResolutionRegistry problemResolutionRegistry = this;
            synchronized (problemResolutionRegistry) {
                return (List)this.fContributedResolutions.get(problemType);
            }
        }
    }
}

