/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.util;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ConnectionUtil;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.util.FormBasedAuth;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.IRepositoryRestService;
import com.ibm.team.repository.common.transport.CancelableCaller;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.ICancelableRunnable;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.DateUtils;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Timestamp;
import java.text.ParseException;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class RepositoryUtil {
    private static final Log log = LogFactory.getLog((String)"com.ibm.team.repository.client");

    public static UUID getRepositoryId(String repositoryURI) {
        repositoryURI = HttpUtil.trimTrailingSlash((String)repositoryURI);
        String urlString = String.format("%s/%s/%s", repositoryURI, "repo", "repositoryId");
        UUID uuid = null;
        try {
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                FormBasedAuth.setupLazySSLSupport(conn);
            }
            conn.setRequestMethod("GET");
            conn.addRequestProperty("Accept", HttpUtil.MediaType.TEXT.toString());
            conn.addRequestProperty("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
            conn.setDoInput(true);
            conn.connect();
            BufferedReader reader = new BufferedReader(HttpUtil.createReader((InputStream)conn.getInputStream(), (HttpUtil.CharsetEncoding)HttpUtil.CharsetEncoding.UTF8));
            String value = reader.readLine();
            conn.disconnect();
            uuid = UUID.valueOf((String)value);
        }
        catch (Exception ex) {
            String msg = NLS.bind((String)Messages.getServerString("RepositoryUtil.RepositoryNotFound"), (Object[])new Object[]{repositoryURI, ex.getMessage()});
            log.info((Object)msg, (Throwable)ex);
        }
        return uuid;
    }

    public static Timestamp getRepositoryTime(ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        String time = RepositoryUtil.fetchResourceValue(repo, "time", ClientUtil.getMonitor(monitor));
        try {
            return DateUtils.parseTimeRFC3339((String)time);
        }
        catch (ParseException e) {
            String msg = String.format("Unexpected error parsing server time \"%s\": %s", time, e.getMessage());
            throw new IllegalStateException(msg);
        }
    }

    public static String getRepositoryVersion(ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepositoryUtil.fetchResourceValue(repo, "productVersion", ClientUtil.getMonitor(monitor));
    }

    public static String getRepositoryBuildId(ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        return RepositoryUtil.fetchResourceValue(repo, "buildId", ClientUtil.getMonitor(monitor));
    }

    private static String fetchResourceValue(ITeamRepository teamRepository, String resourceId, IProgressMonitor monitor) throws TeamRepositoryException {
        if (teamRepository == null) {
            throw new IllegalArgumentException("repo must not be null");
        }
        if (resourceId == null || resourceId.length() == 0) {
            throw new IllegalArgumentException("resourceId must not be null or empty");
        }
        if (monitor == null) {
            throw new IllegalArgumentException("monitor must not be null");
        }
        TeamRepository repo = (TeamRepository)teamRepository;
        ITeamRestServiceClient restClient = repo.getRepositoryRestService();
        Exception thrownException = null;
        repo.setErrorState(0, null);
        Location loc = Location.serviceLocation((String)repo.getRepositoryURI(), IRepositoryRestService.class, (String)resourceId, null);
        final ITeamRestServiceClient.IRestClientConnection connection = restClient.getConnection(loc);
        connection.addRequestHeader("Accept", HttpUtil.MediaType.TEXT.toString());
        connection.addRequestHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        final ITeamRestServiceClient.IRestClientConnection.Response[] response = new ITeamRestServiceClient.IRestClientConnection.Response[1];
        try {
            CancelableCaller.call((IProgressMonitor)monitor, (ICancelableRunnable)new ICancelableRunnable(){

                public void run(IProgressMonitor progressMonitor) throws OperationCanceledException {
                    try {
                        try {
                            progressMonitor.beginTask(null, -1);
                            response[0] = connection.doGet();
                        }
                        catch (TeamRepositoryException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            });
            BufferedReader reader = new BufferedReader(HttpUtil.createReader((InputStream)response[0].getResponseStream(), (HttpUtil.CharsetEncoding)HttpUtil.CharsetEncoding.UTF8));
            String string = reader.readLine();
            return string;
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause != null && cause instanceof TeamRepositoryException) {
                throw (TeamRepositoryException)cause;
            }
            throw ex;
        }
        catch (Exception e) {
            thrownException = e;
            String msg = NLS.bind((String)Messages.getServerString("RepositoryUtil.ResourceNotFound"), (Object[])new Object[]{resourceId, e.getMessage()});
            throw new TeamRepositoryException(msg, (Throwable)e);
        }
        finally {
            if (thrownException != null) {
                ConnectionUtil.setConnectionError(thrownException, repo);
                if (thrownException instanceof TeamRepositoryException) {
                    TeamRepositoryException e = (TeamRepositoryException)((Object)thrownException);
                    e.setOrigin((Object)repo);
                }
            }
            if (connection != null) {
                connection.release();
            }
        }
    }
}

