/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.IUploadHandler;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class ProgressHandlingContentManagerSession
implements IContentManagerSession {
    private long totalTime = 0L;
    private long lastUpdate = -1L;
    private long transferCount = 0L;
    private String transferSpeed = null;
    private final long nextSpeedUpdate = -1L;
    private final int expectedTransfers;
    private int completedTransfers;
    private long completedBytes;
    protected final IProgressMonitor monitor;
    private final Object lock = new Object();

    public ProgressHandlingContentManagerSession(String name, int totalWork, IProgressMonitor mon) {
        this.monitor = ClientUtil.beginMonitor(mon, name, totalWork);
        this.expectedTransfers = totalWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementTransferCount(int howMuch) {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.monitor.worked(howMuch);
            this.completedTransfers += howMuch;
            assert (this.completedTransfers <= this.expectedTransfers);
        }
        this.updateProgressMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void retrieveContent(IContent content, IDownloadHandler handler) throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            ++this.transferCount;
        }
        this.internalRetrieveContent(content, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void storeContent(IUploadHandler handler) throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            ++this.transferCount;
        }
        this.internalStoreContent(handler);
    }

    protected abstract void internalRetrieveContent(IContent var1, IDownloadHandler var2) throws TeamRepositoryException;

    protected abstract void internalStoreContent(IUploadHandler var1) throws TeamRepositoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logTransferredBytes(long bytes) {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        Object object = this.lock;
        synchronized (object) {
            assert (this.transferCount > 0L);
            long now = System.currentTimeMillis();
            if (this.lastUpdate == -1L) {
                this.lastUpdate = now;
            }
            this.completedBytes += bytes;
            this.totalTime += now - this.lastUpdate;
            this.lastUpdate = now;
        }
        this.updateProgressMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logTransferCompleted() {
        Object object = this.lock;
        synchronized (object) {
            --this.transferCount;
            ++this.completedTransfers;
            this.monitor.worked(1);
            assert (this.completedTransfers <= this.expectedTransfers);
            assert (this.transferCount >= 0L);
        }
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.updateProgressMonitor();
        if (this.expectedTransfers == this.completedTransfers) {
            this.monitor.done();
        }
    }

    protected void updateProgressMonitor() {
        this.monitor.subTask(this.getDownloadStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDownloadStats() {
        this.updateTransferSpeed();
        Object object = this.lock;
        synchronized (object) {
            String transferSpeedMsg = new String();
            if (this.transferSpeed != null) {
                transferSpeedMsg = NLS.bind((String)Messages.getServerString("_NoId.ProgressHandlingContentManagerSession.TransferSpeed"), (Object[])new Object[]{this.transferSpeed});
            }
            return NLS.bind((String)Messages.getServerString("_NoId.ProgressHandlingContentManagerSession.TransferProgress"), (Object[])new Object[]{ClientUtil.bytesAsHumanReadable(this.completedBytes), this.completedTransfers, this.expectedTransfers, transferSpeedMsg});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTransferSpeed() {
        Object object = this.lock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (this.totalTime > 0L && this.transferCount > 0L && now > -1L) {
                if (this.lastUpdate == -1L) {
                    this.lastUpdate = now;
                }
                this.totalTime += now - this.lastUpdate;
                this.lastUpdate = now;
                double amt = (double)this.completedBytes / ((double)this.totalTime / 1000.0);
                this.transferSpeed = NLS.bind((String)Messages.getServerString("_NoId.ProgressHandlingContentManagerSession.Seconds"), (Object[])new Object[]{ClientUtil.bytesAsHumanReadable((long)amt)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        Object object = this.lock;
        synchronized (object) {
            return this.monitor.isCanceled();
        }
    }

    public int getCompletedTransfers() {
        return this.completedTransfers;
    }
}

