/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client;

import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.internal.TeamRepositoryService;
import com.ibm.team.repository.common.internal.util.InternalTeamPlatform;

public final class TeamPlatform {
    public static final String PI_REPOSITORY = "com.ibm.team.repository";
    private static ITeamRepositoryService repositoryService;

    public static final void startup() {
        InternalTeamPlatform.getDefault().start(false);
    }

    public static final void shutdown() {
        InternalTeamPlatform.getDefault().shutdown();
    }

    public static final boolean isStarted() {
        return InternalTeamPlatform.getDefault().isStarted();
    }

    public static void setMaxContentThreads(int count) {
        ContentManager.setMaxSimultaneousDownloads(count);
    }

    public static int getMaxContentThreads() {
        return ContentManager.getMaxSimultaneousDownloads();
    }

    public static final synchronized ITeamRepositoryService getTeamRepositoryService() {
        if (!InternalTeamPlatform.getDefault().isStarted()) {
            throw new IllegalStateException("Platform hasn't been started yet");
        }
        if (repositoryService == null) {
            repositoryService = new TeamRepositoryService();
        }
        return repositoryService;
    }

    private TeamPlatform() {
    }
}

