/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTResource
extends SrvcResource {
    private CTLocation _location;
    private CCaseObjInfo _ccObjInfo = null;
    final List<PropertyNameList.PropertyName<?>> VERSION_HISTORY_PROPERTIES = new ArrayList((Collection)Arrays.asList(Resource.CONTENT_TYPE, Resource.CONTENT_CHARACTER_SET, Resource.IS_EXECUTABLE, InteropStream.PN_LINE_SEPARATOR));

    protected static void setResourceIdentifier(Resource resource, SrvcFeedback feedback) throws WvcmException {
        ((ResourceImpl)resource).setPropMapProperty(Resource.RESOURCE_IDENTIFIER, (Object)CTResource.getResourceIdentifier((SrvcProvider)resource.provider(), resource.location(), feedback));
    }

    CTResource(Location location, CTProvider provider) {
        if (location == null) {
            throw new IllegalArgumentException("Cannot create a CTResource with a null Location");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot create a CTResource with a null provider");
        }
        this._location = new CTLocation((CTLocation)location);
        this._provider = provider;
    }

    public Location calculateLocation() throws WvcmException {
        return this._location;
    }

    public CTLocation getLocation() {
        return this._location;
    }

    public CTProvider getProvider() {
        return (CTProvider)this._provider;
    }

    public synchronized CCaseObjInfo getObjInfo(SrvcFeedback feedback) throws WvcmException {
        if (this._ccObjInfo == null) {
            this.setObjInfo(CCaseObjInfo.getObjInfo(this.getProvider().getCCaseLib(), this.getLocation().getDisplayName(), feedback));
        }
        return this._ccObjInfo;
    }

    public synchronized void setObjInfo(CCaseObjInfo objInfo) {
        this._ccObjInfo = objInfo;
    }

    public synchronized void flush(SrvcFeedback feedback) {
        this.getProvider().flushPathnameCacheEntries(feedback);
        this.setObjInfo(null);
    }

    public static String getResourceIdentifier(SrvcProvider provider, Location location, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = (CTProvider)provider;
        String locString = ((CTLocation)location).getDisplayName();
        if (ObjSelUtils.isUniversalSelector(locString)) {
            return locString;
        }
        CCaseObjInfo info = CCaseObjInfo.getObjInfo(p.getCCaseLib(), locString, feedback);
        return info.getUniversalSelector();
    }

    private static void repoCommonUtilsCopyInputToOutput(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[32768];
        int len = 0;
        while (len > -1) {
            len = in.read(bytes);
            if (len <= 0) continue;
            out.write(bytes, 0, len);
        }
    }

    public void readContentInternal(String pathName, OutputStream content, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.getProvider().getCCaseLib();
        String nameToUse = cc.gpath(pathName, null, feedback);
        this.readContentInternalUsingPathname(nameToUse, content);
    }

    protected void readContentInternalUsingPathname(String nameToUse, OutputStream content) throws WvcmException {
        try {
            FileInputStream src = new FileInputStream(nameToUse);
            CTResource.repoCommonUtilsCopyInputToOutput(src, content);
            src.close();
        }
        catch (IOException exception) {
            throw new WvcmException(NLS.bind((String)Messages.CTResource_READ_FILE_FAILED_ERROR, (Object)nameToUse, (Object)nameToUse), null, WvcmException.ReasonCode.READ_FAILED, (Throwable)exception);
        }
    }

    public List<CTLocation> findUcmObjLocations(String ucmObjSel, boolean children, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CTLocation> results = new ArrayList<CTLocation>();
        CCaseLib cc = this.getProvider().getCCaseLib();
        List<String> objSels = cc.findUcmObjSels(ucmObjSel, children, feedback);
        for (String objSel : objSels) {
            CTLocation objLoc = ObjSelUtils.getObjSelKind(objSel).equals("stream") ? CTLocation.valueOf(CTLocation.Kind.STREAM, objSel) : CTLocation.valueOf(CTLocation.Kind.FOLDER, objSel);
            results.add(objLoc);
        }
        return results;
    }

    public PropertyNameList doGetPropertyNameList(String namespace) throws WvcmException {
        throw new WvcmException(Messages.CTResource_UNSUPPORTED_PROP_NAME_LIST_ERROR, WvcmException.ReasonCode.FORBIDDEN);
    }

    public static String getCustomAttName(PropertyNameList.PropertyName<?> propertyName) {
        return String.valueOf(propertyName.getNamespace()) + '_' + propertyName.getName();
    }

    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            if (propertyName.equals((Object)InteropStream.PN_CLONE)) {
                return null;
            }
            CCaseLib cc = this.getProvider().getCCaseLib();
            return cc.getAttr(CTResource.getCustomAttName(propertyName), this._location.getDisplayName(), feedback);
        }
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getUniversalSelector(feedback);
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getPathnameLocation(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public String getUniversalSelector(SrvcFeedback feedback) throws WvcmException {
        return this.getObjInfo(feedback).getUniversalSelector();
    }

    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            CCaseLib cc = ((CTProvider)this.get_provider()).getCCaseLib();
            cc.setAttr(CTResource.getCustomAttName(propertyName), this._location.getDisplayName(), (String)value, !initialize, feedback);
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    public void removePropertyFromClient(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.getNamespace() != null) {
            CCaseLib cc = ((CTProvider)this.get_provider()).getCCaseLib();
            cc.rmAttr(CTResource.getCustomAttName(propertyName), this._location.getDisplayName(), feedback);
        } else {
            super.removePropertyFromClient(propertyName, feedback);
        }
    }

    public CTLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        CTLocation result = CTLocation.valueOf(this.getLocation().getKind(), this.getUniversalSelector(feedback));
        return result;
    }

    protected void checkinHelper(String comment, ControllableResource.CheckinFlag[] flags, List<String> checkouts, String viewTag, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.getProvider();
        CCaseLib cc = provider.getCCaseLib();
        if (checkouts.size() > 0) {
            boolean identicalOK = false;
            if (flags != null) {
                identicalOK = Arrays.asList(flags).contains(ControllableResource.CheckinFlag.CHECKIN_IDENTICAL);
            }
            cc.checkin(identicalOK, comment, checkouts, feedback);
            this.flush(feedback);
        }
    }

    protected void checkinAllHelper(String comment, ControllableResource.CheckinFlag[] flags, List<String> pathnames, String viewTag, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.getProvider();
        CCaseLib cc = provider.getCCaseLib();
        List<String> checkouts = cc.getCheckouts(pathnames, viewTag, feedback);
        if (checkouts.size() > 0) {
            this.checkinHelper(comment, flags, checkouts, viewTag, feedback);
        }
    }

    public Class<?> get_proxyClass() {
        return ResourceImpl.class;
    }

    public boolean isImmutable() throws WvcmException {
        return false;
    }

    public void clearPathname() {
        if (this._ccObjInfo != null) {
            this._ccObjInfo.clearPathname();
        }
    }

    public static class CTTimer {
        long _startTime = System.currentTimeMillis();

        public long duration() {
            return System.currentTimeMillis() - this._startTime;
        }
    }
}

