/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTVOB;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.DiffBLInfo;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.List;
import javax.wvcm.Baseline;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTBranchBaseline
extends CTBaseline {
    private CCaseLib cc = null;
    private static final String TOKEN_SEP = ";";
    private static final String DIRECTORY = "directory";

    public CTBranchBaseline(Location location, CTProvider provider) {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource newBaseline, Baseline.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTLocation oldBlLocation = this.getLocation();
        CTLocation oldTimeLocation = oldBlLocation.getContextLocation(CTLocation.Kind.TIMESTAMP);
        String oldTime = oldTimeLocation.getDisplayName();
        String branchOid = oldBlLocation.getContextLocation(CTLocation.Kind.BRTYPE).getDisplayName();
        String branch = this.cc.getDisplayName(branchOid, feedback);
        String compOid = oldBlLocation.getContextLocation(CTLocation.Kind.VOBCOMPONENT).getDisplayName();
        CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(this.cc, compOid, feedback);
        String mtype = compObjInfo.getMtype();
        String searchRoot = null;
        if (mtype.equals("versioned object base")) {
            searchRoot = String.valueOf('.') + this.cc.computeVobTagFromVobSelector(compObjInfo.getPathName(), feedback);
        } else if (mtype.equals("component")) {
            searchRoot = String.valueOf('.') + this.cc.getComponentRootDir(compObjInfo.getUniversalSelector(), feedback);
        }
        List<String> versionList = this.cc.findNewVersions(searchRoot, oldTime, branch, feedback);
        ArrayList<SrvcResource.SrvcCompareReport> blReports = new ArrayList<SrvcResource.SrvcCompareReport>(versionList.size());
        if (versionList.isEmpty()) {
            return blReports;
        }
        ArrayList<CTVersion> versions = new ArrayList<CTVersion>(versionList.size());
        for (String line : versionList) {
            String[] tokens = line.split(TOKEN_SEP);
            if (tokens == null) {
                throw new IllegalStateException("Could not get version");
            }
            CCaseObjInfo ccObj = new CCaseObjInfo(this.cc, tokens[1], tokens[0].startsWith(DIRECTORY), tokens[2], tokens[0]);
            versions.add(CTVersion.valueOf(this.getProvider(), ccObj, feedback));
        }
        for (CTVersion version : versions) {
            DiffBLInfo diffBLInfo = new DiffBLInfo(null, version, this.getProvider());
            SrvcResource.SrvcCompareReport baselineReport = this.computeBlReport(diffBLInfo);
            blReports.add(baselineReport);
        }
        return blReports;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        Object propertyValue = null;
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            propertyValue = this.getLocation().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            propertyValue = new CTVOB(this.getLocation().getContextLocation(CTLocation.Kind.VOBCOMPONENT), this.getProvider());
        }
        if (propertyValue == null) {
            propertyValue = super.getThisProperty(propertyName, configuration, feedback);
        }
        return propertyValue;
    }
}

