/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseDirectoryEntryMap;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCaseLib {
    private Map<String, String> ctInitArgs;
    private CommandProvider ctProvider;
    private boolean cachingEnabled;
    public static final String HOSTNAME = System.getenv(CommandProvider.IS_WINDOWS ? "COMPUTERNAME" : "HOSTNAME");
    private static final boolean HAS_MVFS = true;
    private static final String CONFIG_SPEC = String.valueOf(CommonUtils.FWDSLASH) + "config_spec";
    public static final String APPLICATION_HTML = "application/html";
    public static final String APPLICATION_MSWORD = "application/msword";
    public static final String APPLICATION_UNKNOWN = "application/unknown";
    public static final String APPLICATION_XML = "application/xml";
    public static final String TEXT_PLAIN = "text/plain";
    private static String mvfsRoot;
    private static String defaultViewDir;
    private static final String MKACT_SCRIPT_NAME = "CreateUCMActivity.pl";
    private static final String DBID_SCRIPT_NAME = "GetUCMActivityDBID.pl";
    private static final String GETACT_SCRIPT_NAME = "GetUCMActivitySelector.pl";
    private static final String GET_COMMENT_SCRIPT_NAME = "GetRecordComment.pl";
    private static final String SET_COMMENT_SCRIPT_NAME = "SetRecordComment.pl";
    private static final String PERFORM_CQ_ACTION_SCRIPT_NAME = "PerformCQAction.pl";
    private static final String CQ_PROP_FILE_EXT = ".cq_password";
    private static final String GENERIC_HEADLINE;
    private static final String RECORD_TYPE_KEY = "Record_Type";
    private static final String RECORD_ID_KEY = "Record_ID";
    private static final String QUERY_PREFIX = "CQ:cq.repo.cq-record:";
    private static Map<String, String> CQ_CREDS;
    private static String MKACT_SCRIPT;
    private static String DBID_SCRIPT;
    private static String GETACT_SCRIPT;
    private static String GET_COMMENT_SCRIPT;
    private static String SET_COMMENT_SCRIPT;
    private static String PERFORM_CQ_ACTION_SCRIPT;
    private static final String UNINITIALIZED_NOT_FOUND = "Uninitialized NOT_FOUND pattern";
    private static String NOT_FOUND_PATTERN;
    private static String NOT_FOUND;
    private static final String DOES_NOT_EXIST = "THIS_THING_DOES_NOT_EXIST";
    private static final String NF_PREFIX = "^cleartool: Error: Unable to .+? \".+?\" ?[:-] ";
    private static final String NF_PATTERN = "(.+?)";
    private static final String NF_SUFFIX = "\\.?$";
    private static final String NF_SEARCH = "^cleartool: Error: Unable to .+? \".+?\" ?[:-] (.+?)\\.?$";
    public static final String DEFAULT_CQ_ACTION = "";
    public static final boolean NO_TAGGED_MESSAGES = false;
    public static final boolean ENABLE_TAGGED_MESSAGES = true;
    private static final String CATCS = "catcs";
    private static final String CHBL = "chbl";
    private static final String CHECKIN = "checkin";
    private static final String CHECKOUT = "checkout";
    private static final String CHEVENT = "chevent";
    private static final String CHPROJECT = "chproject";
    private static final String DELIVER = "deliver";
    private static final String DESCRIBE = "describe";
    private static final String DIFFBL = "diffbl";
    private static final String DUMP = "dump";
    private static final String FIND = "find";
    private static final String LN = "ln";
    private static final String LOCK = "lock";
    private static final String LS = "ls";
    private static final String LSACTIVITY = "lsactivity";
    private static final String LSCO = "lsco";
    private static final String LSFOLDER = "lsfolder";
    private static final String LSPROJECT = "lsproject";
    private static final String LSSTREAM = "lsstream";
    private static final String LSTYPE = "lstype";
    private static final String LSVIEW = "lsview";
    private static final String LSVOB = "lsvob";
    private static final String MKACT = "mkact";
    private static final String MKATTR = "mkattr";
    private static final String MKBL = "mkbl";
    private static final String MKBRTYPE = "mkbrtype";
    private static final String MKCOMP = "mkcomp";
    private static final String MKDIR = "mkdir";
    private static final String MKELEM = "mkelem";
    private static final String MKFOLDER = "mkfolder";
    private static final String MKHLINK = "mkhlink";
    private static final String MKLBTYPE = "mklbtype";
    private static final String MKPROJECT = "mkproject";
    private static final String MKTRTYPE = "mktrtype";
    private static final String MKSTREAM = "mkstream";
    private static final String MKVIEW = "mkview";
    private static final String MKVOB = "mkvob";
    private static final String MOVE = "move";
    private static final String MOUNT = "mount";
    private static final String PROTECT = "protect";
    public static final String PWV = "pwv";
    private static final String REBASE = "rebase";
    private static final String RMATTR = "rmattr";
    private static final String RMBRANCH = "rmbranch";
    private static final String RMFOLDER = "rmfolder";
    private static final String RMNAME = "rmname";
    private static final String RMSTREAM = "rmstream";
    private static final String RMTYPE = "rmtype";
    private static final String RMVIEW = "rmview";
    private static final String RMVOB = "rmvob";
    private static final String SETACT = "setact";
    private static final String SETCS = "setcs";
    private static final String STARTVIEW = "startview";
    private static final String UMOUNT = "umount";
    private static final String UNCHECKOUT = "uncheckout";
    private static final String UNLOCK = "unlock";
    private static final String MKTYPE_PREFIX = "mk";
    private static final String _ABORT = "-abort";
    private static final String _ACTIVITIES = "-activities";
    private static final String _ALL = "-all";
    private static final String _AMODCOMP = "-amodcomp";
    private static final String _BASELINE = "-baseline";
    private static final String _BRANCH = "-branch";
    private static final String _CACT = "-cact";
    private static final String _CANCEL = "-cancel";
    private static final String _CHMOD = "-chmod";
    private static final String _CI = "-ci";
    private static final String _COMMENT = "-comment";
    private static final String _COMPLETE = "-complete";
    private static final String _COMPONENT = "-component";
    private static final String _CURRENT = "-current";
    private static final String _CVIEW = "-cview";
    private static final String _DUMP = "-dump";
    private static final String _EXEC = "-exec";
    private static final String _EXECWIN = "-execwin";
    private static final String _EXECUNIX = "-execunix";
    private static final String _FAMILY = "-family";
    private static final String _FMT = "-fmt";
    private static final String _FORCE = "-force";
    private static final String _GLOBAL = "-global";
    private static final String _GPATH = "-gpath";
    private static final String _HEADLINE = "-headline";
    private static final String _HOST = "-host";
    private static final String _HPATH = "-hpath";
    private static final String _IDENTICAL = "-identical";
    private static final String _IN = "-in";
    private static final String _INCREMENTAL = "-incremental";
    private static final String _INTEGRATION = "-integration";
    private static final String _INVOB = "-invob";
    private static final String _LONG = "-long";
    private static final String _MASTER = "-master";
    private static final String _ME = "-me";
    private static final String _MODCOMP = "-modcomp";
    public static final String _MVFSROOT = "-mvfsroot";
    private static final String _NC = "-nc";
    public static final String _NONE = "-none";
    private static final String _NSET = "-nset";
    private static final String _NUSERS = "-nusers";
    private static final String _NWARN = "-nwarn";
    private static final String _PREOP = "-preop";
    private static final String _PRINT = "-print";
    private static final String _RECURSE = "-recurse";
    private static final String _REPLACE = "-replace";
    private static final String _RM = "-rm";
    private static final String _RMALL = "-rmall";
    private static final String _ROOT = "-root";
    private static final String _S = "-s";
    private static final String _SHARED = "-shared";
    private static final String _SHORT = "-short";
    private static final String _STREAM = "-stream";
    private static final String _TAG = "-tag";
    private static final String _TMODE = "-tmode";
    private static final String _TO = "-to";
    private static final String _UCMOBJECT = "-ucmobject";
    private static final String _UCMPROJECT = "-ucmproject";
    private static final String _VERSION = "-version";
    private static final String _VERSIONS = "-versions";
    private static final String _VIEW = "-view";
    private static final String FMT_CO = "%Rf";
    private static final String FMT_COMPONENTS_CXP = "%[components]CXp";
    private static final String FMT_COMPONENT_XP = "%[component]Xp";
    private static final String FMT_CONTAINS_FOLDERS_CXP = "%[contains_folders]CXp";
    private static final String FMT_CONTAINS_PROJECTS_CXP = "%[contains_projects]CXp";
    private static final String FMT_CRM_RECORD_TYPE_P = "%[crm_record_type]p";
    private static final String FMT_CRM_RECORD_ID_P = "%[crm_record_id]p";
    private static final String FMT_DEF_DELIVER_TGT_XP = "%[def_deliver_tgt]Xp";
    private static final String FMT_DSTREAMS_CXP = "%[dstreams]CXp";
    private static final String FMT_ELEMENT_TYPE = "%[type]p";
    private static final String FMT_EN = "%En";
    private static final String FMT_INITIAL_BL_XP = "%[initial_bl]Xp";
    private static final String FMT_ISSTREAM_CXP = "%[istream]CXp";
    private static final String FMT_LATEST_BLS_CXP = "%[latest_bls]CXp";
    private static final String FMT_LOCKED_P = "%[locked]p";
    private static final String FMT_MTYPE = "%m";
    private static final String FMT_N = "%n";
    private static final String FMT_NC = "%Nc";
    private static final String FMT_PERMISSIONS_P = "%[permissions]p";
    private static final String FMT_PROJECT_XP = "%[project]Xp";
    private static final String FMT_ROOT_DIR = "%[root_dir]p";
    private static final String FMT_SLINK_TEXT_P = "%[slink_text]p";
    private static final String FMT_TYPE_P = "%[type]p";
    private static final String FMT_UNIVERSAL_SELECTOR_P = "%[universal_selector]p";
    private static final String FMT_UNIVERSAL_SELECTOR_XP = "%[universal_selector]%Xp";
    private static final String FMT_XN = "%Xn";
    private static final String FMT_HLINK_PREFIX = "%[hlink:";
    private static final String FMT_NEWLINE = "\\n";
    private static final String FMT_SUFFIX = "]p";
    private static final String PLUS_X = "+x";
    private static final String MINUS_X = "-x";
    public static final String ADMIN_VOB = "AdminVOB";
    private static final String ATTRIBUTE = "attribute";
    private static final String BASELINE_LBTYPE = "BaselineLbtype";
    private static final String BRANCH_LATEST = "/LATEST";
    private static final String COMPONENT_ROOT_DIR_HLTYPE = "ComponentRootDir";
    private static final String HYPERLINK = "hyperlink";
    private static final String INDEPENDENT_GUARD = "IndependentGuard";
    private static final String LOCKED = "locked";
    public static final String LOST_AND_FOUND_NAME = "lost+found";
    private static final String MTYPE_EQUALS_SYMBOLIC_LINK = "mtype=symbolic link";
    private static final String QUERY_BRTYPE_PREFIX = "brtype(";
    private static final String QUERY_CREATED_SINCE_PREFIX = "created_since(";
    private static final char QUERY_SUFFIX_CHAR = ')';
    private static final String QUERY_VERSION_PREFIX = "version(.../";
    public static final String ROOT_FOLDER = "RootFolder";
    private static final String LATEST = "LATEST";
    private static final String CHECKEDOUT = "CHECKEDOUT";
    private static final String BACKSTOP = "BACKSTOP";
    private static final Pattern OBJECT_ALREADY_EXISTS_PATTERN;
    private static final String DEFAULT_MVFSROOT;
    public static final String AT_AT = "@@";
    private static final String SEMI_COLON = ";";
    private static final String AMPAMP = " && ";
    public static final String SPACE = " ";
    public static final String EMPTY_STRING;
    private static final String COMMA;
    private static final String ADD = "add";
    private static final String _DATABASE = "-database";
    private static final String _CONNECTION = "-connection";
    static final String _USERNAME = "-username";
    static final String _PASSWORD = "-password";
    private static final String _USERDB = "-userdb";
    private static final String _DBSET = "-dbset";
    private static final String _TYPE = "-type";
    private static final String _ID = "-id";
    private static final String _DBID = "-dbid";
    private static final String _ACTION = "-action";
    private static final String COVOB_ATTR_NAMESPACE = "com.ibm.team.interop";
    private static final String COVOB_ATTR_NAME = "CoVOB";
    private static final String COVOB_ATTR = "com.ibm.team.interop_CoVOB";
    private static final String MVFS_CASE_PRESERVING_MODE = "Case PRESERVING mode";
    private static final String MVFS_DOWNCASING_MODE = "Downcasing mode";
    Log log = null;
    public static final String DIRECTORY_CONTENT_TYPE = "text/directory";
    private Cache _elementTypeToMimeContentType = new Cache();
    private static final String NO_BRANCH_CHECKED_OUT = "Error: No branch of element is checked out to view";
    private static final String UNABLE_TO_FIND_CHECKED_OUT_VERSION = "Error: Unable to find checked out version for";
    private static final Pattern NOT_CHECKED_IN_PATTERN;
    private static final Pattern CHECKIN_IDENTICAL_ERR_PATTERN;
    private static final Pattern LS_VOB_OUT_PATTERN;
    private static final Pattern VOB_SEL_PATTERN;
    private Cache describeOutputByName = new Cache();
    private static final String UTF_8 = "UTF-8";
    private Cache componentByBaseline = new Cache();
    private static final Pattern NAME_PATTERN;
    private static final Pattern OID_PATTERN;
    private static final Pattern ELEM_DBID_PATTERN;
    private static final Pattern DUMP_OID_PATTERN;
    private static final Pattern MTYPE_PATTERN;
    public static final String DUMP_MTYPE_DIRECTORY = "2";
    public static final String LITERAL_VERTICAL_BAR_PATTERN = "\\|";
    private Cache streamByView = new Cache();
    private Cache projectByStream = new Cache();
    private Cache labeltypeByBaseline = new Cache();
    private static Set<String> viewsOnUCMCQStreams;
    private static Set<String> activityOnNonCQEnabledProject;
    private static Set<String> activityOnCQEnabledProject;
    private static final Pattern CREATED_BASELINE_PATTERN;
    private static final Pattern UNLABELED_BASELINE_PATTERN;
    private static final Pattern COMPONENT_LINE_PATTERN;
    private Cache rootDirByComponentAndView = new Cache();
    private static final Pattern COMP_ROOT_DIR_PATTERN;
    private static final Pattern HLINK_TARGET_LEFT_ARROW_PATTERN;
    private static final Pattern LS_VOBVIEW_PATTERN;
    private Cache extendedNameByUSel = new Cache();
    private static final Pattern CANT_CONTACT_ALBD_PATTERN;
    private Cache baseCCViewInfo = new Cache();
    public static final Pattern SUPERTYPE_PATTERN;
    private Cache queryStringForActivity = new Cache();
    private Cache ucmActivityPvar = new Cache();
    private Cache recordDbids = new Cache();
    private Cache activityFromQueryString = new Cache();
    private Cache activitySelectorFromRecord = new Cache();
    private static final Pattern CRDE_PATTERN;
    private Cache intstreamByStream = new Cache();
    private Cache intstreamByProject = new Cache();
    private static Set<String> isBaseCCView;
    private static Set<String> isUCMView;
    private static Map<String, List<String>> checkoutVobs;
    static final Pattern ELEM_PNAME_TAG_ID_PATTERN;
    static final Pattern ELEM_PNAME_TAG_VALUE_PATTERN;
    static final Pattern USER_PERMS_TAG_ID_PATTERN;
    static final Pattern USER_PERMS_TAG_VALUE_PATTERN;
    public static String littleX;
    private static final Pattern LOGFILE_PATTERN;
    private static final String EITHER_SLASH = ".*[/\\\\]";
    private static final String EOS_OR_EITHER_SLASH = "($|.*[/\\\\].+)";
    private static final String lAndFPattern = ".*[/\\\\]lost\\+found($|.*[/\\\\].+)";

    static {
        GENERIC_HEADLINE = Messages.CCaseLib_CQ_RECORD_NAME;
        CQ_CREDS = null;
        MKACT_SCRIPT = null;
        DBID_SCRIPT = null;
        GETACT_SCRIPT = null;
        GET_COMMENT_SCRIPT = null;
        SET_COMMENT_SCRIPT = null;
        PERFORM_CQ_ACTION_SCRIPT = null;
        NOT_FOUND_PATTERN = UNINITIALIZED_NOT_FOUND;
        NOT_FOUND = UNINITIALIZED_NOT_FOUND;
        OBJECT_ALREADY_EXISTS_PATTERN = Pattern.compile("^.*?Error: Name \"(.*?)\" already exists.");
        DEFAULT_MVFSROOT = CommandProvider.IS_WINDOWS ? "M:" : "/view";
        EMPTY_STRING = new String();
        COMMA = String.valueOf(',');
        NOT_CHECKED_IN_PATTERN = Pattern.compile("^.*?Error: Unable to check in \"(.*?)\"\\.");
        CHECKIN_IDENTICAL_ERR_PATTERN = Pattern.compile("^.*?By default, won't create version with data identical to predecessor.$");
        LS_VOB_OUT_PATTERN = Pattern.compile("^[ \\*] (.*?) .*? .*? \\(.*ucmvob.*\\)");
        VOB_SEL_PATTERN = Pattern.compile("vob:(.+?)");
        NAME_PATTERN = Pattern.compile("===> name: \"(.*?)\", ino: .*");
        OID_PATTERN = Pattern.compile("     cataloged oid: ([0-9a-f.:]+) \\(mtype .*");
        ELEM_DBID_PATTERN = Pattern.compile("^elem=([0-9]+)  branch=.*");
        DUMP_OID_PATTERN = Pattern.compile("^oid=([^ ]*)");
        MTYPE_PATTERN = Pattern.compile("     cataloged oid: [0-9a-f.:]+ \\(mtype ([0-9]+)\\)");
        viewsOnUCMCQStreams = Collections.synchronizedSet(new HashSet());
        activityOnNonCQEnabledProject = Collections.synchronizedSet(new HashSet());
        activityOnCQEnabledProject = Collections.synchronizedSet(new HashSet());
        CREATED_BASELINE_PATTERN = Pattern.compile("Created baseline \"(.+?)\" in component.+");
        UNLABELED_BASELINE_PATTERN = Pattern.compile("cleartool: Warning: Some of stream \"(.+?)\"'s latest baselines are not labeled\nUnlabeled baselines can't be recommended and can't be rebased to.\nUse \"cleartool chbl -incremental <baseline-selector>\" to label these baselines:\n(.+?)");
        COMPONENT_LINE_PATTERN = Pattern.compile("(.+?) \\(component (.+?)\\)");
        COMP_ROOT_DIR_PATTERN = Pattern.compile(".+ -> \"(.+)@@\" ");
        HLINK_TARGET_LEFT_ARROW_PATTERN = Pattern.compile("\".+?\" <- \"(.+)\" ");
        LS_VOBVIEW_PATTERN = Pattern.compile("^.? +.+? +([^ ]+)");
        CANT_CONTACT_ALBD_PATTERN = Pattern.compile("^cleartool: Error: Unable to contact albd_server on host '(.*?)'");
        SUPERTYPE_PATTERN = Pattern.compile("^  supertype: (.+)");
        CRDE_PATTERN = Pattern.compile("^crde=(\\d+) *$");
        isBaseCCView = Collections.synchronizedSet(new HashSet());
        isUCMView = Collections.synchronizedSet(new HashSet());
        checkoutVobs = new Hashtable<String, List<String>>();
        ELEM_PNAME_TAG_ID_PATTERN = Pattern.compile("TAG_ID:cmd!!\\d+!!272:END_ID");
        ELEM_PNAME_TAG_VALUE_PATTERN = Pattern.compile("TAG_VALUES:(.+):END_VALUES");
        USER_PERMS_TAG_ID_PATTERN = Pattern.compile("TAG_ID:cmd!!\\d+!!349:END_ID");
        USER_PERMS_TAG_VALUE_PATTERN = Pattern.compile("TAG_VALUES:.+!!(...):END_VALUES");
        littleX = String.valueOf('x');
        LOGFILE_PATTERN = Pattern.compile("^\\s*Kernel logfile:\\s+\"(.+)\"$");
    }

    public static final String getTextMode() {
        String text_mode = System.getProperty("com.ibm.rational.wvcm.ct.TEXT_MODE", "transparent");
        return text_mode;
    }

    public static final String getDefaultViewDir() {
        return defaultViewDir;
    }

    public void logIgnoredException(String operation, Exception e) {
        if (this.log == null) {
            this.log = LogFactory.getLog((String)CCaseLib.class.getName());
        }
        this.log.debug((Object)("Failure ignored in attempt to " + operation + ": " + e.getMessage()));
    }

    public CCaseLib(CommandProvider provider, Map<String, String> initArgs, boolean enableCaching) {
        this.ctProvider = provider;
        this.ctInitArgs = initArgs == null ? new HashMap() : initArgs;
        this.cachingEnabled = enableCaching;
        SrvcFeedback feedback = new SrvcFeedback(null);
        try {
            mvfsRoot = this.ctProvider.execute(feedback, PWV, _MVFSROOT);
        }
        catch (WvcmException e) {
            mvfsRoot = DEFAULT_MVFSROOT;
            this.logIgnoredException("get MVFS root", (Exception)((Object)e));
        }
        String defaultViewTag = CTInitArgUtils.getViewTag(this.ctInitArgs);
        defaultViewDir = defaultViewTag == null ? null : CCaseLib.getPathIntoView(defaultViewTag);
        this._elementTypeToMimeContentType.put(null, "binary_delta_file", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "compressed_file", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "compressed_text_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, "directory", DIRECTORY_CONTENT_TYPE);
        this._elementTypeToMimeContentType.put(null, "file", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "file_system_object", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "html", APPLICATION_HTML);
        this._elementTypeToMimeContentType.put(null, "ms_word", APPLICATION_MSWORD);
        this._elementTypeToMimeContentType.put(null, "process_def_object", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "rose", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "rosert", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "text_file", TEXT_PLAIN);
        this._elementTypeToMimeContentType.put(null, "xde", APPLICATION_UNKNOWN);
        this._elementTypeToMimeContentType.put(null, "xml", APPLICATION_XML);
        this._elementTypeToMimeContentType.put(null, new String(), APPLICATION_UNKNOWN);
        try {
            CommandResult result = this.ctProvider.executeGetResult(feedback, DESCRIBE, _SHORT, DOES_NOT_EXIST);
            String error = result.getStdErr();
            Pattern pattern = Pattern.compile(NF_SEARCH);
            Matcher m = pattern.matcher(error);
            if (m.find()) {
                NOT_FOUND = m.group(1);
                NOT_FOUND_PATTERN = NF_PREFIX + NOT_FOUND + NF_SUFFIX;
            }
        }
        catch (WvcmException e) {
            this.logIgnoredException("get \"not found\" string", (Exception)((Object)e));
        }
    }

    public static final String getNotFoundPattern() throws WvcmException {
        if (NOT_FOUND_PATTERN.equals(UNINITIALIZED_NOT_FOUND)) {
            throw new WvcmException(UNINITIALIZED_NOT_FOUND, WvcmException.ReasonCode.FORBIDDEN);
        }
        return NOT_FOUND_PATTERN;
    }

    public static final String getNotFound() throws WvcmException {
        if (NOT_FOUND.equals(UNINITIALIZED_NOT_FOUND)) {
            throw new WvcmException(UNINITIALIZED_NOT_FOUND, WvcmException.ReasonCode.FORBIDDEN);
        }
        return NOT_FOUND;
    }

    public static final String getMvfsRoot() {
        if (mvfsRoot == null) {
            throw new IllegalStateException("CCaseLib has not been initialized");
        }
        return mvfsRoot;
    }

    public static final String getPathIntoView(String viewTag) {
        return String.format("%s%s%s", mvfsRoot, File.separator, viewTag);
    }

    public void checkin(boolean identicalOK, String comment, List<String> checkouts, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(7);
        cleartoolArgs.add(CHECKIN);
        cleartoolArgs.add(_NWARN);
        if (identicalOK) {
            cleartoolArgs.add(_IDENTICAL);
        }
        if (comment == null) {
            cleartoolArgs.add(_NC);
        } else {
            cleartoolArgs.add(_COMMENT);
            cleartoolArgs.add(comment);
        }
        List<CommandResult> checkoutResults = this.executeBatched(feedback, null, false, cleartoolArgs, checkouts);
        for (CommandResult checkoutResult : checkoutResults) {
            if (checkoutResult.getStat() == 0 || identicalOK || checkoutResult.getStdErrList() == null) continue;
            List<String> pathsToUnco = CCaseLib.getPathsToUnco(checkouts.size(), checkoutResult);
            if (pathsToUnco.size() > 0) {
                System.out.printf("** Duplicate content write to ClearCase\n", new Object[0]);
                this.uncheckoutSilently(pathsToUnco, feedback);
            }
            ArrayList<String> newStdErr = new ArrayList<String>(checkoutResult.getStdErrList().size());
            for (String line : checkoutResult.getStdErrList()) {
                if (line.contains(NO_BRANCH_CHECKED_OUT) || line.contains(UNABLE_TO_FIND_CHECKED_OUT_VERSION)) {
                    feedback.notifyWarning(NLS.bind((String)Messages.CCaseLib_WARNING_IGNORE_CLEARTOOL_ERROR, (Object)line));
                    continue;
                }
                newStdErr.add(line);
            }
            checkoutResult.updateResults(checkoutResult.getStat(), newStdErr, checkoutResult.getStdOutList(), checkoutResult.getDurationMillis());
            if (checkoutResult.getStdErrList().isEmpty()) continue;
            CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
            checkoutResult.assertSuccess(ignoreFlags);
        }
    }

    public static List<String> getPathsToUnco(int size, CommandResult checkoutResult) throws WvcmException {
        ArrayList<String> pathsToUnco = new ArrayList<String>(size);
        List<String> stdErr = checkoutResult.getStdErrList();
        ArrayList<String> newStdErr = new ArrayList<String>(stdErr.size());
        boolean getNotCheckedInName = false;
        for (String line : stdErr) {
            if (getNotCheckedInName) {
                Matcher notCheckedIn = NOT_CHECKED_IN_PATTERN.matcher(line);
                if (notCheckedIn.find()) {
                    String uncheckout = notCheckedIn.replaceAll("$1");
                    pathsToUnco.add(uncheckout);
                }
                getNotCheckedInName = false;
                continue;
            }
            Matcher m = CHECKIN_IDENTICAL_ERR_PATTERN.matcher(line);
            getNotCheckedInName = m.find();
            if (getNotCheckedInName) continue;
            newStdErr.add(line);
        }
        checkoutResult.updateResults(checkoutResult.getStat(), newStdErr, checkoutResult.getStdOutList(), checkoutResult.getDurationMillis());
        return pathsToUnco;
    }

    private void uncheckoutSilently(List<String> checkouts, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(UNCHECKOUT, _RM));
        this.executeBatched(feedback, cleartoolArgs, checkouts);
    }

    public List<String> getCheckouts(List<String> componentRoots, String viewTag, SrvcFeedback feedback) throws WvcmException {
        List<String> checkouts = new ArrayList<String>();
        if (!componentRoots.isEmpty()) {
            CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
            ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(LSCO, _CVIEW, _ME, _SHORT, _ALL));
            checkouts = this.executeBatched(feedback, CCaseLib.getPathIntoView(viewTag), ignoreFlags, false, cleartoolArgs, componentRoots);
            if (checkouts.size() > 1) {
                HashSet<String> fixedCheckouts = new HashSet<String>(checkouts.size());
                fixedCheckouts.addAll(checkouts);
                if (fixedCheckouts.size() < checkouts.size()) {
                    checkouts = new ArrayList(fixedCheckouts.size());
                    checkouts.addAll(fixedCheckouts);
                }
            }
        }
        return checkouts;
    }

    private List<CommandResult> executeBatched(SrvcFeedback feedback, String cwd, boolean enableTaggedMessages, List<String> cleartoolArgs, List<String> objNames) throws WvcmException {
        ArrayList<CommandResult> result = new ArrayList<CommandResult>(objNames.size());
        ArrayList<String> args = new ArrayList<String>(cleartoolArgs);
        int maxCmdLen = CTInitArgUtils.getMaxCmdLen(this.ctInitArgs);
        int cleartoolArgLen = 0;
        for (String cleartoolArg : cleartoolArgs) {
            cleartoolArgLen += cleartoolArg.length() + 1;
        }
        int cmdLen = cleartoolArgLen;
        for (String objName : objNames) {
            int newLen = cmdLen + objName.length() + 1;
            if (newLen <= maxCmdLen) {
                cmdLen = newLen;
            } else {
                result.add(this.ctProvider.executeGetResult(feedback, cwd, enableTaggedMessages, args));
                args.clear();
                args.addAll(cleartoolArgs);
                cmdLen = cleartoolArgLen + objName.length() + 1;
            }
            args.add(objName);
        }
        result.add(this.ctProvider.executeGetResult(feedback, cwd, enableTaggedMessages, args));
        return result;
    }

    private List<String> executeBatched(SrvcFeedback feedback, String cwd, CommandResult.IgnoreFlags flags, boolean enableTaggedMessages, List<String> cleartoolArgs, List<String> objNames) throws WvcmException {
        List<CommandResult> commandResults = this.executeBatched(feedback, cwd, enableTaggedMessages, cleartoolArgs, objNames);
        ArrayList<String> result = new ArrayList<String>(objNames.size());
        for (CommandResult r : commandResults) {
            r.assertSuccess(flags);
            result.addAll(r.getStdOutList());
        }
        return result;
    }

    private List<String> executeBatched(SrvcFeedback feedback, List<String> cleartoolArgs, List<String> objNames) throws WvcmException {
        return this.executeBatched(feedback, null, new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO), false, cleartoolArgs, objNames);
    }

    public List<String> findStreams(String pVobTag, String filter, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(LSSTREAM, _FMT, "%Xn\\n"));
        if (filter != null && filter.length() != 0) {
            if (all) {
                cleartoolArgs.add(_RECURSE);
            }
            cleartoolArgs.add(_IN);
            cleartoolArgs.add(String.valueOf(filter) + '@' + pVobTag);
        } else {
            cleartoolArgs.add(_INVOB);
            cleartoolArgs.add(pVobTag);
        }
        return this.ctProvider.executeGetValues(feedback, cleartoolArgs);
    }

    public List<String> getPvobSelectors(boolean all, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSVOB);
        r.assertSuccess(new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO));
        if (r.getStat() != 0 || r.getStdOutList() == null || r.getStdOutList().size() == 0) {
            throw new WvcmException(Messages.CCaseLib_NO_VOBS_FOUND, WvcmException.ReasonCode.NOT_FOUND);
        }
        ArrayList<String> pvobs = new ArrayList<String>();
        int i = 0;
        while (i < r.getStdOutList().size()) {
            Matcher m = LS_VOB_OUT_PATTERN.matcher(r.getStdOutList().get(i));
            if (m.find()) {
                pvobs.add(ObjSelUtils.formatSelector("vob", m.group(1)));
                if (!all) {
                    return pvobs;
                }
            }
            ++i;
        }
        return pvobs;
    }

    public List<String> findUcmObjSels(String ucmObjSel, boolean children, SrvcFeedback feedback) throws WvcmException {
        List<String> cmd;
        List<String> childCmd;
        List<String> sourceCmd;
        Matcher m = VOB_SEL_PATTERN.matcher(ucmObjSel);
        if (m.find()) {
            return this.findUcmObjSels(m.replaceFirst(String.format("folder:%s@$1", ROOT_FOLDER)), children, feedback);
        }
        String objKind = ObjSelUtils.getObjSelKind(ucmObjSel);
        if (objKind == null) {
            objKind = this.getUcmObjKind(ucmObjSel, feedback);
        }
        if (objKind.equals("folder")) {
            sourceCmd = null;
            childCmd = Arrays.asList(LSFOLDER, _FMT, FMT_CONTAINS_FOLDERS_CXP, FMT_CONTAINS_PROJECTS_CXP, ucmObjSel);
        } else if (objKind.equals("project")) {
            sourceCmd = null;
            childCmd = Arrays.asList(LSPROJECT, _FMT, FMT_ISSTREAM_CXP, ucmObjSel);
        } else if (objKind.equals("stream")) {
            sourceCmd = Arrays.asList(LSSTREAM, _FMT, FMT_DSTREAMS_CXP, ucmObjSel);
            childCmd = null;
        } else {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_FIND_UCM_OBJ_LOCATIONS_BAD_OBJECT_KIND_ERROR, (Object)objKind), WvcmException.ReasonCode.FORBIDDEN);
        }
        List<String> list = cmd = children ? childCmd : sourceCmd;
        if (cmd == null) {
            return Collections.emptyList();
        }
        List<String> outList = this.ctProvider.executeGetValues(feedback, cmd);
        List<String> objSels = CommandResult.splitStdOutList(outList);
        return objSels;
    }

    public void deliverStream(String fromStream, String toView, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, DELIVER, _COMPLETE, _FORCE, _ABORT, _STREAM, fromStream, _TO, toView);
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        r.assertSuccess(ignoreFlags);
        if (r.getStat() != 0) {
            this.ctProvider.execute(feedback, DELIVER, _CANCEL, _FORCE, _STREAM, fromStream);
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_DELIVER_FAILED_ERROR, (Object)r.getStdErr()), WvcmException.ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
        }
    }

    public void lock(String objSel, SrvcFeedback feedback) throws WvcmException {
        String loginName = System.getProperty("user.name");
        String expectedCCLoginName = CTInitArgUtils.getCCLoginName(this.ctInitArgs);
        if (expectedCCLoginName != null && !expectedCCLoginName.equals(loginName)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_UNEXPECTED_LOGIN_NAME, (Object)loginName, (Object)expectedCCLoginName), WvcmException.ReasonCode.UNAUTHORIZED);
        }
        this.ctProvider.execute(feedback, LOCK, _NUSERS, loginName, objSel);
    }

    public void unlock(String objSel, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, UNLOCK, objSel);
    }

    public boolean isLocked(String objSel, SrvcFeedback feedback) throws WvcmException {
        String stdOut = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_LOCKED_P, objSel);
        return stdOut.equals(LOCKED);
    }

    public void checkout(String pathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, CHECKOUT, _NC, pathname);
    }

    public void checkout(String pathname, String viewTag, String streamSelector, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, CHECKOUT, _NC, pathname);
        if (r.getStdErr().contains("cleartool: Error: To operate on UCM branch, must be set to an activity and a UCM view.")) {
            try {
                this.makeActivityInView(viewTag, streamSelector, null, null, true, feedback);
            }
            catch (WvcmException e) {
                this.logIgnoredException("make activity in the context of a checkout operation", (Exception)((Object)e));
            }
            this.checkout(pathname, feedback);
        } else {
            CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
            r.assertSuccess(ignoreFlags);
        }
    }

    public void uncheckout(String pathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, UNCHECKOUT, _RM, pathname);
    }

    public List<String[]> describeForVerInfo(List<String> pathnames, CommandResult.IgnoreFlags flags, SrvcFeedback feedback) throws WvcmException {
        return this.describeForObjInfo(pathnames, true, false, flags, feedback);
    }

    public List<String[]> describeForElemInfo(List<String> pathnames, CommandResult.IgnoreFlags flags, SrvcFeedback feedback) throws WvcmException {
        return this.describeForObjInfo(pathnames, false, true, flags, feedback);
    }

    public List<String[]> describeForObjInfo(List<String> pathnames, CommandResult.IgnoreFlags flags, SrvcFeedback feedback) throws WvcmException {
        return this.describeForObjInfo(pathnames, false, false, flags, feedback);
    }

    private List<String[]> describeForObjInfo(List<String> pathnames, boolean getElementPathName, boolean getElementInfo, CommandResult.IgnoreFlags flags, SrvcFeedback feedback) throws WvcmException {
        if (getElementPathName && getElementInfo) {
            throw new IllegalArgumentException("Only one of getElementPathName and getElementType may be specified");
        }
        ArrayList<String> stdOutList = new ArrayList<String>(pathnames.size());
        ArrayList<String> subsetToDescribe = new ArrayList<String>();
        for (String pathname : pathnames) {
            String describeOutput = this.describeOutputByName.get(null, pathname);
            if (describeOutput == null) {
                subsetToDescribe.add(pathname);
                continue;
            }
            stdOutList.add(describeOutput);
        }
        int count = 3;
        String format = "%m|%[universal_selector]p|%n";
        if (getElementPathName) {
            format = String.valueOf(format) + "|%En";
            ++count;
        } else if (getElementInfo) {
            format = String.valueOf(format) + "|%[type]p|%[permissions]p";
            count += 2;
        }
        format = String.valueOf(format) + FMT_NEWLINE;
        ArrayList<String> argsPrefix = new ArrayList<String>((Collection)Arrays.asList(DESCRIBE, _FMT, format));
        stdOutList.addAll(this.executeBatched(feedback, null, flags, false, argsPrefix, subsetToDescribe));
        ArrayList<String[]> result = new ArrayList<String[]>(pathnames.size());
        for (String line : stdOutList) {
            String mtype;
            String[] tokens = CCaseLib.getObjInfoTokens(line, count);
            if (getElementPathName) {
                tokens[3] = ObjSelUtils.extendedElemPathName(tokens[3]);
            }
            if (!(mtype = tokens[0]).endsWith("version") && !mtype.equals("symbolic link")) {
                if (getElementPathName) {
                    throw new IllegalArgumentException("Caller requested element pathname, but object is not a version, line: " + line);
                }
                if (!mtype.endsWith("element")) {
                    if (getElementInfo) {
                        throw new IllegalArgumentException("Caller requested element type, but object is not an element: " + line);
                    }
                    if (!mtype.equals("view private object") && !mtype.equals("symbolic link")) {
                        String name = tokens[2];
                        this.describeOutputByName.put(null, name, line);
                    }
                }
            }
            result.add(tokens);
        }
        return result;
    }

    public String[] describeForObjInfo(String pathname, CommandResult.IgnoreFlags flags, SrvcFeedback feedback) throws WvcmException {
        List<String[]> describeOutput = this.describeForObjInfo(Collections.singletonList(pathname), flags, feedback);
        if (describeOutput.isEmpty()) {
            return new String[0];
        }
        return describeOutput.get(0);
    }

    public List<String> describeGetElemPathnames(List<String> verStrings, CommandResult.IgnoreFlags flags, SrvcFeedback feedback) throws WvcmException {
        if (verStrings.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(DESCRIBE, _FMT, "%En\\n"));
        return this.executeBatched(feedback, null, flags, false, cleartoolArgs, verStrings);
    }

    public String describeShort(String arg, CommandResult.IgnoreFlags flags, String viewTag, SrvcFeedback feedback) throws WvcmException {
        String dirContext = viewTag == null ? null : CCaseLib.getPathIntoView(viewTag);
        return this.ctProvider.execute(feedback, dirContext, flags, DESCRIBE, _SHORT, arg);
    }

    public String describeGetSLink(String objSel, SrvcFeedback feedback) throws WvcmException {
        String stdOut = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_SLINK_TEXT_P, objSel);
        return stdOut;
    }

    public List<String> diffBl(boolean activities, String olderBaseline, String newerBaseline, SrvcFeedback feedback) throws WvcmException {
        String subCmd = activities ? _ACTIVITIES : _VERSIONS;
        List<String> outputLines = this.ctProvider.executeGetValues(feedback, DIFFBL, subCmd, olderBaseline, newerBaseline);
        ArrayList<String> result = new ArrayList<String>(outputLines.size());
        for (String line : outputLines) {
            if (!line.startsWith("<<") && !line.startsWith(">>") && !line.startsWith("<-") && !line.startsWith("->")) continue;
            result.add(line);
        }
        return result;
    }

    private List<String> generateAttrArgs(String attype, String objectSelector, String value) {
        String preparedValue;
        try {
            preparedValue = URLEncoder.encode(value, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Unexpected UnsupportedEncodingException encoding characters with UTF-8");
        }
        return Arrays.asList(attype, "\"" + preparedValue + "\"", objectSelector);
    }

    public String getAttr(String attype, String objectSelector, SrvcFeedback feedback) throws WvcmException {
        String value = this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%NS[" + attype + "]a", objectSelector);
        int valueLength = value.length();
        try {
            String result = valueLength <= 2 ? null : URLDecoder.decode(value.substring(1, valueLength - 1), UTF_8);
            return result;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException("Unexpected UnsupportedEncodingException decoding characters with UTF-8");
        }
    }

    public List<String> getComponents(List<String> baselineSels, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> subsetToCompute = new ArrayList<String>();
        for (String baselineSel : baselineSels) {
            String componentName = this.componentByBaseline.get(null, baselineSel);
            if (componentName != null) continue;
            subsetToCompute.add(baselineSel);
        }
        List<String> computedComponents = this.computeComponents(subsetToCompute, feedback);
        this.componentByBaseline.put(null, subsetToCompute, computedComponents);
        ArrayList<String> result = new ArrayList<String>(baselineSels.size());
        Iterator<String> it = computedComponents.iterator();
        for (String baselineSel : baselineSels) {
            String componentName = this.componentByBaseline.get(null, baselineSel);
            if (componentName == null) {
                if (!it.hasNext()) {
                    throw new IllegalStateException("Uncached component list is not of expected length");
                }
                componentName = it.next();
            }
            result.add(componentName);
        }
        return result;
    }

    public String getComponent(String baselineSel, SrvcFeedback feedback) throws WvcmException {
        return this.getComponents(Collections.singletonList(baselineSel), feedback).get(0);
    }

    public List<String> getRootedComponents(String streamSel, SrvcFeedback feedback) throws WvcmException {
        if (streamSel == null) {
            throw new IllegalArgumentException("Stream selector must not be null");
        }
        List<String> lines = this.ctProvider.executeGetValues(feedback, DESCRIBE, _FMT, FMT_COMPONENTS_CXP, streamSel);
        List<String> allComponents = CommandResult.splitStdOutList(lines);
        ArrayList<String> result = new ArrayList<String>(allComponents.size());
        List<String> rootDirHyperlinks = this.getHyperlinks(COMPONENT_ROOT_DIR_HLTYPE, allComponents, null, feedback);
        Iterator<String> it = allComponents.iterator();
        for (String rootDirHyperlink : rootDirHyperlinks) {
            if (!it.hasNext()) {
                throw new IllegalStateException("Number of root hyperlinks does not match number of components");
            }
            String component = it.next();
            if (rootDirHyperlink.length() == 0) continue;
            result.add(component);
        }
        return result;
    }

    public String getInitialBaseline(String compSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_INITIAL_BL_XP, compSel);
    }

    public void syncToStreamConfiguration(String viewTag, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, SETCS, _STREAM, _TAG, viewTag);
    }

    public String getCurrentActivityName(String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, LSACTIVITY, _SHORT, _CACT, _VIEW, viewTag);
    }

    public String getCurrentActivity(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String curAct = this.ctProvider.execute(feedback, LSACTIVITY, _CACT, _FMT, FMT_UNIVERSAL_SELECTOR_P, _VIEW, viewTag);
        return curAct.length() == 0 ? null : curAct;
    }

    public CCaseDirectoryEntryMap getDirectoryOfVobObjects(String verString, String vobuuid, SrvcFeedback feedback) throws WvcmException {
        if (verString == null) {
            throw new IllegalArgumentException("Null version for getDirectory()");
        }
        List<String> entryLines = this.ctProvider.executeGetValues(feedback, LS, _DUMP, verString);
        if (entryLines == null) {
            throw new IllegalArgumentException("getDirectoryOfVobObjects: null result from executing ls -dump of " + verString);
        }
        CCaseDirectoryEntryMap result = new CCaseDirectoryEntryMap(entryLines.size());
        boolean lookingForName = true;
        String name = null;
        for (String line : entryLines) {
            if (lookingForName) {
                Matcher nameMatcher = NAME_PATTERN.matcher(line);
                if (!nameMatcher.find() || (name = nameMatcher.replaceFirst("$1")).equals(LOST_AND_FOUND_NAME)) continue;
                lookingForName = false;
                continue;
            }
            Matcher oidMatcher = OID_PATTERN.matcher(line);
            if (!oidMatcher.find()) continue;
            String oid = oidMatcher.replaceFirst("$1");
            result.put(ObjSelUtils.makeUsel(vobuuid, oid), name);
            lookingForName = true;
            name = null;
        }
        return result;
    }

    public String getElementUsel(String verSelectorString, String vobSel, SrvcFeedback feedback) throws WvcmException {
        List<String> verDump = this.ctProvider.executeGetValues(feedback, DUMP, verSelectorString);
        String oid = null;
        for (String line : verDump) {
            Matcher m = ELEM_DBID_PATTERN.matcher(line);
            if (m.find()) {
                String elemDbidString = m.replaceAll("$1");
                String dbidSel = ObjSelUtils.formatSelector("dbid", elemDbidString, vobSel);
                String result = this.getUniversalSelector(dbidSel, feedback);
                return result;
            }
            Matcher m2 = DUMP_OID_PATTERN.matcher(line);
            if (m2.find()) {
                oid = m2.group(1);
            }
            if (!line.startsWith(MTYPE_EQUALS_SYMBOLIC_LINK)) continue;
            String result = ObjSelUtils.formatSelector("oid", oid, vobSel);
            return result;
        }
        return null;
    }

    public List<String> getElemPathNames(List<String> pathNames, SrvcFeedback feedback) throws WvcmException {
        List<String> elemPathNamesAlmost = this.describeGetElemPathnames(pathNames, new CommandResult.IgnoreFlags(new CommandResult.IgnoreFlags.Kind[0]), feedback);
        ArrayList<String> result = new ArrayList<String>(elemPathNamesAlmost.size());
        for (String elemPathName : elemPathNamesAlmost) {
            result.add(ObjSelUtils.extendedElemPathName(elemPathName));
        }
        return result;
    }

    public String getElemPathName(String pathName, SrvcFeedback feedback) throws WvcmException {
        return this.getElemPathNames(Collections.singletonList(pathName), feedback).get(0);
    }

    private List<String> computeUniversalSelectors(List<String> objNames, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(DESCRIBE, _FMT, "%[universal_selector]p\\n"));
        return this.executeBatched(feedback, cleartoolArgs, objNames);
    }

    private String computeUniversalSelector(String objName, SrvcFeedback feedback) throws WvcmException {
        return this.computeUniversalSelectors(Collections.singletonList(objName), feedback).get(0);
    }

    public List<String> getUniversalSelectors(List<String> objNames, SrvcFeedback feedback) throws WvcmException {
        List<String> result = new ArrayList<String>(objNames.size());
        boolean needCompute = false;
        for (String objName : objNames) {
            if (!ObjSelUtils.isUniversalSelector(objName)) {
                result.clear();
                needCompute = true;
                break;
            }
            result.add(objName);
        }
        if (needCompute) {
            result = this.computeUniversalSelectors(objNames, feedback);
        }
        return result;
    }

    public String getUniversalSelector(String objName, SrvcFeedback feedback) throws WvcmException {
        return this.getUniversalSelectors(Collections.singletonList(objName), feedback).get(0);
    }

    public Map<String, Boolean> getFSDirectory(String pathname, SrvcFeedback feedback) throws WvcmException {
        if (pathname == null) {
            throw new IllegalArgumentException("Null pathname for getFSDirectory()");
        }
        String targetName = ObjSelUtils.isOidSelector(pathname) ? this.gpathNoVersionExtension(pathname, null, feedback) : pathname;
        File rootdir = new File(targetName);
        File[] files = rootdir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Can't list files for non-directory: " + targetName);
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(files.length);
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            boolean isDirectory = file.isDirectory();
            result.put(file.getName(), new Boolean(isDirectory));
            ++i;
        }
        return result;
    }

    public Map<String, String> getCCDirectory(String pathname, SrvcFeedback feedback) throws WvcmException {
        if (pathname == null) {
            throw new IllegalArgumentException("Null pathname for getCCDirectory()");
        }
        String targetName = ObjSelUtils.isOidSelector(pathname) ? this.gpathNoVersionExtension(pathname, null, feedback) : pathname;
        List<String> entryLines = this.directoryTreeHelper(targetName, false, feedback);
        HashMap<String, String> result = new HashMap<String, String>();
        String name = null;
        for (String line : entryLines) {
            if (name == null) {
                Matcher nameMatcher = NAME_PATTERN.matcher(line);
                if (!nameMatcher.find() || !(name = nameMatcher.group(1)).equals(LOST_AND_FOUND_NAME)) continue;
                name = null;
                continue;
            }
            Matcher mtypeMatcher = MTYPE_PATTERN.matcher(line);
            if (!mtypeMatcher.find()) continue;
            String mtype = mtypeMatcher.group(1);
            result.put(name, mtype);
            name = null;
        }
        return result;
    }

    private List<String> directoryTreeHelper(String targetName, boolean doRecurse, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> args = new ArrayList<String>(3);
        args.add(LS);
        if (doRecurse) {
            args.add(_RECURSE);
            args.add(_SHORT);
        } else {
            args.add(_DUMP);
        }
        args.add(targetName);
        CommandResult r = this.ctProvider.executeGetResult(feedback, null, false, args);
        if (r.getStat() != 0) {
            String pattern = "cleartool: Error: Pathname is not within a VOB:";
            if (r.getStdErr() != null && r.getStdErr().startsWith(pattern)) {
                throw new WvcmException(r.toString(), WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
            }
            r.assertSuccess(new CommandResult.IgnoreFlags(new CommandResult.IgnoreFlags.Kind[0]));
        }
        List<String> stdOutList = r.getStdOutList();
        if (r.getStdOutList() == null) {
            throw new IllegalArgumentException("directoryTreeHelper: null result from executing cleartool ls of " + targetName);
        }
        return stdOutList;
    }

    private String gpathNoVersionExtension(String pathname, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.gpath(pathname, viewTag, feedback).replaceAll("@@/.+", new String());
    }

    public List<String> getLatestRootedBaselines(String streamSel, SrvcFeedback feedback) throws WvcmException {
        List<String> allBaselines = this.getLatestBaselines(streamSel, feedback);
        List<String> rootedComponents = this.getUniversalSelectors(this.getRootedComponents(streamSel, feedback), feedback);
        List<String> allComponents = this.getComponents(allBaselines, feedback);
        ArrayList<String> result = new ArrayList<String>(rootedComponents.size());
        Iterator<String> it = allComponents.iterator();
        for (String baseline : allBaselines) {
            if (!it.hasNext()) {
                throw new IllegalStateException("Number of components does not match number of baselines");
            }
            String component = it.next();
            if (!rootedComponents.contains(component)) continue;
            result.add(baseline);
        }
        return result;
    }

    public List<String> getLatestBaselines(String streamSel, SrvcFeedback feedback) throws WvcmException {
        List<String> baselines = this.ctProvider.executeGetValues(feedback, DESCRIBE, _FMT, FMT_LATEST_BLS_CXP, streamSel);
        return CommandResult.splitStdOutList(baselines);
    }

    public static String[] getObjInfoTokens(String line, int count) {
        String[] tokens = line.split(LITERAL_VERTICAL_BAR_PATTERN);
        if (tokens.length != count) {
            StringBuffer nonLocalizedExceptionMessage = new StringBuffer(String.format("stdout line contains %d tokens, but expected %d.\n  context:\n", tokens.length, count));
            nonLocalizedExceptionMessage.append(line);
            throw new IllegalStateException(nonLocalizedExceptionMessage.toString());
        }
        return tokens;
    }

    public String computeVobTagFromVobSelector(String vobFamilyUUID, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, LSVOB, _SHORT, _FAMILY, vobFamilyUUID);
    }

    private String[] getViewsStreamSelectorParts(String viewTag, SrvcFeedback feedback) throws WvcmException {
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        String stdout = this.ctProvider.execute(feedback, null, ignoreFlags, LSSTREAM, _FMT, "%[universal_selector]%Xp|%n", _VIEW, viewTag);
        String[] parts = CCaseLib.getObjInfoTokens(stdout, 2);
        return parts;
    }

    public String getStreamUniversalSelector(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String streamSel = this.streamByView.get(null, viewTag);
        if (streamSel == null && (streamSel = this.getViewsStreamSelectorParts(viewTag, feedback)[0]).length() > 0) {
            this.streamByView.put(null, viewTag, streamSel);
        }
        return streamSel;
    }

    public String getProjectObjectSelector(String streamSel, SrvcFeedback feedback) throws WvcmException {
        String projectSel = this.projectByStream.get(null, streamSel);
        if (projectSel == null && (projectSel = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_PROJECT_XP, streamSel)) != null) {
            this.projectByStream.put(null, streamSel, projectSel);
        }
        return projectSel;
    }

    public String getVobuuid(String verString, SrvcFeedback feedback) throws WvcmException {
        String vobUSel = this.computeUniversalSelector(ObjSelUtils.formatSelector("vob", verString), feedback);
        String result = ObjSelUtils.vobUuidSubstring(vobUSel);
        return result;
    }

    public String getVobSelector(String vobTag, SrvcFeedback feedback) throws WvcmException {
        return this.computeUniversalSelector(ObjSelUtils.formatSelector("vob", vobTag), feedback);
    }

    public String getLabelTypeName(String baselineSelector, SrvcFeedback feedback) throws WvcmException {
        String lbtypeName = this.labeltypeByBaseline.get(null, baselineSelector);
        if (lbtypeName == null && (lbtypeName = this.computeTypeNameFromHyperlink(BASELINE_LBTYPE, baselineSelector, feedback)).length() > 0) {
            this.labeltypeByBaseline.put(null, baselineSelector, lbtypeName);
        }
        return lbtypeName;
    }

    private String computeTypeNameFromHyperlink(String hltype, String baselineSelector, SrvcFeedback feedback) throws WvcmException {
        List<String> targets = this.getHyperlinkTargets(hltype, baselineSelector, feedback);
        if (targets.isEmpty()) {
            return new String();
        }
        return ObjSelUtils.getObjSelName(targets.get(0));
    }

    public String makeActivityInView(String viewTag, String streamSelector, String title, String comment, boolean setCurrent, SrvcFeedback feedback) throws WvcmException {
        String streamsPvobUUIDString = ObjSelUtils.vobUuidSubstring(streamSelector);
        String activity = null;
        if (!viewsOnUCMCQStreams.contains(viewTag)) {
            List<String> cleartoolArgs = this.mkactCommandPrefixArgs(title, comment, setCurrent);
            CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
            CommandResult r = this.ctProvider.executeGetResult(feedback, CCaseLib.getPathIntoView(viewTag), false, cleartoolArgs);
            if (r.getStat() != 0) {
                String pattern = "cleartool: Error: The \"mkactivity\" command can not be used in a stream which is\ncontained in a ClearQuest-enabled project.";
                if (r.getStdErr() != null && r.getStdErr().startsWith(pattern)) {
                    activity = this.createAndSetCQActivity(title, viewTag, streamsPvobUUIDString, feedback);
                    viewsOnUCMCQStreams.add(viewTag);
                    activityOnCQEnabledProject.add(activity);
                } else {
                    r.assertSuccess(ignoreFlags);
                }
            } else {
                String info = r.getStdOut();
                activity = ObjSelUtils.createActivitySelectorFromStdOut(streamsPvobUUIDString, info);
                activityOnNonCQEnabledProject.add(activity);
            }
        } else {
            activity = this.createAndSetCQActivity(title, viewTag, streamsPvobUUIDString, feedback);
            activityOnCQEnabledProject.add(activity);
        }
        return activity;
    }

    public boolean isActivityOnCQEnabledProject(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        boolean result = false;
        if (activityOnCQEnabledProject.contains(activitySelector)) {
            result = true;
        } else if (activityOnNonCQEnabledProject.contains(activitySelector)) {
            result = false;
        } else {
            Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
            if (pvarMap.isEmpty()) {
                result = false;
                activityOnNonCQEnabledProject.add(activitySelector);
            } else {
                result = true;
                activityOnCQEnabledProject.add(activitySelector);
            }
        }
        return result;
    }

    public String makeActivityInStream(String streamSelector, String title, String comment, SrvcFeedback feedback) throws WvcmException {
        List<String> cleartoolArgs = this.mkactCommandPrefixArgs(title, comment, true);
        cleartoolArgs.add(_IN);
        cleartoolArgs.add(streamSelector);
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        String info = this.ctProvider.execute(feedback, null, ignoreFlags, cleartoolArgs.toArray(new String[cleartoolArgs.size()]));
        return ObjSelUtils.createActivitySelectorFromStdOut(ObjSelUtils.getObjSelVobSel(streamSelector), info);
    }

    private final List<String> mkactCommandPrefixArgs(String title, String comment, boolean setCurrent) {
        ArrayList<String> args = new ArrayList<String>(6);
        args.add(MKACT);
        args.add(_FORCE);
        if (title != null && title.length() != 0) {
            args.add(_HEADLINE);
            args.add(title);
        }
        if (comment != null) {
            args.add(_COMMENT);
            args.add(comment);
        }
        if (!setCurrent) {
            args.add(_NSET);
        }
        return args;
    }

    public void makeElement(boolean isDirectory, String pathname, SrvcFeedback feedback) throws WvcmException {
        if (isDirectory) {
            this.ctProvider.execute(feedback, MKDIR, _NC, _MASTER, pathname);
        } else {
            this.ctProvider.execute(feedback, MKELEM, _NC, _CI, _MASTER, pathname);
        }
    }

    public void checkoutIgnoreExpectedFailures(String viewTag, String pathname, String streamSelector, SrvcFeedback feedback) throws WvcmException {
        int status;
        String crde;
        CommandResult r = this.ctProvider.executeGetResult(feedback, CHECKOUT, _NC, pathname);
        boolean alreadyCheckedOut = false;
        for (String line : r.getStdErrList()) {
            if (line.matches("cleartool: Error: Element \".*?\" is already checked out to view \".*?\".")) {
                alreadyCheckedOut = true;
                continue;
            }
            if (line.matches("cleartool: Error: .*")) break;
        }
        if (alreadyCheckedOut) {
            return;
        }
        String stdErr = r.getStdErr();
        if (stdErr.contains("cleartool: Error: Config spec indicates that checkouts are not allowed for element") && (crde = this.getComponentCRDE(pathname, feedback)) == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTUcmView_ERROR_INVALID_UCM_COMPONENT, (Object)pathname), WvcmException.ReasonCode.NOT_FOUND);
        }
        if (stdErr.contains("the stream lacks foundation baselines")) {
            String compSel = this.getFriendlyComponentSelectorFromGPath(pathname, false, feedback);
            String projSel = this.getProjectObjectSelector(streamSelector, feedback);
            this.ctProvider.execute(feedback, CHPROJECT, _AMODCOMP, compSel, projSel);
            String blSel = ObjSelUtils.initialBaselineSelector(ObjSelUtils.getObjSelName(compSel), ObjSelUtils.getObjSelVobSel(streamSelector));
            this.rebaseStream(viewTag, streamSelector, blSel, feedback);
            r = this.ctProvider.executeGetResult(feedback, CHECKOUT, _NC, pathname);
            stdErr = r.getStdErr();
        }
        if (stdErr.contains("cleartool: Error: To operate on UCM branch, must be set to an activity and a UCM view.")) {
            this.makeActivityInView(viewTag, streamSelector, null, null, true, feedback);
            r = this.ctProvider.executeGetResult(feedback, CHECKOUT, _NC, pathname);
            stdErr = r.getStdErr();
        }
        if ((status = r.getStat()) == 1 && stdErr.length() == 0) {
            this.cleanupThenRetryCheckout(viewTag, pathname, feedback);
            return;
        }
        if (stdErr.contains("cleartool: Warning: Non-UCM checkout of \"" + pathname + "\".  Any modifications will not participate in any UCM change management operations.")) {
            this.cleanupThenRetryCheckout(viewTag, pathname, feedback);
        }
        if (!stdErr.contains("cleartool: Error: Not a vob object")) {
            r.assertSuccess(new CommandResult.IgnoreFlags(new CommandResult.IgnoreFlags.Kind[0]));
        }
    }

    private void cleanupThenRetryCheckout(String viewTag, String pathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, SETCS, _CURRENT, _TAG, viewTag);
        this.uncheckout(pathname, feedback);
        this.checkout(pathname, feedback);
    }

    public void rmAttr(String attype, String objectSelector, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, RMATTR, attype, objectSelector);
    }

    public void setActivity(String viewTag, String actName, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, SETACT, _VIEW, viewTag, actName);
    }

    public void setAttr(String attype, String objectSelector, String value, boolean replace, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>(4);
        cleartoolArgs.add(MKATTR);
        cleartoolArgs.add(_NC);
        if (replace) {
            cleartoolArgs.add(_REPLACE);
        }
        cleartoolArgs.addAll(this.generateAttrArgs(attype, objectSelector, value));
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        this.retryIfNoType(r, cleartoolArgs, "attype", feedback);
    }

    public void setHyperlink(String hltype, String fromObjectSelector, String toObjectSelector, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(MKHLINK, _NC, hltype, fromObjectSelector, toObjectSelector));
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        this.retryIfNoType(r, cleartoolArgs, "hltype", feedback);
    }

    private final void retryIfNoType(CommandResult result, List<String> cleartoolArgs, String typeString, SrvcFeedback feedback) throws WvcmException {
        String primaryErr;
        if (result.getStat() == 0) {
            return;
        }
        String typeKind = null;
        if (typeString.equals("attype")) {
            typeKind = ATTRIBUTE;
        } else if (typeString.equals("hltype")) {
            typeKind = HYPERLINK;
        } else {
            throw new IllegalArgumentException("Type not yet supported: " + typeString);
        }
        if (result.getStdErrList() == null || result.getStdErrList().size() == 0) {
            throw new IllegalArgumentException("Error parsing arguments");
        }
        Pattern MK_ERR_PATTERN = Pattern.compile("^.*? " + typeKind + " type \"(.*?)\" not found in VOB \"(.*?)\" and no global type definition can be found.$");
        Matcher m = MK_ERR_PATTERN.matcher(primaryErr = result.getStdErrList().get(0));
        if (!m.find()) {
            throw new IllegalArgumentException("Error parsing arguments: " + primaryErr);
        }
        String mkTypeArg = m.replaceFirst("$1@$2");
        this.ctProvider.execute(feedback, MKTYPE_PREFIX + typeString, _NC, _GLOBAL, mkTypeArg);
        this.ctProvider.execute(feedback, cleartoolArgs);
    }

    public String gpath(String oidSel, String viewTag, SrvcFeedback feedback) throws WvcmException {
        String pathname = this.describeShort(oidSel, new CommandResult.IgnoreFlags(new CommandResult.IgnoreFlags.Kind[0]), viewTag, feedback);
        return CommonUtils.canonicalizePathname(pathname);
    }

    private String getUcmObjKind(String objSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_MTYPE, ObjSelUtils.formatSelector("anyactivity", objSel));
    }

    public String makeBaseline(String viewTag, String componentSel, SrvcFeedback feedback) throws WvcmException {
        String baseName = Messages.CCaseLib_CTWVCM_BASELINE_NAME;
        CommandResult r = this.ctProvider.executeGetResult(feedback, MKBL, _VIEW, viewTag, _COMPONENT, componentSel, baseName);
        Matcher errMatcher = UNLABELED_BASELINE_PATTERN.matcher(r.getStdErr());
        if (errMatcher.find()) {
            String[] warningLines;
            String componentName = ObjSelUtils.isUniversalSelector(componentSel) ? this.describeShort(componentSel, new CommandResult.IgnoreFlags(new CommandResult.IgnoreFlags.Kind[0]), viewTag, feedback) : ObjSelUtils.getObjSelName(componentSel);
            String baselineName = null;
            String allWarningLines = errMatcher.replaceFirst("$2").trim();
            String[] stringArray = warningLines = allWarningLines.split(FMT_NEWLINE);
            int n = warningLines.length;
            int n2 = 0;
            while (n2 < n) {
                String warningLine = stringArray[n2];
                Matcher lineMatcher = COMPONENT_LINE_PATTERN.matcher(warningLine);
                String warningBlName = lineMatcher.replaceFirst("$1").trim();
                String warningCompName = lineMatcher.replaceFirst("$2").trim();
                if (componentName.equals(warningCompName)) {
                    baselineName = warningBlName;
                    break;
                }
                ++n2;
            }
            if (baselineName != null) {
                String streamSel = this.getStreamUniversalSelector(viewTag, feedback);
                this.ctProvider.execute(feedback, CHBL, _INCREMENTAL, ObjSelUtils.formatSelector("baseline", baselineName, ObjSelUtils.getObjSelVobSel(streamSel)));
            }
        } else {
            r.assertSuccess(new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO));
            Matcher m = CREATED_BASELINE_PATTERN.matcher(r.getStdOutList().get(0));
            if (m.find()) {
                String baselineBasename = m.replaceFirst("$1");
                return baselineBasename;
            }
        }
        return null;
    }

    public String getLatestBaselineInStreamOfComponent(String streamSel, String compName, SrvcFeedback feedback) throws WvcmException {
        List<String> latestBaselines = this.getLatestBaselines(streamSel, feedback);
        String result = this.lookupBaseline(compName, latestBaselines, feedback);
        return result;
    }

    private String lookupBaseline(String compName, List<String> baselines, SrvcFeedback feedback) throws WvcmException {
        if (!ObjSelUtils.isUniversalSelector(compName)) {
            throw new IllegalArgumentException("Component path must be a universal selector");
        }
        List<String> components = this.getComponents(baselines, feedback);
        Iterator<String> blIt = baselines.iterator();
        for (String component : components) {
            String bl = blIt.next();
            if (!compName.equals(component)) continue;
            return bl;
        }
        return null;
    }

    public List<String> computeComponents(List<String> blSelectors, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(DESCRIBE, _FMT, "%[component]Xp\\n"));
        List<String> componentSels = this.executeBatched(feedback, cleartoolArgs, blSelectors);
        return this.getUniversalSelectors(componentSels, feedback);
    }

    public List<String> getComponentRootDirPathnames(List<String> compSels, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.getComponentRootDirs(compSels, CCaseLib.getPathIntoView(viewTag), feedback);
    }

    public String getComponentRootDirPathname(String compSel, String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.getComponentRootDirPathnames(Collections.singletonList(compSel), viewTag, feedback).get(0);
    }

    private List<String> getComponentRootDirs(List<String> compSels, String pathIntoView, SrvcFeedback feedback) throws WvcmException {
        List<String> result = this.rootDirByComponentAndView.get(pathIntoView, compSels);
        if (result.isEmpty()) {
            result = this.computeComponentRootDirs(compSels, pathIntoView, feedback);
            this.rootDirByComponentAndView.put(pathIntoView, compSels, result);
        }
        return result;
    }

    private List<String> computeComponentRootDirs(List<String> names, String pathIntoView, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> result = new ArrayList<String>(names.size());
        List<String> lines = this.getHyperlinks(COMPONENT_ROOT_DIR_HLTYPE, names, pathIntoView, feedback);
        Iterator<String> it = names.iterator();
        for (String line : lines) {
            String vobRootDir;
            if (!it.hasNext()) {
                throw new IllegalStateException("Number of hyperlink lines does not match number of components");
            }
            String name = it.next();
            Matcher m = COMP_ROOT_DIR_PATTERN.matcher(line);
            String string = vobRootDir = m.find() ? m.replaceFirst("$1") : null;
            if (vobRootDir == null) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_COULD_NOT_GET_COMPONENT_ROOT, (Object)name, (Object)pathIntoView), null, WvcmException.ReasonCode.FORBIDDEN);
            }
            result.add(CommonUtils.canonicalizePathname(vobRootDir));
        }
        return result;
    }

    private List<String> getHyperlinks(String hltype, List<String> objectNames, String pathIntoView, SrvcFeedback feedback) throws WvcmException {
        if (objectNames.size() == 0) {
            return new ArrayList<String>();
        }
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(DESCRIBE, _FMT, FMT_HLINK_PREFIX + hltype + FMT_SUFFIX + FMT_NEWLINE));
        return this.executeBatched(feedback, pathIntoView, ignoreFlags, false, cleartoolArgs, objectNames);
    }

    private String getHyperlinksLine(String hltype, String objectName, SrvcFeedback feedback) throws WvcmException {
        List<String> linkLines = this.getHyperlinks(hltype, Collections.singletonList(objectName), null, feedback);
        if (linkLines.size() == 0) {
            return new String();
        }
        return linkLines.get(0);
    }

    public List<String> getHyperlinkTargets(String hltype, String objSel, SrvcFeedback feedback) throws WvcmException {
        return this.getHyperlinkEnds(true, hltype, objSel, feedback);
    }

    public List<String> getHyperlinkSources(String hltype, String objSel, SrvcFeedback feedback) throws WvcmException {
        return this.getHyperlinkEnds(false, hltype, objSel, feedback);
    }

    private List<String> getHyperlinkEnds(boolean isTarget, String hltype, String objSel, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> result = new ArrayList<String>();
        String arrow = isTarget ? "->" : "<-";
        String[] tokens = this.getHyperlinksLine(hltype, objSel, feedback).split(SPACE);
        boolean nextIsResult = false;
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (nextIsResult) {
                if (token.charAt(0) == '\"') {
                    token = token.substring(1, token.length() - 1);
                }
                result.add(token);
                nextIsResult = false;
            } else {
                nextIsResult = token.equals(arrow);
            }
            ++n2;
        }
        return result;
    }

    public void removeName(String folderPathname, String nameToRemove, SrvcFeedback feedback) throws WvcmException {
        String pathname = String.valueOf(folderPathname) + '/' + nameToRemove;
        this.ctProvider.execute(feedback, RMNAME, _NC, pathname);
    }

    public void moveName(String oldPathname, String newPathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, MOVE, _NC, oldPathname, newPathname);
    }

    public void link(String oldVersPathname, String newPathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, LN, _NC, oldVersPathname, newPathname);
    }

    public void symLink(String linkTarget, String newPathname, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, LN, _S, _NC, linkTarget, newPathname);
    }

    public final String makeView(String viewTag, String stream, SrvcFeedback feedback) throws WvcmException {
        int viewTagIndex = 2;
        ArrayList<String> args = new ArrayList<String>(14);
        args.add(MKVIEW);
        if (stream != null) {
            args.add(_STREAM);
            args.add(stream);
            viewTagIndex = 4;
        }
        String viewStgParentDir = CTInitArgUtils.getStgLoc(this.ctInitArgs);
        String path = ObjSelUtils.computeStgPath(true, viewTag, viewStgParentDir);
        args.addAll((Collection)Arrays.asList(_TAG, viewTag, _TMODE, CCaseLib.getTextMode()));
        boolean useTripleSet = CTInitArgUtils.useTripleSet(this.ctInitArgs);
        if (useTripleSet) {
            String host = CTInitArgUtils.getHost(this.ctInitArgs);
            String hpathStgDir = CTInitArgUtils.getHpath(this.ctInitArgs);
            String gpathStgDir = CTInitArgUtils.getGpath(this.ctInitArgs);
            String hpath = ObjSelUtils.computeStgPath(true, viewTag, hpathStgDir);
            String gpath = ObjSelUtils.computeStgPath(true, viewTag, gpathStgDir);
            args.addAll((Collection<String>)Arrays.asList(_HOST, host, _HPATH, hpath, _GPATH, gpath));
        }
        args.add(path);
        CommandResult r = this.ctProvider.executeGetResult(feedback, args);
        String uniqueViewTag = viewTag;
        if (r.getStdErr().contains("registry entry already exists")) {
            String suffix = CommonUtils.uniquifier();
            uniqueViewTag = String.valueOf(viewTag) + suffix;
            args.set(viewTagIndex, uniqueViewTag);
            path = ObjSelUtils.computeStgPath(true, uniqueViewTag, viewStgParentDir);
            args.set(args.size() - 1, path);
            if (useTripleSet) {
                String hpathStgDir = CTInitArgUtils.getHpath(this.ctInitArgs);
                String gpathStgDir = CTInitArgUtils.getGpath(this.ctInitArgs);
                String hpath = ObjSelUtils.computeStgPath(true, uniqueViewTag, hpathStgDir);
                String gpath = ObjSelUtils.computeStgPath(true, uniqueViewTag, gpathStgDir);
                args.set(args.size() - 2, gpath);
                args.set(args.size() - 4, hpath);
            }
            this.ctProvider.execute(feedback, args);
        } else {
            r.assertSuccess(new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO));
        }
        return uniqueViewTag;
    }

    public void startView(String viewTag, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, STARTVIEW, viewTag);
    }

    public String makeVob(boolean ucmProjectVob, String vobPrefix, String vobBasename, boolean mountIt, SrvcFeedback feedback) throws WvcmException {
        String vobStgParentDir = CTInitArgUtils.getStgLoc(this.ctInitArgs);
        boolean useTripleSet = CTInitArgUtils.useTripleSet(this.ctInitArgs);
        ArrayList<String> cleartoolArgs = new ArrayList<String>(12);
        cleartoolArgs.add(MKVOB);
        cleartoolArgs.add(_NC);
        String vobTag = String.valueOf(vobPrefix) + vobBasename;
        String vobStg = ObjSelUtils.computeStgPath(false, vobBasename, vobStgParentDir);
        if (ucmProjectVob) {
            cleartoolArgs.add(_UCMPROJECT);
        }
        cleartoolArgs.add(_TAG);
        cleartoolArgs.add(vobTag);
        if (useTripleSet) {
            String host = CTInitArgUtils.getHost(this.ctInitArgs);
            String hpathStgDir = CTInitArgUtils.getHpath(this.ctInitArgs);
            String gpathStgDir = CTInitArgUtils.getGpath(this.ctInitArgs);
            String hpath = ObjSelUtils.computeStgPath(false, vobBasename, hpathStgDir);
            String gpath = ObjSelUtils.computeStgPath(false, vobBasename, gpathStgDir);
            cleartoolArgs.addAll((Collection<String>)Arrays.asList(_HOST, host, _HPATH, hpath, _GPATH, gpath));
        }
        cleartoolArgs.add(vobStg);
        this.ctProvider.execute(feedback, cleartoolArgs);
        if (mountIt) {
            this.mount(vobTag, feedback);
        }
        return vobTag;
    }

    public void mount(String vobTag, SrvcFeedback feedback) throws WvcmException {
        boolean created;
        File mountPoint;
        if (!(CommandProvider.IS_WINDOWS || (mountPoint = new File(vobTag)).exists() || (created = mountPoint.mkdir()))) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_NO_MOUNT_POINT_ERROR, (Object)vobTag), WvcmException.ReasonCode.FORBIDDEN);
        }
        this.ctProvider.execute(feedback, MOUNT, vobTag);
    }

    public final String makeComponent(String compRootPath, String compSel, String streamSel, boolean isSubVobComponent, SrvcFeedback feedback) throws WvcmException {
        String compName = ObjSelUtils.getObjSelName(compSel);
        String uniqueCompSel = compSel;
        String uniqueRoot = CommonUtils.canonicalizePathname(compRootPath);
        if (isSubVobComponent && !uniqueRoot.endsWith(String.valueOf('/') + compName)) {
            throw new IllegalArgumentException("Component name must match last segment of component path");
        }
        String[] cleartoolArgs = new String[]{MKCOMP, _NC, _ROOT, compRootPath, compSel};
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        r.assertSuccess(new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO));
        if (streamSel != null) {
            String projSel = this.getProjectObjectSelector(streamSel, feedback);
            this.ctProvider.execute(feedback, CHPROJECT, _AMODCOMP, compSel, projSel);
            String blSel = ObjSelUtils.initialBaselineSelector(ObjSelUtils.getObjSelName(compSel), ObjSelUtils.getObjSelVobSel(streamSel));
            String defaultUCMViewTag = CTInitArgUtils.getIntViewTag(this.ctInitArgs);
            this.rebaseStream(defaultUCMViewTag, streamSel, blSel, feedback);
        }
        return uniqueCompSel;
    }

    public void makeProject(String projectSel, List<String> compSel, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(MKPROJECT, _NC, _IN, ROOT_FOLDER));
        if (compSel != null) {
            cleartoolArgs.add(_MODCOMP);
            cleartoolArgs.add(this.getCommaSeparatedFromList(compSel));
        }
        cleartoolArgs.add(projectSel);
        this.ctProvider.execute(feedback, cleartoolArgs);
    }

    public String makeStream(String inProject, boolean isIntegration, List<String> baselineSel, String streamName, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>((Collection)Arrays.asList(MKSTREAM, _NC, _IN, inProject));
        if (isIntegration) {
            cleartoolArgs.add(_INTEGRATION);
        }
        if (baselineSel != null) {
            cleartoolArgs.add(_BASELINE);
            cleartoolArgs.add(this.getCommaSeparatedFromList(baselineSel));
        }
        String pVobSelector = ObjSelUtils.getObjSelVobSel(inProject);
        String streamSel = ObjSelUtils.formatSelector("stream", streamName, pVobSelector);
        cleartoolArgs.add(streamSel);
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        Matcher alreadyExists = OBJECT_ALREADY_EXISTS_PATTERN.matcher(r.getStdErr());
        if (alreadyExists.find()) {
            streamSel = ObjSelUtils.formatSelector("stream", String.valueOf(streamName) + CommonUtils.uniquifier(), pVobSelector);
            cleartoolArgs.set(cleartoolArgs.size() - 1, streamSel);
            this.ctProvider.execute(feedback, cleartoolArgs);
        } else {
            r.assertSuccess(new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO));
        }
        return streamSel;
    }

    public void removeView(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String viewStorageDir;
        block2: {
            viewStorageDir = null;
            try {
                viewStorageDir = this.getStorageDirectory(viewTag, false, feedback);
            }
            catch (WvcmException e) {
                if (e.getMessage().contains("No matching entries found for view tag")) break block2;
                throw e;
            }
        }
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        this.ctProvider.execute(feedback, CommonUtils.FWDSLASH, ignoreFlags, RMVIEW, _FORCE, _TAG, viewTag);
        this.waitForItToBeGone(viewStorageDir);
    }

    private void waitForItToBeGone(String storageDir) {
        if (storageDir != null) {
            File dir = new File(storageDir);
            try {
                int i = 0;
                while (dir.exists()) {
                    if (i >= 10) {
                        throw new IllegalStateException("Storage directory not gone after 10 seconds");
                    }
                    ++i;
                    Thread.sleep(1000L);
                    dir = new File(storageDir);
                }
            }
            catch (InterruptedException e) {
                this.logIgnoredException("waiting for storage directory to be removed", e);
            }
        }
    }

    public void removeStream(String streamSel, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, RMSTREAM, _FORCE, streamSel);
    }

    public void removeVobIgnoreFailures(String vTag, SrvcFeedback feedback) {
        this.unmountVobIgnoreFailures(vTag, feedback);
        try {
            String vobStorageDir = this.getStorageDirectory(vTag, true, feedback);
            this.ctProvider.execute(feedback, RMVOB, _FORCE, this.getStorageDirectory(vTag, true, feedback));
            this.waitForItToBeGone(vobStorageDir);
        }
        catch (WvcmException e) {
            this.logIgnoredException("remove VOB", (Exception)((Object)e));
        }
    }

    private String getStorageDirectory(String vTag, boolean isVobTag, SrvcFeedback feedback) throws WvcmException {
        String info = this.ctProvider.execute(feedback, isVobTag ? LSVOB : LSVIEW, vTag);
        Matcher m = LS_VOBVIEW_PATTERN.matcher(info);
        if (!m.find()) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_COULD_NOT_FIND_STORAGE_ERROR, (Object)vTag, (Object)info), WvcmException.ReasonCode.FORBIDDEN);
        }
        String result = m.group(1);
        return result;
    }

    public void removeViewIgnoreFailures(String viewTag, SrvcFeedback feedback) {
        try {
            this.removeView(viewTag, feedback);
        }
        catch (WvcmException e) {
            this.logIgnoredException("remove view", (Exception)((Object)e));
        }
    }

    public void unmountVobIgnoreFailures(String vobTag, SrvcFeedback feedback) {
        try {
            this.ctProvider.execute(feedback, UMOUNT, vobTag);
        }
        catch (WvcmException e) {
            this.logIgnoredException("unmount VOB", (Exception)((Object)e));
        }
    }

    public static final String cleanName(String displayName) {
        return displayName.replaceAll("[:|@\\/ ]", "_");
    }

    public String getBranchTypeName(String streamSel, SrvcFeedback feedback) throws WvcmException {
        return this.computeTypeNameFromHyperlink(INDEPENDENT_GUARD, streamSel, feedback);
    }

    public String anyVersionDisplayNameToPathname(String name, SrvcFeedback feedback) throws WvcmException {
        return this.gpath(name, null, feedback);
    }

    public String getFriendlyComponentSelectorFromGPath(String gpath, boolean isBaseCCContext, SrvcFeedback feedback) throws WvcmException {
        String compSel = null;
        String vobTag = this.getVobTagFromGpath(gpath, feedback);
        String viewTag = ObjSelUtils.getViewTag(mvfsRoot, gpath);
        String vobPath = String.valueOf(CCaseLib.getPathIntoView(viewTag)) + vobTag;
        boolean ucmEnabled = this.isVobUCMEnabled(vobPath, feedback);
        if (ucmEnabled) {
            String crdeDBID = this.getComponentCRDE(gpath, feedback);
            if (crdeDBID == null) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_PATH_MUST_BE_IN_A_COMPONENT_ERROR, (Object)gpath), WvcmException.ReasonCode.NOT_FOUND);
            }
            compSel = this.getComponentSelector(ObjSelUtils.formatSelector("dbid", crdeDBID, vobTag), feedback);
        } else {
            if (!isBaseCCContext) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_PATH_MUST_BE_IN_A_COMPONENT_ERROR, (Object)gpath), WvcmException.ReasonCode.NOT_FOUND);
            }
            compSel = this.getVobSelector(vobTag, feedback);
        }
        return compSel;
    }

    public String getComponentSelectorFromGPath(String gpath, boolean isBaseCCContext, SrvcFeedback feedback) throws WvcmException {
        String compSel = this.getFriendlyComponentSelectorFromGPath(gpath, isBaseCCContext, feedback);
        String result = this.getUniversalSelector(compSel, feedback);
        return result;
    }

    public String getComponentSelectorFromComponentRoot(String gpath, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String elemGpath = String.valueOf(gpath) + AT_AT;
        String compSel = this.getComponentSelector(elemGpath, feedback);
        if (compSel != null) {
            result = this.getUniversalSelector(compSel, feedback);
        }
        return result;
    }

    private String getComponentSelector(String path, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        String line = this.getHyperlinksLine(COMPONENT_ROOT_DIR_HLTYPE, path, feedback);
        if (line.length() == 0) {
            return null;
        }
        Matcher m = HLINK_TARGET_LEFT_ARROW_PATTERN.matcher(line);
        if (!m.find()) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_COULD_NOT_GET_COMPONENT_SELECTOR_ERROR, (Object)COMPONENT_ROOT_DIR_HLTYPE, (Object)line), null, WvcmException.ReasonCode.FORBIDDEN);
        }
        result = m.group(1);
        return result;
    }

    public String getVobTagFromGpath(String gpath, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _SHORT, ObjSelUtils.formatSelector("vob", gpath));
    }

    public boolean equalObjSels(String sel1, String sel2, SrvcFeedback feedback) throws WvcmException {
        if (sel1 == null || sel2 == null || sel1.length() == 0 || sel2.length() == 0) {
            return false;
        }
        String uSel1 = this.getUniversalSelector(sel1, feedback);
        String uSel2 = this.getUniversalSelector(sel2, feedback);
        return uSel1.equals(uSel2);
    }

    public String getDisplayName(String objSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_N, objSel);
    }

    public String getExtendedName(String viewTag, String objSel, SrvcFeedback feedback) throws WvcmException {
        String result = null;
        if (ObjSelUtils.isUniversalSelector(objSel) && (result = this.extendedNameByUSel.get(null, objSel)) != null) {
            return result;
        }
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        String viewPath = null;
        if (viewTag != null) {
            viewPath = CCaseLib.getPathIntoView(viewTag);
        }
        if ((result = this.ctProvider.execute(feedback, viewPath, ignoreFlags, DESCRIBE, _FMT, FMT_XN, objSel)).startsWith("folder:") || result.startsWith("stream:")) {
            this.extendedNameByUSel.put(null, objSel, result);
        }
        return result;
    }

    public String getParentStream(String streamSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_DEF_DELIVER_TGT_XP, streamSel);
    }

    public boolean isViewValid(String viewTag, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSVIEW, viewTag);
        this.checkAlbdRunning(r);
        if (r == null || r.getStat() != 0 || r.getStdOutList() == null || r.getStdOutList().size() == 0) {
            return false;
        }
        return r.getStdOutList().get(0).charAt(0) == '*' || (r = this.ctProvider.executeGetResult(feedback, STARTVIEW, viewTag)) != null && r.getStat() == 0 && (r.getStdErrList() == null || r.getStdErrList().size() == 0);
    }

    public boolean isVobValid(String pvobTag, boolean isPvob, SrvcFeedback feedback) {
        boolean mountIt;
        CommandResult r;
        try {
            r = this.ctProvider.executeGetResult(feedback, LSVOB, pvobTag);
            this.checkAlbdRunning(r);
        }
        catch (WvcmException e) {
            this.logIgnoredException("list VOB", (Exception)((Object)e));
            return false;
        }
        if (r.getStat() != 0 || r.getStdOutList() == null || r.getStdOutList().size() == 0) {
            return false;
        }
        String line = r.getStdOutList().get(0);
        boolean alreadyMounted = line.charAt(0) == '*';
        boolean bl = mountIt = !isPvob || line.matches(".*(.*ucmvob.*)$");
        if (!alreadyMounted && mountIt) {
            try {
                r = this.ctProvider.executeGetResult(feedback, MOUNT, pvobTag);
            }
            catch (WvcmException e) {
                this.logIgnoredException("mount PVOB", (Exception)((Object)e));
                return false;
            }
            if (r.getStdErrList() != null && r.getStdErrList().size() != 0) {
                return false;
            }
        }
        return true;
    }

    public void checkAlbdRunning(CommandResult r) throws WvcmException {
        if (r.getStdErrList().size() != 0) {
            for (String error : r.getStdErrList()) {
                Matcher m = CANT_CONTACT_ALBD_PATTERN.matcher(error);
                if (!m.find()) continue;
                throw new WvcmException(NLS.bind((String)Messages.CommandProvider_UNABLE_TO_EXECUTE_CLEARTOOL, (Object)m.replaceFirst("$1")), WvcmException.ReasonCode.NOT_FOUND);
            }
        }
    }

    public String queryStream(String streamSelSuffix, SrvcFeedback feedback) throws WvcmException {
        String streamSel = ObjSelUtils.formatSelector("stream", streamSelSuffix);
        String vobSel = ObjSelUtils.getObjSelVobSel(streamSel);
        if (!this.isVobValid(vobSel, true, feedback)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_INVALID_PVOB_TAG_ERROR, (Object)vobSel), WvcmException.ReasonCode.FORBIDDEN);
        }
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSSTREAM, _FMT, "%Xn\\n", streamSel);
        if (r.getStat() != 0 || r.getStdErrList() != null && r.getStdErrList().size() != 0 || r.getStdOutList() == null || r.getStdOutList().size() != 1) {
            return null;
        }
        return r.getStdOutList().get(0);
    }

    public String getComponentPathnameFromAnyKindOfName(String viewTag, String displayName, SrvcFeedback feedback) throws WvcmException {
        String result = ObjSelUtils.isUniversalSelector(displayName) ? this.getComponentRootDirPathname(displayName, viewTag, feedback) : ObjSelUtils.composePathname(viewTag, String.valueOf('/') + displayName, ".");
        return result;
    }

    public String getPathname(String versionUniversalSelector, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%n\\n", versionUniversalSelector);
    }

    public String getVerExtendedPathnameInView(String viewTag, String versionSelector, SrvcFeedback feedback) throws WvcmException {
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        String viewPath = null;
        if (viewTag != null) {
            viewPath = CCaseLib.getPathIntoView(viewTag);
        }
        return this.ctProvider.execute(feedback, viewPath, ignoreFlags, DESCRIBE, _CVIEW, _FMT, "%n\\n", versionSelector);
    }

    public String getNonVerExtendedPathnameInView(String viewTag, String versionSelector, SrvcFeedback feedback) throws WvcmException {
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        String viewPath = null;
        if (viewTag != null) {
            viewPath = CCaseLib.getPathIntoView(viewTag);
        }
        return this.ctProvider.execute(feedback, viewPath, ignoreFlags, DESCRIBE, _CVIEW, _FMT, "%En\\n", versionSelector);
    }

    public String getComment(String pathname, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_NC, pathname);
    }

    public void setComment(String pathname, String comment, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, CHEVENT, _REPLACE, _COMMENT, comment, pathname);
    }

    public String removeType(String typeSel, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, RMTYPE, _NC, _RMALL, _FORCE, typeSel);
    }

    public String getViewConfigSpec(String viewTag, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, CATCS, _TAG, viewTag);
    }

    public void setViewConfigSpec(String viewTag, String[] configSpec, SrvcFeedback feedback) throws WvcmException {
        String viewStorage = this.getStorageDirectory(viewTag, false, feedback);
        String fileName = String.valueOf(viewStorage) + CONFIG_SPEC;
        File file = new File(fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            PrintWriter writer = new PrintWriter(fos);
            int i = 0;
            while (i < configSpec.length) {
                writer.println(configSpec[i]);
                ++i;
            }
            writer.close();
            fos.close();
            this.ctProvider.execute(feedback, SETCS, _CURRENT, _TAG, viewTag);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_CS_FILE_NOT_FOUND_ERROR, (Object)file.getAbsolutePath()), WvcmException.ReasonCode.WRITE_FAILED);
        }
        catch (IOException iOException) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_CS_FILE_NOT_FOUND_ERROR, (Object)file.getAbsolutePath()), WvcmException.ReasonCode.WRITE_FAILED);
        }
    }

    public String mkBrType(String brtypeName, String vobTag, SrvcFeedback feedback) throws WvcmException {
        String name = this.createExtendedTypeName("brtype", brtypeName, vobTag);
        String[] args = new String[]{MKBRTYPE, _NC, _GLOBAL, name};
        CommandResult r = this.ctProvider.executeGetResult(feedback, args);
        Matcher alreadyExists = OBJECT_ALREADY_EXISTS_PATTERN.matcher(r.getStdErr());
        if (alreadyExists.find() || r.getStdErr().contains("would eclipse global definition of branch type") || r.getStdErr().contains("would be eclipsed by definition") || r.getStdErr().contains("Cannot define branch type with the same name as a label type")) {
            args[args.length - 1] = name = this.createExtendedTypeName("brtype", String.valueOf(brtypeName) + CommonUtils.uniquifier(), vobTag);
            this.ctProvider.execute(feedback, args);
        } else {
            r.assertSuccess(new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO));
        }
        return name;
    }

    public String mkLbType(String lbtypeName, String vobTag, SrvcFeedback feedback) throws WvcmException {
        String name = this.createExtendedTypeName("lbtype", lbtypeName, vobTag);
        String[] args = new String[]{MKLBTYPE, _NC, _GLOBAL, _SHARED, name};
        CommandResult r = this.ctProvider.executeGetResult(feedback, args);
        Matcher alreadyExists = OBJECT_ALREADY_EXISTS_PATTERN.matcher(r.getStdErr());
        if (alreadyExists.find() || r.getStdErr().contains("would eclipse global definition of label type") || r.getStdErr().contains("would be eclipsed by definition") || r.getStdErr().contains("Cannot define label type with the same name as a branch type")) {
            args[args.length - 1] = name = this.createExtendedTypeName("lbtype", String.valueOf(lbtypeName) + CommonUtils.uniquifier(), vobTag);
            this.ctProvider.execute(feedback, args);
        } else {
            r.assertSuccess(new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO));
        }
        return name;
    }

    public String createExtendedTypeName(String type, String typeName, String vobTag) {
        return ObjSelUtils.formatSelector(type, typeName, vobTag);
    }

    public String validateAndLockBranchType(String brtypeSelSuffix, boolean lock, SrvcFeedback feedback) throws WvcmException {
        String brtypeSel = ObjSelUtils.formatSelector("brtype", brtypeSelSuffix);
        String vobSel = ObjSelUtils.getObjSelVobSel(brtypeSel);
        if (!this.isVobValid(vobSel, false, feedback)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_INVALID_ADMIN_VOB_TAG_BRANCH_ERROR, (Object)vobSel), WvcmException.ReasonCode.NOT_FOUND);
        }
        return this.validateAndLockType(brtypeSel, lock, feedback);
    }

    public String validateAndLockLabelType(String lbtypeSelSuffix, boolean lock, SrvcFeedback feedback) throws WvcmException {
        String lbtypeSel = ObjSelUtils.formatSelector("lbtype", lbtypeSelSuffix);
        String lbtypeName = ObjSelUtils.getObjSelName(lbtypeSel);
        if (this.isReservedLabelType(lbtypeName)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_INVALID_RESERVED_LABEL_TYPE_ERROR, (Object)lbtypeSelSuffix), WvcmException.ReasonCode.FORBIDDEN);
        }
        String vobSel = ObjSelUtils.getObjSelVobSel(lbtypeSel);
        if (!this.isVobValid(vobSel, false, feedback)) {
            throw new WvcmException(NLS.bind((String)Messages.CCaseLib_INVALID_ADMIN_VOB_TAG_LABEL_ERROR, (Object)vobSel), WvcmException.ReasonCode.NOT_FOUND);
        }
        return this.validateAndLockType(lbtypeSel, lock, feedback);
    }

    private boolean isReservedLabelType(String typeName) {
        boolean reservedType = false;
        if (typeName.equals(LATEST) || typeName.equals(CHECKEDOUT) || typeName.equals(BACKSTOP)) {
            reservedType = true;
        }
        return reservedType;
    }

    private String validateAndLockType(String typeSel, boolean lock, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSTYPE, _FMT, "%Xn|%[locked]p\\n", typeSel);
        if (r.getStat() != 0 || r.getStdErrList() != null && r.getStdErrList().size() != 0 || r.getStdOutList() == null || r.getStdOutList().size() != 1) {
            return null;
        }
        String[] tokens = CCaseLib.getObjInfoTokens(r.getStdOut(), 2);
        String type = tokens[0];
        String lockStatus = tokens[1];
        if (!lockStatus.equals(LOCKED) && lock) {
            this.lock(typeSel, feedback);
        }
        return type;
    }

    public List<String> findNewVersions(String searchRoot, String createdSince, String syncBranch, SrvcFeedback feedback) throws WvcmException {
        List<String> versionList = new ArrayList<String>();
        ArrayList<String> findArgs = new ArrayList<String>();
        findArgs.add(FIND);
        findArgs.add(searchRoot);
        findArgs.add(_ALL);
        findArgs.add(_VERSION);
        String timeQuery = "{created_since(" + createdSince + ')' + AMPAMP + QUERY_VERSION_PREFIX + syncBranch + BRANCH_LATEST + ')' + '}';
        findArgs.add(timeQuery);
        findArgs.add(_BRANCH);
        String branchQuery = QUERY_BRTYPE_PREFIX + syncBranch + ')';
        findArgs.add(branchQuery);
        findArgs.add(_PRINT);
        List<String> findResult = this.ctProvider.executeGetValues(feedback, findArgs);
        if (!findResult.isEmpty()) {
            ArrayList<String> descArgs = new ArrayList<String>();
            descArgs.add(DESCRIBE);
            descArgs.add(_FMT);
            String fmtString = "%m;%[universal_selector]p;%n;%En@@\\n";
            descArgs.add(fmtString);
            versionList = this.executeBatched(feedback, descArgs, findResult);
        }
        return versionList;
    }

    public String getBaseCCInfo(String viewTag, SrvcFeedback feedback) throws WvcmException {
        String info = this.baseCCViewInfo.get(null, viewTag);
        if (info == null) {
            String configSpec = this.getViewConfigSpec(viewTag, feedback);
            String branch = CCaseLib.getBrtypeFromConfigSpec(configSpec);
            if (branch != null) {
                String label = CCaseLib.getLbypeFromConfigSpec(configSpec);
                info = label != null ? new String(String.valueOf(branch) + "|" + label) : new String(branch);
                this.baseCCViewInfo.put(null, viewTag, info);
            } else {
                this.baseCCViewInfo.put(null, viewTag, "|");
            }
        } else if (info.equals("|")) {
            info = null;
        }
        return info;
    }

    private static String getBrtypeFromConfigSpec(String configSpec) {
        String branch = null;
        if (configSpec.contains("#BRANCH=")) {
            int start = configSpec.indexOf("#BRANCH=") + "#BRANCH=".length();
            int end = configSpec.lastIndexOf("#BRANCH=");
            branch = configSpec.substring(start, end);
        }
        return branch;
    }

    private static String getLbypeFromConfigSpec(String configSpec) {
        String label = null;
        if (configSpec.contains("#LABEL=")) {
            int start = configSpec.indexOf("#LABEL=") + "#LABEL=".length();
            int end = configSpec.lastIndexOf("#LABEL=");
            label = configSpec.substring(start, end);
        }
        return label;
    }

    public void setcsCurrent(String viewTag, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, null, new CommandResult.IgnoreFlags(new CommandResult.IgnoreFlags.Kind[0]), SETCS, _CURRENT, _TAG, viewTag);
    }

    public String getContentType(String elementUsel, SrvcFeedback feedback) throws WvcmException {
        String elementType = this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%[type]p", elementUsel);
        String result = this.elementTypeToMimeContentType(ObjSelUtils.getObjSelVobSel(elementUsel), elementType, feedback);
        return result;
    }

    public synchronized String elementTypeToMimeContentType(String vobSel, String elementType, SrvcFeedback feedback) throws WvcmException {
        String result = this._elementTypeToMimeContentType.get(null, elementType);
        if (result == null) {
            this.updateEltypeToMimeContentTypeMap(this._elementTypeToMimeContentType, vobSel, elementType, feedback);
            result = this._elementTypeToMimeContentType.get(null, elementType);
        }
        return result;
    }

    private String updateEltypeToMimeContentTypeMap(Cache eltypeToMimeContentType, String vobSel, String elementType, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> elementTypes = new ArrayList<String>();
        String result = null;
        String nextType = elementType;
        block0: while (result == null) {
            elementTypes.add(nextType);
            String eltypeSel = ObjSelUtils.formatSelector("eltype", nextType, vobSel);
            List<String> lines = this.ctProvider.executeGetValues(feedback, DESCRIBE, _LONG, eltypeSel);
            for (String line : lines) {
                Matcher m = SUPERTYPE_PATTERN.matcher(line);
                if (!m.find()) continue;
                nextType = m.group(1);
                result = eltypeToMimeContentType.get(null, nextType);
                continue block0;
            }
        }
        for (String eltype : elementTypes) {
            eltypeToMimeContentType.put(null, eltype, result);
        }
        return result;
    }

    private String createAndSetCQActivity(String headline, String viewTag, String streamPvobUuid, SrvcFeedback feedback) throws WvcmException {
        String recordID = this.createUCMUtilityActivityRecord(headline, feedback);
        this.setActivity(viewTag, recordID, feedback);
        String activitySelector = ObjSelUtils.formatSelector("activity", recordID, streamPvobUuid);
        return activitySelector;
    }

    private String createUCMUtilityActivityRecord(String headline, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
        String login = cqArgs.get(_USERNAME);
        String password = cqArgs.get(_PASSWORD);
        String dbset = cqArgs.get(_DBSET);
        String userdb = cqArgs.get(_USERDB);
        if (headline == null) {
            headline = GENERIC_HEADLINE;
        } else if (headline.trim().length() == 0) {
            headline = GENERIC_HEADLINE;
        }
        String script = this.getMkactScriptAbsolutePath();
        ArrayList<String> ratlPerlArgs = new ArrayList<String>();
        ratlPerlArgs.add(script);
        ratlPerlArgs.add(_USERNAME);
        ratlPerlArgs.add(login);
        ratlPerlArgs.add(_PASSWORD);
        ratlPerlArgs.add(password);
        ratlPerlArgs.add(_USERDB);
        ratlPerlArgs.add(userdb);
        ratlPerlArgs.add(_DBSET);
        ratlPerlArgs.add(dbset);
        ratlPerlArgs.add(_HEADLINE);
        ratlPerlArgs.add(headline);
        String recordID = this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
        return recordID;
    }

    private File getInstalledScmConnectorsLocation() {
        return new File(CTInitArgUtils.getInstallLocation(this.ctInitArgs), "ScmConnectors");
    }

    private String getMkactScriptAbsolutePath() {
        if (MKACT_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), MKACT_SCRIPT_NAME);
            MKACT_SCRIPT = script.getAbsolutePath();
        }
        return MKACT_SCRIPT;
    }

    private String getDbidScriptAbsolutePath() {
        if (DBID_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), DBID_SCRIPT_NAME);
            DBID_SCRIPT = script.getAbsolutePath();
        }
        return DBID_SCRIPT;
    }

    private String getActivityScriptAbsolutePath() {
        if (GETACT_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), GETACT_SCRIPT_NAME);
            GETACT_SCRIPT = script.getAbsolutePath();
        }
        return GETACT_SCRIPT;
    }

    private String getReadCommentScriptAbsolutePath() {
        if (GET_COMMENT_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), GET_COMMENT_SCRIPT_NAME);
            GET_COMMENT_SCRIPT = script.getAbsolutePath();
        }
        return GET_COMMENT_SCRIPT;
    }

    private String getWriteCommentScriptAbsolutePath() {
        if (SET_COMMENT_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), SET_COMMENT_SCRIPT_NAME);
            SET_COMMENT_SCRIPT = script.getAbsolutePath();
        }
        return SET_COMMENT_SCRIPT;
    }

    private String getCQActionScriptAbsolutePath() {
        if (PERFORM_CQ_ACTION_SCRIPT == null) {
            File script = new File(this.getInstalledScmConnectorsLocation(), PERFORM_CQ_ACTION_SCRIPT_NAME);
            PERFORM_CQ_ACTION_SCRIPT = script.getAbsolutePath();
        }
        return PERFORM_CQ_ACTION_SCRIPT;
    }

    private Map<String, String> getCQLoginInfo(SrvcFeedback feedback) throws WvcmException {
        if (CQ_CREDS == null) {
            HashMap<String, String> args = new HashMap<String, String>();
            String cqLoginName = CTInitArgUtils.getCQLoginName(this.ctInitArgs);
            if (cqLoginName == null || cqLoginName.trim().equals(EMPTY_STRING)) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(Messages.CCaseLib_INVALID_CQ_USERNAME);
                messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQLoginNameKeyName())));
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            String dbsetName = CTInitArgUtils.getCQDbsetName(this.ctInitArgs);
            if (dbsetName == null || dbsetName.trim().equals(EMPTY_STRING)) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(Messages.CCaseLib_INVALID_CQ_DBSET);
                messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQDbsetNameKeyName())));
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            String userdbName = CTInitArgUtils.getCQUserdbName(this.ctInitArgs);
            if (userdbName == null || userdbName.trim().equals(EMPTY_STRING)) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(Messages.CCaseLib_INVALID_CQ_USERDB);
                messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CHECK_VALUE_OF_PROVIDER_PROPERTY, (Object)CommandResult.getPropertyFriendlyName(CTInitArgUtils.getCQUserdbNameKeyName())));
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            Properties properties = new Properties();
            String passwordFolderPath = this.getPasswordFolderPath();
            File passwordFile = new File(passwordFolderPath, String.valueOf(cqLoginName) + CQ_PROP_FILE_EXT);
            try {
                properties.load(new FileInputStream(passwordFile));
                String password = properties.getProperty(_PASSWORD);
                if (password == null) {
                    StringBuffer messageBuffer = new StringBuffer();
                    messageBuffer.append(NLS.bind((String)Messages.CCaseLib_ERROR_CANNOT_GET_PWD_FOR_CQ_USER, (Object)cqLoginName));
                    messageBuffer.append(NLS.bind((String)Messages.CCaseLib_INVALID_CQ_PASSWORD_PROPERTY, (Object)CommonUtils.canonicalizePathname(passwordFile.getAbsolutePath())));
                    messageBuffer.append(CommandResult.computeMsgCqPasswordFile(this.getPasswordFolderPath(), cqLoginName));
                    throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
                }
                args.put(_DBSET, dbsetName);
                args.put(_USERDB, userdbName);
                args.put(_USERNAME, cqLoginName);
                args.put(_PASSWORD, password);
                ArrayList<String> crmRegisterArgs = new ArrayList<String>();
                crmRegisterArgs.add(ADD);
                crmRegisterArgs.add(_DATABASE);
                crmRegisterArgs.add(userdbName);
                crmRegisterArgs.add(_CONNECTION);
                crmRegisterArgs.add(dbsetName);
                crmRegisterArgs.add(_USERNAME);
                crmRegisterArgs.add(cqLoginName);
                crmRegisterArgs.add(_PASSWORD);
                crmRegisterArgs.add(password);
                this.ctProvider.executeCrmRegister(passwordFolderPath, feedback, crmRegisterArgs);
                CQ_CREDS = args;
            }
            catch (FileNotFoundException fileNotFoundException) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(NLS.bind((String)Messages.CCaseLib_ERROR_CANNOT_GET_PWD_FOR_CQ_USER, (Object)cqLoginName));
                if (passwordFile.exists() && !passwordFile.canRead()) {
                    String user = System.getProperty("user.name", "sync");
                    messageBuffer.append(NLS.bind((String)Messages.CCaseLib_NO_READ_PERMISSION_CQ_PWD_FILE, (Object)user, (Object)CommonUtils.canonicalizePathname(passwordFile.getAbsolutePath())));
                } else {
                    messageBuffer.append(NLS.bind((String)Messages.CCaseLib_MISSING_CQ_PWD_FILE, (Object)CommonUtils.canonicalizePathname(passwordFile.getAbsolutePath())));
                    messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CQ_PASSWORD_FILE, (Object)passwordFolderPath, (Object)cqLoginName));
                }
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            catch (IOException iOException) {
                StringBuffer messageBuffer = new StringBuffer();
                messageBuffer.append(NLS.bind((String)Messages.CCaseLib_ERROR_CANNOT_GET_PWD_FOR_CQ_USER, (Object)cqLoginName));
                messageBuffer.append(NLS.bind((String)Messages.CommandResult_MSG_CQ_PASSWORD_FILE, (Object)passwordFolderPath, (Object)cqLoginName));
                messageBuffer.append(NLS.bind((String)Messages.CCaseLib_ERROR_READING_PROPERTIES_FILE, (Object)cqLoginName));
                throw new WvcmException(messageBuffer.toString(), WvcmException.ReasonCode.READ_FAILED);
            }
        }
        return CQ_CREDS;
    }

    private String getPasswordFolderPath() {
        return CTInitArgUtils.getScriptLocationPrefix(this.ctInitArgs);
    }

    public String getQueryStringForCQResource(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        String queryString = this.queryStringForActivity.get(null, activitySelector);
        if (queryString == null) {
            Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
            Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
            if (!pvarMap.isEmpty() && !cqArgs.isEmpty()) {
                String recordType = pvarMap.get(RECORD_TYPE_KEY);
                String recordID = pvarMap.get(RECORD_ID_KEY);
                String dbset = cqArgs.get(_DBSET).replaceAll("\"", new String());
                String userdb = cqArgs.get(_USERDB).replaceAll("\"", new String());
                String dbid = this.getRecordDbid(cqArgs, recordType, recordID, feedback);
                queryString = QUERY_PREFIX + recordType + "/" + dbid + '@' + dbset + "/" + userdb;
                try {
                    queryString = URLEncoder.encode(queryString, UTF_8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException("Unexpected UnsupportedEncodingException encoding characters with UTF-8");
                }
                this.queryStringForActivity.put(null, activitySelector, queryString);
            } else {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_MISSING_CQ_QUERY_ERROR, (Object)activitySelector), WvcmException.ReasonCode.FORBIDDEN);
            }
        }
        return queryString;
    }

    private Map<String, String> getCQPvarForActivity(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        String pvar = this.ucmActivityPvar.get(null, activitySelector);
        if (pvar == null) {
            pvar = this.ctProvider.execute(feedback, DESCRIBE, _FMT, "%[crm_record_type]p|%[crm_record_id]p", activitySelector);
            this.ucmActivityPvar.put(null, activitySelector, pvar);
        }
        StringTokenizer tokens = new StringTokenizer(pvar, "|");
        HashMap<String, String> pvarMap = new HashMap<String, String>();
        if (tokens.countTokens() >= 2) {
            String recordType = tokens.nextToken();
            String recordID = tokens.nextToken();
            pvarMap.put(RECORD_TYPE_KEY, recordType);
            pvarMap.put(RECORD_ID_KEY, recordID);
        }
        return pvarMap;
    }

    private String getRecordDbid(Map<String, String> cqArgs, String recordType, String recordID, SrvcFeedback feedback) throws WvcmException {
        String dbid = this.recordDbids.get(recordType, recordID);
        if (dbid == null) {
            String login = cqArgs.get(_USERNAME);
            String password = cqArgs.get(_PASSWORD);
            String dbset = cqArgs.get(_DBSET);
            String userdb = cqArgs.get(_USERDB);
            String script = this.getDbidScriptAbsolutePath();
            ArrayList<String> ratlPerlArgs = new ArrayList<String>();
            ratlPerlArgs.add(script);
            ratlPerlArgs.add(_USERNAME);
            ratlPerlArgs.add(login);
            ratlPerlArgs.add(_PASSWORD);
            ratlPerlArgs.add(password);
            ratlPerlArgs.add(_USERDB);
            ratlPerlArgs.add(userdb);
            ratlPerlArgs.add(_DBSET);
            ratlPerlArgs.add(dbset);
            ratlPerlArgs.add(_TYPE);
            ratlPerlArgs.add(recordType);
            ratlPerlArgs.add(_ID);
            ratlPerlArgs.add(recordID);
            dbid = this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
            this.recordDbids.put(recordType, recordID, dbid);
        }
        return dbid;
    }

    public String getActivityFromQueryString(String queryString, SrvcFeedback feedback) throws WvcmException {
        String recordArgs;
        StringTokenizer tokens;
        String activitySelector = this.activityFromQueryString.get(null, queryString);
        if (activitySelector == null && queryString.startsWith(QUERY_PREFIX) && (tokens = new StringTokenizer(recordArgs = queryString.substring(QUERY_PREFIX.length(), queryString.indexOf(64)), "/")).countTokens() >= 2) {
            String recordType = tokens.nextToken();
            String dbid = tokens.nextToken();
            activitySelector = this.getActivityFromCQRecord(recordType, dbid, feedback);
            this.activityFromQueryString.put(null, queryString, activitySelector);
        }
        return activitySelector;
    }

    private String getActivityFromCQRecord(String recordType, String dbid, SrvcFeedback feedback) throws WvcmException {
        String activitySelector = this.activitySelectorFromRecord.get(recordType, dbid);
        if (activitySelector == null) {
            Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
            String login = cqArgs.get(_USERNAME);
            String password = cqArgs.get(_PASSWORD);
            String dbset = cqArgs.get(_DBSET);
            String userdb = cqArgs.get(_USERDB);
            String script = this.getActivityScriptAbsolutePath();
            ArrayList<String> ratlPerlArgs = new ArrayList<String>();
            ratlPerlArgs.add(script);
            ratlPerlArgs.add(_USERNAME);
            ratlPerlArgs.add(login);
            ratlPerlArgs.add(_PASSWORD);
            ratlPerlArgs.add(password);
            ratlPerlArgs.add(_USERDB);
            ratlPerlArgs.add(userdb);
            ratlPerlArgs.add(_DBSET);
            ratlPerlArgs.add(dbset);
            ratlPerlArgs.add(_TYPE);
            ratlPerlArgs.add(recordType);
            ratlPerlArgs.add(_DBID);
            ratlPerlArgs.add(dbid);
            activitySelector = this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
            this.activitySelectorFromRecord.put(recordType, dbid, activitySelector);
        }
        return activitySelector;
    }

    public String getCQActivityComment(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
        String recordType = pvarMap.get(RECORD_TYPE_KEY);
        String recordId = pvarMap.get(RECORD_ID_KEY);
        Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
        String login = cqArgs.get(_USERNAME);
        String password = cqArgs.get(_PASSWORD);
        String dbset = cqArgs.get(_DBSET);
        String userdb = cqArgs.get(_USERDB);
        String script = this.getReadCommentScriptAbsolutePath();
        ArrayList<String> ratlPerlArgs = new ArrayList<String>();
        ratlPerlArgs.add(script);
        ratlPerlArgs.add(_USERNAME);
        ratlPerlArgs.add(login);
        ratlPerlArgs.add(_PASSWORD);
        ratlPerlArgs.add(password);
        ratlPerlArgs.add(_USERDB);
        ratlPerlArgs.add(userdb);
        ratlPerlArgs.add(_DBSET);
        ratlPerlArgs.add(dbset);
        ratlPerlArgs.add(_TYPE);
        ratlPerlArgs.add(recordType);
        ratlPerlArgs.add(_ID);
        ratlPerlArgs.add(recordId);
        String comment = this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
        return comment;
    }

    public void setCQActivityComment(String activitySelector, String comment, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
        String recordType = pvarMap.get(RECORD_TYPE_KEY);
        String recordId = pvarMap.get(RECORD_ID_KEY);
        Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
        String login = cqArgs.get(_USERNAME);
        String password = cqArgs.get(_PASSWORD);
        String dbset = cqArgs.get(_DBSET);
        String userdb = cqArgs.get(_USERDB);
        String script = this.getWriteCommentScriptAbsolutePath();
        ArrayList<String> ratlPerlArgs = new ArrayList<String>();
        ratlPerlArgs.add(script);
        ratlPerlArgs.add(_USERNAME);
        ratlPerlArgs.add(login);
        ratlPerlArgs.add(_PASSWORD);
        ratlPerlArgs.add(password);
        ratlPerlArgs.add(_USERDB);
        ratlPerlArgs.add(userdb);
        ratlPerlArgs.add(_DBSET);
        ratlPerlArgs.add(dbset);
        ratlPerlArgs.add(_TYPE);
        ratlPerlArgs.add(recordType);
        ratlPerlArgs.add(_ID);
        ratlPerlArgs.add(recordId);
        ratlPerlArgs.add(_COMMENT);
        ratlPerlArgs.add(comment);
        this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
    }

    public void fixInvisibleElementPaths(String viewTag, String oldVersPathname, String newPathname, SrvcFeedback feedback) throws WvcmException {
        String delimiter = "main";
        String oldPathname = CommonUtils.canonicalizePathname(oldVersPathname);
        oldPathname = oldPathname.replace(AT_AT, new String());
        String[] tokens = oldPathname.split(delimiter);
        String[] oldTokens = oldVersPathname.split(delimiter);
        String parent = null;
        String finalSegment = newPathname;
        String base = null;
        String oldBase = null;
        Stack<String> stack = new Stack<String>();
        int i = 0;
        while (i < tokens.length - 1) {
            String token = tokens[i];
            String oldToken = oldTokens[i];
            if (token.endsWith(CommonUtils.FWDSLASH)) {
                token = token.substring(0, token.length() - 1);
            }
            if (i == 0) {
                parent = base = token;
                oldBase = oldToken;
            } else {
                String leafElement = token.substring(token.lastIndexOf(CommonUtils.FWDSLASH));
                parent = base;
                base = String.valueOf(base) + leafElement;
                oldBase = String.valueOf(oldBase) + delimiter + oldToken;
            }
            finalSegment = base;
            ArrayList<String> args = new ArrayList<String>((Collection)Arrays.asList(DESCRIBE, _FMT, FMT_EN));
            args.add(base);
            CommandResult r = this.ctProvider.executeGetResult(feedback, args);
            if (r.getStat() != 0 || r.getStdOut().contains(AT_AT)) {
                if (this.isCheckedout(parent, feedback)) {
                    this.checkin(true, "Checkin While Fixing Invisible Paths", Collections.singletonList(parent), feedback);
                }
                this.checkout(parent, feedback);
                this.link(oldBase, base, feedback);
                stack.push(parent);
            }
            ++i;
        }
        this.moveName(finalSegment, newPathname, feedback);
        while (!stack.isEmpty()) {
            String path = (String)stack.pop();
            this.uncheckout(path, feedback);
            String xName = this.getExtendedName(viewTag, path, feedback);
            String branchName = null;
            if (xName.endsWith("\\0")) {
                branchName = xName.substring(0, xName.lastIndexOf("\\0"));
            } else if (xName.endsWith("/0")) {
                branchName = xName.substring(0, xName.lastIndexOf("/0"));
            }
            if (branchName == null) continue;
            this.removeBranch(branchName, feedback);
        }
    }

    private void removeBranch(String branchName, SrvcFeedback feedback) throws WvcmException {
        this.ctProvider.execute(feedback, RMBRANCH, _NC, _FORCE, branchName);
    }

    private boolean isCheckedout(String pathname, SrvcFeedback feedback) throws WvcmException {
        boolean checkout = false;
        String status = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_CO, pathname);
        if (status != null && status.contains("reserved")) {
            checkout = true;
        }
        return checkout;
    }

    public void performCQActionOnUCMRecord(String activitySelector, SrvcFeedback feedback) throws WvcmException {
        String newAction = CTInitArgUtils.getCQUCMRecordAction(this.ctInitArgs).trim();
        if (!newAction.equals(DEFAULT_CQ_ACTION)) {
            Map<String, String> pvarMap = this.getCQPvarForActivity(activitySelector, feedback);
            String recordType = pvarMap.get(RECORD_TYPE_KEY);
            String recordId = pvarMap.get(RECORD_ID_KEY);
            Map<String, String> cqArgs = this.getCQLoginInfo(feedback);
            String login = cqArgs.get(_USERNAME);
            String password = cqArgs.get(_PASSWORD);
            String dbset = cqArgs.get(_DBSET);
            String userdb = cqArgs.get(_USERDB);
            String script = this.getCQActionScriptAbsolutePath();
            ArrayList<String> ratlPerlArgs = new ArrayList<String>();
            ratlPerlArgs.add(script);
            ratlPerlArgs.add(_USERNAME);
            ratlPerlArgs.add(login);
            ratlPerlArgs.add(_PASSWORD);
            ratlPerlArgs.add(password);
            ratlPerlArgs.add(_USERDB);
            ratlPerlArgs.add(userdb);
            ratlPerlArgs.add(_DBSET);
            ratlPerlArgs.add(dbset);
            ratlPerlArgs.add(_TYPE);
            ratlPerlArgs.add(recordType);
            ratlPerlArgs.add(_ID);
            ratlPerlArgs.add(recordId);
            ratlPerlArgs.add(_ACTION);
            ratlPerlArgs.add(newAction);
            this.ctProvider.executeRatlPerl(this.getPasswordFolderPath(), feedback, ratlPerlArgs);
        }
    }

    private boolean isVobUCMEnabled(String vobPath, SrvcFeedback feedback) throws WvcmException {
        boolean enabled = false;
        String vobCompCrde = this.getComponentCRDE(vobPath, feedback);
        if (vobCompCrde != null) {
            enabled = true;
        } else {
            Map<String, String> children = this.getCCDirectory(vobPath, feedback);
            for (String child : children.keySet()) {
                String childPath;
                String compCrde;
                String mtype = children.get(child);
                if (!mtype.equals(DUMP_MTYPE_DIRECTORY) || (compCrde = this.getComponentCRDE(childPath = String.valueOf(vobPath) + CommonUtils.FWDSLASH + child, feedback)) == null) continue;
                enabled = true;
                break;
            }
        }
        return enabled;
    }

    private String getComponentCRDE(String gpath, SrvcFeedback feedback) throws WvcmException {
        String crdeDBID = null;
        String elemGpath = this.getElemPathName(gpath, feedback);
        List<String> lines = this.ctProvider.executeGetValues(feedback, DUMP, elemGpath);
        for (String string : lines) {
            Matcher m = CRDE_PATTERN.matcher(string);
            if (!m.find()) continue;
            crdeDBID = m.replaceFirst("$1");
            break;
        }
        return crdeDBID;
    }

    public String getComponentRootDir(String compSelector, SrvcFeedback feedback) throws WvcmException {
        return this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_ROOT_DIR, compSelector);
    }

    public void rebaseStream(String viewTag, String streamSelector, String blSel, SrvcFeedback feedback) throws WvcmException {
        String[] rebaseArgs;
        CommandResult r;
        boolean viewCreated = false;
        if (viewTag == null) {
            viewTag = this.makeViewOnStream(streamSelector, feedback);
            viewCreated = true;
        }
        if ((r = this.ctProvider.executeGetResult(feedback, rebaseArgs = new String[]{REBASE, _VIEW, viewTag, _COMPLETE, _STREAM, streamSelector, _BASELINE, blSel})).getStdErr().contains("is not attached to stream")) {
            viewTag = this.makeViewOnStream(streamSelector, feedback);
            viewCreated = true;
            this.rebaseStream(viewTag, streamSelector, blSel, feedback);
        } else if (r.getStdErr().contains("because it is not from the parent stream,\nin the parent's stream foundation, from the same project or delivered to the\nparent stream.")) {
            String intStream = this.getIntStreamOfStream(streamSelector, feedback);
            if (ObjSelUtils.isUniversalSelector(streamSelector)) {
                streamSelector = this.getExtendedName(viewTag, streamSelector, feedback);
            }
            if (streamSelector.equals(intStream)) {
                CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
                r.assertSuccess(ignoreFlags);
            }
            String parentStream = this.getParentStream(streamSelector, feedback);
            String parentViewTag = this.makeViewOnStream(parentStream, feedback);
            this.rebaseStream(parentViewTag, parentStream, blSel, feedback);
            this.rebaseStream(viewTag, streamSelector, blSel, feedback);
            this.removeView(parentViewTag, feedback);
        } else {
            CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
            r.assertSuccess(ignoreFlags);
        }
        if (viewCreated) {
            this.removeView(viewTag, feedback);
        }
    }

    private String getIntStreamOfStream(String streamSel, SrvcFeedback feedback) throws WvcmException {
        String intStream = this.intstreamByStream.get(null, streamSel);
        if (intStream == null) {
            String projectSel = this.getProjectObjectSelector(streamSel, feedback);
            intStream = this.getIntStreamOfProject(projectSel, feedback);
            this.intstreamByStream.put(null, streamSel, intStream);
        }
        return intStream;
    }

    private String getIntStreamOfProject(String projectSel, SrvcFeedback feedback) throws WvcmException {
        String intStream = this.intstreamByProject.get(null, projectSel);
        if (intStream == null && (intStream = this.ctProvider.execute(feedback, DESCRIBE, _FMT, FMT_ISSTREAM_CXP, projectSel)) != null) {
            this.intstreamByProject.put(null, projectSel, intStream);
        }
        return intStream;
    }

    private String makeViewOnStream(String streamSelector, SrvcFeedback feedback) throws WvcmException {
        String viewTag = this.makeView("temp_view", this.getExtendedName(null, streamSelector, feedback), feedback);
        return viewTag;
    }

    public boolean isBaseCCView(String viewTag, SrvcFeedback feedback) throws WvcmException {
        boolean returnValue = false;
        if (isBaseCCView.contains(viewTag)) {
            returnValue = true;
        }
        if (!returnValue && !isUCMView.contains(viewTag)) {
            String stream = this.getViewStream(viewTag, feedback);
            if (stream != null) {
                isUCMView.add(viewTag);
            } else {
                returnValue = true;
                isBaseCCView.add(viewTag);
            }
        }
        return returnValue;
    }

    private String getViewStream(String viewTag, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.ctProvider.executeGetResult(feedback, LSSTREAM, _SHORT, _VIEW, viewTag);
        CommandResult.IgnoreFlags ignoreFlags = new CommandResult.IgnoreFlags(CommandResult.IgnoreFlags.Kind.NOT_FOUND, CommandResult.IgnoreFlags.Kind.NO_VIEW_INFO);
        r.assertSuccess(ignoreFlags);
        String stream = r.getStdOut();
        if (stream.equals(DEFAULT_CQ_ACTION)) {
            stream = null;
        }
        return stream;
    }

    public void setCheckoutVOBList(String objSel, String pathname, SrvcFeedback feedback) throws WvcmException {
        String myPath = CommonUtils.canonicalizePathname(pathname);
        boolean addNewVobPath = true;
        List<String> vobList = checkoutVobs.get(objSel);
        if (vobList != null) {
            String viewTag = ObjSelUtils.getViewTag(mvfsRoot, myPath);
            String viewPath = CCaseLib.getPathIntoView(viewTag);
            String myRelativePath = myPath.substring(viewPath.length());
            Iterator<String> iterator = vobList.iterator();
            while (addNewVobPath && iterator.hasNext()) {
                String storedPath = CommonUtils.canonicalizePathname(iterator.next());
                if (!myRelativePath.startsWith(String.valueOf(storedPath) + CommonUtils.FWDSLASH)) continue;
                addNewVobPath = false;
            }
        } else {
            vobList = new ArrayList<String>();
        }
        if (addNewVobPath) {
            String vobPath = this.getVobTagFromGpath(myPath, feedback);
            this.addPathOnVOBList(objSel, vobPath, feedback);
            vobList.add(vobPath);
            checkoutVobs.put(objSel, vobList);
        }
    }

    public List<String> getCheckoutVobPathList(String objSel, SrvcFeedback feedback) throws WvcmException {
        String coVobs = this.getAttr(COVOB_ATTR, objSel, feedback);
        ArrayList<String> tokens = new ArrayList<String>();
        if (coVobs != null) {
            if (coVobs.contains("|")) {
                String[] oidsArray;
                String[] stringArray = oidsArray = coVobs.split(LITERAL_VERTICAL_BAR_PATTERN);
                int n = oidsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String oidSelector = stringArray[n2];
                    this.addVobPathToCheckoutsList(oidSelector, tokens, feedback);
                    ++n2;
                }
            } else {
                this.addVobPathToCheckoutsList(coVobs, tokens, feedback);
            }
        }
        return tokens;
    }

    private void addVobPathToCheckoutsList(String oidSelector, List<String> tokens, SrvcFeedback feedback) throws WvcmException {
        block2: {
            String familyUUID = ObjSelUtils.getObjSelName(oidSelector);
            try {
                tokens.add(String.valueOf('.') + this.computeVobTagFromVobSelector(familyUUID, feedback));
            }
            catch (WvcmException e) {
                if (e.getMessage().contains("cleartool: Error: No matching entries found for uuid")) break block2;
                throw e;
            }
        }
    }

    private void addPathOnVOBList(String objSel, String vobTag, SrvcFeedback feedback) throws WvcmException {
        String coVobs = this.getAttr(COVOB_ATTR, objSel, feedback);
        String vobSelector = this.getVobSelector(vobTag, feedback);
        if (coVobs != null) {
            if (!coVobs.contains(vobSelector)) {
                coVobs = String.valueOf(coVobs) + "|" + vobSelector;
                this.setAttr(COVOB_ATTR, objSel, coVobs, true, feedback);
            }
        } else {
            coVobs = vobSelector;
            this.setAttr(COVOB_ATTR, objSel, coVobs, false, feedback);
        }
    }

    public String mkFolderGUITrtype(String trtypeName, String vobTag, SrvcFeedback feedback) throws WvcmException {
        String trtype = ObjSelUtils.formatSelector("trtype", trtypeName, vobTag);
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(MKTRTYPE);
        cleartoolArgs.add(_UCMOBJECT);
        cleartoolArgs.add(_ALL);
        cleartoolArgs.add(_PREOP);
        cleartoolArgs.add(MKFOLDER);
        cleartoolArgs.add(_NC);
        cleartoolArgs.add(_EXEC);
        cleartoolArgs.add(CommandProvider.CP);
        cleartoolArgs.add(trtype);
        this.ctProvider.execute(feedback, cleartoolArgs);
        return trtype;
    }

    public void makeFolder(String folderSel, String parentFolderSel, SrvcFeedback feedback) throws WvcmException {
        CommandResult r = this.makeFolderWithResult(folderSel, parentFolderSel, feedback);
        r.assertSuccess(new CommandResult.IgnoreFlags(new CommandResult.IgnoreFlags.Kind[0]));
    }

    public void removeFolder(String folderSel, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(RMFOLDER);
        cleartoolArgs.add(_NC);
        cleartoolArgs.add(_FORCE);
        cleartoolArgs.add(folderSel);
        this.ctProvider.execute(feedback, cleartoolArgs);
    }

    public CommandResult makeFolderWithResult(String folderSel, String parentFolderSel, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(MKFOLDER);
        cleartoolArgs.add(_NC);
        cleartoolArgs.add(_IN);
        cleartoolArgs.add(parentFolderSel);
        cleartoolArgs.add(folderSel);
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        return r;
    }

    public String mkFolderEvTrtype(String trtypeName, String vobTag, String scriptPath, SrvcFeedback feedback) throws WvcmException {
        String trtype = ObjSelUtils.formatSelector("trtype", trtypeName, vobTag);
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(MKTRTYPE);
        cleartoolArgs.add(_UCMOBJECT);
        cleartoolArgs.add(_ALL);
        cleartoolArgs.add(_PREOP);
        cleartoolArgs.add(MKFOLDER);
        cleartoolArgs.add(_NC);
        if (CommandProvider.IS_WINDOWS) {
            cleartoolArgs.add(_EXECWIN);
        } else {
            cleartoolArgs.add(_EXECUNIX);
        }
        cleartoolArgs.add(String.valueOf(this.ctProvider.getRatlPerl(feedback)) + SPACE + scriptPath);
        cleartoolArgs.add(trtype);
        this.ctProvider.execute(feedback, cleartoolArgs);
        return trtype;
    }

    public void setExecutePermission(String elementPath, boolean permission, SrvcFeedback feedback) throws WvcmException {
        ArrayList<String> cleartoolArgs = new ArrayList<String>();
        cleartoolArgs.add(PROTECT);
        cleartoolArgs.add(_CHMOD);
        if (permission) {
            cleartoolArgs.add(PLUS_X);
        } else {
            cleartoolArgs.add(MINUS_X);
        }
        cleartoolArgs.add(elementPath);
        CommandResult r = this.ctProvider.executeGetResult(feedback, cleartoolArgs);
        String stdErr = r.getStdErr();
        if (!stdErr.contains("cleartool: Error: Not a vob object")) {
            r.assertSuccess(new CommandResult.IgnoreFlags(new CommandResult.IgnoreFlags.Kind[0]));
        }
    }

    public boolean getExecutePermission(String elementPath, SrvcFeedback feedback) throws WvcmException {
        Map<String, String> results = this.getExecutePermissionMap(feedback, elementPath);
        String perms = results.get(elementPath);
        if (perms == null) {
            throw new IllegalStateException(NLS.bind((String)"Could not find pathname '{0}' in results map", (Object)elementPath));
        }
        return CCaseLib.isExecutable(perms);
    }

    public Map<String, String> getExecutePermissionMap(SrvcFeedback feedback, String ... elementPaths) throws WvcmException {
        List<String> describeInfoTagged = this.executeBatched(feedback, null, null, true, Collections.singletonList(DESCRIBE), Arrays.asList(elementPaths));
        return CCaseLib.parseTaggedDescribeOutputForExecutePermission(describeInfoTagged, feedback);
    }

    public static Map<String, String> parseTaggedDescribeOutputForExecutePermission(List<String> describeInfoTagged, SrvcFeedback feedback) {
        HashMap<String, String> results = new HashMap<String, String>();
        LookingFor lookingFor = LookingFor.ELEM_PNAME_TAG_ID;
        String elemPname = null;
        for (String descLine : describeInfoTagged) {
            switch (lookingFor) {
                case ELEM_PNAME_TAG_ID: {
                    Matcher m = ELEM_PNAME_TAG_ID_PATTERN.matcher(descLine);
                    if (!m.find()) break;
                    lookingFor = LookingFor.ELEM_PNAME_TAG_VALUE;
                    break;
                }
                case ELEM_PNAME_TAG_VALUE: {
                    Matcher m = ELEM_PNAME_TAG_VALUE_PATTERN.matcher(descLine);
                    if (!m.find()) break;
                    elemPname = CommonUtils.canonicalizePathname(m.group(1));
                    lookingFor = LookingFor.USER_PERMS_TAG_ID;
                    break;
                }
                case USER_PERMS_TAG_ID: {
                    Matcher m = USER_PERMS_TAG_ID_PATTERN.matcher(descLine);
                    if (!m.find()) break;
                    lookingFor = LookingFor.USER_PERMS_TAG_VALUE;
                    break;
                }
                case USER_PERMS_TAG_VALUE: {
                    Matcher m = USER_PERMS_TAG_VALUE_PATTERN.matcher(descLine);
                    if (!m.find()) break;
                    results.put(elemPname, m.group(1));
                    lookingFor = LookingFor.ELEM_PNAME_TAG_ID;
                }
            }
        }
        return results;
    }

    public static boolean isExecutable(String perms) {
        return perms.contains(littleX);
    }

    public String getAdminVobTag(String vobTag, SrvcFeedback feedback) throws WvcmException {
        String objSel = ObjSelUtils.formatSelector("vob", vobTag);
        List<String> hLinks = this.getHyperlinkEnds(true, ADMIN_VOB, objSel, feedback);
        String result = ObjSelUtils.getObjSelName(hLinks.get(0));
        return result;
    }

    private String getCommaSeparatedFromList(List<String> list) {
        return CommonUtils.myToString(COMMA, list, true);
    }

    public boolean isCasePreservingNature(SrvcFeedback feedback) throws WvcmException {
        boolean nature;
        block10: {
            nature = false;
            if (!CommandProvider.IS_WINDOWS) {
                nature = true;
            } else {
                try {
                    File[] logFiles;
                    File printedLogFile;
                    File parent;
                    List<String> logLines = this.ctProvider.executeMvfsLog(feedback);
                    String logFileName = null;
                    for (String logEntry : logLines) {
                        Matcher m = LOGFILE_PATTERN.matcher(logEntry);
                        if (!m.find()) continue;
                        logFileName = m.group(1);
                        break;
                    }
                    if (logFileName == null || !(parent = new File((printedLogFile = new File(logFileName)).getParent())).exists()) break block10;
                    File[] fileArray = logFiles = CCaseLib.getFilesByLastModifiedDate(parent);
                    int n = logFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line;
                        File logFile = fileArray[n2];
                        BufferedReader reader = new BufferedReader(new FileReader(logFile));
                        while ((line = reader.readLine()) != null) {
                            if (line.contains(MVFS_CASE_PRESERVING_MODE)) {
                                nature = true;
                            } else if (!line.contains(MVFS_DOWNCASING_MODE)) {
                                continue;
                            }
                            break block10;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
        }
        return nature;
    }

    private static File[] getFilesByLastModifiedDate(File dir) {
        File[] logFiles = dir.listFiles();
        Arrays.sort(logFiles, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return (int)(f2.lastModified() - f1.lastModified());
            }
        });
        return logFiles;
    }

    public List<String> listDirectoryTree(String pathName, SrvcFeedback feedback) throws WvcmException {
        return CCaseLib.removeLostAndFoundEntries(this.directoryTreeHelper(pathName, true, feedback));
    }

    public static List<String> removeLostAndFoundEntries(List<String> entries) {
        ArrayList<String> results = new ArrayList<String>();
        for (String entry : entries) {
            boolean matches = entry.matches(lAndFPattern);
            if (matches) continue;
            results.add(entry);
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Cache {
        private Map<String, String> cache = new HashMap<String, String>();

        Cache() {
        }

        private List<String> get(String keyPrefix, List<String> keys) {
            ArrayList<String> result = new ArrayList<String>(keys.size());
            if (CCaseLib.this.cachingEnabled) {
                for (String key : keys) {
                    String realKey;
                    String string = realKey = keyPrefix == null ? key : String.valueOf(keyPrefix) + key;
                    if (!this.cache.containsKey(realKey)) {
                        result.clear();
                        break;
                    }
                    result.add(this.cache.get(realKey));
                }
            }
            return result;
        }

        private String get(String keyPrefix, String key) {
            if (!CCaseLib.this.cachingEnabled) {
                return null;
            }
            if (keyPrefix == null) {
                return this.cache.get(key);
            }
            return this.cache.get(String.valueOf(keyPrefix) + key);
        }

        private void put(String keyPrefix, List<String> keys, List<String> values) {
            if (CCaseLib.this.cachingEnabled) {
                Iterator<String> it = keys.iterator();
                for (String value : values) {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException("Number of keys does not match number of values");
                    }
                    String key = it.next();
                    this.cache.put(String.valueOf(keyPrefix) + key, value);
                }
            }
        }

        private void put(String keyPrefix, String key, String value) {
            if (value == null) {
                throw new IllegalArgumentException("Attempt to cache null value");
            }
            if (CCaseLib.this.cachingEnabled) {
                if (keyPrefix == null) {
                    this.cache.put(key, value);
                } else {
                    this.cache.put(String.valueOf(keyPrefix) + key, value);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LookingFor {
        ELEM_PNAME_TAG_ID,
        ELEM_PNAME_TAG_VALUE,
        USER_PERMS_TAG_ID,
        USER_PERMS_TAG_VALUE;

    }
}

