/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.core.subscribers.WorkingSetFilteredSyncInfoCollector;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SubscriberParticipantPage;
import org.eclipse.team.ui.synchronize.ISynchronizePage;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

public class RemoveFromViewAction
extends SynchronizeModelAction {
    public RemoveFromViewAction(ISynchronizePageConfiguration configuration) {
        super(null, configuration);
        Utils.initAction((IAction)this, "action.removeFromView.");
    }

    public void run() {
        if (this.confirmRemove()) {
            super.run();
        }
    }

    protected SynchronizeModelOperation getSubscriberOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        return new SynchronizeModelOperation(configuration, elements){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SyncInfoSet set = this.getSyncInfoSet();
                this.removeFromView(set);
            }

            protected boolean canRunAsJob() {
                return false;
            }

            private void removeFromView(SyncInfoSet set) {
                ISynchronizePage page = RemoveFromViewAction.this.getConfiguration().getPage();
                if (page instanceof SubscriberParticipantPage) {
                    WorkingSetFilteredSyncInfoCollector collector = ((SubscriberParticipantPage)page).getCollector();
                    collector.run(new IWorkspaceRunnable(this, collector, set){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ WorkingSetFilteredSyncInfoCollector val$collector;
                        private final /* synthetic */ SyncInfoSet val$set;
                        {
                            this.this$1 = var1_1;
                            this.val$collector = workingSetFilteredSyncInfoCollector;
                            this.val$set = syncInfoSet;
                        }

                        public void run(IProgressMonitor monitor) throws CoreException {
                            this.val$collector.getWorkingSetSyncInfoSet().removeAll(this.val$set.getResources());
                        }
                    });
                }
            }
        };
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    private boolean confirmRemove() {
        IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        if (store.getBoolean("org.eclipse.team.ui.remove_from_view_without_prompt")) {
            return true;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getConfiguration().getSite().getShell(), (String)TeamUIMessages.RemoveFromView_warningTitle, (String)TeamUIMessages.RemoveFromView_warningMessage, (String)TeamUIMessages.RemoveFromView_warningDontShow, (boolean)false, null, null);
        store.setValue("org.eclipse.team.ui.remove_from_view_without_prompt", dialog.getToggleState());
        return dialog.getReturnCode() == 0;
    }
}

