/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.ResourceUtil;

public abstract class TeamAction
extends AbstractHandler
implements IObjectActionDelegate,
IViewActionDelegate,
IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    private IStructuredSelection selection;
    private Shell shell;
    public static final int PROGRESS_DIALOG = 1;
    public static final int PROGRESS_BUSYCURSOR = 2;
    private IWorkbenchPart targetPart;
    private IWorkbenchWindow window;
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                TeamAction.this.selection = (IStructuredSelection)selection;
            }
        }
    };

    public static Object[] getSelectedAdaptables(ISelection selection, Class c) {
        ArrayList<Object> result = null;
        if (selection != null && !selection.isEmpty()) {
            result = new ArrayList<Object>();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object adapter = TeamAction.getAdapter(elements.next(), c);
                if (!c.isInstance(adapter)) continue;
                result.add(adapter);
            }
        }
        if (result != null && !result.isEmpty()) {
            return result.toArray((Object[])Array.newInstance(c, result.size()));
        }
        return (Object[])Array.newInstance(c, 0);
    }

    public static Object getAdapter(Object adaptable, Class c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    protected IProject[] getSelectedProjects() {
        IResource[] selectedResources = this.getSelectedResources();
        if (selectedResources.length == 0) {
            return new IProject[0];
        }
        ArrayList<IResource> projects = new ArrayList<IResource>();
        int i = 0;
        while (i < selectedResources.length) {
            IResource resource = selectedResources[i];
            if (resource.getType() == 4) {
                projects.add(resource);
            }
            ++i;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    protected Object[] getAdaptedSelection(Class c) {
        return TeamAction.getSelectedAdaptables((ISelection)this.selection, c);
    }

    protected IResource[] getSelectedResources() {
        return Utils.getContributedResources(this.getSelection().toArray());
    }

    protected IStructuredSelection getSelection() {
        if (this.selection == null) {
            this.selection = StructuredSelection.EMPTY;
        }
        return this.selection;
    }

    protected ResourceMapping[] getSelectedResourceMappings(String providerId) {
        Object[] elements = this.getSelection().toArray();
        ArrayList<ResourceMapping> providerMappings = new ArrayList<ResourceMapping>();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            Object adapted = this.getResourceMapping(object);
            if (adapted instanceof ResourceMapping) {
                ResourceMapping mapping = (ResourceMapping)adapted;
                if (providerId == null || this.isMappedToProvider(mapping, providerId)) {
                    providerMappings.add(mapping);
                }
            }
            ++i;
        }
        return providerMappings.toArray(new ResourceMapping[providerMappings.size()]);
    }

    private Object getResourceMapping(Object object) {
        if (object instanceof ResourceMapping) {
            return (ResourceMapping)object;
        }
        return Utils.getResourceMapping(object);
    }

    private boolean isMappedToProvider(ResourceMapping element, String providerId) {
        IProject[] projects = element.getProjects();
        int k = 0;
        while (k < projects.length) {
            IProject project = projects[k];
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider != null && provider.getID().equals(providerId)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    protected Shell getShell() {
        if (this.shell != null) {
            return this.shell;
        }
        if (this.targetPart != null) {
            return this.targetPart.getSite().getShell();
        }
        if (this.window != null) {
            return this.window.getShell();
        }
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    protected final void run(final IRunnableWithProgress runnable, String problemMessage, int progressKind) {
        final Exception[] exceptions = new Exception[1];
        switch (progressKind) {
            case 2: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            runnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException interruptedException) {
                            exceptions[0] = null;
                        }
                    }
                });
                break;
            }
            default: {
                try {
                    new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
                    break;
                }
                catch (InvocationTargetException e) {
                    exceptions[0] = e;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    exceptions[0] = null;
                }
            }
        }
        if (exceptions[0] != null) {
            this.handle(exceptions[0], null, problemMessage);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            if (action != null) {
                this.setActionEnablement(action);
            }
        }
    }

    protected void setActionEnablement(IAction action) {
        action.setEnabled(this.isEnabled());
    }

    protected boolean isEnabledForException(TeamException exception) {
        if (exception.getStatus().getCode() == 274) {
            return true;
        }
        TeamPlugin.log((CoreException)exception);
        return false;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null) {
            this.shell = targetPart.getSite().getShell();
            this.targetPart = targetPart;
        }
    }

    protected void handle(Exception exception, String title, String message) {
        Utils.handleError(this.getShell(), exception, title, message);
    }

    protected Hashtable getProviderMapping(IResource[] resources) {
        Hashtable<RepositoryProvider, ArrayList<IResource>> result = new Hashtable<RepositoryProvider, ArrayList<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    protected IWorkbenchPart getTargetPart() {
        IWorkbenchPage page;
        if (this.targetPart == null && (page = TeamUIPlugin.getActivePage()) != null) {
            this.targetPart = page.getActivePart();
        }
        return this.targetPart;
    }

    protected IWorkbenchPage getTargetPage() {
        if (this.getTargetPart() == null) {
            return TeamUIPlugin.getActivePage();
        }
        return this.getTargetPart().getSite().getPage();
    }

    protected IViewPart showView(String viewId) {
        try {
            return this.getTargetPage().showView(viewId);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void init(IViewPart view) {
        if (view != null) {
            this.shell = view.getSite().getShell();
            this.targetPart = view;
        }
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.shell = window.getShell();
        window.getSelectionService().addPostSelectionListener(this.selectionListener);
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void dispose() {
        super.dispose();
        if (this.window != null) {
            this.window.getSelectionService().removePostSelectionListener(this.selectionListener);
        }
        this.selection = null;
        this.window = null;
        this.targetPart = null;
        this.shell = null;
    }

    protected abstract void execute(IAction var1) throws InvocationTargetException, InterruptedException;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (activeWorkbenchWindow != null && (selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) != null) {
            IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
            try {
                this.execute(activeWorkbenchWindow, part, selection);
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException(TeamUIMessages.TeamAction_errorTitle, (Throwable)e);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    private void execute(IWorkbenchWindow activeWorkbenchWindow, IWorkbenchPart part, ISelection selection) throws InvocationTargetException, InterruptedException {
        if (part != null && part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            if (file != null) {
                this.selectionChanged(null, (ISelection)new StructuredSelection((Object)file));
            }
        } else {
            this.selectionChanged(null, selection);
        }
        if (this.isEnabled()) {
            this.execute((IAction)null);
        } else {
            MessageDialog.openInformation((Shell)activeWorkbenchWindow.getShell(), (String)TeamUIMessages.TeamAction_handlerNotEnabledTitle, (String)TeamUIMessages.TeamAction_handlerNotEnabledMessage);
        }
    }

    public void run(IAction action) {
        try {
            this.execute(action);
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void handle(Exception e) {
        this.handle(e, TeamUIMessages.TeamAction_errorTitle, null);
    }

    public void init(IAction action) {
    }

    public final void runWithEvent(IAction action, Event event) {
        this.run(action);
    }
}

