/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.srvc;

import com.ibm.rational.wvcm.ri.impl.ActivityImpl;
import com.ibm.rational.wvcm.ri.impl.BaselineImpl;
import com.ibm.rational.wvcm.ri.impl.ComponentImpl;
import com.ibm.rational.wvcm.ri.impl.ConfigurationImpl;
import com.ibm.rational.wvcm.ri.impl.ControllableFolderImpl;
import com.ibm.rational.wvcm.ri.impl.ControllableResourceImpl;
import com.ibm.rational.wvcm.ri.impl.ControllableSymbolicLinkImpl;
import com.ibm.rational.wvcm.ri.impl.FolderImpl;
import com.ibm.rational.wvcm.ri.impl.FolderVersionImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.impl.ResourceListImpl;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.impl.SymbolicLinkVersionImpl;
import com.ibm.rational.wvcm.ri.impl.TaskImpl;
import com.ibm.rational.wvcm.ri.impl.VersionHistoryImpl;
import com.ibm.rational.wvcm.ri.impl.VersionImpl;
import com.ibm.rational.wvcm.ri.impl.WorkspaceImpl;
import com.ibm.rational.wvcm.ri.srvc.Messages;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.rational.wvcm.ri.srvc.WvcmService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.FolderVersion;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SrvcProvider
implements WorkspaceProvider {
    private static final String DOT = ".";
    public static final String RATIONAL_WVCM_NAMESPACE = "com.ibm.rational.wvcm";
    public static final String IA_DISPLAYNAME = "com.ibm.rational.wvcm.DISPLAYNAME";
    public static final String IA_CR_HAS_ONE_PARENT = "com.ibm.rational.wvcm.CR_HAS_ONE_PARENT";
    public static final String IA_STREAM_FORGETS_UNBOUND_VERSIONS = "com.ibm.rational.wvcm.STREAM_FORGETS_UNBOUND_VERSIONS";
    public static final String IA_VERSION_KNOWS_PARENT = "com.ibm.rational.wvcm.VERSION_KNOWS_PARENT";
    public static final String IA_WVCM_LOG_MINIMUM_DURATION = "com.ibm.rational.wvcm.LOG_MINIMUM_DURATION";
    protected ProviderFactory.Callback _callback;
    protected Map<String, String> _initArgs;
    public WvcmService _service;

    protected SrvcProvider() {
        this._service = new WvcmService(this);
    }

    public void initialize(Map<String, String> initArgs, ProviderFactory.Callback callback) throws WvcmException {
        if (initArgs != null) {
            if (this._initArgs == null) {
                this._initArgs = initArgs;
            } else {
                this._initArgs.putAll(initArgs);
            }
        }
        if (this._initArgs == null) {
            this._initArgs = new Hashtable<String, String>();
        }
        this._callback = callback;
    }

    protected SrvcProvider(ProviderFactory.Callback callback) {
        if (callback != null) {
            this._callback = callback;
            this._initArgs = new Hashtable<String, String>();
        }
        this._service = new WvcmService(this);
    }

    protected SrvcProvider(ProviderFactory.Callback callback, Map<String, String> args) {
        this._callback = callback;
        this._initArgs = args;
        this._service = new WvcmService(this);
    }

    public Location rootLocation() {
        throw new RuntimeException("rootLocation not yet implemented");
    }

    public Location relativeRootLocation() {
        throw new RuntimeException("rootLocation not yet implemented");
    }

    public Location location(String string) throws WvcmException {
        throw new WvcmException("location() not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public <T extends Resource> T buildProxy(Class<T> type, Location loc) throws WvcmException {
        if (Workspace.class.isAssignableFrom(type)) {
            return (T)new WorkspaceImpl(loc, (Provider)this);
        }
        if (ControllableSymbolicLink.class.isAssignableFrom(type)) {
            return (T)new ControllableSymbolicLinkImpl(loc, (Provider)this);
        }
        if (ControllableFolder.class.isAssignableFrom(type)) {
            return (T)new ControllableFolderImpl(loc, (Provider)this);
        }
        if (Configuration.class.isAssignableFrom(type)) {
            return (T)new ConfigurationImpl(loc, (Provider)this);
        }
        if (ControllableResource.class.isAssignableFrom(type)) {
            return (T)new ControllableResourceImpl(loc, (Provider)this);
        }
        if (Component.class.isAssignableFrom(type)) {
            return (T)new ComponentImpl(loc, (Provider)this);
        }
        if (VersionHistory.class.isAssignableFrom(type)) {
            return (T)new VersionHistoryImpl(loc, (Provider)this);
        }
        if (Folder.class.isAssignableFrom(type)) {
            return (T)new FolderImpl(loc, (Provider)this);
        }
        if (Stream.class.isAssignableFrom(type)) {
            return (T)new StreamImpl(loc, (Provider)this);
        }
        if (Activity.class.isAssignableFrom(type)) {
            return (T)new ActivityImpl(loc, (Provider)this);
        }
        if (Task.class.isAssignableFrom(type)) {
            return (T)new TaskImpl(loc, (Provider)this);
        }
        if (Baseline.class.isAssignableFrom(type)) {
            return (T)new BaselineImpl(loc, (Provider)this);
        }
        if (SymbolicLinkVersion.class.isAssignableFrom(type)) {
            return (T)new SymbolicLinkVersionImpl(loc, (Provider)this);
        }
        if (FolderVersion.class.isAssignableFrom(type)) {
            return (T)new FolderVersionImpl(loc, (Provider)this);
        }
        if (Version.class.isAssignableFrom(type)) {
            return (T)new VersionImpl(loc, (Provider)this);
        }
        return (T)new ResourceImpl(loc, (Provider)this);
    }

    public Resource buildProxy(Location location, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        SrvcResource resource = this.lookup(location, feedback);
        if (resource == null) {
            String msg = feedback.format(Messages.getString("SrvcProvider.ERR_NO_RESOURCE_FOUND"), location);
            throw new WvcmException(msg, WvcmException.ReasonCode.NOT_FOUND);
        }
        ResourceImpl proxy = resource.buildProxy(location);
        resource.readProperties(proxy, resource, propertyRequest, feedback);
        return proxy;
    }

    public Component component(Location loc) {
        ComponentImpl proxy = new ComponentImpl(loc, (Provider)this);
        return proxy;
    }

    public Stream stream(Location loc) {
        StreamImpl proxy = new StreamImpl(loc, (Provider)this);
        return proxy;
    }

    public Task task(Location loc) {
        TaskImpl proxy = new TaskImpl(loc, (Provider)this);
        return proxy;
    }

    public Activity activity(Location loc) {
        ActivityImpl proxy = new ActivityImpl(loc, (Provider)this);
        return proxy;
    }

    public Baseline baseline(Location loc) {
        BaselineImpl proxy = new BaselineImpl(loc, (Provider)this);
        return proxy;
    }

    public Configuration configuration(Location loc) {
        ConfigurationImpl proxy = new ConfigurationImpl(loc, (Provider)this);
        return proxy;
    }

    public ControllableFolder controllableFolder(Location loc) {
        ControllableFolderImpl proxy = new ControllableFolderImpl(loc, (Provider)this);
        return proxy;
    }

    public ControllableResource controllableResource(Location loc) {
        ControllableResourceImpl proxy = new ControllableResourceImpl(loc, (Provider)this);
        return proxy;
    }

    public ControllableSymbolicLink controllableSymbolicLink(Location loc) {
        ControllableSymbolicLinkImpl proxy = new ControllableSymbolicLinkImpl(loc, (Provider)this);
        return proxy;
    }

    public Folder folder(Location loc) {
        FolderImpl proxy = new FolderImpl(loc, (Provider)this);
        return proxy;
    }

    public FolderVersion folderVersion(Location loc) {
        FolderVersionImpl proxy = new FolderVersionImpl(loc, (Provider)this);
        return proxy;
    }

    public Resource resource(Location loc) {
        ResourceImpl proxy = new ResourceImpl(loc, (Provider)this);
        return proxy;
    }

    public Version version(Location loc) {
        VersionImpl proxy = new VersionImpl(loc, (Provider)this);
        return proxy;
    }

    public VersionHistory versionHistory(Location loc) {
        VersionHistoryImpl proxy = new VersionHistoryImpl(loc, (Provider)this);
        return proxy;
    }

    public Workspace workspace(Location loc) {
        WorkspaceImpl proxy = new WorkspaceImpl(loc, (Provider)this);
        return proxy;
    }

    public <T extends Resource> ResourceList<T> resourceList(T ... initialContent) {
        ResourceListImpl result = new ResourceListImpl(this);
        T[] TArray = initialContent;
        int n = initialContent.length;
        int n2 = 0;
        while (n2 < n) {
            T resource = TArray[n2];
            result.add(resource);
            ++n2;
        }
        return result;
    }

    public ProviderFactory.Callback callback() {
        return this._callback;
    }

    public Map<String, String> initArgs() {
        return this._initArgs;
    }

    public WvcmService service() {
        return this._service;
    }

    public SrvcResource getSrvcRes(Location loc, SrvcFeedback feedback) throws WvcmException {
        SrvcResource resource = this.lookup(loc, feedback);
        if (resource == null) {
            throw new WvcmException(String.valueOf(Messages.getString("SrvcProvider.ERR_DOES_NOT_EXIST")) + loc.string(), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return resource;
    }

    public List<Object> doUpdateProperties(List<Location> locations, PropertyRequestItem.PropertyRequest propertyRequest, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, SrvcFeedback feedback) throws WvcmException {
        return this.doUpdateContextProperties(locations, null, propertyRequest, updatesList, updatedList, feedback);
    }

    public List<Object> doUpdateContextProperties(List<Location> locations, SrvcResource context, PropertyRequestItem.PropertyRequest propertyRequest, List<Map<PropertyNameList.PropertyName<?>, PropValue>> updatesList, List<List<PropertyNameList.PropertyName<?>>> updatedList, SrvcFeedback feedback) throws WvcmException {
        int size = locations.size();
        int count = 1;
        ArrayList<Object> results = new ArrayList<Object>(locations.size());
        int i = 0;
        while (i < locations.size()) {
            block6: {
                ArrayList updated = new ArrayList();
                try {
                    try {
                        Location location = locations.get(i);
                        SrvcResource srvcResource = this.getSrvcRes(location, feedback.nest(20 * count / size));
                        Map<PropertyNameList.PropertyName<?>, PropValue> updates = updatesList.get(i);
                        srvcResource.doWriteProperties(updates, updated, feedback.nest(40 * count / size));
                        SrvcResource ctxt = context == null ? srvcResource : context;
                        ResourceImpl resource = srvcResource.buildProxy(location, propertyRequest, ctxt, feedback.nest(100 * count / size));
                        results.add(resource);
                    }
                    catch (WvcmException e) {
                        results.add((Object)e);
                        updatedList.add(updated);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    updatedList.add(updated);
                    throw throwable;
                }
                updatedList.add(updated);
            }
            ++count;
            ++i;
        }
        return results;
    }

    public List<Object> doFind(ResourceList<?> queries, PropertyRequestItem.PropertyRequest propertyRequest, SrvcFeedback feedback) throws WvcmException {
        int size = queries.size();
        int count = 1;
        ArrayList<Object> results = new ArrayList<Object>(queries.size());
        for (Resource query : queries) {
            try {
                List<Object> oneResult = this.doFind(query, propertyRequest, false, feedback.nest(100 * count / size));
                if (oneResult == null || oneResult.size() == 0) {
                    results.add(null);
                } else {
                    results.add(oneResult.get(0));
                }
            }
            catch (WvcmException e) {
                results.add((Object)e);
            }
            ++count;
        }
        return results;
    }

    public void validate(Feedback feedback) {
        if (feedback != null) {
            feedback.notifyPercentComplete(100);
            feedback.notifyActive(Messages.getString("INFO_NO_VALIDATIONS"));
        }
    }

    public SrvcResource lookup(Location location, SrvcFeedback feedback) {
        throw new RuntimeException("lookup not yet implemented");
    }

    public SrvcResource doCreateControllableResource(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateControllableResource not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateVersionControlledResource not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateControllableSymbolicLink not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateControllableFolder(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateControllableFolder not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateWorkspace not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateGeneratedWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateGeneratedWorkspace not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateActivity not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateGeneratedActivity(Location location, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateGeneratedActivity not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateGeneratedTask not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doBaselineControl(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doBaselineControl not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doCreateBaselineControlledFolder(Location location, Location baselineLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doCreateBaselineControlledFolder not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public List<Object> doFind(Resource query, PropertyRequestItem.PropertyRequest propertyRequest, boolean all, SrvcFeedback feedback) throws WvcmException {
        throw new WvcmException("doFind not yet implemented", WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
    }

    public SrvcResource doWriteContent(Location location, InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource srvcResource = this.lookup(location, feedback);
        if (srvcResource == null) {
            srvcResource = this.doCreateControllableResource(location, updates, updated, feedback.nest(50));
            updates.clear();
        }
        srvcResource.doWriteContent(content, contentIdentifier, updates, updated, feedback);
        return srvcResource;
    }
}

