/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import javax.wvcm.Location;
import javax.wvcm.WvcmException;

public class RiLocation
implements Location {
    private String _string;

    public boolean equals(Object o) {
        if (!(o instanceof RiLocation)) {
            return false;
        }
        return this._string.equals(((RiLocation)o)._string);
    }

    public int hashCode() {
        return this._string.hashCode();
    }

    public String toString() {
        return this._string;
    }

    public RiLocation(String string, Object dummy) {
        this._string = string;
    }

    public RiLocation(String string) throws WvcmException {
        if (string == null) {
            throw new WvcmException("RiLocation must not be null", WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        if (!string.startsWith("/")) {
            throw new WvcmException("RiLocation must start with /", WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        if (string.endsWith("/")) {
            throw new WvcmException("RiLocation must not end with / unless it is specifying just the root", WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        this._string = string;
    }

    public String string() {
        return this._string;
    }

    public Location parent() {
        String[] segments = this._string.split("/");
        if (segments.length < 5) {
            return null;
        }
        String parentString = this._string.substring(0, this._string.lastIndexOf("/"));
        return new RiLocation(parentString, null);
    }

    public Location child(String bindingName) throws WvcmException {
        if (bindingName.length() == 0) {
            throw new WvcmException("binding name must not be empty", WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        if (bindingName.indexOf(47) != -1) {
            throw new WvcmException("Child cannot contain / as part of its name: " + bindingName, WvcmException.ReasonCode.ILLEGAL_LOCATION_SYNTAX);
        }
        return new RiLocation(String.valueOf(this._string) + "/" + bindingName);
    }

    public String lastSegment() {
        if (this.parent() == null) {
            return null;
        }
        return this._string.substring(this._string.lastIndexOf("/") + 1);
    }
}

