/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.impl;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.ResponseIteratorImpl;
import com.ibm.rational.wvcm.ri.impl.WvcmServiceConverter;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Provider;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImpl
implements Resource {
    public Location location;
    public WorkspaceProvider provider;
    private HashMap<PropertyNameList.PropertyName<?>, PropValue> propMap = new HashMap();

    public ResourceImpl(Location location, Provider provider) {
        this.location = location;
        this.provider = (SrvcProvider)provider;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceImpl)) {
            return false;
        }
        ResourceImpl r = (ResourceImpl)o;
        PropValue thisPV = this.propMap.get(RESOURCE_IDENTIFIER);
        String thisId = thisPV == null ? this.location.string() : (String)thisPV.get_value();
        PropValue otherPV = r.propMap.get(RESOURCE_IDENTIFIER);
        String otherId = otherPV == null ? r.location.string() : (String)otherPV.get_value();
        return thisId.equals(otherId);
    }

    public int hashCode() {
        PropValue pv = this.propMap.get(Resource.RESOURCE_IDENTIFIER);
        String string = pv == null ? this.location.string() : (String)pv.get_value();
        return string.hashCode();
    }

    public Location location() {
        return this.location;
    }

    public void modifyLocation(Location newLocation) {
        this.location = newLocation;
    }

    public Provider provider() {
        return this.provider;
    }

    public PropertyNameList doGetPropertyNameList(Feedback feedback) throws WvcmException {
        return this.doGetPropertyNameList(null, feedback);
    }

    public PropertyNameList doGetPropertyNameList(String namespace, Feedback feedback) throws WvcmException {
        return WvcmServiceConverter.doGetPropertyNameList(this, namespace, feedback);
    }

    public Resource doReadProperties(Feedback propertyRequest) throws WvcmException {
        return WvcmServiceConverter.doReadProperties(this, propertyRequest);
    }

    public static PropertyNameList convertList2PropertyNameList(List<PropertyNameList.PropertyName<?>> propNames) {
        PropertyNameList.PropertyName[] propNameArray = new PropertyNameList.PropertyName[propNames.size()];
        int i = 0;
        while (i < propNames.size()) {
            propNameArray[i] = propNames.get(i);
            ++i;
        }
        return new PropertyNameList(propNameArray);
    }

    public PropertyNameList propertyNameList() {
        ArrayList propNames = new ArrayList();
        for (PropValue propValue : this.propMap.values()) {
            PropertyNameList.PropertyName<?> propName = propValue.get_propertyName();
            if (!propValue.isOK() || propValue.is_removed()) continue;
            propNames.add(propName);
        }
        return ResourceImpl.convertList2PropertyNameList(propNames);
    }

    public PropertyNameList updatedPropertyNameList() {
        ArrayList propNames = new ArrayList();
        for (PropValue propValue : this.propMap.values()) {
            if (!propValue.is_updated()) continue;
            propNames.add(propValue.get_propertyName());
        }
        return ResourceImpl.convertList2PropertyNameList(propNames);
    }

    public Resource doWriteProperties(Feedback feedback) throws WvcmException {
        return WvcmServiceConverter.doWriteProperties(this, feedback);
    }

    public Resource doReadContent(OutputStream content, Feedback feedback) throws WvcmException {
        return WvcmServiceConverter.doReadContent(this, content, feedback);
    }

    public Resource doWriteContent(InputStream content, String contentIdentifier, Feedback feedback) throws WvcmException {
        return WvcmServiceConverter.doWriteContent(this, content, contentIdentifier, feedback);
    }

    public Resource doCopy(Location destination, Resource.CopyFlag[] flags, Feedback feedback) throws WvcmException {
        return WvcmServiceConverter.doCopy(this, destination, flags, feedback);
    }

    public String getComment() throws WvcmException {
        return (String)this.getProperty(COMMENT);
    }

    public void setComment(String comment) {
        this.setProperty(COMMENT, comment);
    }

    public String getContentCharacterSet() throws WvcmException {
        return (String)this.getProperty(CONTENT_CHARACTER_SET);
    }

    public void setContentCharacterSet(String contentCharacterSet) {
        this.setProperty(CONTENT_CHARACTER_SET, contentCharacterSet);
    }

    public String getContentIdentifier() throws WvcmException {
        return (String)this.getProperty(CONTENT_IDENTIFIER);
    }

    public Locale getContentLanguage() throws WvcmException {
        return (Locale)this.getProperty(CONTENT_LANGUAGE);
    }

    public void setContentLanguage(Locale contentLanguage) {
        this.setProperty(CONTENT_LANGUAGE, contentLanguage);
    }

    public long getContentLength() throws WvcmException {
        return (Long)this.getProperty(CONTENT_LENGTH);
    }

    public String getContentType() throws WvcmException {
        return (String)this.getProperty(CONTENT_TYPE);
    }

    public void setContentType(String contentType) {
        this.setProperty(CONTENT_TYPE, contentType);
    }

    public Boolean getIsExecutable() throws WvcmException {
        return (Boolean)this.getProperty(IS_EXECUTABLE);
    }

    public void setIsExecutable(Boolean isExecutable) {
        this.setProperty(IS_EXECUTABLE, isExecutable);
    }

    public Date getCreationDate() throws WvcmException {
        return (Date)this.getProperty(CREATION_DATE);
    }

    public String getCreatorDisplayName() throws WvcmException {
        return (String)this.getProperty(CREATOR_DISPLAY_NAME);
    }

    public void setCreatorDisplayName(String val) {
        this.setProperty(CREATOR_DISPLAY_NAME, val);
    }

    public String getDisplayName() throws WvcmException {
        return (String)this.getProperty(DISPLAY_NAME);
    }

    public void setDisplayName(String val) {
        this.setProperty(DISPLAY_NAME, val);
    }

    public Date getLastModified() throws WvcmException {
        return (Date)this.getProperty(LAST_MODIFIED);
    }

    public ResourceList<Folder> getWorkspaceFolderList() throws WvcmException {
        return (ResourceList)this.getProperty(WORKSPACE_FOLDER_LIST);
    }

    public List<String> getProviderList() throws WvcmException {
        return (List)this.getProperty(PROVIDER_LIST);
    }

    public String getResourceIdentifier() throws WvcmException {
        return (String)this.getProperty(RESOURCE_IDENTIFIER);
    }

    public Location getPathnameLocation() throws WvcmException {
        return (Location)this.getProperty(PATHNAME_LOCATION);
    }

    public ResourceList<Folder> getParentList() throws WvcmException {
        return (ResourceList)this.getProperty(PARENT_LIST);
    }

    public <T> T getProperty(PropertyNameList.PropertyName<T> name) throws WvcmException {
        if (!this.propMap.containsKey(name)) {
            throw new WvcmException("Property not requested when proxy created: " + name, (Resource)this, WvcmException.ReasonCode.PROPERTY_NOT_REQUESTED);
        }
        PropValue propValue = this.propMap.get(name);
        if (!propValue.isOK()) {
            WvcmException e = propValue.get_exception();
            throw new WvcmException(e.getMessage(), (Resource)this, e.getReasonCode(), (Throwable)e);
        }
        if (propValue.is_removed()) {
            throw new WvcmException("property was removed", (Resource)this, WvcmException.ReasonCode.PROPERTY_NOT_CURRENTLY_AVAILABLE);
        }
        Object result = propValue.get_value();
        return (T)result;
    }

    public Object lookupProperty(PropertyNameList.PropertyName<?> name) {
        if (!this.propMap.containsKey(name)) {
            return new WvcmException("Property not requested when proxy created: " + name, (Resource)this, WvcmException.ReasonCode.PROPERTY_NOT_REQUESTED);
        }
        PropValue propValue = this.propMap.get(name);
        if (!propValue.isOK()) {
            WvcmException e = propValue.get_exception();
            return new WvcmException(e.getMessage(), (Resource)this, e.getReasonCode(), (Throwable)e);
        }
        if (propValue.is_removed()) {
            return new WvcmException("property was removed", (Resource)this, WvcmException.ReasonCode.PROPERTY_NOT_CURRENTLY_AVAILABLE);
        }
        return propValue.get_value();
    }

    private PropValue getPropValue(PropertyNameList.PropertyName<?> name) {
        PropValue propValue = this.propMap.get(name);
        if (propValue == null) {
            propValue = new PropValue(name, null);
            this.propMap.put(name, propValue);
        }
        return propValue;
    }

    public <T> void setProperty(PropertyNameList.PropertyName<T> name, T value) {
        PropValue propValue = new PropValue(name, value);
        propValue.set_updated(true);
        this.propMap.put(name, propValue);
    }

    public <T> void initProperty(PropertyNameList.PropertyName<T> name, T value) {
        PropValue propValue = new PropValue(name, value);
        propValue.set_initialized(true);
        this.propMap.put(name, propValue);
    }

    public void forgetProperty(PropertyNameList.PropertyName<?> name) {
        this.propMap.remove(name);
    }

    public void removeProperty(PropertyNameList.PropertyName<?> name) {
        this.getPropValue(name).set_removed(true);
    }

    public <V, U extends Collection<V>> void setProperty(PropertyNameList.PropertyName<U> name, U additions, U removals) {
        this.getPropValue(name).set_valueUpdates(additions, removals);
    }

    public Resource doFind(Feedback feedback) throws WvcmException {
        return WvcmServiceConverter.doFind(this, this, feedback);
    }

    public ResourceList.ResponseIterator<Resource> doFindAll(Feedback feedback) throws WvcmException {
        return new ResponseIteratorImpl<Resource>(WvcmServiceConverter.doFindAll(this, this, feedback));
    }

    public HashMap<PropertyNameList.PropertyName<?>, PropValue> getPropMap() {
        return this.propMap;
    }

    public void setPropMap(HashMap<PropertyNameList.PropertyName<?>, PropValue> propMap) {
        this.propMap = propMap;
    }

    public void setPropMapProperty(PropertyNameList.PropertyName<?> name, Object value) {
        PropValue propValue = new PropValue(name, value);
        this.propMap.put(name, propValue);
    }

    protected void wrapEx(WvcmException ex) throws WvcmException {
        ResourceImpl res = (ResourceImpl)ex.getResource();
        if (res != null) {
            throw ex;
        }
        WvcmException newEx = new WvcmException(ex.getMessage(), (Resource)this, ex.getReasonCode(), ex.getCause(), ex.getNestedExceptions());
        newEx.setStackTrace(ex.getStackTrace());
        throw newEx;
    }

    public void doUnbindAll(Feedback feedback) throws WvcmException {
        WvcmServiceConverter.doUnbindAll(this, feedback);
    }
}

