/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.LockManager;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class ThreadJob
extends Job {
    static final Object notifier = new Object();
    private final JobManager manager;
    protected boolean acquireRule = false;
    boolean isBlocked = false;
    protected boolean isRunning = false;
    private RuntimeException lastPush = null;
    protected Job realJob;
    private ISchedulingRule[] ruleStack;
    private int top;

    ThreadJob(JobManager jobManager, ISchedulingRule iSchedulingRule) {
        super("Implicit Job");
        this.manager = jobManager;
        this.setSystem(true);
        this.setPriority(10);
        this.ruleStack = new ISchedulingRule[2];
        this.top = -1;
        this.setRule(iSchedulingRule);
    }

    private void illegalPop(ISchedulingRule iSchedulingRule) {
        StringBuffer stringBuffer = new StringBuffer("Attempted to endRule: ");
        stringBuffer.append(iSchedulingRule);
        if (this.top >= 0 && this.top < this.ruleStack.length) {
            stringBuffer.append(", does not match most recent begin: ");
            stringBuffer.append(this.ruleStack[this.top]);
        } else if (this.top < 0) {
            stringBuffer.append(", but there was no matching beginRule");
        } else {
            stringBuffer.append(", but the rule stack was out of bounds: " + this.top);
        }
        stringBuffer.append(".  See log for trace information if rule tracing is enabled.");
        String string = stringBuffer.toString();
        if (JobManager.DEBUG || JobManager.DEBUG_BEGIN_END) {
            System.out.println(string);
            RuntimeException runtimeException = this.lastPush == null ? new IllegalArgumentException() : this.lastPush;
            Status status = new Status(4, "org.eclipse.core.jobs", 1, string, (Throwable)runtimeException);
            RuntimeLog.log((IStatus)((IStatus)status));
        }
        Assert.isLegal((boolean)false, (String)string);
    }

    private void illegalPush(ISchedulingRule iSchedulingRule, ISchedulingRule iSchedulingRule2) {
        StringBuffer stringBuffer = new StringBuffer("Attempted to beginRule: ");
        stringBuffer.append(iSchedulingRule);
        stringBuffer.append(", does not match outer scope rule: ");
        stringBuffer.append(iSchedulingRule2);
        String string = stringBuffer.toString();
        if (JobManager.DEBUG) {
            System.out.println(string);
            Status status = new Status(4, "org.eclipse.core.jobs", 1, string, (Throwable)new IllegalArgumentException());
            RuntimeLog.log((IStatus)((IStatus)status));
        }
        Assert.isLegal((boolean)false, (String)string);
    }

    private boolean isCanceled(IProgressMonitor iProgressMonitor) {
        try {
            return iProgressMonitor.isCanceled();
        }
        catch (RuntimeException runtimeException) {
            Status status = new Status(4, "org.eclipse.core.jobs", 2, "ThreadJob.isCanceled", (Throwable)runtimeException);
            RuntimeLog.log((IStatus)((IStatus)status));
            return false;
        }
    }

    synchronized boolean isRunning() {
        return this.isRunning;
    }

    /*
     * Exception decompiling
     */
    ThreadJob joinRun(IProgressMonitor var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 21[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    boolean pop(ISchedulingRule iSchedulingRule) {
        if (this.top < 0 || this.ruleStack[this.top] != iSchedulingRule) {
            this.illegalPop(iSchedulingRule);
        }
        this.ruleStack[this.top--] = null;
        return this.top < 0;
    }

    void push(ISchedulingRule iSchedulingRule) {
        ISchedulingRule iSchedulingRule2 = this.getRule();
        if (++this.top >= this.ruleStack.length) {
            ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[this.ruleStack.length * 2];
            System.arraycopy(this.ruleStack, 0, iSchedulingRuleArray, 0, this.ruleStack.length);
            this.ruleStack = iSchedulingRuleArray;
        }
        this.ruleStack[this.top] = iSchedulingRule;
        if (JobManager.DEBUG_BEGIN_END) {
            this.lastPush = (RuntimeException)((Throwable)new RuntimeException()).fillInStackTrace();
        }
        if (iSchedulingRule2 != null && iSchedulingRule != null && !iSchedulingRule2.contains(iSchedulingRule)) {
            this.illegalPush(iSchedulingRule, iSchedulingRule2);
        }
    }

    boolean recycle() {
        if (this.getState() != 0) {
            return false;
        }
        this.isBlocked = false;
        this.isRunning = false;
        this.acquireRule = false;
        this.realJob = null;
        this.setRule(null);
        this.setThread(null);
        if (this.ruleStack.length != 2) {
            this.ruleStack = new ISchedulingRule[2];
        } else {
            this.ruleStack[1] = null;
            this.ruleStack[0] = null;
        }
        this.top = -1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor iProgressMonitor) {
        ThreadJob threadJob = this;
        synchronized (threadJob) {
            this.isRunning = true;
        }
        return Job.ASYNC_FINISH;
    }

    void setRealJob(Job job) {
        this.realJob = job;
    }

    boolean shouldInterrupt() {
        return this.realJob == null ? true : !this.realJob.isSystem();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ThreadJob");
        stringBuffer.append('(').append(this.realJob).append(',').append('[');
        int n = 0;
        while (n <= this.top && n < this.ruleStack.length) {
            stringBuffer.append(this.ruleStack[n]).append(',');
            ++n;
        }
        stringBuffer.append(']').append(')');
        return stringBuffer.toString();
    }

    private void waitEnd(IProgressMonitor iProgressMonitor) {
        LockManager lockManager = this.manager.getLockManager();
        Thread thread = Thread.currentThread();
        if (this.isRunning()) {
            lockManager.addLockThread(thread, this.getRule());
            lockManager.resumeSuspendedLocks(thread);
        } else {
            lockManager.removeLockWaitThread(thread, this.getRule());
        }
    }

    private void waitStart(IProgressMonitor iProgressMonitor, InternalJob internalJob) {
        this.manager.getLockManager().addLockWaitThread(Thread.currentThread(), this.getRule());
        this.isBlocked = true;
        this.manager.reportBlocked(iProgressMonitor, internalJob);
    }
}

