/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.ide.ui.internal;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.fulltext.ide.ui.internal.ResultItem;
import com.ibm.team.fulltext.ide.ui.internal.ScoredResultAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ResultModel {
    private ResultItem[] fRootElements = new ResultItem[0];
    private Map<URIReference, ResultItem> fAllItems = new HashMap<URIReference, ResultItem>();

    public ResultModel(IScoredResult[] results) {
        this.createModel(results);
    }

    public Object[] getRootElements() {
        return this.fRootElements;
    }

    private void createModel(IScoredResult[] results) {
        IScoredResult[] iScoredResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            IScoredResult result = iScoredResultArray[n2];
            URIReference[] containers = result.getContainers() != null ? result.getContainers() : new URIReference[]{};
            ResultItem resultItem = this.fAllItems.get(result.getResult());
            if (resultItem == null) {
                resultItem = new ResultItem(result);
                this.fAllItems.put(result.getResult(), resultItem);
            }
            URIReference[] uRIReferenceArray = containers;
            int n3 = containers.length;
            int n4 = 0;
            while (n4 < n3) {
                URIReference containerRef = uRIReferenceArray[n4];
                ResultItem containerItem = this.fAllItems.get(containerRef);
                if (containerItem == null || containerItem.getResult().getScore() < result.getScore()) {
                    Collection<ResultItem> takeOverChilds = containerItem != null ? containerItem.getChildren() : null;
                    containerItem = new ResultItem(new ScoredResultAdapter(containerRef, result.getScore()));
                    if (takeOverChilds != null) {
                        containerItem.addChilds(takeOverChilds);
                    }
                    this.fAllItems.put(containerRef, containerItem);
                }
                containerItem.addChild(resultItem);
                resultItem.setHasParent(true);
                ++n4;
            }
            ++n2;
        }
        Collection<ResultItem> allItems = this.fAllItems.values();
        ArrayList<ResultItem> rootElements = new ArrayList<ResultItem>();
        for (ResultItem item : allItems) {
            if (item.hasParent()) continue;
            rootElements.add(item);
        }
        this.fRootElements = rootElements.toArray(new ResultItem[rootElements.size()]);
    }
}

