/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public abstract class ConvertingSelectionProvider
implements ISelectionProvider {
    private final ISelectionProvider fProvider;
    private SelectionChangedListener fListener;

    public ConvertingSelectionProvider(ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fProvider = provider;
    }

    protected abstract ISelection convertFrom(ISelection var1);

    public ISelection convertTo(ISelection selection) {
        return selection;
    }

    public final ISelection getSelection() {
        return this.convertFrom(this.fProvider.getSelection());
    }

    public final void setSelection(ISelection selection) {
        this.fProvider.setSelection(this.convertTo(selection));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fListener == null) {
            this.fListener = new SelectionChangedListener();
            this.fProvider.addSelectionChangedListener((ISelectionChangedListener)this.fListener);
        }
        this.fListener.addListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fListener == null) {
            return;
        }
        this.fListener.removeListener(listener);
        if (this.fListener.isEmpty()) {
            this.fProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fListener);
            this.fListener = null;
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        ListenerList fListeners = new ListenerList();

        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = ConvertingSelectionProvider.this.convertFrom(event.getSelection());
            SelectionChangedEvent newEvent = new SelectionChangedEvent((ISelectionProvider)ConvertingSelectionProvider.this, selection);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ISelectionChangedListener)listeners[i]).selectionChanged(newEvent);
                ++i;
            }
        }

        public void addListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public void removeListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public boolean isEmpty() {
            return this.fListeners.isEmpty();
        }
    }
}

