/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.timeline;

import com.ibm.icu.util.Calendar;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.timeline.ITimelineContentProvider;
import com.ibm.team.jface.timeline.Messages;
import com.ibm.team.jface.timeline.Range;
import com.ibm.team.jface.timeline.TimelineViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TimelineUtils {
    private static Calendar fCal = Calendar.getInstance();

    public static long trimToHour(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static long trimToDay(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(11, 0);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static long trimToWeek(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(7, fCal.getFirstDayOfWeek());
        fCal.set(11, 0);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static long trimToMonth(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(5, 1);
        fCal.set(11, 0);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static long trimToYear(long date) {
        fCal.setTimeInMillis(date);
        fCal.set(2, 0);
        fCal.set(6, 1);
        fCal.set(11, 0);
        fCal.set(12, 0);
        fCal.set(13, 0);
        fCal.set(14, 0);
        return fCal.getTimeInMillis();
    }

    public static IAction createZoomInAction(final TimelineViewer viewer) {
        Action action = new Action(Messages.TimelineUtils_ZOOM_IN){

            public void run() {
                viewer.zoomIn();
            }
        };
        action.setImageDescriptor(ImagePool.ZOOM_IN);
        action.setId("com.ibm.team.jface.timeline.ZoomInAction");
        action.setToolTipText(Messages.TimelineUtils_ZOOM_IN);
        return action;
    }

    public static IAction createZoomOutAction(final TimelineViewer viewer) {
        Action action = new Action(Messages.TimelineUtils_ZOOM_OUT){

            public void run() {
                viewer.zoomOut();
            }
        };
        action.setImageDescriptor(ImagePool.ZOOM_OUT);
        action.setId("com.ibm.team.jface.timeline.ZoomOutAction");
        action.setToolTipText(Messages.TimelineUtils_ZOOM_OUT);
        return action;
    }

    public static IAction createZoomToSelectionAction(final TimelineViewer viewer) {
        Action action = new Action(Messages.TimelineUtils_ZOOM_CURRENT_SELECTION){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Range range = (Range)selection.getFirstElement();
                    viewer.setVisibleRange(range);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)range));
                }
            }
        };
        action.setImageDescriptor(ImagePool.ZOOM_TO_SEL);
        action.setId("com.ibm.team.jface.timeline.ZoomToSelectionAction");
        action.setToolTipText(Messages.TimelineUtils_ZOOM_CURRENT_SELECTION);
        return action;
    }

    public static IAction createResetViewAction(final TimelineViewer viewer) {
        Action action = new Action(Messages.TimelineUtils_RESET_VIEW_DEFAULT){

            public void run() {
                ITimelineContentProvider cP = (ITimelineContentProvider)viewer.getContentProvider();
                if (cP != null) {
                    Range defaultRange = cP.getDefaultRange();
                    viewer.setVisibleRange(defaultRange);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)defaultRange));
                }
            }
        };
        action.setImageDescriptor(ImagePool.RESET_TIMELINE);
        action.setId("com.ibm.team.jface.timeline.ResetViewAction");
        action.setToolTipText(Messages.TimelineUtils_RESET_VIEW_DEFAULT);
        return action;
    }

    public static IAction createShowTodayAction(final TimelineViewer viewer) {
        Action action = new Action(Messages.TimelineUtils_SHOW_TODAY){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Range range = (Range)selection.getFirstElement();
                    if (range.contains(System.currentTimeMillis())) {
                        return;
                    }
                    range.setCenter(System.currentTimeMillis());
                    viewer.setVisibleRange(range);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)range));
                }
            }
        };
        action.setImageDescriptor(ImagePool.SHOW_TODAY);
        action.setId("com.ibm.team.jface.timeline.ShowTodayAction");
        action.setToolTipText(Messages.TimelineUtils_SHOW_TODAY);
        return action;
    }
}

