/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.timeline;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.jface.timeline.Messages;
import java.util.Date;
import org.eclipse.osgi.util.NLS;

public class Range {
    private long fStart;
    private long fEnd;

    public Range(Range other) {
        this.fStart = other.getStart();
        this.fEnd = other.getEnd();
    }

    public Range(long start, long end) {
        this.fStart = start;
        this.fEnd = end;
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    public void setEnd(long end) {
        this.fEnd = end;
    }

    public void setStart(long start) {
        this.fStart = start;
    }

    public boolean contains(long value) {
        if (value > this.fStart && value < this.fEnd) {
            return true;
        }
        return value == this.fStart || value == this.fEnd;
    }

    public boolean contains(Range range) {
        return this.contains(range.getStart()) && this.contains(range.getEnd());
    }

    public boolean overlaps(Range range) {
        return range.fStart < this.fEnd && range.fEnd > this.fStart;
    }

    public long getDif() {
        return this.fEnd - this.fStart;
    }

    public long getCenter() {
        return this.fStart + this.getDif() / 2L;
    }

    public void setCenter(long center) {
        long dif = this.getDif();
        this.fStart = center - dif / 2L;
        this.fEnd = center + dif / 2L;
    }

    public void multiply(long center, float factor) {
        float range = this.getDif();
        this.fStart = center - (long)(range /= factor) / 2L;
        this.fEnd = center + (long)range / 2L;
    }

    public void shift(long value) {
        this.fStart += value;
        this.fEnd += value;
    }

    public boolean exceeds(long value) {
        long range = this.getDif();
        return range > value;
    }

    public String toString() {
        DateFormat dF = DateFormat.getDateTimeInstance((int)0, (int)0);
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(NLS.bind((String)Messages.Range_FROM_TO, (Object)dF.format(new Date(this.fStart)), (Object)dF.format(new Date(this.fEnd))));
        return strBuf.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.fStart ^ this.fStart >>> 32);
        result = 31 * result + (int)(this.fEnd ^ this.fEnd >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.fStart != other.fStart) {
            return false;
        }
        return this.fEnd == other.fEnd;
    }
}

