/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.itemview;

import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.jface.timeline.Range;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TimelineFilter
extends ViewerFilter {
    private static final boolean STRICT = true;
    private Range fSelectedRange;

    public TimelineFilter(Range selectedRange) {
        this.fSelectedRange = selectedRange;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Date date = this.getDate(element);
        return date != null && this.fSelectedRange.contains(date.getTime());
    }

    public Range getSelectedRange() {
        return this.fSelectedRange;
    }

    public void setSelectedRange(Range selectedRange) {
        this.fSelectedRange = selectedRange;
    }

    private Date getDate(Object element) {
        IDateProvider dateProvider = MarkupItemView.getDateProvider(element);
        if (dateProvider != null) {
            return dateProvider.getDate();
        }
        if (element instanceof Date) {
            return (Date)element;
        }
        return null;
    }
}

