/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.tooltip;

import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.jface.BrowserLocationListener;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.internal.tooltip.Messages;
import com.ibm.team.jface.internal.tooltip.Tooltip;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.tooltip.SlideoutSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;

public class Slideout
extends Tooltip {
    public static final String SLIDEOUT_CONTROL_MARKER = "com.ibm.team.jface.internal.tooltip.Slideout#Marker";
    private static final int MIN_WIDTH = 160;
    private static final int MIN_HEIGHT = 60;
    private Browser fBrowser;
    private String fNumbers;
    private ResourceManager fResources;
    private Composite fHeadContainer;
    private ToolBar fLeftBar;
    private ToolItem fNavLeft;
    private Label fHeadLabel;
    private ToolBar fRightBar;
    private ToolItem fNavRight;
    private KeyListener fKeyListener;
    private Composite fNavContainer;
    private Composite fBrowserComp;
    private boolean fIsLeftEnabled;
    private boolean fIsRightEnabled;
    private boolean fIsOpenable;
    private ToolItem fCloseButton;
    private Listener fListener = new Listener(){
        private static final int N = 0;
        private static final int E = 1;
        private static final int S = 2;
        private static final int W = 3;
        private static final int NE = 4;
        private static final int NW = 5;
        private static final int SE = 6;
        private static final int SW = 7;

        public void handleEvent(Event event) {
            switch (event.type) {
                case 5: 
                case 6: {
                    Rectangle bounds = Slideout.this.getShell().getBounds();
                    int orientation = this.getOrientation(event, bounds);
                    Slideout.this.getShell().setCursor(event.display.getSystemCursor(this.getCursor(orientation)));
                    break;
                }
                case 3: {
                    int orientation = this.getOrientation(event, Slideout.this.getShell().getBounds());
                    if (orientation <= -1) break;
                    Tracker tracker = new Tracker(event.display, this.getTrackerStyle(orientation));
                    tracker.setRectangles(new Rectangle[]{Slideout.this.getShell().getBounds()});
                    tracker.open();
                    Rectangle rectangle = tracker.getRectangles()[0];
                    tracker.dispose();
                    this.updateSize(new Point(rectangle.width, rectangle.height));
                    Slideout.this.pack();
                    break;
                }
                case 7: {
                    Slideout.this.getShell().setCursor(event.display.getSystemCursor(0));
                    break;
                }
                case 11: {
                    Point size = Slideout.this.getShell().getSize();
                    if (size.x < 160 || size.y < 60) {
                        event.doit = false;
                    }
                    this.updateSize(size);
                }
            }
        }

        private void updateSize(Point size) {
            int width = size.x;
            int height = size.y;
            if (width < 160) {
                width = 160;
            }
            if (height < 60) {
                height = 60;
            }
            Slideout.this.setPreferredSizeInPixels(new Point(width, height));
            ((SlideoutSupport.ISlideoutHoverSite)Slideout.this.getHoverSite()).slideoutResized();
        }

        private int getOrientation(Event event, Rectangle bounds) {
            int orientation = -1;
            if (event.x < Slideout.this.fMargin) {
                orientation = event.y < Slideout.this.fMargin ? 5 : (event.y > bounds.height - Slideout.this.fMargin - 1 ? 7 : 3);
            } else if (event.x > bounds.width - Slideout.this.fMargin - 1) {
                orientation = event.y < Slideout.this.fMargin ? 4 : (event.y > bounds.height - Slideout.this.fMargin - 1 ? 6 : 1);
            } else if (event.y < Slideout.this.fMargin) {
                orientation = 0;
            } else if (event.y > bounds.height - Slideout.this.fMargin - 1) {
                orientation = 2;
            }
            return orientation;
        }

        private int getTrackerStyle(int orientation) {
            switch (orientation) {
                case 0: {
                    return 144;
                }
                case 1: {
                    return 131088;
                }
                case 2: {
                    return 1040;
                }
                case 3: {
                    return 16400;
                }
                case 5: {
                    return 16528;
                }
                case 4: {
                    return 131216;
                }
                case 6: {
                    return 132112;
                }
                case 7: {
                    return 17424;
                }
            }
            return 16;
        }

        private int getCursor(int orientation) {
            switch (orientation) {
                case 0: {
                    return 10;
                }
                case 1: {
                    return 12;
                }
                case 2: {
                    return 11;
                }
                case 3: {
                    return 13;
                }
                case 5: {
                    return 17;
                }
                case 4: {
                    return 14;
                }
                case 6: {
                    return 15;
                }
                case 7: {
                    return 16;
                }
            }
            return 0;
        }
    };
    private int fMargin;
    private int fUnreadCount;
    private static final boolean IS_LINUX = "gtk".equals(SWT.getPlatform());
    private static final boolean IS_WIN = SWT.getPlatform().startsWith("win");
    private Label fUnreadLabel;
    private final Control fParent;
    private Listener fGlobalMouseListener;

    private Slideout(Control parent, SlideoutSupport.ISlideoutHoverSite hoverSite, boolean isOpenable, Point preferredSize, KeyListener keyListener) {
        super(parent.getShell(), hoverSite, preferredSize, false);
        this.fParent = parent;
        this.fKeyListener = keyListener;
        this.fIsOpenable = isOpenable;
    }

    public static Slideout createSlideoutTooltip(Control parent, SlideoutSupport.ISlideoutHoverSite hoverSite, boolean isOpenable, Point preferredSize, KeyListener keyListener) {
        Slideout cachedTooltip = (Slideout)Slideout.getCachedTooltip(parent.getShell(), Slideout.class);
        if (cachedTooltip != null && !cachedTooltip.isDisposed()) {
            cachedTooltip.setText("");
            cachedTooltip.setHoverSite(hoverSite);
            cachedTooltip.setPreferredSizeInPixels(preferredSize);
            cachedTooltip.fIsOpenable = isOpenable;
            cachedTooltip.setKeyListener(keyListener);
            cachedTooltip.pack();
            return cachedTooltip;
        }
        return new Slideout(parent, hoverSite, isOpenable, preferredSize, keyListener);
    }

    protected Layout getShellLayout() {
        GridLayout gridLayout = new GridLayout();
        this.fMargin = 1;
        if (IS_LINUX) {
            this.fMargin = 2;
        }
        if (IS_WIN) {
            this.fMargin = 0;
        }
        gridLayout.marginHeight = this.fMargin;
        gridLayout.marginWidth = this.fMargin;
        gridLayout.verticalSpacing = 1;
        return gridLayout;
    }

    public void open(Point itemLocation) {
        super.open(itemLocation, -8);
    }

    protected Shell createShell() {
        final Display display = this.fParent.getDisplay();
        Shell shell = new Shell(this.fParent.getShell(), this.getShellStyle());
        shell.setForeground(this.getForeground());
        shell.setBackground(this.getBackground());
        shell.setLayout(this.getShellLayout());
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                Slideout.this.close();
            }

            public void shellDeactivated(ShellEvent e) {
                if (!Slideout.this.fParent.isDisposed()) {
                    Control cursorControl = Slideout.this.fParent.getDisplay().getCursorControl();
                    if (Slideout.this.fParent.equals(cursorControl)) {
                        return;
                    }
                    Slideout.this.close();
                }
            }
        });
        this.fGlobalMouseListener = new Listener(){

            public void handleEvent(Event event) {
                Control cursorControl;
                if (Slideout.this.isVisible() && (cursorControl = display.getCursorControl()) != null && !cursorControl.isDisposed()) {
                    if (Slideout.this.fParent.equals(cursorControl) || Slideout.this.getShell().equals(cursorControl.getShell()) || cursorControl.getData(Slideout.SLIDEOUT_CONTROL_MARKER) != null) {
                        return;
                    }
                    Slideout.this.close();
                }
            }
        };
        display.addFilter(4, this.fGlobalMouseListener);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                display.removeFilter(4, Slideout.this.fGlobalMouseListener);
            }
        });
        return shell;
    }

    public Control createContents(Composite parent) {
        this.getShell().setBackground(parent.getDisplay().getSystemColor(18));
        this.getShell().addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        ((SlideoutSupport.ISlideoutHoverSite)Slideout.this.getHoverSite()).parentFocusRequested(false);
                        Slideout.this.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (Slideout.this.fBrowser != null) {
                    Slideout.this.fBrowser.setFocus();
                }
                Slideout.this.setBorderColor(true);
            }

            public void shellDeactivated(ShellEvent e) {
            }
        });
        if (IS_LINUX) {
            this.getShell().addListener(6, this.fListener);
            this.getShell().addListener(5, this.fListener);
            this.getShell().addListener(3, this.fListener);
            this.getShell().addListener(7, this.fListener);
        } else {
            this.getShell().addListener(11, this.fListener);
        }
        this.fBrowserComp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fBrowserComp.setLayout((Layout)gridLayout);
        this.fBrowserComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fBrowser = new Browser(this.fBrowserComp, 0);
        GridData data = new GridData(4, 4, true, true);
        this.fBrowser.setLayoutData((Object)data);
        this.fBrowser.addKeyListener(this.fKeyListener);
        this.fBrowser.addLocationListener((LocationListener)new BrowserLocationListener((ContextProvider)new StandardContextProvider(null)){

            public void changing(LocationEvent event) {
                super.changing(event);
                if (!event.doit) {
                    Slideout.this.close();
                }
            }
        });
        this.fBrowser.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8) {
                    ((SlideoutSupport.ISlideoutHoverSite)Slideout.this.getHoverSite()).parentFocusRequested(true);
                    e.doit = false;
                }
            }
        });
        this.setBrowserText(this.getText());
        this.fBrowser.setFocus();
        return this.fBrowser;
    }

    private void setBorderColor(boolean isActive) {
        if (!this.isDisposed()) {
            if (isActive) {
                this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(2));
            } else {
                this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(18));
            }
        }
    }

    protected int getShellStyle() {
        return 542740;
    }

    public Control createFooter(Composite parent) {
        return null;
    }

    public Control createHeader(Composite parent) {
        this.fHeadContainer = new Composite(parent, 0);
        this.fHeadContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout titleBarLayout = new GridLayout(3, false);
        titleBarLayout.marginHeight = 0;
        titleBarLayout.marginWidth = 0;
        titleBarLayout.horizontalSpacing = 0;
        titleBarLayout.verticalSpacing = 0;
        this.fHeadContainer.setLayout((Layout)titleBarLayout);
        Composite navContainer = this.createNavigation(this.fHeadContainer);
        navContainer.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        Composite unreadContainer = new Composite(this.fHeadContainer, 0);
        unreadContainer.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        unreadContainer.setLayout((Layout)new GridLayout());
        ((GridLayout)unreadContainer.getLayout()).marginHeight = 0;
        this.fUnreadLabel = new Label(unreadContainer, 0);
        unreadContainer.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        Composite openCloseContainer = this.createOpenCloseContainer(this.fHeadContainer);
        openCloseContainer.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        return this.fHeadContainer;
    }

    protected void updateSize() {
        if (this.fBrowser == null || this.fBrowser.isDisposed()) {
            return;
        }
    }

    public void pack() {
        this.getShell().setSize(this.getPreferredWidth(), this.getPreferredHeight());
        this.getShell().layout();
    }

    public void setBrowserText(String text) {
        StringBuffer html = new StringBuffer(text);
        RGB bg = this.getBackground().getRGB();
        StringBuffer bgcss = new StringBuffer();
        bgcss.append("body { " + MarkupUtil.getDefaultFont() + " background-color: rgb(").append(bg.red).append(",").append(bg.green).append(",").append(bg.blue).append("); }");
        int idx = html.indexOf("<head>");
        if (idx > 0) {
            html.insert(idx += 6, "<style type=\"text/css\">");
            html.insert(idx += "<style type=\"text/css\">".length(), bgcss);
            html.insert(idx += bgcss.length(), "</style>");
        } else {
            idx = 0;
            html.insert(idx, "<head><style type=\"text/css\">");
            html.insert(idx += "<head><style type=\"text/css\">".length(), bgcss);
            html.insert(idx += bgcss.length(), "</style></head>");
        }
        this.fBrowser.setText(html.toString());
    }

    public void setNumbersText(String text) {
        this.fNumbers = text;
    }

    public void setUnreadCount(int unread) {
        this.fUnreadCount = unread;
    }

    public void update() {
        if (this.fBrowser != null && !this.fBrowser.isDisposed()) {
            this.setBrowserText(this.getText());
        }
        if (this.fHeadLabel != null && !this.fHeadLabel.isDisposed()) {
            this.fHeadLabel.setText(this.fNumbers);
        }
        if (this.fUnreadLabel != null && !this.fUnreadLabel.isDisposed()) {
            if (this.fUnreadCount > 0) {
                this.fUnreadLabel.setText(NLS.bind((String)Messages.Slideout_N_UNREAD, (Object)this.fUnreadCount));
            } else {
                this.fUnreadLabel.setText("");
            }
            this.fHeadContainer.layout(true, true);
        }
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.pack();
            this.setBorderColor(this.getShell().getDisplay().getActiveShell() == this.getShell());
        }
    }

    protected Composite createNavigation(Composite parent) {
        this.fNavContainer = new Composite(parent, 0);
        if (this.fResources == null) {
            this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fNavContainer);
        }
        GridLayout layout = new GridLayout(3, false);
        this.setHeaderLayoutProperties(layout);
        this.fNavContainer.setLayout((Layout)layout);
        this.fLeftBar = new ToolBar(this.fNavContainer, 0x800000);
        this.fNavLeft = new ToolItem(this.fLeftBar, 8);
        this.fNavLeft.setImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.NAV_LEFT));
        this.fNavLeft.setHotImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.NAV_LEFT_HOVER));
        this.fNavLeft.setDisabledImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.NAV_LEFT_DISABLED));
        this.fNavLeft.setEnabled(this.fIsLeftEnabled);
        this.fNavLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Slideout.this.getHoverSite().navigatedToPrevious(Slideout.this);
            }
        });
        this.fHeadLabel = new Label(this.fNavContainer, 0x1000000);
        GC gc = new GC((Drawable)this.fHeadLabel);
        int width = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)7);
        gc.dispose();
        GridData data = new GridData();
        data.widthHint = width;
        this.fHeadLabel.setLayoutData((Object)data);
        if (this.fNumbers != null) {
            this.fHeadLabel.setText(this.fNumbers);
        }
        this.fRightBar = new ToolBar(this.fNavContainer, 0x800000);
        this.fNavRight = new ToolItem(this.fRightBar, 8);
        this.fNavRight.setImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.NAV_RIGHT));
        this.fNavRight.setHotImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.NAV_RIGHT_HOVER));
        this.fNavRight.setDisabledImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.NAV_RIGHT_DISABLED));
        this.fNavRight.setEnabled(this.fIsRightEnabled);
        this.fNavRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Slideout.this.getHoverSite().navigatedToNext(Slideout.this);
            }
        });
        return this.fNavContainer;
    }

    protected Composite createOpenCloseContainer(Composite parent) {
        Composite openCloseComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        this.setHeaderLayoutProperties(layout);
        openCloseComp.setLayout((Layout)layout);
        ToolBar openbar = new ToolBar(openCloseComp, 0x800000);
        ToolItem open = new ToolItem(openbar, 8);
        open.setImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.LNCH_VIEW));
        open.setDisabledImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.LNCH_VIEW_DISABLED));
        open.setEnabled(this.fIsOpenable);
        open.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Slideout.this.getHoverSite().openRequested();
                Slideout.this.close();
            }
        });
        ToolBar closebar = new ToolBar(openCloseComp, 0x800000);
        this.fCloseButton = new ToolItem(closebar, 8);
        this.fCloseButton.setImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.CLOSE));
        this.fCloseButton.setHotImage(JazzResources.getImageWithDefault(this.fResources, ImagePool.CLOSE_ACTIVE));
        this.fCloseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SlideoutSupport.ISlideoutHoverSite)Slideout.this.getHoverSite()).parentFocusRequested(false);
                Slideout.this.close();
            }
        });
        closebar.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    ((SlideoutSupport.ISlideoutHoverSite)Slideout.this.getHoverSite()).parentFocusRequested(true);
                    e.doit = false;
                }
            }
        });
        return openCloseComp;
    }

    private void setHeaderLayoutProperties(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
    }

    public void setLeftNavigationEnabled(boolean isEnabled) {
        this.fIsLeftEnabled = isEnabled;
        if (this.fNavLeft != null && !this.fNavLeft.isDisposed()) {
            this.fNavLeft.setEnabled(isEnabled);
        }
    }

    public void setRightNavigationEnabled(boolean isEnabled) {
        this.fIsRightEnabled = isEnabled;
        if (this.fNavRight != null && !this.fNavRight.isDisposed()) {
            this.fNavRight.setEnabled(isEnabled);
        }
    }

    private void setKeyListener(KeyListener listener) {
        if (this.fBrowser != null && !this.fBrowser.isDisposed()) {
            if (this.fKeyListener != null) {
                this.fBrowser.removeKeyListener(this.fKeyListener);
            }
            this.fBrowser.addKeyListener(listener);
        }
        this.fKeyListener = listener;
    }

    public void removeKeyListener(KeyListener listener) {
        if (this.fKeyListener != null && this.fKeyListener == listener && this.fBrowser != null && !this.fBrowser.isDisposed()) {
            this.fBrowser.removeKeyListener(listener);
            this.fKeyListener = null;
        }
    }
}

