/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.dashboard.views;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class MultiTrackingSelectionProvider
implements ISelectionProvider {
    private ISelectionProvider fActiveSelectionProvider;
    private ListenerList fListeners = new ListenerList();

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public ISelectionProvider getActiveSelectionProvider() {
        return this.fActiveSelectionProvider;
    }

    public void clearActiveSelectionProvider() {
        this.fActiveSelectionProvider = null;
    }

    public ISelection getSelection() {
        if (this.fActiveSelectionProvider != null) {
            return this.fActiveSelectionProvider.getSelection();
        }
        return new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        };
    }

    public void registerControl(final ISelectionProvider controlSelectionProvider) {
        controlSelectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MultiTrackingSelectionProvider.this.fActiveSelectionProvider = controlSelectionProvider;
                MultiTrackingSelectionProvider.this.fireSelectionChanged(event);
            }
        });
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.fActiveSelectionProvider != null) {
            this.fActiveSelectionProvider.setSelection(selection);
        }
    }
}

