/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal.alerts;

import com.ibm.team.foundation.rcp.core.notification.NotificationInfo;
import com.ibm.team.foundation.rcp.core.notification.Notifier;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.internal.alerts.DefaultInfoPopControlCreator;
import com.ibm.team.jface.internal.alerts.InfoPop;
import com.ibm.team.jface.internal.alerts.InfoPopManager;
import com.ibm.team.jface.internal.alerts.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;

public class AlertNotifier
extends Notifier {
    public void notify(String eventCategoryId, String eventTypeId, final String triggerId, final NotificationInfo event) {
        final InfoPopManager popManager = InfoPopManager.getDefault();
        FoundationUIJob uiJob = new FoundationUIJob(Messages.AlertNotifier_SHOW_ALERT){

            public boolean belongsTo(Object family) {
                return InfoPopManager.INFOPOP_JOB_FAMILY.equals(family);
            }

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (popManager.fStopped || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                InfoPop infoPop = AlertNotifier.this.createFrom(event);
                if (infoPop != null) {
                    infoPop.setTriggerId(triggerId);
                    popManager.requestOpen(infoPop);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    private InfoPop createFrom(NotificationInfo event) {
        Shell shell = null;
        if (JFacePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null) {
            shell = JFacePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        DefaultInfoPopControlCreator controlCreator = null;
        if (shell == null) {
            return null;
        }
        if (controlCreator == null) {
            controlCreator = new DefaultInfoPopControlCreator();
        }
        return new InfoPop(shell, event, controlCreator);
    }
}

