/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.jface.internal;

import com.ibm.team.jface.internal.ImagePool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DecorationImageDescriptor
extends CompositeImageDescriptor {
    public static final int CHANGED = 1;
    public static final int ACTIVE = 2;
    private Image fBaseImage;
    private int fFlags;
    private Point fSize;

    public DecorationImageDescriptor(Image baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public int getAdronments() {
        return this.fFlags;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        if (object == null || !DecorationImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        DecorationImageDescriptor other = (DecorationImageDescriptor)((Object)object);
        return this.fBaseImage.equals((Object)other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.getImageData(this.fBaseImage), 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
    }

    private void drawTopRight() {
        int x = this.getSize().x;
        if ((this.fFlags & 1) != 0) {
            ImageData data = this.getImageData(ImagePool.CHANGED_OVRL);
            this.drawImage(data, x -= data.width, 0);
        }
    }

    private void drawBottomRight() {
        Point size = this.getSize();
        int x = size.x;
        int flags = this.fFlags;
        if ((flags & 2) != 0) {
            ImageData data = this.getImageData(ImagePool.ACTIVE_OVRL);
            this.drawImage(data, x -= data.width, size.y - data.height);
        }
    }

    private ImageData getImageData(Image image) {
        ImageData data = image.getImageData();
        return data == null ? DEFAULT_IMAGE_DATA : data;
    }

    private ImageData getImageData(ImageDescriptor imageDescriptor) {
        ImageData data = imageDescriptor.getImageData();
        return data == null ? DEFAULT_IMAGE_DATA : data;
    }
}

