/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;
    private RegistryStrategyOSGI strategy;
    private Object token;

    public EclipseBundleListener(ExtensionRegistry extensionRegistry, Object object, RegistryStrategyOSGI registryStrategyOSGI) {
        this.registry = extensionRegistry;
        this.token = object;
        this.strategy = registryStrategyOSGI;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        switch (bundleEvent.getType()) {
            case 32: {
                this.addBundle(bundle);
                break;
            }
            case 64: {
                this.removeBundle(bundle);
            }
        }
    }

    public void processBundles(Bundle[] bundleArray) {
        int n = 0;
        while (n < bundleArray.length) {
            if (this.isBundleResolved(bundleArray[n])) {
                this.addBundle(bundleArray[n]);
            } else {
                this.removeBundle(bundleArray[n]);
            }
            ++n;
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle) {
        URL uRL;
        long l = 0L;
        if (this.strategy.checkContributionsTimestamp() && (uRL = EclipseBundleListener.getExtensionURL(bundle, false)) != null) {
            l = this.strategy.getExtendedTimestamp(bundle, uRL);
        }
        this.registry.remove(Long.toString(bundle.getBundleId()), l);
    }

    public static URL getExtensionURL(Bundle bundle, boolean bl) {
        if (bundle.getBundleId() == 0L) {
            return null;
        }
        if (bundle.getSymbolicName() == null) {
            return null;
        }
        boolean bl2 = OSGIUtils.getDefault().isFragment(bundle);
        String string = bl2 ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST;
        URL uRL = bundle.getEntry(string);
        if (uRL == null) {
            return null;
        }
        if (!EclipseBundleListener.isSingleton(bundle)) {
            if (bl) {
                String string2 = NLS.bind((String)RegistryMessages.parse_nonSingleton, (Object)bundle.getLocation());
                RuntimeLog.log((IStatus)((IStatus)new Status(1, "org.eclipse.equinox.registry", 0, string2, null)));
            }
            return null;
        }
        if (!bl2) {
            return uRL;
        }
        Bundle[] bundleArray = OSGIUtils.getDefault().getHosts(bundle);
        if (bundleArray == null) {
            return null;
        }
        if (EclipseBundleListener.isSingleton(bundleArray[0])) {
            return uRL;
        }
        if (bl) {
            String string3 = NLS.bind((String)RegistryMessages.parse_nonSingleton, (Object)bundleArray[0].getLocation());
            RuntimeLog.log((IStatus)((IStatus)new Status(1, "org.eclipse.equinox.registry", 0, string3, null)));
        }
        return null;
    }

    private void addBundle(Bundle bundle) {
        BufferedInputStream bufferedInputStream;
        String string = Long.toString(bundle.getBundleId());
        if (this.registry.hasContribution(string)) {
            return;
        }
        URL uRL = EclipseBundleListener.getExtensionURL(bundle, this.registry.debug());
        if (uRL == null) {
            return;
        }
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            bufferedInputStream = null;
        }
        if (bufferedInputStream == null) {
            return;
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceTranslator.getResourceBundle((Bundle)bundle);
        }
        catch (MissingResourceException missingResourceException) {}
        long l = 0L;
        if (this.strategy.checkContributionsTimestamp()) {
            l = this.strategy.getExtendedTimestamp(bundle, uRL);
        }
        IContributor iContributor = ContributorFactoryOSGi.createContributor(bundle);
        this.registry.addContribution(bufferedInputStream, iContributor, true, uRL.getPath(), resourceBundle, this.token, l);
    }

    private static boolean isSingleton(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders("");
        String string = (String)dictionary.get("Bundle-SymbolicName");
        try {
            ManifestElement[] manifestElementArray;
            if (string != null && (manifestElementArray = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)string)).length > 0) {
                String string2 = manifestElementArray[0].getDirective("singleton");
                if (string2 == null) {
                    string2 = manifestElementArray[0].getAttribute("singleton");
                }
                if (!"true".equalsIgnoreCase(string2)) {
                    String string3 = (String)dictionary.get("Bundle-ManifestVersion");
                    return string3 == null && OSGIUtils.getDefault().getBundle(manifestElementArray[0].getValue()) == bundle;
                }
            }
        }
        catch (BundleException bundleException) {}
        return true;
    }
}

