/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.internal.registry.HashtableOfStringAndInt$$Cold;
import org.eclipse.core.internal.registry.RegistryObjectManager;

public final class HashtableOfStringAndInt
implements Cloneable {
    public static final int MISSING_ELEMENT = Integer.MIN_VALUE;
    private String[] keyTable;
    private int[] valueTable;
    private int elementSize = 0;
    private int threshold;
    private static final float GROWTH_FACTOR = 1.33f;
    private static final byte NULL = 0;
    private static final byte OBJECT = 1;

    public HashtableOfStringAndInt() {
        this(13);
    }

    public HashtableOfStringAndInt(int n) {
        this.threshold = n;
        int n2 = (int)((float)n * 1.75f);
        if (this.threshold == n2) {
            ++n2;
        }
        this.keyTable = new String[n2];
        this.valueTable = new int[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        throw (Throwable)new CloneNotSupportedException();
    }

    public int get(String string) {
        String string2;
        int n = (string.hashCode() & Integer.MAX_VALUE) % this.valueTable.length;
        int n2 = string.length();
        while ((string2 = this.keyTable[n]) != null) {
            if (string2.length() == n2 && string2.equals(string)) {
                return this.valueTable[n];
            }
            n = (n + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public int put(String string, int n) {
        String string2;
        int n2 = (string.hashCode() & Integer.MAX_VALUE) % this.valueTable.length;
        int n3 = string.length();
        while ((string2 = this.keyTable[n2]) != null) {
            if (string2.length() == n3 && string2.equals(string)) {
                this.valueTable[n2] = n;
                return this.valueTable[n2];
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        this.keyTable[n2] = string;
        this.valueTable[n2] = n;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return n;
    }

    private void rehash() {
        HashtableOfStringAndInt hashtableOfStringAndInt = new HashtableOfStringAndInt((int)((float)this.elementSize * 1.33f));
        int n = this.keyTable.length;
        while (--n >= 0) {
            String string = this.keyTable[n];
            if (string == null) continue;
            hashtableOfStringAndInt.put(string, this.valueTable[n]);
        }
        this.keyTable = hashtableOfStringAndInt.keyTable;
        this.valueTable = hashtableOfStringAndInt.valueTable;
        this.threshold = hashtableOfStringAndInt.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public int[] getValues() {
        int n = this.keyTable.length;
        int[] nArray = new int[this.size()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.keyTable[n3] != null) {
                nArray[n2++] = this.valueTable[n3];
            }
            ++n3;
        }
        return nArray;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.elementSize);
        int n = this.keyTable.length;
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.threshold);
        int n2 = 0;
        while (n2 < n) {
            this.writeStringOrNull(this.keyTable[n2], dataOutputStream);
            dataOutputStream.writeInt(this.valueTable[n2]);
            ++n2;
        }
    }

    public void save(DataOutputStream dataOutputStream, RegistryObjectManager registryObjectManager) throws IOException {
        HashtableOfStringAndInt hashtableOfStringAndInt = new HashtableOfStringAndInt((int)((float)this.elementSize * 1.33f));
        int n = this.keyTable.length;
        while (--n >= 0) {
            String string = this.keyTable[n];
            if (string == null || !registryObjectManager.shouldPersist(this.valueTable[n])) continue;
            hashtableOfStringAndInt.put(string, this.valueTable[n]);
        }
        hashtableOfStringAndInt.save(dataOutputStream);
    }

    private void writeStringOrNull(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(string);
        }
    }

    public boolean containsKey(String string) {
        String string2;
        int n = (string.hashCode() & Integer.MAX_VALUE) % this.valueTable.length;
        int n2 = string.length();
        while ((string2 = this.keyTable[n]) != null) {
            if (string2.length() == n2 && string2.equals(string)) {
                return true;
            }
            n = (n + 1) % this.keyTable.length;
        }
        return false;
    }

    public int removeKey(String string) {
        String string2;
        int n = (string.hashCode() & Integer.MAX_VALUE) % this.valueTable.length;
        int n2 = string.length();
        while ((string2 = this.keyTable[n]) != null) {
            if (string2.length() == n2 && string2.equals(string)) {
                int n3 = this.valueTable[n];
                --this.elementSize;
                this.keyTable[n] = null;
                this.valueTable[n] = Integer.MIN_VALUE;
                this.rehash();
                return n3;
            }
            n = (n + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public String toString() {
        String string = "";
        int n = 0;
        int n2 = this.valueTable.length;
        while (n < n2) {
            int n3 = this.valueTable[n];
            if (n3 != Integer.MIN_VALUE) {
                string = String.valueOf(string) + new String(this.keyTable[n]) + " -> " + n3 + "\n";
            }
            ++n;
        }
        return string;
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        this.elementSize = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        this.threshold = dataInputStream.readInt();
        boolean bl = true;
        if ((double)n / (double)this.elementSize < (double)1.33f) {
            this.keyTable = new String[(int)((float)this.elementSize * 1.33f)];
            this.valueTable = new int[(int)((float)this.elementSize * 1.33f)];
            this.elementSize = 0;
            bl = false;
        } else {
            this.keyTable = new String[n];
            this.valueTable = new int[n];
        }
        int n2 = 0;
        while (n2 < n) {
            String string = this.readStringOrNull(dataInputStream);
            int n3 = dataInputStream.readInt();
            if (bl) {
                this.keyTable[n2] = string;
                this.valueTable[n2] = n3;
            } else if (string != null) {
                this.put(string, n3);
            }
            ++n2;
        }
    }

    private String readStringOrNull(DataInputStream dataInputStream) throws IOException {
        return HashtableOfStringAndInt$$Cold.readStringOrNull(this, dataInputStream);
    }
}

