/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.util.Hashtable;
import org.eclipse.core.internal.registry.ConfigurationElement$$Cold;
import org.eclipse.core.internal.registry.ConfigurationElementHandle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.osgi.util.NLS;

public class ConfigurationElement
extends RegistryObject {
    static final ConfigurationElement[] EMPTY_ARRAY = new ConfigurationElement[0];
    int parentId;
    byte parentType;
    private String[] propertiesAndValue;
    private String name;
    private String contributorId;

    protected ConfigurationElement(ExtensionRegistry extensionRegistry, boolean bl) {
        super(extensionRegistry, bl);
    }

    protected String getValue() {
        return this.getValueAsIs();
    }

    String getValueAsIs() {
        if (this.propertiesAndValue.length != 0 && this.propertiesAndValue.length % 2 == 1) {
            return this.propertiesAndValue[this.propertiesAndValue.length - 1];
        }
        return null;
    }

    public String getAttribute(String string) {
        return this.getAttributeAsIs(string);
    }

    String getAttributeAsIs(String string) {
        if (this.propertiesAndValue.length <= 1) {
            return null;
        }
        int n = this.propertiesAndValue.length - this.propertiesAndValue.length % 2;
        int n2 = 0;
        while (n2 < n) {
            if (this.propertiesAndValue[n2].equals(string)) {
                return this.propertiesAndValue[n2 + 1];
            }
            n2 += 2;
        }
        return null;
    }

    void setProperties(String[] stringArray) {
        this.propertiesAndValue = stringArray;
    }

    protected String[] getPropertiesAndValue() {
        return this.propertiesAndValue;
    }

    void setValue(String string) {
        if (this.propertiesAndValue.length == 0) {
            this.propertiesAndValue = new String[]{string};
            return;
        }
        if (this.propertiesAndValue.length % 2 == 1) {
            this.propertiesAndValue[this.propertiesAndValue.length - 1] = string;
            return;
        }
        String[] stringArray = new String[this.propertiesAndValue.length + 1];
        System.arraycopy(this.propertiesAndValue, 0, stringArray, 0, this.propertiesAndValue.length);
        stringArray[this.propertiesAndValue.length] = string;
        this.propertiesAndValue = stringArray;
    }

    void setContributorId(String string) {
        this.contributorId = string;
    }

    protected String getContributorId() {
        return this.contributorId;
    }

    public ConfigurationElement[] getChildren(String string) {
        if (this.getRawChildren().length == 0) {
            return EMPTY_ARRAY;
        }
        ConfigurationElement[] configurationElementArray = new ConfigurationElement[1];
        int n = 0;
        RegistryObjectManager registryObjectManager = this.registry.getObjectManager();
        int n2 = 0;
        while (n2 < this.children.length) {
            ConfigurationElement configurationElement = (ConfigurationElement)registryObjectManager.getObject(this.children[n2], this.noExtraData() ? (byte)1 : 4);
            if (configurationElement.name.equals(string)) {
                if (n != 0) {
                    ConfigurationElement[] configurationElementArray2 = new ConfigurationElement[configurationElementArray.length + 1];
                    System.arraycopy(configurationElementArray, 0, configurationElementArray2, 0, configurationElementArray.length);
                    configurationElementArray = configurationElementArray2;
                }
                configurationElementArray[n++] = configurationElement;
            }
            ++n2;
        }
        if (n == 0) {
            configurationElementArray = EMPTY_ARRAY;
        }
        return configurationElementArray;
    }

    void setParentId(int n) {
        this.parentId = n;
    }

    protected String getName() {
        return this.name;
    }

    void setName(String string) {
        this.name = string;
    }

    void setParentType(byte by) {
        this.parentType = by;
    }

    protected Object createExecutableExtension(String string) throws CoreException {
        Object object;
        Object object2;
        Object object3;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object object4 = null;
        if (string != null) {
            string2 = this.getAttribute(string);
        } else {
            string2 = this.getValue();
            if (string2 != null && (string2 = string2.trim()).equals("")) {
                string2 = null;
            }
        }
        if (string2 == null) {
            object3 = this.getChildren(string);
            if (((ConfigurationElement[])object3).length != 0) {
                object2 = object3[0];
                string3 = ((ConfigurationElement)object2).getAttribute("plugin");
                string4 = ((ConfigurationElement)object2).getAttribute("class");
                object = ((ConfigurationElement)object2).getChildren("parameter");
                if (((ConfigurationElement[])object).length != 0) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>(((ConfigurationElement[])object).length + 1);
                    int n = 0;
                    while (n < ((ConfigurationElement[])object).length) {
                        String string5 = object[n].getAttribute("name");
                        if (string5 != null) {
                            hashtable.put(string5, object[n].getAttribute("value"));
                        }
                        ++n;
                    }
                    if (!hashtable.isEmpty()) {
                        object4 = hashtable;
                    }
                }
            } else {
                this.throwException(NLS.bind((String)RegistryMessages.exExt_extDefNotFound, (Object)string), null);
            }
        } else {
            String string6;
            int n = string2.indexOf(58);
            if (n != -1) {
                string6 = string2.substring(0, n).trim();
                object4 = string2.substring(n + 1).trim();
            } else {
                string6 = string2;
            }
            n = string6.indexOf(47);
            if (n != -1) {
                string3 = string6.substring(0, n).trim();
                string4 = string6.substring(n + 1).trim();
            } else {
                string4 = string6;
            }
        }
        object3 = this.registry.getObjectManager().getContributor(this.contributorId);
        object = this.registry.createExecutableExtension((RegistryContributor)object3, string4, string3);
        try {
            object2 = new ConfigurationElementHandle(this.registry.getObjectManager(), this.getObjectId());
            if (object instanceof IExecutableExtension) {
                ((IExecutableExtension)object).setInitializationData((IConfigurationElement)object2, string, object4);
            }
        }
        catch (CoreException coreException) {
            throw (Throwable)coreException;
        }
        catch (Exception exception) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_initObjectError, (Object)this.getContributor().getName(), (Object)string4), exception);
        }
        if (object instanceof IExecutableExtensionFactory) {
            object = ((IExecutableExtensionFactory)object).create();
        }
        return object;
    }

    protected ConfigurationElement(int n, String string, String string2, String[] stringArray, int[] nArray, int n2, int n3, byte by, ExtensionRegistry extensionRegistry, boolean bl) {
        super(extensionRegistry, bl);
        this.setObjectId(n);
        this.contributorId = string;
        this.name = string2;
        this.propertiesAndValue = stringArray;
        this.setRawChildren(nArray);
        this.setExtraDataOffset(n2);
        this.parentId = n3;
        this.parentType = by;
    }

    void throwException(String string, Throwable throwable) throws CoreException {
        ConfigurationElement$$Cold.throwException(this, string, throwable);
    }

    protected String[] getAttributeNames() {
        if (this.propertiesAndValue.length <= 1) {
            return RegistryObjectManager.EMPTY_STRING_ARRAY;
        }
        int n = this.propertiesAndValue.length / 2;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.propertiesAndValue[n2 * 2];
            ++n2;
        }
        return stringArray;
    }

    public IContributor getContributor() {
        return this.registry.getObjectManager().getContributor(this.contributorId);
    }
}

