/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.interop.InteropStreamSegment;
import com.ibm.rational.wvcm.interop.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.Feedback;
import javax.wvcm.Folder;
import javax.wvcm.FolderVersion;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteropStream {
    private static final String NO_CLONE_PREFIX = "NO_CLONE";
    private static final String CONCAT_PATH = "{0}/{1}";
    private static final String TRUNC_PATH = ".../{0}";
    private static final String CONCAT_NAME = "{0}_{1}";
    private static final String CONCAT_MSG = "{0}\n{1}";
    private static final String CLONE_WORKSPACE_NAME = Messages.getString("InteropStream.CLONE_WORKSPACE_NAME");
    private static final String INTERNAL_WORKSPACE_NAME = Messages.getString("InteropStream.INTERNAL_WORKSPACE_NAME");
    private static final String OTHER_WORKSPACE_NAME = Messages.getString("InteropStream.OTHER_WORKSPACE_NAME");
    private static final String TRUE_STRING = Boolean.TRUE.toString();
    private static final String EMPTY_STRING = new String();
    public static final String DOT = String.valueOf('.');
    public static final String SCM_CONNECTOR_NAMESPACE = "com.ibm.team.connector.scm";
    public static final String INTEROP_NAMESPACE = "com.ibm.team.interop";
    public static final String RATIONAL_WVCM_NAMESPACE = "com.ibm.rational.wvcm";
    public static final String IA_PREFIX = "com.ibm.team.connector.scm" + DOT;
    public static final String IA_WORKSPACE_PATH = "com.ibm.rational.wvcm" + DOT + "WORKSPACE_LOCATION";
    public static final String IA_LINE_SEPARATOR = String.valueOf(IA_PREFIX) + "LINE_DELIMITER";
    public static final String IA_MERGE_WORKSPACE = "com.ibm.team.interop" + DOT + "MERGE_WORKSPACE";
    public static final String IA_NO_COMPONENT_ROOT_CLONE = "com.ibm.team.interop" + DOT + "NO_COMPONENT_ROOT_CLONE";
    public static final String IA_OTHER_WORKSPACE_NAME = "com.ibm.team.interop" + DOT + "OTHER_WORKSPACE_NAME";
    public static final String IA_OTHER_STREAM_LOCATION = "com.ibm.team.interop" + DOT + "OTHER_STREAM_LOCATION";
    public static final String IA_IGNORE_TASK_CREATION_FAILURE = "com.ibm.team.interop" + DOT + "IGNORE_TASK_CREATION_FAILURE";
    private static final String DEFAULT_IGNORE_TASK_CREATION_FAILURE = "true";
    public static final String IA_FORCE_EXCEPTION = "com.ibm.team.interop" + DOT + "FORCE_EXCEPTION";
    public static int MAX_FORCE_EXCEPTION = 27;
    public static final String IA_DESYNC = "com.ibm.team.interop" + DOT + "DESYNC";
    public static final String DESYNC_TREE = "tree";
    public static final String DESYNC_COMPONENT = "component";
    public static final String TERMINATOR1 = "\n\n\n.";
    public static final String TERMINATOR2 = "\n\n.";
    public static final String TERMINATOR3 = "\n.";
    public static final LineSeparator LINE_SEPARATOR_DEFAULT = LineSeparator.LF;
    public static final PropertyNameList.PropertyName<String> PN_INTEROP_STREAM = new PropertyNameList.PropertyName("com.ibm.team.interop", "INTEROP_STREAM");
    public static final PropertyNameList.PropertyName<String> PN_INTEROP_STREAM_LOCKED = new PropertyNameList.PropertyName("com.ibm.team.interop", "INTEROP_STREAM_LOCKED");
    public static final PropertyNameList.PropertyName<String> PN_CLONE = new PropertyNameList.PropertyName("com.ibm.team.interop", "CLONE");
    public static final PropertyNameList.PropertyName<String> PN_RESERVE_FOR_INTEROP = new PropertyNameList.PropertyName("com.ibm.team.interop", "RESERVE_FOR_INTEROP");
    public static final PropertyNameList.PropertyName<String> PN_RESERVED_FOR_INTEROP = new PropertyNameList.PropertyName("com.ibm.team.interop", "RESERVED_FOR_INTEROP");
    public static final PropertyNameList.PropertyName<String> PN_LINE_SEPARATOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "PN_LINE_SEPARATOR_CONVERSION");
    private static final Workspace.MergeFlag[] MF_NO_CHECKOUTS = new Workspace.MergeFlag[]{Workspace.MergeFlag.NO_CHECKOUT};
    private static final Workspace.MergeFlag[] MF_NO_CHECKOUTS_UPDATE = new Workspace.MergeFlag[]{Workspace.MergeFlag.NO_CHECKOUT, Workspace.MergeFlag.UPDATE_STREAM};
    public static int numChanges = 0;
    public static int numClones = 0;
    public static int numFilesCreated = 0;
    public static int numFilesUpdated = 0;
    public static int numFoldersCreated = 0;
    public static int numFoldersUpdated = 0;
    private InteropStreamSegment _thisSegment;
    private InteropStreamSegment _otherSegment;
    private long _minorVersion;
    private long _lastAttemptedSyncDate;
    private long _lastSyncDate;
    private long _stateId;
    private InteropStreamOperation _operation;
    private String[] _newSyncRootPaths;
    private static final PropertyRequestItem.PropertyRequest PR_CA_COMMENT_TASKS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)Workspace.CURRENT_ACTIVITY.nest(new PropertyRequestItem[]{Activity.COMMENT, Activity.TASK_LIST})});
    private static PropertyRequestItem.PropertyRequest PR_ISL_IS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_INTEROP_STREAM_LOCKED, PN_INTEROP_STREAM});
    PropertyRequestItem.PropertyRequest PR_RFIS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_RESERVED_FOR_INTEROP});
    public static PropertyRequestItem.PropertyRequest PR_PATH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Resource.PATHNAME_LOCATION});
    public static final PropertyRequestItem.PropertyRequest PR_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)ControllableResource.VERSION_HISTORY.nest(new PropertyRequestItem[]{Resource.RESOURCE_IDENTIFIER, PN_CLONE})});
    private static final PropertyRequestItem.PropertyRequest PR_VERSION_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, (PropertyRequestItem)FolderVersion.CHILD_MAP.nest(new PropertyRequestItem[]{PN_CLONE})});
    public static final PropertyRequestItem.PropertyRequest PR_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)Version.VERSION_HISTORY.nest(new PropertyRequestItem[]{Resource.RESOURCE_IDENTIFIER})});
    public static final Baseline.CompareFlag[] CF_ACT_NEW = new Baseline.CompareFlag[]{Baseline.CompareFlag.ACTIVITIES, Baseline.CompareFlag.NEW_ONLY};
    public static final PropertyRequestItem.PropertyRequest PR_CHANGED_VERSIONS_ACT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, (PropertyRequestItem)Activity.TASK_LIST.nest(new PropertyRequestItem[]{PN_CLONE, Resource.DISPLAY_NAME, Resource.COMMENT})});
    private static final PropertyRequestItem.PropertyRequest PR_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.CHILD_MAP});
    private static final PropertyRequestItem.PropertyRequest PR_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)Folder.CHILD_MAP.nest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN, PR_VH_CLONE})});
    private static final PropertyRequestItem.PropertyRequest PR_PATH_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Folder.PATHNAME_LOCATION, PR_CR_CHILD_CLONE});
    private static final PropertyRequestItem.PropertyRequest PR_PATH_VH_CR_CHILD_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableFolder.PATHNAME_LOCATION, ControllableFolder.VERSION_HISTORY, PR_CR_CHILD_CLONE});
    private static final PropertyRequestItem.PropertyRequest PR_CI_LINK_TARGET = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{SymbolicLinkVersion.LINK_TARGET})});
    public static final PropertyRequestItem.PropertyRequest PR_CI = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.CHECKED_IN});
    public static final PropertyRequestItem.PropertyRequest PR_NEW_CONTENT_CHARACTERISTICS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Version.CONTENT_TYPE, Version.CONTENT_CHARACTER_SET, Version.IS_EXECUTABLE, PN_LINE_SEPARATOR});
    private static final PropertyRequestItem.PropertyRequest PR_VH_NAME = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)Configuration.VERSION_HISTORY.nest(new PropertyRequestItem[]{Component.DISPLAY_NAME})});
    private static final String IA_HAS_CLONE_INFO = "com.ibm.rational.wvcm" + DOT + "HAS_CLONE_INFO";
    private static final PropertyRequestItem.PropertyRequest PR_CI_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
    private static final PropertyRequestItem.PropertyRequest PR_CI_VH_VERSION_CHILDMAP = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)ControllableResource.CHECKED_IN.nest(new PropertyRequestItem[]{PR_VERSION_CHILDMAP, PR_NEW_CONTENT_CHARACTERISTICS})});
    private static final PropertyRequestItem.PropertyRequest PR_CA_TASKS_COMMENT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)Workspace.CURRENT_ACTIVITY.nest(new PropertyRequestItem[]{(PropertyRequestItem)Activity.TASK_LIST.nest(new PropertyRequestItem[]{Task.COMMENT})})});
    private static final PropertyRequestItem.PropertyRequest PR_COMMENT = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Task.COMMENT});
    private static final PropertyRequestItem.PropertyRequest PR_STREAM = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Workspace.STREAM});
    private static int CURRENT_MAJOR_VERSION = 8;
    private static int CURRENT_MINOR_VERSION = 1;
    private static final PropertyRequestItem.PropertyRequest PR_CFG_WS_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, ControllableResource.PATHNAME_LOCATION, ControllableResource.WORKSPACE, (PropertyRequestItem)ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{Configuration.VERSION_HISTORY})});
    private static PropertyRequestItem.PropertyRequest PR_CFG_RF = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, (PropertyRequestItem)ControllableFolder.CONFIGURATION.nest(new PropertyRequestItem[]{(PropertyRequestItem)Configuration.ROOT_FOLDER.nest(new PropertyRequestItem[]{ControllableFolder.PATHNAME_LOCATION}), (PropertyRequestItem)Configuration.VERSION_HISTORY.nest(new PropertyRequestItem[]{Component.DISPLAY_NAME, PN_CLONE})})});
    private static final PropertyRequestItem.PropertyRequest PR_CFG_RF_WS_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PR_VH_CLONE, ControllableResource.PATHNAME_LOCATION, ControllableResource.WORKSPACE, PR_CFG_RF});
    private static PropertyRequestItem.PropertyRequest PR_RF_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)Configuration.ROOT_FOLDER.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
    private static PropertyRequestItem.PropertyRequest PR_ROOT_DN = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Component.ROOT_VERSION, Component.DISPLAY_NAME});
    private static PropertyRequestItem.PropertyRequest PR_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_CLONE});
    private static final PropertyRequestItem.PropertyRequest PR_CONFIG_VH = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{PR_VH})});
    private static final PropertyRequestItem.PropertyRequest PR_PATH_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{ControllableResource.PATHNAME_LOCATION, PR_VH_CLONE});
    private static final PropertyRequestItem.PropertyRequest PR_CONFIG_VH_CLONE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{(PropertyRequestItem)ControllableResource.CONFIGURATION.nest(new PropertyRequestItem[]{PR_VH_CLONE})});
    public static final PropertyRequestItem.PropertyRequest PR_IS = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{PN_INTEROP_STREAM});
    private static final PropertyRequestItem.PropertyRequest PR_WORKSPACE = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{Stream.WORKSPACE});

    public static int FB_BASE(int begin, int end, int count, int size) {
        return begin + (end - begin) * count / size;
    }

    public static int FB_LOOP_FACTOR(int begin, int end, int size) {
        return 100 * size / (end - begin);
    }

    private static boolean shouldForceException(Provider p, int i) {
        String faultRequestedVal = (String)p.initArgs().get(IA_FORCE_EXCEPTION);
        if (faultRequestedVal == null || faultRequestedVal.length() == 0) {
            return false;
        }
        int faultRequested = Integer.parseInt(faultRequestedVal);
        return i == faultRequested;
    }

    private static void forceWvcmException(Provider p, int i) throws WvcmException {
        if (InteropStream.shouldForceException(p, i)) {
            throw new WvcmException("Aborted", WvcmException.ReasonCode.ABORTED);
        }
    }

    private static void forceAbortWvcmException(Provider p, int i, Feedback f) {
        String faultRequestedVal = (String)p.initArgs().get(IA_FORCE_EXCEPTION);
        if (faultRequestedVal == null || faultRequestedVal.length() == 0) {
            return;
        }
        int faultRequested = Integer.parseInt(faultRequestedVal);
        if (i != faultRequested) {
            return;
        }
        f.abortRequested(true);
    }

    public static <T> T getOrReadProperty(Resource resource, PropertyNameList.PropertyName<T> requestedPropertyName, Feedback feedback) throws WvcmException {
        if (Arrays.asList(resource.propertyNameList().getPropertyNames()).contains(requestedPropertyName)) {
            return (T)resource.getProperty(requestedPropertyName);
        }
        return InteropStream.doReadProperty(resource, requestedPropertyName, feedback);
    }

    public static <T> T doReadProperty(Resource resource, PropertyNameList.PropertyName<T> propName, Feedback feedback) throws WvcmException {
        PropertyRequestItem.PropertyRequest pr = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{propName});
        PropertyRequestItem.PropertyRequest f = feedback == null ? pr : feedback.nest(pr);
        resource = resource.doReadProperties((Feedback)f);
        return (T)resource.getProperty(propName);
    }

    private InteropStream(InteropStreamSegment thisSegment, InteropStreamSegment otherSegment, long minorVersion, long lastAttemptedSyncDate, long lastSyncDate, long stateId, InteropStreamOperation operation, String[] roots) {
        this._thisSegment = thisSegment;
        this._otherSegment = otherSegment;
        this._minorVersion = minorVersion;
        this._lastAttemptedSyncDate = lastAttemptedSyncDate;
        this._lastSyncDate = lastSyncDate;
        this._stateId = stateId;
        this._operation = operation;
        this._newSyncRootPaths = roots;
    }

    public InteropStream(InteropStreamSegment thisSegment, InteropStreamSegment otherSegment) {
        this(thisSegment, otherSegment, 0L, 0L, 0L, 0L, InteropStreamOperation.INITIALIZE, null);
    }

    public static Workspace createWorkspace(String name, boolean isIsolated, Stream stream, boolean reservedForInterop, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = stream.workspaceProvider();
        Workspace ws = p.workspace(p.rootLocation().child(name));
        if (isIsolated) {
            ws.setIsolatedTarget(stream);
        } else {
            ws.setTarget(stream);
        }
        if (reservedForInterop) {
            ws.setProperty(PN_RESERVE_FOR_INTEROP, (Object)TRUE_STRING);
        }
        ws = ws.doCreateGeneratedResource(feedback);
        return ws;
    }

    private static boolean getIgnoreTaskCreationFailure(WorkspaceProvider p) {
        return DEFAULT_IGNORE_TASK_CREATION_FAILURE.equals(p.initArgs().get(IA_IGNORE_TASK_CREATION_FAILURE));
    }

    private static Task createTask(Workspace tgtBringoverWs, Feedback f) throws WvcmException {
        Task task = null;
        WorkspaceProvider p = tgtBringoverWs.workspaceProvider();
        String taskName = Messages.getString("InteropStream.NAME_SYNCHRONIZE_TASK");
        try {
            InteropStream.forceAbortWvcmException((Provider)p, 1, f);
            task = p.task(tgtBringoverWs.location().child(Messages.getString("InteropStream.ID_SYNCHRONIZE_TASK")));
            task.setDisplayName(taskName);
            task = task.doCreateGeneratedResource(f);
        }
        catch (WvcmException e) {
            if (!InteropStream.getIgnoreTaskCreationFailure(p)) {
                throw e;
            }
            f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_COULD_NOT_CREATE_TASK"), new Object[]{taskName}));
        }
        return task;
    }

    public static Stream createStream(String name, WorkspaceProvider p, Stream target, Feedback feedback) throws WvcmException {
        Stream stream = p.stream(p.rootLocation().child(name));
        if (target != null) {
            stream.setTarget(target);
        }
        return (Stream)stream.doCreateGeneratedResource(feedback);
    }

    private static void closeCurrentActivity(Workspace ws, Feedback f) throws WvcmException {
        Activity activity = (ws = (Workspace)ws.doReadProperties(f.nest(PR_CA_COMMENT_TASKS, 25))).getCurrentActivity();
        if (activity != null) {
            Task task;
            if (activity.getComment() == null) {
                activity.setComment(Messages.getString("InteropStream.SYNCHRONIZE"));
            }
            if (activity.getTaskList().size() == 0 && (task = InteropStream.createTask(ws, f.nest(50))) != null) {
                activity.setTaskList(InteropStream.makeList(task));
            }
            activity.doWriteProperties(f.nest(75));
            ws.setCurrentActivity(null);
            ws.doWriteProperties(f.nest(100));
        }
    }

    private static void updateStreamWithWorkspace(Stream stream, Workspace ws, Feedback f) throws WvcmException {
        InteropStream.closeCurrentActivity(ws, f.nest(30));
        stream.doUpdate(InteropStream.makeList(ws), f.nest(100));
    }

    private String createOtherWorkspaceName(String otherSyncStreamName, Feedback f) {
        String wsName = this.otherSegment().get_initArgs().get(IA_OTHER_WORKSPACE_NAME);
        if (wsName == null || wsName.length() == 0) {
            wsName = f.format(OTHER_WORKSPACE_NAME, new Object[]{otherSyncStreamName});
        }
        return wsName;
    }

    private static String getFriendlyPathname(Resource resource, int maxLength, Feedback f) throws WvcmException {
        Location loc = (Location)resource.getProperty(Resource.PATHNAME_LOCATION);
        int remainder = maxLength;
        String name = loc.lastSegment();
        while ((loc = loc.parent()) != null && loc.parent() != null && loc.parent().parent() != null) {
            if (maxLength > 0 && loc.lastSegment().length() > remainder + 5) {
                name = f.format(TRUNC_PATH, new Object[]{name});
                return name;
            }
            name = f.format(CONCAT_PATH, new Object[]{loc.lastSegment(), name});
        }
        return name;
    }

    private void lockInteropStream(Feedback f) throws WvcmException {
        Stream stream = this.thisSyncStream();
        String locked = InteropStream.getProperty((Resource)(stream = (Stream)stream.doReadProperties(f.nest(PR_ISL_IS, 30))), PN_INTEROP_STREAM_LOCKED);
        if (locked != null) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_THIS_STREAM_LOCKED"), WvcmException.ReasonCode.CONFLICT);
        }
        InteropStream currentIS = this.refresh(f.nest(70));
        if (this._stateId != currentIS._stateId) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_STALE_DATA"), WvcmException.ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN);
        }
        stream.initProperty(PN_INTEROP_STREAM_LOCKED, (Object)TRUE_STRING);
        stream.doWriteProperties(f.nest(100));
    }

    private void unlockInteropStream(Feedback f) throws WvcmException {
        Stream thisSyncStream = this.thisSyncStream();
        try {
            InteropStream.forceAbortWvcmException((Provider)thisSyncStream.workspaceProvider(), 2, f);
            thisSyncStream.removeProperty(PN_INTEROP_STREAM_LOCKED);
            thisSyncStream.doWriteProperties(f.nest(100));
        }
        catch (Exception exception) {
            f.notifyWarning(Messages.getString("InteropStream.ERROR_COULD_NOT_UNLOCK"));
        }
    }

    public void unreserveInteropStream(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        boolean keepReserved = this.get_state().equals((Object)InteropStreamState.SENDOVER_ERROR);
        if (!keepReserved) {
            Stream otherSyncStream = this.otherSyncStream();
            try {
                InteropStream.forceAbortWvcmException((Provider)otherSyncStream.workspaceProvider(), 3, f);
                otherSyncStream.removeProperty(PN_RESERVED_FOR_INTEROP);
                otherSyncStream.doWriteProperties(f.nest(50));
            }
            catch (Exception exception) {
                f.notifyWarning(Messages.getString("InteropStream.ERROR_COULD_NOT_UNRESERVE_STREAM"));
            }
        }
        this.unlockInteropStream(f);
    }

    private static List<ControllableResource> getSyncRoots(Workspace ws, InteropStreamSegment segment, Feedback f) throws WvcmException {
        Feedback nowork = f.nest(f.getPropertyRequestForResult());
        ArrayList<ControllableResource> roots = new ArrayList<ControllableResource>();
        WorkspaceProvider p = ws.workspaceProvider();
        String[] paths = segment.get_syncRootPaths();
        int size = paths.length;
        int count = 0;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            int done = InteropStream.FB_BASE(0, 100, ++count, size);
            VersionHistory vh = p.versionHistory(p.location(path));
            roots.add(InteropStream.doFindCRInWorkspace(ws, vh, nowork));
            f.notifyPercentComplete(done);
            ++n2;
        }
        return roots;
    }

    private List<ControllableResource> getPrunedSyncRoots(boolean isThis, Workspace ws, Feedback f) throws WvcmException {
        Feedback nowork = f.nest(f.getPropertyRequestForResult());
        InteropStreamSegment segment = isThis ? this.thisSegment() : this.otherSegment();
        ArrayList<ControllableResource> roots = new ArrayList<ControllableResource>();
        ArrayList<VersionHistory> prunedRoots = new ArrayList<VersionHistory>();
        WorkspaceProvider p = ws.workspaceProvider();
        String[] paths = segment.get_syncRootPaths();
        int size = paths.length;
        int count = 0;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            int done = InteropStream.FB_BASE(0, 100, ++count, size);
            VersionHistory vh = p.versionHistory(p.location(path));
            ControllableResource root = InteropStream.doFindCRInWorkspace(ws, vh, nowork);
            if (root == null) {
                prunedRoots.add(vh);
            } else {
                roots.add(root);
            }
            f.notifyPercentComplete(done);
            ++n2;
        }
        this.internalDeleteSyncRoots(isThis, prunedRoots, f);
        return roots;
    }

    private void sendoverStream(Feedback f) throws WvcmException {
        Workspace srcWs = this.thisInternalWs();
        Stream srcStream = this.thisInternalStream();
        Workspace srcSentoverWs = this.thisCloneWs();
        Stream srcSentoverStream = this.thisCloneStream();
        Workspace tgtBringoverWs = this.otherSyncWs();
        Stream tgtBringoverStream = this.otherSyncStream();
        InteropStream.closeCurrentActivity(tgtBringoverWs, f.nest(10));
        WorkspaceProvider srcP = srcStream.workspaceProvider();
        ResourceList srcChangedVersions = srcP.resourceList((Resource[])new Version[0]);
        ResourceList srcTasks = srcP.resourceList((Resource[])new Task[0]);
        f.notifyActive(Messages.getString("InteropStream.MSG_CHANGES_IN_STREAM"));
        InteropStream.computeNewVersionList((ResourceList<Version>)srcChangedVersions, (ResourceList<Task>)srcTasks, (ResourceList.ResponseIterator<Baseline.CompareReport>)srcSentoverStream.doCompareReport(srcStream, CF_ACT_NEW, f.nest(PR_CHANGED_VERSIONS_ACT, 50)));
        if (srcChangedVersions.size() > 0) {
            f.notifyActive(Messages.getString("InteropStream.MSG_COMPUTING_OTHER_ROOTS"));
            List<ControllableResource> tgtRoots = this.otherSyncRoots(this.otherSyncWs(), f.nest(PR_PATH, 100));
            HashSet<String> tgtRootPaths = new HashSet<String>();
            for (ControllableResource tgtRoot : tgtRoots) {
                if (tgtRoot == null) continue;
                tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
            }
            InteropStream.bringoverChanges(tgtBringoverWs, tgtBringoverStream, tgtRootPaths, (ResourceList<Version>)srcChangedVersions, srcWs, false, null, f.nest(80));
            InteropStream.bringoverTasks(tgtBringoverWs, tgtBringoverStream, (ResourceList<Task>)srcTasks, f.nest(85));
            this.setBroughtover(f.nest(95));
        }
        srcSentoverWs.doUpdate(InteropStream.makeList(srcStream), f.nest(97));
        srcSentoverStream.doUpdate(InteropStream.makeList(srcSentoverWs), f.nest(99));
        InteropStream.closeCurrentActivity(tgtBringoverWs, f.nest(100));
    }

    private ResourceList<Baseline> getSentoverBaselines(Feedback f) throws WvcmException {
        WorkspaceProvider srcP = this.otherProvider();
        String[] srcBlNames = this.otherSegment().get_sentoverBaselinePaths();
        ResourceList srcOldBaselines = srcP.resourceList((Resource[])new Baseline[0]);
        String[] stringArray = srcBlNames;
        int n = srcBlNames.length;
        int n2 = 0;
        while (n2 < n) {
            String srcBlName = stringArray[n2];
            Location blLoc = srcP.location(srcBlName);
            Resource b = srcP.baseline(blLoc).doReadProperties((Feedback)f.getPropertyRequestForResult());
            srcOldBaselines.add((Object)((Baseline)b));
            ++n2;
        }
        f.notifyPercentComplete(100);
        return srcOldBaselines;
    }

    private Set<VersionHistory> getSentoverComponents(Feedback f) throws WvcmException {
        HashSet<VersionHistory> oldComponents = new HashSet<VersionHistory>();
        ResourceList<Baseline> oldBaselines = this.getSentoverBaselines(f.nest(PR_VH));
        for (Baseline b : oldBaselines) {
            oldComponents.add(b.getVersionHistory());
        }
        return oldComponents;
    }

    private void bringoverBaselines(Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace srcWs = this.otherSyncWs();
        Stream srcStream = this.otherSyncStream();
        Workspace tgtBringoverWs = this.thisCloneWs();
        Stream tgtBringoverStream = this.thisCloneStream();
        List<ControllableResource> tgtRoots = this.thisSyncRoots(this.thisCloneWs(), f.nest(PR_PATH, 5));
        HashSet<String> tgtRootPaths = new HashSet<String>();
        for (ControllableResource tgtRoot : tgtRoots) {
            if (tgtRoot == null) continue;
            tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
        }
        InteropStream.closeCurrentActivity(tgtBringoverWs, f.nest(6));
        WorkspaceProvider srcP = srcStream.workspaceProvider();
        boolean srcHasChanges = false;
        ResourceList<Baseline> srcOldBaselines = this.getSentoverBaselines(f.nest(PR_VH_NAME, 10));
        int size = srcOldBaselines.size();
        int factor = InteropStream.FB_LOOP_FACTOR(15, 25, size);
        int count = 0;
        String[] srcResultBaselineNames = new String[srcOldBaselines.size()];
        for (Baseline srcOldBaseline : srcOldBaselines) {
            int base = InteropStream.FB_BASE(15, 25, count, size);
            ResourceList srcChangedVersions = srcP.resourceList((Resource[])new Version[0]);
            ResourceList srcTasks = srcP.resourceList((Resource[])new Task[0]);
            Component comp = (Component)srcOldBaseline.getVersionHistory();
            Configuration conf = InteropStream.doFindConfigurationInWorkspace(srcWs, comp, f.nest(PR_CI, base + 5 / factor));
            Baseline srcNewBaseline = (Baseline)conf.getCheckedIn();
            srcResultBaselineNames[count] = srcOldBaseline.location().string();
            if (srcNewBaseline != null) {
                srcResultBaselineNames[count] = srcNewBaseline.location().string();
                String compName = comp.getDisplayName();
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CHANGES_IN_COMPONENT"), new Object[]{compName}));
                int percentCompleted = base + 20 / factor;
                InteropStream.computeNewVersionList((ResourceList<Version>)srcChangedVersions, (ResourceList<Task>)srcTasks, (ResourceList.ResponseIterator<Baseline.CompareReport>)srcOldBaseline.doCompareReport(srcNewBaseline, CF_ACT_NEW, f.nest(PR_CHANGED_VERSIONS_ACT, percentCompleted)));
            }
            if (srcChangedVersions.size() > 0) {
                srcHasChanges = true;
                if (srcTasks.size() > 0) {
                    InteropStream.closeCurrentActivity(tgtBringoverWs, nowork);
                }
                ResourceList<Version> srcVersions = this.updateVersionsToThoseSelectedByWorkspace(srcWs, (ResourceList<Version>)srcChangedVersions, f.nest(base + 60 / factor));
                InteropStream.bringoverChanges(tgtBringoverWs, tgtBringoverStream, tgtRootPaths, srcVersions, srcWs, false, null, f.nest(base + 80 / factor));
                InteropStream.bringoverTasks(tgtBringoverWs, tgtBringoverStream, (ResourceList<Task>)srcTasks, f.nest(base + 100 / factor));
            }
            ++count;
        }
        if (srcHasChanges) {
            InteropStream.updateStreamWithWorkspace(tgtBringoverStream, tgtBringoverWs, f.nest(100));
            this.otherSegment().set_sentoverBaselinePaths(srcResultBaselineNames);
        }
    }

    private ResourceList<Version> updateVersionsToThoseSelectedByWorkspace(Workspace srcWs, ResourceList<Version> srcVersions, Feedback fb) throws WvcmException {
        Map<VersionHistory, Version> srcVh2srcVersion = InteropStream.computeSrvVh2srcVersionMap(srcVersions);
        Map<VersionHistory, ControllableResource> crs = InteropStream.doFindCRsInWorkspace(srcWs, (Collection<VersionHistory>)srcVh2srcVersion.keySet(), fb.nest(PR_CI_VH_CLONE));
        ResourceList<Version> results = InteropStream.makeList((Version)srcVersions.get(0));
        for (VersionHistory srcVH : crs.keySet()) {
            ControllableResource cr = crs.get(srcVH);
            if (cr == null) continue;
            results.add((Object)cr.getCheckedIn());
        }
        return results;
    }

    private static void bringoverTasks(Workspace tgtBringoverWs, Stream tgtBringoverStream, ResourceList<Task> srcTasks, Feedback f) throws WvcmException {
        if (srcTasks.size() == 0) {
            return;
        }
        WorkspaceProvider tgtP = tgtBringoverWs.workspaceProvider();
        Feedback nowork = f.nest();
        Activity tgtAct = (tgtBringoverWs = (Workspace)tgtBringoverWs.doReadProperties(f.nest(PR_CA_TASKS_COMMENT, 10))).getCurrentActivity();
        if (tgtAct == null) {
            return;
        }
        Task tgtSummaryTask = null;
        String tgtSummaryComment = EMPTY_STRING;
        ResourceList tgtTasks = tgtAct.getTaskList();
        boolean isTaskAdded = false;
        if (tgtTasks.size() > 0) {
            tgtSummaryTask = (Task)tgtTasks.get(0);
            tgtSummaryComment = tgtSummaryTask.getComment();
        }
        String comment = null;
        for (Task srcTask : srcTasks) {
            String taskName = srcTask.getDisplayName();
            Task tgtTask = InteropStream.lookupClone(srcTask, tgtP);
            comment = comment == null ? f.format(Messages.getString("InteropStream.MSG_SYNCHRONIZED_TASK_FIRST_TASK_NAME_PREFIX"), new Object[]{taskName}) : f.format(Messages.getString("InteropStream.MSG_SYNCHRONIZED_TASK_NAME_PREFIX"), new Object[]{comment, taskName});
            if (tgtTask == null) continue;
            tgtTasks.add((Object)tgtTask);
            isTaskAdded = true;
        }
        if (comment != null) {
            Task task;
            if (tgtSummaryTask == null && (task = InteropStream.createTask(tgtBringoverWs, f)) != null) {
                tgtSummaryTask = task;
                tgtTasks.add((Object)task);
                isTaskAdded = true;
            }
            if (tgtSummaryTask != null) {
                if (tgtSummaryComment != null) {
                    comment = f.format(CONCAT_MSG, new Object[]{tgtSummaryComment, comment});
                }
                try {
                    InteropStream.forceAbortWvcmException((Provider)tgtP, 4, f);
                    tgtSummaryTask.setComment(comment);
                    tgtSummaryTask.doWriteProperties(nowork);
                }
                catch (WvcmException e) {
                    if (!InteropStream.getIgnoreTaskCreationFailure(tgtP)) {
                        throw e;
                    }
                    f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_COULD_NOT_UPDATE_COMMENT"), new Object[]{tgtSummaryTask.location()}));
                }
            }
        }
        if (isTaskAdded) {
            try {
                InteropStream.forceAbortWvcmException((Provider)tgtP, 5, f);
                tgtAct.setTaskList(tgtTasks);
                tgtAct.doWriteProperties(f);
            }
            catch (WvcmException wvcmException) {
                f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_COULD_NOT_UPDATE_TASK_LIST"), new Object[]{tgtAct.location()}));
            }
        }
    }

    private static void computeNewVersionList(ResourceList<Version> changes, ResourceList<Task> newTasks, ResourceList.ResponseIterator<Baseline.CompareReport> compares) throws WvcmException {
        while (compares.hasNext()) {
            Baseline.CompareReport change = (Baseline.CompareReport)compares.next();
            if (change instanceof Baseline.AddedVersion) {
                changes.add((Object)((Baseline.AddedVersion)change).getVersion());
                continue;
            }
            if (change instanceof Baseline.ChangedVersion) {
                changes.add((Object)((Baseline.ChangedVersion)change).getNewVersion());
                continue;
            }
            if (change instanceof Baseline.AddedActivity) {
                newTasks.addAll((Collection)((Baseline.AddedActivity)change).getActivity().getTaskList());
                continue;
            }
            if (change instanceof Baseline.PartiallyAddedActivity) {
                newTasks.addAll((Collection)((Baseline.PartiallyAddedActivity)change).getActivity().getTaskList());
                continue;
            }
            if (!(change instanceof Baseline.ChangedActivity)) continue;
            newTasks.addAll((Collection)((Baseline.ChangedActivity)change).getActivity().getTaskList());
        }
    }

    private static void createFile(ControllableResource tgtCR, Version srcVersion, Feedback f) throws WvcmException {
        String bn = tgtCR.location().lastSegment();
        f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CREATING_FILE"), new Object[]{bn}));
        ++numFilesCreated;
        InteropStream.copyVersionToCR(tgtCR, srcVersion, true, f.nest(100));
    }

    private static void createFiles(Workspace tgtWorkspace, Map<ControllableResource, Version> tgtCr2srcVer, Feedback f) throws WvcmException {
        int count = 1;
        int size = tgtCr2srcVer.size();
        if (size == 0) {
            return;
        }
        Provider tgtP = tgtWorkspace.provider();
        Provider srcP = null;
        ResourceList tgtCRs = tgtP.resourceList((Resource[])new ControllableResource[0]);
        for (ControllableResource tgtCR : tgtCr2srcVer.keySet()) {
            Version srcVersion = tgtCr2srcVer.get(tgtCR);
            if (srcP == null) {
                srcP = srcVersion.provider();
            }
            InteropStream.createFile(tgtCR, srcVersion, f.nest(70 * count / size));
            tgtCRs.add((Object)tgtCR);
            ++count;
        }
        tgtWorkspace.doVersionControl(tgtCRs, f.nest(80));
        ResourceList.ResponseIterator tgtCRIter = tgtCRs.doReadProperties(f.nest(PR_VH_CLONE, 90));
        boolean tgtHasCloneInfo = InteropStream.hasCloneInfo(tgtP.initArgs());
        ResourceList vHs = tgtHasCloneInfo ? tgtP.resourceList((Resource[])new VersionHistory[0]) : srcP.resourceList((Resource[])new VersionHistory[0]);
        for (Version srcVer : tgtCr2srcVer.values()) {
            ControllableResource tgtCR = (ControllableResource)tgtCRIter.next();
            VersionHistory tgtVH = tgtCR.getVersionHistory();
            VersionHistory srcVH = srcVer.getVersionHistory();
            if (tgtHasCloneInfo) {
                InteropStream.initClone((Resource)tgtVH, (Resource)srcVH);
                vHs.add((Object)tgtVH);
                continue;
            }
            InteropStream.initClone((Resource)srcVH, (Resource)tgtVH);
            vHs.add((Object)srcVH);
        }
        vHs.doWriteProperties(f.nest(100));
    }

    private static void bringoverChanges(Workspace tgtWorkspace, Stream tgtStream, Set<String> tgtRootPaths, ResourceList<Version> srcChangedVersions, Workspace srcWorkspace, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Feedback f) throws WvcmException {
        numChanges += srcChangedVersions.size();
        Map<VersionHistory, Version> tgtVh2srcVer = InteropStream.computeTargetVh2SrcVerMap(tgtWorkspace.workspaceProvider(), srcChangedVersions, srcWorkspace.workspaceProvider(), f);
        HashMap<VersionHistory, FolderVersion> tgtChildRemoved = new HashMap<VersionHistory, FolderVersion>();
        ArrayList<VersionHistory> tgtProcessed = new ArrayList<VersionHistory>();
        HashMap<ControllableResource, Version> tgtCr2srcVer = new HashMap<ControllableResource, Version>();
        InteropStream.bringoverFolders(tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtChildRemoved, tgtProcessed, srcWorkspace, isTree, srcVh2srcVer, tgtCr2srcVer, f.nest(30));
        InteropStream.bringoverContent(tgtWorkspace, tgtRootPaths, tgtVh2srcVer, tgtProcessed, isTree, f.nest(50));
        InteropStream.createFiles(tgtWorkspace, tgtCr2srcVer, f.nest(70));
        InteropStream.removeDeletedChildren(tgtWorkspace, tgtChildRemoved, f.nest(95));
        f.notifyActive(Messages.getString("InteropStream.MSG_CHECKING_IN_CHANGES"));
        tgtWorkspace.doCheckinAll(null, null, f.nest(100));
    }

    private static Map<VersionHistory, Version> computeTargetVh2SrcVerMap(WorkspaceProvider tgtProv, ResourceList<Version> srcChangedVersions, WorkspaceProvider srcProv, Feedback f) throws WvcmException {
        Map<VersionHistory, Version> srcVh2srcVersion = InteropStream.computeSrvVh2srcVersionMap(srcChangedVersions);
        Set<VersionHistory> srcVersionHistories = srcVh2srcVersion.keySet();
        Map<VersionHistory, String> srcVh2ClonePath = InteropStream.lookupClonePaths(srcProv, srcVersionHistories, tgtProv);
        HashMap<VersionHistory, Version> results = new HashMap<VersionHistory, Version>(srcChangedVersions.size());
        for (VersionHistory srcVersionHistory : srcVersionHistories) {
            VersionHistory tgtVH;
            String tgtCloneVHPath = srcVh2ClonePath.get(srcVersionHistory);
            if (tgtCloneVHPath == null || tgtCloneVHPath.startsWith(NO_CLONE_PREFIX) || (tgtVH = InteropStream.lookupClone(srcVersionHistory, tgtProv, tgtCloneVHPath)) == null) continue;
            results.put(tgtVH, srcVh2srcVersion.get(srcVersionHistory));
        }
        return results;
    }

    private static Map<VersionHistory, Version> computeSrvVh2srcVersionMap(ResourceList<Version> srcChangedVersions) throws WvcmException {
        HashMap<VersionHistory, Version> srcVh2srcVersion = new HashMap<VersionHistory, Version>(srcChangedVersions.size());
        for (Version srcVersion : srcChangedVersions) {
            srcVh2srcVersion.put(srcVersion.getVersionHistory(), srcVersion);
        }
        return srcVh2srcVersion;
    }

    private static void bringoverFolders(Workspace tgtWorkspace, Stream tgtStream, Set<String> tgtRootPaths, Map<VersionHistory, Version> tgtVh2srcVer, Map<VersionHistory, FolderVersion> tgtChildRemoved, List<VersionHistory> tgtProcessed, Workspace srcWorkspace, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Map<ControllableResource, Version> tgtCr2srcVer, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        try {
            InteropStream.forceAbortWvcmException((Provider)tgtWorkspace.workspaceProvider(), 6, f);
            ArrayList tgtNewVH = new ArrayList();
            tgtNewVH.addAll(tgtVh2srcVer.keySet());
            int size = tgtNewVH.size();
            int count = 0;
            while (!tgtNewVH.isEmpty()) {
                int done = InteropStream.FB_BASE(0, 100, ++count, size);
                ArrayList<VersionHistory> tgtVHAdded = new ArrayList<VersionHistory>();
                for (VersionHistory tgtVH : tgtNewVH) {
                    Version srcVersion = tgtVh2srcVer.get(tgtVH);
                    if (srcVersion == null) continue;
                    if (srcVersion instanceof FolderVersion && !tgtProcessed.contains(tgtVH)) {
                        FolderVersion srcFV = (FolderVersion)InteropStream.doFindVersionInWorkspace(srcWorkspace, srcVersion.getVersionHistory(), f.nest(PR_VERSION_CHILDMAP));
                        if (srcFV == null) {
                            tgtProcessed.add(tgtVH);
                        } else {
                            ControllableFolder tgtCF = (ControllableFolder)InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtVH, f.nest(PR_PATH_CR_CHILD_CLONE));
                            if (tgtCF != null && (isTree || InteropStream.isBelowRootPath((ControllableResource)tgtCF, tgtRootPaths))) {
                                InteropStream.bringoverFolder(tgtCF, tgtVH, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtVHAdded, tgtChildRemoved, tgtProcessed, (Version)srcFV, srcWorkspace, isTree, srcVh2srcVer, tgtCr2srcVer, nowork);
                            }
                        }
                    }
                    f.notifyPercentComplete(done);
                }
                tgtNewVH = tgtVHAdded;
            }
        }
        finally {
            f.notifyPercentComplete(100);
        }
    }

    private static boolean isRootPath(ControllableResource cr, Set<String> rootPaths) throws WvcmException {
        String path = cr.getPathnameLocation().string();
        return rootPaths.contains(path);
    }

    private static boolean isBelowRootPath(ControllableResource cr, Set<String> rootPaths) throws WvcmException {
        String path = cr.getPathnameLocation().string();
        for (String rootPath : rootPaths) {
            if (!path.startsWith(rootPath)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAboveRootPath(ControllableResource cr, Set<String> rootPaths) throws WvcmException {
        String path = cr.getPathnameLocation().string();
        for (String rootPath : rootPaths) {
            if (!rootPath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private static void bringoverFolder(ControllableFolder tgtCF, VersionHistory tgtVH, Workspace tgtWorkspace, Stream tgtStream, Set<String> tgtRootPaths, Map<VersionHistory, Version> tgtVh2srcVer, List<VersionHistory> tgtVHAdded, Map<VersionHistory, FolderVersion> tgtChildRemoved, List<VersionHistory> tgtProcessed, Version srcVersion, Workspace srcWorkspace, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Map<ControllableResource, Version> tgtCr2srcVer, Feedback f) throws WvcmException {
        VersionHistory tgtChildVH;
        VersionHistory srcChildVH;
        int done;
        if (tgtCF instanceof ControllableSymbolicLink) {
            return;
        }
        Feedback nowork = f.nest();
        WorkspaceProvider tgtProv = tgtCF.workspaceProvider();
        boolean isChildRemoved = false;
        boolean isChildAdded = false;
        FolderVersion srcFV = (FolderVersion)srcVersion;
        Map tgtCFChildMap = tgtCF.getChildMap();
        Map srcFVChildMap = srcFV.getChildMap();
        Collection srcFVChildNames = srcFVChildMap.keySet();
        tgtProcessed.add(tgtVH);
        f.notifyActive(f.format(Messages.getString("InteropStream.MSG_UPDATING_FOLDER"), new Object[]{InteropStream.getFriendlyPathname((Resource)tgtCF, 200, nowork)}));
        int size = srcFVChildNames.size();
        int count = 0;
        HashSet<String> rebindNames = new HashSet<String>();
        for (String srcBN : srcFVChildNames) {
            Version srcVer;
            done = InteropStream.FB_BASE(0, 20, ++count, size);
            srcChildVH = (VersionHistory)srcFVChildMap.get(srcBN);
            if (!tgtCFChildMap.containsKey(srcBN)) continue;
            VersionHistory tgtWantedChildVH = InteropStream.lookupClone(srcChildVH, tgtProv);
            ControllableResource tgtChild = (ControllableResource)tgtCFChildMap.get(srcBN);
            tgtChildVH = tgtChild.getVersionHistory();
            Version tgtChildVersion = tgtChild.getCheckedIn();
            String origPath = ((Location)InteropStream.getOrReadProperty((Resource)tgtChild, ControllableResource.PATHNAME_LOCATION, nowork)).string();
            if (!InteropStream.isSame(tgtChildVH, tgtWantedChildVH, tgtChildVersion, srcChildVH, srcWorkspace, nowork)) {
                InteropStream.rebindToTmp(tgtCF, srcBN, srcFVChildNames, origPath, tgtRootPaths, nowork);
                isChildRemoved = true;
                rebindNames.add(srcBN);
            } else if (isTree && !tgtRootPaths.contains(origPath) && (srcVer = InteropStream.doFindVersionInWorkspace(srcWorkspace, srcChildVH, f.nest(PR_VERSION_CHILDMAP))) != null) {
                tgtVh2srcVer.put(tgtChildVH, srcVer);
            }
            f.notifyPercentComplete(done);
        }
        size = srcFVChildNames.size();
        count = 0;
        for (String srcBN : srcFVChildNames) {
            ControllableResource tgtChild;
            done = InteropStream.FB_BASE(20, 100, ++count, size);
            srcChildVH = (VersionHistory)srcFVChildMap.get(srcBN);
            if (rebindNames.contains(srcBN) || !tgtCFChildMap.containsKey(srcBN)) {
                isChildAdded = true;
                InteropStream.bindVersionHistory(tgtCF, srcBN, srcChildVH, srcWorkspace, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtChildRemoved, tgtProcessed, tgtVHAdded, isTree, srcVh2srcVer, tgtCr2srcVer, nowork);
            } else if (isTree && !((tgtChild = (ControllableResource)tgtCFChildMap.get(srcBN)) instanceof ControllableSymbolicLink) && tgtChild instanceof ControllableFolder) {
                ControllableFolder tgtChildCF = (ControllableFolder)tgtChild.doReadProperties(f.nest(PR_PATH_VH_CR_CHILD_CLONE));
                tgtChildVH = tgtChildCF.getVersionHistory();
                Version srcChildVer = tgtVh2srcVer.get(tgtChildVH);
                if (srcChildVer == null && (srcChildVer = InteropStream.doFindVersionInWorkspace(srcWorkspace, srcChildVH, f.nest(PR_VH_CLONE))) != null) {
                    tgtVh2srcVer.put(tgtChildVH, srcChildVer);
                }
                if (!tgtRootPaths.contains(tgtChildCF.getPathnameLocation().string())) {
                    InteropStream.bringoverFolder(tgtChildCF, tgtChildVH, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtVHAdded, tgtChildRemoved, tgtProcessed, srcChildVer, srcWorkspace, isTree, srcVh2srcVer, tgtCr2srcVer, nowork);
                }
            }
            f.notifyPercentComplete(done);
        }
        for (String bn : tgtCFChildMap.keySet()) {
            if (srcFVChildMap.containsKey(bn)) continue;
            isChildRemoved = true;
        }
        if (isChildRemoved) {
            tgtChildRemoved.put(tgtVH, srcFV);
        }
        if (isChildRemoved || isChildAdded) {
            ++numFoldersUpdated;
        }
        f.notifyPercentComplete(100);
    }

    public static boolean isEquivalentLinkTarget(Location loc1, Location loc2) {
        Location parent1 = loc1.parent();
        Location parent2 = loc2.parent();
        if (parent1 == null || parent2 == null) {
            return parent1 == parent2;
        }
        if (!loc1.lastSegment().equals(loc2.lastSegment())) {
            return false;
        }
        return InteropStream.isEquivalentLinkTarget(parent1, parent2);
    }

    private static boolean isSame(VersionHistory curVH, VersionHistory cloneVH, Version curVersion, VersionHistory srcVH, Workspace srcWs, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        if (cloneVH != null) {
            return curVH.equals(cloneVH);
        }
        if (!(curVersion instanceof SymbolicLinkVersion)) {
            return false;
        }
        ControllableResource srcCR = InteropStream.doFindCRInWorkspace(srcWs, srcVH, f.nest(PR_CI_LINK_TARGET));
        Version srcVersion = null;
        srcVersion = srcCR == null ? (Version)InteropStream.doReadProperty((Resource)srcVH, VersionHistory.ROOT_VERSION, nowork) : srcCR.getCheckedIn();
        if (!(srcVersion instanceof SymbolicLinkVersion)) {
            return false;
        }
        Location target1 = (Location)InteropStream.doReadProperty((Resource)curVersion, SymbolicLinkVersion.LINK_TARGET, nowork);
        Location target2 = (Location)InteropStream.doReadProperty((Resource)srcVersion, SymbolicLinkVersion.LINK_TARGET, nowork);
        return InteropStream.isEquivalentLinkTarget(target1, target2);
    }

    private static void removeDeletedChildren(Workspace tgtWorkspace, Map<VersionHistory, FolderVersion> tgtChildRemoved, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        boolean isFirstUnbind = true;
        int size = tgtChildRemoved.size();
        int count = 0;
        for (VersionHistory tgtVH : tgtChildRemoved.keySet()) {
            int done = InteropStream.FB_BASE(0, 100, ++count, size);
            ControllableFolder tgtCF = (ControllableFolder)InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtVH, f.nest(PR_CHILDMAP));
            if (tgtCF != null) {
                FolderVersion srcFV = tgtChildRemoved.get(tgtVH);
                Map tgtCFChildMap = tgtCF.getChildMap();
                Map srcFVChildMap = srcFV.getChildMap();
                for (String bn : tgtCFChildMap.keySet()) {
                    if (srcFVChildMap.containsKey(bn)) continue;
                    if (isFirstUnbind) {
                        tgtWorkspace.doCheckinAll(null, null, null);
                        isFirstUnbind = false;
                    }
                    f.notifyActive(f.format(Messages.getString("InteropStream.MSG_DELETING"), new Object[]{bn}));
                    tgtCF.doUnbindChild(bn, nowork);
                }
            }
            f.notifyPercentComplete(done);
        }
        f.notifyPercentComplete(100);
    }

    private static void bringoverContent(Workspace tgtWorkspace, Set<String> tgtRootPaths, Map<VersionHistory, Version> tgtVh2srcVer, List<VersionHistory> tgtProcessed, boolean isTree, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Set<VersionHistory> tgtVhs = tgtVh2srcVer.keySet();
        Map<VersionHistory, ControllableResource> tgtVhs2Crs = InteropStream.doFindCRsInWorkspace(tgtWorkspace, tgtVhs, f.nest(PR_PATH, 10));
        int size = tgtVh2srcVer.size();
        int count = 0;
        int factor = InteropStream.FB_LOOP_FACTOR(10, 100, size);
        for (VersionHistory tgtVH : tgtVhs) {
            int base = InteropStream.FB_BASE(10, 100, count, size);
            ++count;
            Version srcVersion = tgtVh2srcVer.get(tgtVH);
            ControllableResource tgtCR = tgtVhs2Crs.get(tgtVH);
            if (tgtCR == null || tgtProcessed.contains(tgtVH) || srcVersion instanceof FolderVersion || srcVersion instanceof SymbolicLinkVersion || !isTree && !InteropStream.isBelowRootPath(tgtCR, tgtRootPaths)) continue;
            tgtProcessed.add(tgtVH);
            String name = InteropStream.getFriendlyPathname((Resource)tgtCR, 200, f);
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_UPDATING"), new Object[]{name}));
            InteropStream.copyVersionToCR(tgtCR, srcVersion, false, nowork);
            f.notifyPercentComplete(base + 100 / factor);
            ++numFilesUpdated;
        }
    }

    private static <T> T getProperty(Resource r, PropertyNameList.PropertyName<T> pName) throws WvcmException {
        Object value = r.lookupProperty(pName);
        if (value instanceof WvcmException) {
            WvcmException e = (WvcmException)((Object)value);
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.PROPERTY_NOT_DEFINED_FOR_RESOURCE) || e.getReasonCode().equals((Object)WvcmException.ReasonCode.PROPERTY_NOT_SUPPORTED_BY_SERVER)) {
                return null;
            }
            throw e;
        }
        Object result = value;
        return (T)result;
    }

    private static void bindVersionHistory(ControllableFolder tgtParentCF, String bn, VersionHistory srcVH, Workspace srcWorkspace, Workspace tgtWorkspace, Stream tgtStream, Set<String> tgtRootPaths, Map<VersionHistory, Version> tgtVh2srcVer, Map<VersionHistory, FolderVersion> tgtChildRemoved, List<VersionHistory> tgtProcessed, List<VersionHistory> tgtVHAdded, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Map<ControllableResource, Version> tgtCr2srcVer, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider tgtProv = tgtParentCF.workspaceProvider();
        Version tgtPredecessor = null;
        Version srcVersion = srcVh2srcVer != null ? srcVh2srcVer.get(srcVH) : InteropStream.doFindVersionInWorkspace(srcWorkspace, srcVH, f.nest(PR_VERSION_CHILDMAP, 5));
        if (srcVersion == null) {
            throw new RuntimeException("Could not find source version in source workspace");
        }
        VersionHistory tgtVH = InteropStream.lookupClone(srcVH, tgtProv);
        if (tgtVH != null) {
            ControllableResource tgtOrigCR = InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtVH, f.nest(PR_PATH, 10));
            if (tgtOrigCR != null) {
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_MOVING"), new Object[]{bn}));
                boolean tgtOrigIsRoot = InteropStream.isRootPath(tgtOrigCR, tgtRootPaths);
                boolean tgtOrigIsBelowRoot = InteropStream.isBelowRootPath(tgtOrigCR, tgtRootPaths);
                InteropStream.rebindFixup(tgtParentCF, bn, tgtOrigCR, tgtRootPaths, f.nest(15));
                if (isTree && !tgtOrigIsRoot || !tgtOrigIsBelowRoot) {
                    if (tgtOrigCR instanceof ControllableSymbolicLink) {
                        throw new RuntimeException("Symbolic link should not be marked as a clone: " + tgtOrigCR.location());
                    }
                    if (tgtOrigCR instanceof ControllableFolder) {
                        ControllableFolder tgtCF = tgtProv.controllableFolder(tgtParentCF.location().child(bn));
                        tgtCF = (ControllableFolder)tgtCF.doReadProperties(f.nest(PR_PATH_CR_CHILD_CLONE));
                        InteropStream.bringoverFolder(tgtCF, tgtVH, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtVHAdded, tgtChildRemoved, tgtProcessed, srcVersion, srcWorkspace, true, srcVh2srcVer, tgtCr2srcVer, f.nest(100));
                    } else {
                        ControllableResource tgtCR = tgtProv.controllableResource(tgtParentCF.location().child(bn));
                        f.notifyActive(f.format(Messages.getString("InteropStream.MSG_UPDATING"), new Object[]{bn}));
                        tgtProcessed.add(tgtVH);
                        InteropStream.copyVersionToCR(tgtCR, srcVersion, true, f.nest(100));
                    }
                }
                f.notifyPercentComplete(100);
                return;
            }
            tgtPredecessor = (Version)InteropStream.doReadProperty((Resource)tgtVH, VersionHistory.ROOT_VERSION, f.nest(20));
        }
        if (srcVersion instanceof FolderVersion) {
            FolderVersion srcFolderVersion = (FolderVersion)srcVersion;
            ControllableFolder tgtCF = tgtProv.controllableFolder(tgtParentCF.location().child(bn));
            if (tgtPredecessor == null) {
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CREATING_FOLDER"), new Object[]{bn}));
                tgtCF.doCreateResource(nowork);
                tgtCF = (ControllableFolder)tgtCF.doVersionControl(f.nest(PR_VH_CLONE));
                tgtVH = tgtCF.getVersionHistory();
                InteropStream.linkClones((Resource)srcVH, (Resource)tgtVH, nowork);
            } else {
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RESTORING_FOLDER"), new Object[]{bn}));
                tgtCF = (ControllableFolder)tgtCF.doCreateVersionControlledResource(tgtPredecessor, f.nest(PR_CHILDMAP));
                ++numFoldersCreated;
                for (String childName : tgtCF.getChildMap().keySet()) {
                    tgtCF.doUnbindChild(childName, nowork);
                }
            }
            f.notifyPercentComplete(50);
            Map srcFVChildMap = srcFolderVersion.getChildMap();
            for (String childName : srcFVChildMap.keySet()) {
                InteropStream.bindVersionHistory(tgtCF, childName, (VersionHistory)srcFVChildMap.get(childName), srcWorkspace, tgtWorkspace, tgtStream, tgtRootPaths, tgtVh2srcVer, tgtChildRemoved, tgtProcessed, tgtVHAdded, isTree, srcVh2srcVer, tgtCr2srcVer, f.nest(100));
            }
        } else if (srcVersion instanceof SymbolicLinkVersion) {
            ControllableSymbolicLink tgtCSL = tgtProv.controllableSymbolicLink(tgtParentCF.location().child(bn));
            Location linkTarget = (Location)InteropStream.doReadProperty((Resource)srcVersion, SymbolicLinkVersion.LINK_TARGET, nowork);
            tgtCSL.setLinkTarget(linkTarget);
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CREATING_SYMLINK"), new Object[]{bn}));
            tgtCSL.doCreateResource(nowork);
            tgtCSL.doVersionControl(nowork);
            f.notifyPercentComplete(100);
        } else {
            ControllableResource tgtCR = tgtProv.controllableResource(tgtParentCF.location().child(bn));
            if (tgtPredecessor == null) {
                if (isTree) {
                    tgtCr2srcVer.put(tgtCR, srcVersion);
                } else {
                    InteropStream.createFile(tgtCR, srcVersion, f.nest(90));
                    tgtCR = tgtCR.doVersionControl(f.nest(PR_VH_CLONE, 95));
                    tgtVH = tgtCR.getVersionHistory();
                    InteropStream.linkClones((Resource)srcVH, (Resource)tgtVH, f.nest(100));
                }
            } else {
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RESTORING_FILE"), new Object[]{bn}));
                tgtCR.doCreateVersionControlledResource(tgtPredecessor, f.nest(50));
                ++numFilesCreated;
                InteropStream.copyVersionToCR(tgtCR, srcVersion, true, f.nest(100));
            }
        }
        f.notifyPercentComplete(100);
    }

    private static void rebindFixup(ControllableFolder parent, String bn, ControllableResource newChild, Set<String> rootPaths, Feedback f) throws WvcmException {
        parent.doRebindAll(bn, (Resource)newChild, null, f);
        if (!InteropStream.isAboveRootPath(newChild, rootPaths)) {
            return;
        }
        String oldPath = newChild.getPathnameLocation().string();
        String newPath = ((Location)InteropStream.doReadProperty((Resource)parent, ControllableFolder.PATHNAME_LOCATION, f.nest())).child(bn).string();
        HashSet<String> removedPaths = new HashSet<String>();
        HashSet<String> addedPaths = new HashSet<String>();
        for (String rootPath : rootPaths) {
            if (!rootPath.startsWith(oldPath)) continue;
            removedPaths.add(rootPath);
            addedPaths.add(String.valueOf(newPath) + rootPath.substring(oldPath.length()));
        }
        rootPaths.removeAll(removedPaths);
        rootPaths.addAll(addedPaths);
    }

    public static Version doFindVersionInWorkspace(Workspace workspace, VersionHistory vh, Feedback f) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        Version vQuery = p.version(p.rootLocation());
        VersionHistory vhQuery = p.versionHistory(p.rootLocation());
        vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
        Workspace wsQuery = p.workspace(p.rootLocation());
        wsQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
        ResourceList wsQueryList = p.resourceList((Resource[])new Workspace[0]);
        wsQueryList.add((Object)wsQuery);
        vQuery.setProperty(Version.VERSION_HISTORY, (Object)vhQuery);
        vQuery.setProperty(Version.IN_WORKSPACE_LIST, (Object)wsQueryList);
        return (Version)vQuery.doFind(f);
    }

    public static ControllableResource doFindCRInWorkspace(Workspace workspace, VersionHistory vh, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        ControllableResource crQuery = p.controllableResource(p.rootLocation());
        VersionHistory vhQuery = p.versionHistory(p.rootLocation());
        vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
        Workspace workspaceQuery = p.workspace(p.rootLocation());
        workspaceQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
        crQuery.setProperty(ControllableResource.VERSION_HISTORY, (Object)vhQuery);
        crQuery.setProperty(ControllableResource.WORKSPACE, (Object)workspaceQuery);
        return (ControllableResource)crQuery.doFind(feedback);
    }

    public static Map<VersionHistory, ControllableResource> doFindCRsInWorkspace(Workspace workspace, Collection<VersionHistory> tgtVhs, Feedback feedback) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        ResourceList queries = p.resourceList((Resource[])new ControllableResource[0]);
        for (VersionHistory vh : tgtVhs) {
            ControllableResource crQuery = p.controllableResource(p.rootLocation());
            VersionHistory vhQuery = p.versionHistory(p.rootLocation());
            vhQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)vh.location());
            Workspace workspaceQuery = p.workspace(p.rootLocation());
            workspaceQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)workspace.location());
            crQuery.setProperty(ControllableResource.VERSION_HISTORY, (Object)vhQuery);
            crQuery.setProperty(ControllableResource.WORKSPACE, (Object)workspaceQuery);
            queries.add((Object)crQuery);
        }
        HashMap<VersionHistory, ControllableResource> results = new HashMap<VersionHistory, ControllableResource>(tgtVhs.size());
        ResourceList.ResponseIterator findings = queries.doFind(feedback);
        for (VersionHistory vh : tgtVhs) {
            results.put(vh, (ControllableResource)findings.next());
        }
        return results;
    }

    public static Component doFindComponent(WorkspaceProvider p, String componentName, Feedback f) throws WvcmException {
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.DISPLAY_NAME, (Object)componentName);
        return (Component)compQuery.doFind(f);
    }

    public static Configuration doFindConfigurationInWorkspace(Workspace workspace, Component comp, Feedback f) throws WvcmException {
        WorkspaceProvider p = workspace.workspaceProvider();
        Configuration configQuery = p.configuration(p.rootLocation());
        Component compQuery = p.component(p.rootLocation());
        compQuery.setProperty(Resource.PATHNAME_LOCATION, (Object)comp.location());
        Workspace workspaceQuery = p.workspace(p.rootLocation());
        workspaceQuery.setProperty(Workspace.PATHNAME_LOCATION, (Object)workspace.location());
        configQuery.setProperty(Configuration.VERSION_HISTORY, (Object)compQuery);
        configQuery.setProperty(Configuration.WORKSPACE, (Object)workspaceQuery);
        return (Configuration)configQuery.doFind(f);
    }

    public static void copyVersionToCR(ControllableResource tgtCR, Version srcVersion, boolean isNew, Feedback f) throws WvcmException {
        if (tgtCR instanceof ControllableSymbolicLink) {
            throw new RuntimeException("Cannot copy content for symbolic link: " + tgtCR.location());
        }
        PipedInputStream pins = new PipedInputStream();
        PipedOutputStream pouts = InteropStream.createPipedOutputStream(tgtCR, pins);
        ChildException childEx = new ChildException();
        WorkspaceProvider tgtP = tgtCR.workspaceProvider();
        String tgtDefaultLSVal = (String)tgtP.initArgs().get(IA_LINE_SEPARATOR);
        new ContentReader((Resource)srcVersion, pouts, childEx, f);
        if (isNew) {
            InteropStream.initializeContentProperties(tgtCR, srcVersion, tgtDefaultLSVal);
        }
        try {
            InteropStream.forceAbortWvcmException(tgtCR.provider(), 27, f);
            tgtCR.doWriteContent((InputStream)pins, null, f);
        }
        catch (WvcmException wvcmException) {
            InteropStream.closePipedInputStream(tgtCR, pins);
            pins = new PipedInputStream();
            pouts = InteropStream.createPipedOutputStream(tgtCR, pins);
            new ContentReader((Resource)srcVersion, pouts, childEx, f);
            InteropStream.setBinaryContentProperties(tgtCR);
            tgtCR.doWriteContent((InputStream)pins, null, f);
            f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_BROUGHT_OVER_AS_BINARY"), new Object[]{InteropStream.doReadProperty((Resource)tgtCR, Resource.DISPLAY_NAME, f)}));
        }
        InteropStream.closePipedInputStream(tgtCR, pins);
        if (childEx.ex != null) {
            if (childEx.ex instanceof WvcmException) {
                throw (WvcmException)childEx.ex;
            }
            throw new WvcmException(Messages.getString("InteropStream.ERROR_CONTENT_READER_DIED"), (Resource)tgtCR, WvcmException.ReasonCode.CONFLICT, childEx.ex);
        }
    }

    private static void closePipedInputStream(ControllableResource tgtCR, PipedInputStream pins) throws WvcmException {
        try {
            if (InteropStream.shouldForceException(tgtCR.provider(), 10)) {
                throw new IOException("Abort");
            }
            pins.close();
        }
        catch (IOException e) {
            throw new WvcmException("Could not close pipe", (Resource)tgtCR, WvcmException.ReasonCode.WRITE_FAILED, (Throwable)e);
        }
    }

    private static PipedOutputStream createPipedOutputStream(ControllableResource tgtCR, PipedInputStream pins) throws WvcmException {
        PipedOutputStream pouts;
        try {
            if (InteropStream.shouldForceException(tgtCR.provider(), 9)) {
                throw new IOException("Abort");
            }
            pouts = new PipedOutputStream(pins);
        }
        catch (IOException e) {
            throw new WvcmException("Could not open pipe", (Resource)tgtCR, WvcmException.ReasonCode.WRITE_FAILED, (Throwable)e);
        }
        return pouts;
    }

    private static boolean isTextContentType(String contentType) {
        return contentType.trim().toLowerCase().startsWith("text");
    }

    private static void initializeContentProperties(ControllableResource tgtCR, Version srcVersion, String tgtDefaultLSVal) throws WvcmException {
        Version srcV = srcVersion;
        if (srcV.lookupProperty(Resource.CONTENT_TYPE) instanceof WvcmException) {
            srcV = (Version)srcVersion.doReadProperties((Feedback)PR_NEW_CONTENT_CHARACTERISTICS);
        }
        tgtCR.setContentType(srcV.getContentType());
        if (InteropStream.isTextContentType(srcV.getContentType())) {
            InteropStream.setIfNotNull((Resource)tgtCR, (Resource)srcV, PN_LINE_SEPARATOR);
            if (!(tgtCR.lookupProperty(PN_LINE_SEPARATOR) instanceof String)) {
                tgtCR.setProperty(PN_LINE_SEPARATOR, (Object)tgtDefaultLSVal);
            }
            InteropStream.setIfNotNull((Resource)tgtCR, (Resource)srcV, Resource.CONTENT_CHARACTER_SET);
            if (!(tgtCR.lookupProperty(Resource.CONTENT_CHARACTER_SET) instanceof String)) {
                tgtCR.setContentCharacterSet(System.getProperty("file.encoding"));
            }
        } else {
            tgtCR.setProperty(PN_LINE_SEPARATOR, (Object)LineSeparator.UNSPECIFIED.name());
        }
        InteropStream.setIfNotNull((Resource)tgtCR, (Resource)srcV, Resource.IS_EXECUTABLE);
    }

    private static void setBinaryContentProperties(ControllableResource tgtCR) {
        tgtCR.setProperty(Resource.CONTENT_TYPE, (Object)"application/unknown");
        tgtCR.setContentCharacterSet(null);
        tgtCR.setProperty(PN_LINE_SEPARATOR, (Object)LineSeparator.UNSPECIFIED.toString());
    }

    private static <T> void setIfNotNull(Resource target, Resource source, PropertyNameList.PropertyName<T> propertyName) throws WvcmException {
        Object obj = source.lookupProperty(propertyName);
        if (obj == null) {
            return;
        }
        if (obj instanceof WvcmException) {
            throw (WvcmException)((Object)obj);
        }
        Object value = obj;
        target.setProperty(propertyName, value);
    }

    public static void linkClones(Resource thisResource, Resource otherResource, Feedback f) throws WvcmException {
        ++numClones;
        if (InteropStream.hasCloneInfo(thisResource.provider().initArgs())) {
            InteropStream.initClone(thisResource, otherResource);
            thisResource.doWriteProperties(f);
        } else if (InteropStream.hasCloneInfo(otherResource.provider().initArgs())) {
            InteropStream.initClone(otherResource, thisResource);
            otherResource.doWriteProperties(f);
        } else {
            throw new WvcmException("Neither provider is storing clone information", thisResource, WvcmException.ReasonCode.FORBIDDEN);
        }
    }

    private static void initClone(Resource thisResource, Resource otherResource) throws WvcmException {
        if (InteropStream.getProperty(thisResource, PN_CLONE) != null) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_ALREADY_HAS_CLONE"), thisResource, WvcmException.ReasonCode.CONFLICT);
        }
        thisResource.initProperty(PN_CLONE, (Object)otherResource.getResourceIdentifier());
    }

    public static <T extends Resource> T lookupClone(T thisResource, WorkspaceProvider otherP) throws WvcmException {
        String path = InteropStream.lookupClonePath(thisResource, otherP);
        return InteropStream.lookupClone(thisResource, otherP, path);
    }

    public static <T extends Resource> T lookupClone(T thisResource, WorkspaceProvider otherP, String path) throws WvcmException {
        if (path == null) {
            return null;
        }
        Class<?> type = thisResource.getClass();
        return (T)otherP.buildProxy(type, otherP.location(path));
    }

    private static <T extends Resource> String lookupClonePath(T thisResource, WorkspaceProvider otherProvider) throws WvcmException {
        if (InteropStream.hasCloneInfo(thisResource.provider().initArgs())) {
            return InteropStream.getProperty(thisResource, PN_CLONE);
        }
        if (!InteropStream.hasCloneInfo(otherProvider.initArgs())) {
            throw new WvcmException("Neither provider is storing clone information", thisResource, WvcmException.ReasonCode.FORBIDDEN);
        }
        Class<?> type = thisResource.getClass();
        Resource otherResourceQuery = otherProvider.buildProxy(type, otherProvider.rootLocation());
        otherResourceQuery.setProperty(PN_CLONE, (Object)thisResource.getResourceIdentifier());
        Resource otherResource = otherResourceQuery.doFind(null);
        if (otherResource == null) {
            return null;
        }
        return otherResource.getResourceIdentifier();
    }

    private static Map<VersionHistory, String> lookupClonePaths(WorkspaceProvider srcProv, Set<VersionHistory> srcVersionHistories, WorkspaceProvider tgtProv) throws WvcmException {
        HashMap<VersionHistory, String> results = new HashMap<VersionHistory, String>(srcVersionHistories.size());
        if (InteropStream.hasCloneInfo(srcProv.initArgs())) {
            for (VersionHistory versionHistory : srcVersionHistories) {
                results.put(versionHistory, InteropStream.getProperty((Resource)versionHistory, PN_CLONE));
            }
            return results;
        }
        if (!InteropStream.hasCloneInfo(tgtProv.initArgs())) {
            throw new WvcmException("Neither provider is storing clone information", null, WvcmException.ReasonCode.FORBIDDEN);
        }
        ResourceList queries = tgtProv.resourceList((Resource[])new VersionHistory[0]);
        for (VersionHistory srcVh : srcVersionHistories) {
            VersionHistory queryElement = tgtProv.versionHistory(tgtProv.rootLocation());
            queryElement.setProperty(PN_CLONE, (Object)srcVh.getResourceIdentifier());
            queries.add((Object)queryElement);
        }
        ResourceList.ResponseIterator clones = queries.doFind(null);
        for (VersionHistory srcVh : srcVersionHistories) {
            VersionHistory clone = (VersionHistory)clones.next();
            String value = clone != null ? clone.getResourceIdentifier() : null;
            results.put(srcVh, value);
        }
        return results;
    }

    public static <T extends Resource> ResourceList<T> makeList(T r) throws WvcmException {
        ResourceList resourceList = r.provider().resourceList(new Resource[]{r});
        return resourceList;
    }

    private static String rebindToTmp(ControllableFolder sourceFolder, String bindingName, Collection<String> reservedNames, String origPath, Set<String> rootPaths, Feedback f) throws WvcmException {
        int i = 0;
        while (true) {
            try {
                String newName;
                do {
                    if (InteropStream.shouldForceException(sourceFolder.provider(), 12)) {
                        i = 101;
                        throw new WvcmException("Abort", WvcmException.ReasonCode.ABORTED);
                    }
                    newName = f.format(CONCAT_NAME, new Object[]{bindingName, String.valueOf(++i)});
                } while (reservedNames != null && reservedNames.contains(newName));
                WorkspaceProvider p = sourceFolder.workspaceProvider();
                Location newChildLoc = sourceFolder.location().child(bindingName);
                ControllableResource newChild = p.controllableResource(newChildLoc);
                newChild = (ControllableResource)newChild.doReadProperties(f.nest(PR_PATH));
                InteropStream.rebindFixup(sourceFolder, newName, newChild, rootPaths, f);
                return newName;
            }
            catch (WvcmException e) {
                if (i <= 100) continue;
                throw e;
            }
            break;
        }
    }

    private void createBaselinesForRoots(Feedback f) throws WvcmException {
        String[] oldBaselinePaths;
        Feedback nowork = f.nest();
        Workspace sourceWs = this.otherSyncWs();
        Stream sourceStream = this.otherSyncStream();
        WorkspaceProvider p = sourceWs.workspaceProvider();
        ArrayList<Component> components = new ArrayList<Component>();
        String[] stringArray = oldBaselinePaths = this.otherSegment().get_sentoverBaselinePaths();
        int n = oldBaselinePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            Baseline oldBaseline = p.baseline(p.location(path));
            oldBaseline = (Baseline)oldBaseline.doReadProperties(f.nest(PR_VH_NAME));
            components.add((Component)oldBaseline.getVersionHistory());
            ++n2;
        }
        for (Component comp : components) {
            Configuration conf = InteropStream.doFindConfigurationInWorkspace(sourceWs, comp, nowork);
            String compName = comp.getDisplayName();
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_BASELINING_COMPONENT"), new Object[]{compName}));
            conf.doCheckout(null, nowork);
            conf.doCheckin(null, nowork);
        }
        InteropStream.updateStreamWithWorkspace(sourceStream, sourceWs, f.nest(100));
    }

    private void setBroughtover(Feedback f) throws WvcmException {
        if (this.otherSegment().numSyncRoots() == 0) {
            return;
        }
        Feedback nowork = f.nest();
        Set<VersionHistory> oldComponents = this.getSentoverComponents(nowork);
        int size = oldComponents.size();
        if (size > 0 && InteropStream.shouldForceException(oldComponents.iterator().next().provider(), 13)) {
            size = 0;
        }
        if (size == 0) {
            throw new WvcmException("No baselines found", WvcmException.ReasonCode.CONFLICT);
        }
        String[] baselineNames = new String[size];
        int count = 0;
        int factor = InteropStream.FB_LOOP_FACTOR(0, 100, size);
        for (VersionHistory comp : oldComponents) {
            int base = InteropStream.FB_BASE(0, 100, count, size);
            Configuration conf = InteropStream.doFindConfigurationInWorkspace(this.otherSyncWs(), (Component)comp, f.nest(PR_VH_NAME));
            String compName = conf.getVersionHistory().getDisplayName();
            f.notifyActive(f.format(Messages.getString("InteropStream.MSG_BASELINING_COMPONENT"), new Object[]{compName}));
            conf.doCheckout(null, nowork);
            f.notifyPercentComplete(base + 30 / factor);
            conf = (Configuration)conf.doCheckin(null, f.nest(PR_CI, base + 100 / factor));
            Baseline bl = (Baseline)conf.getCheckedIn();
            baselineNames[count] = bl.location().string();
            ++count;
        }
        this.otherSegment().set_sentoverBaselinePaths(baselineNames);
        f.notifyPercentComplete(100);
    }

    private void addBroughtover(boolean isImport, Set<Configuration> otherConfigurations, Feedback f) throws WvcmException {
        int size = otherConfigurations.size();
        if (size == 0) {
            return;
        }
        HashMap<VersionHistory, Object> components = new HashMap<VersionHistory, Object>();
        ResourceList<Baseline> oldBaselines = this.getSentoverBaselines(f.nest(PR_VH));
        for (Baseline b : oldBaselines) {
            components.put(b.getVersionHistory(), b);
        }
        HashSet<VersionHistory> newComponents = new HashSet<VersionHistory>();
        int count = 0;
        int factor = InteropStream.FB_LOOP_FACTOR(0, 95, size);
        for (Configuration configuration : otherConfigurations) {
            int base = InteropStream.FB_BASE(0, 95, count, size);
            VersionHistory vh = configuration.getVersionHistory();
            if (!newComponents.contains(vh)) {
                newComponents.add(vh);
                if (!isImport || !components.keySet().contains(vh)) {
                    configuration.doCheckout(null, null);
                    configuration = (Configuration)configuration.doCheckin(null, f.nest(PR_CI, base + 100 / factor));
                    components.put(vh, configuration.getCheckedIn());
                }
            }
            ++count;
        }
        String[] baselineNames = new String[components.keySet().size()];
        int i = 0;
        for (VersionHistory component : components.keySet()) {
            baselineNames[i++] = ((Version)components.get(component)).location().string();
        }
        this.otherSegment().set_sentoverBaselinePaths(baselineNames);
        f.notifyPercentComplete(100);
    }

    private static void setHasCloneInfo(Map<String, String> initArgs, boolean hasCloneInfo) {
        if (hasCloneInfo) {
            initArgs.put(IA_HAS_CLONE_INFO, TRUE_STRING);
        } else {
            initArgs.remove(IA_HAS_CLONE_INFO);
        }
    }

    public static boolean hasCloneInfo(Map<String, String> initArgs) {
        return initArgs.containsKey(IA_HAS_CLONE_INFO);
    }

    private static void bringoverTree(ControllableResource tgtCR, Stream tgtStream, Set<String> tgtRootPaths, ControllableResource srcCR, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider otherP = srcCR.workspaceProvider();
        Workspace tgtWs = tgtCR.getWorkspace();
        ResourceList srcChangedVersions = otherP.resourceList((Resource[])new Version[0]);
        String rootName = InteropStream.getFriendlyPathname((Resource)srcCR, 100, nowork);
        f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RETRIEVING_METADATA"), new Object[]{rootName}));
        ControllableResource srcRootCR = (ControllableResource)srcCR.doReadProperties(f.nest(PR_CI_VH_CLONE, 5));
        srcChangedVersions.add((Object)srcRootCR.getCheckedIn());
        Map<VersionHistory, Version> srcVh2srcVer = InteropStream.create_srcVh2srcVer(srcRootCR, tgtCR, tgtRootPaths, f.nest(30));
        InteropStream.bringoverChanges(tgtWs, tgtStream, tgtRootPaths, (ResourceList<Version>)srcChangedVersions, srcCR.getWorkspace(), true, srcVh2srcVer, f.nest(100));
    }

    private static Map<VersionHistory, Version> create_srcVh2srcVer(ControllableResource srcCR, ControllableResource tgtCR, Set<String> tgtRootPaths, Feedback f) throws WvcmException {
        HashMap<VersionHistory, Version> srcVh2srcVer = null;
        if (!(tgtCR instanceof ControllableSymbolicLink) && tgtCR instanceof ControllableFolder && !InteropStream.isAboveRootPath(tgtCR, tgtRootPaths)) {
            ControllableFolder srcCF = (ControllableFolder)srcCR;
            srcVh2srcVer = new HashMap<VersionHistory, Version>();
            ResourceList.ResponseIterator srcCrIterator = srcCF.doReadMemberList(true, f.nest(PR_CI_VH_VERSION_CHILDMAP, 100));
            while (srcCrIterator.hasNext()) {
                ControllableResource srcCr = (ControllableResource)srcCrIterator.next();
                Version srcVer = srcCr.getCheckedIn();
                srcVh2srcVer.put(srcVer.getVersionHistory(), srcVer);
            }
        }
        return srcVh2srcVer;
    }

    private static void commitChanges(ControllableResource srcRoot, Workspace tgtWs, Stream tgtStream, boolean isTree, Feedback f) throws WvcmException {
        WorkspaceProvider tgtP = tgtWs.workspaceProvider();
        Feedback nowork = f.nest();
        String rootName = InteropStream.getFriendlyPathname((Resource)srcRoot, 100, nowork);
        Activity tgtAct = (tgtWs = (Workspace)tgtWs.doReadProperties(f.nest(PR_CA_TASKS_COMMENT))).getCurrentActivity();
        if (tgtAct != null) {
            if (tgtAct.getTaskList().size() == 0) {
                String msg = isTree ? Messages.getString("InteropStream.MSG_OVERWRITE_TASKNAME") : Messages.getString("InteropStream.MSG_BRING_OVER_TASKNAME");
                String taskName = f.format(msg, new Object[]{rootName});
                try {
                    InteropStream.forceAbortWvcmException((Provider)tgtP, 14, f);
                    Task tgtTask = tgtP.task(tgtWs.location().child(Messages.getString("InteropStream.ID_SYNCHRONIZE_TASK")));
                    tgtTask.setDisplayName(taskName);
                    tgtTask = tgtTask.doCreateGeneratedResource(f.nest(PR_COMMENT));
                    tgtAct.setTaskList(InteropStream.makeList(tgtTask));
                    tgtAct.doWriteProperties(nowork);
                }
                catch (WvcmException wvcmException) {
                    f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_COULD_NOT_CREATE_TASK"), new Object[]{taskName}));
                }
            } else {
                Task tgtTask = (Task)tgtAct.getTaskList().get(0);
                if (isTree) {
                    String comment = f.format(Messages.getString("InteropStream.MSG_OVERWRITE_TASKNAME"), new Object[]{rootName});
                    String origComment = tgtTask.getComment();
                    if (origComment != null && origComment.length() > 0) {
                        comment = f.format(CONCAT_MSG, new Object[]{comment, origComment});
                    }
                    tgtTask.setComment(comment);
                    tgtTask.doWriteProperties(nowork);
                }
            }
            InteropStream.closeCurrentActivity(tgtWs, nowork);
            f.notifyPercentComplete(50);
        }
        InteropStream.updateStreamWithWorkspace(tgtStream, tgtWs, nowork);
        f.notifyPercentComplete(100);
    }

    private Workspace newInteropStreamWs(String wsName, InteropStreamSegment segment, Workspace oldWorkspace, boolean isIsolated, Stream stream, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        PropertyRequestItem.PropertyRequest pr = f.getPropertyRequestForResult();
        Workspace ws = InteropStream.createWorkspace(wsName, isIsolated, stream, true, f.nest(pr, 80));
        f.notifyPercentComplete(40);
        if (segment.get_initArgs().get(IA_WORKSPACE_PATH) != null) {
            segment.put_initArgs(IA_WORKSPACE_PATH, ws.location().string());
        }
        try {
            oldWorkspace.doUnbindAll(nowork);
        }
        catch (Exception exception) {}
        f.notifyPercentComplete(100);
        return ws;
    }

    private void updateISMetadata(Feedback f) throws WvcmException {
        Stream thisSyncStream = this.thisSyncStream();
        ++this._stateId;
        thisSyncStream.setProperty(PN_INTEROP_STREAM, (Object)this.unparse());
        thisSyncStream.doWriteProperties(f);
    }

    private static String getVersionField(String[] fields) {
        return fields[0];
    }

    private static String getStateIdField(String[] fields) {
        return fields[5];
    }

    private static InteropStream parse(String interopStreamValue, ProviderFactory.Callback callback, Feedback f) {
        if (interopStreamValue == null) {
            return null;
        }
        String[] field = interopStreamValue.split(TERMINATOR1, -1);
        int version = Integer.parseInt(InteropStream.getVersionField(field));
        if (version > CURRENT_MAJOR_VERSION) {
            throw new RuntimeException(f.format(Messages.getString("InteropStream.ERROR_OLD_CLIENT"), new Object[]{CURRENT_MAJOR_VERSION}));
        }
        if (version < CURRENT_MAJOR_VERSION) {
            f.notifyWarning(f.format(Messages.getString("InteropStream.WARNING_UPGRADING_METADATA_VERSION"), new Object[]{String.valueOf(version), String.valueOf(CURRENT_MAJOR_VERSION)}));
        }
        InteropStreamSegment thisSegment = new InteropStreamSegment(field[1], version, callback);
        InteropStreamSegment otherSegment = new InteropStreamSegment(field[2], version, callback);
        long lastAttemptedSyncDate = Long.parseLong(field[3]);
        long lastSyncDate = Long.parseLong(field[4]);
        long stateId = Long.parseLong(InteropStream.getStateIdField(field));
        InteropStreamOperation operation = Enum.valueOf(InteropStreamOperation.class, field[6]);
        String[] roots = null;
        roots = field[7].split(TERMINATOR3);
        if (roots.length == 0) {
            roots = null;
        }
        long minor_version = Long.parseLong(field[8]);
        InteropStream is = new InteropStream(thisSegment, otherSegment, minor_version, lastAttemptedSyncDate, lastSyncDate, stateId, operation, roots);
        return is;
    }

    private String unparse() {
        StringBuffer s = new StringBuffer();
        s.append(CURRENT_MAJOR_VERSION);
        s.append(TERMINATOR1);
        s.append(this._thisSegment.toString());
        s.append(TERMINATOR1);
        s.append(this._otherSegment.toString());
        s.append(TERMINATOR1);
        s.append(this._lastAttemptedSyncDate);
        s.append(TERMINATOR1);
        s.append(this._lastSyncDate);
        s.append(TERMINATOR1);
        s.append(this._stateId);
        s.append(TERMINATOR1);
        s.append((Object)this._operation);
        s.append(TERMINATOR1);
        if (this._newSyncRootPaths != null && this._newSyncRootPaths.length > 0) {
            String[] stringArray = this._newSyncRootPaths;
            int n = this._newSyncRootPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                s.append(path);
                s.append(TERMINATOR3);
                ++n2;
            }
        } else {
            s.append(TERMINATOR3);
        }
        s.append(TERMINATOR1);
        s.append(this._minorVersion);
        return s.toString();
    }

    private void internalSetSyncState(InteropStreamState state, Feedback f) throws WvcmException {
        this.set_state(state);
        this.updateISMetadata(f);
    }

    private void internalSync(boolean alreadyLocked, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        if (this.thisSegment().numSyncRoots() == 0) {
            this.thisCloneWs().doUpdate(InteropStream.makeList(this.thisSyncStream()), f.nest(25));
            InteropStream.updateStreamWithWorkspace(this.thisCloneStream(), this.thisCloneWs(), f.nest(50));
            this.thisInternalWs().doUpdate(InteropStream.makeList(this.thisCloneStream()), f.nest(75));
            InteropStream.updateStreamWithWorkspace(this.thisInternalStream(), this.thisInternalWs(), f.nest(100));
            if (this.otherSegment().get_sentoverBaselinePaths().length > 0) {
                this.otherSegment().set_sentoverBaselinePaths(new String[0]);
            }
            this.otherSyncWs().doMerge(InteropStream.makeList(this.otherSyncStream()), MF_NO_CHECKOUTS, nowork);
            return;
        }
        Workspace otherSyncWs = this.otherSyncWs();
        otherSyncWs.doCheckinAll(Messages.getString("InteropStream.MSG_LEFTOVER_CHECKOUTS"), null, nowork);
        InteropStream.closeCurrentActivity(otherSyncWs, nowork);
        Workspace thisCloneWs = this.thisCloneWs();
        thisCloneWs.doCheckinAll(Messages.getString("InteropStream.MSG_LEFTOVER_CHECKOUTS"), null, nowork);
        InteropStream.closeCurrentActivity(thisCloneWs, nowork);
        if (!alreadyLocked) {
            otherSyncWs.doMerge(InteropStream.makeList(this.otherSyncStream()), MF_NO_CHECKOUTS, nowork);
            this.createBaselinesForRoots(f.nest(15));
            this.bringoverBaselines(f.nest(50));
            Workspace thisInternalWs = this.thisInternalWs();
            thisInternalWs.doUpdate(InteropStream.makeList(this.thisCloneStream()), f.nest(52));
            thisInternalWs.doMerge(InteropStream.makeList(this.thisSyncStream()), MF_NO_CHECKOUTS_UPDATE, f.nest(55));
            InteropStream.updateStreamWithWorkspace(this.thisInternalStream(), thisInternalWs, nowork);
        }
        this.set_state(InteropStreamState.SENDOVER_ACTIVE);
        this.updateISMetadata(nowork);
        this.sendoverStream(f.nest(97));
        this.set_state(InteropStreamState.OPERATION_ACTIVE);
        this.updateISMetadata(nowork);
    }

    public static boolean isNoComponentRootClone(WorkspaceProvider p) {
        return TRUE_STRING.equals(p.initArgs().get(IA_NO_COMPONENT_ROOT_CLONE));
    }

    private static ControllableFolder getTgtBaselineControlledFolder(Workspace tgtCloneWs, Configuration srcConfig, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider tgtProvider = tgtCloneWs.workspaceProvider();
        Component srcComponent = (Component)srcConfig.getVersionHistory();
        String compName = srcComponent.getDisplayName();
        Component tgtComponent = InteropStream.lookupClone(srcComponent, tgtProvider);
        ControllableFolder tgtBCF = null;
        if (tgtComponent == null && (tgtComponent = InteropStream.doFindComponent(tgtProvider, compName, f.nest(PR_CLONE))) != null) {
            InteropStream.linkClones((Resource)tgtComponent, (Resource)srcComponent, nowork);
        }
        if (tgtComponent == null) {
            ControllableFolder root = (ControllableFolder)InteropStream.doReadProperty((Resource)tgtCloneWs, Workspace.CONFIGURATION_ROOT_FOLDER_HOME, nowork);
            tgtBCF = tgtProvider.controllableFolder(root.location().child(compName));
            try {
                InteropStream.forceAbortWvcmException(tgtBCF.provider(), 16, f);
                tgtBCF = (ControllableFolder)tgtBCF.doReadProperties(f.nest(PR_CFG_RF));
            }
            catch (WvcmException e) {
                if (e.getReasonCode() != WvcmException.ReasonCode.NOT_FOUND) {
                    throw e;
                }
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_CREATING_COMPONENT"), new Object[]{compName}));
                tgtBCF = tgtBCF.doBaselineControl(f.nest(PR_CFG_RF));
            }
            tgtComponent = (Component)tgtBCF.getConfiguration().getVersionHistory();
            InteropStream.linkClones((Resource)tgtComponent, (Resource)srcComponent, nowork);
        } else {
            Configuration tgtConfig = InteropStream.doFindConfigurationInWorkspace(tgtCloneWs, tgtComponent, f.nest(PR_RF_VH));
            if (tgtConfig != null) {
                tgtBCF = tgtConfig.getRootFolder();
            } else {
                tgtComponent = (Component)tgtComponent.doReadProperties(f.nest(PR_ROOT_DN));
                Baseline thisRootB = (Baseline)tgtComponent.getRootVersion();
                String tgtCompName = tgtComponent.getDisplayName();
                tgtBCF = tgtProvider.controllableFolder(tgtCloneWs.location().child(tgtCompName));
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RESTORING_COMPONENT"), new Object[]{tgtCompName}));
                tgtBCF = tgtBCF.doCreateBaselineControlledFolder(thisRootB, f.nest(PR_VH_CLONE));
            }
        }
        return tgtBCF;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ControllableResource createTgtCloneRoot(boolean isRoot, ControllableFolder tgtBCF, Workspace tgtWorkspace, ControllableResource srcRoot, Location srcBCFLoc, Feedback f) throws WvcmException {
        void var10_17;
        VersionHistory tgtCloneVH;
        ControllableResource srcRootWithCloneInfo;
        String lastSegment;
        Feedback nowork;
        block14: {
            ControllableResource controllableResource;
            WorkspaceProvider tgtP = tgtBCF.workspaceProvider();
            WorkspaceProvider srcP = srcRoot.workspaceProvider();
            nowork = f.nest();
            lastSegment = srcRoot.location().lastSegment();
            Object var10_10 = null;
            srcRootWithCloneInfo = (ControllableResource)srcRoot.doReadProperties(f.nest(PR_VH_CLONE));
            VersionHistory srcRootVH = srcRootWithCloneInfo.getVersionHistory();
            String tgtCloneVHPath = InteropStream.lookupClonePath(srcRootVH, tgtP);
            if (tgtCloneVHPath != null && tgtCloneVHPath.startsWith(NO_CLONE_PREFIX)) {
                throw new WvcmException(Messages.getString("InteropStream.ERROR_ONLY_ONE_SYNCHRONIZED_PROJECT"), WvcmException.ReasonCode.FORBIDDEN);
            }
            tgtCloneVH = null;
            if (tgtCloneVHPath != null && (controllableResource = InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtCloneVH = InteropStream.lookupClone(srcRootVH, tgtP, tgtCloneVHPath), f.nest(PR_VH_CLONE))) != null) {
                return controllableResource;
            }
            if (srcBCFLoc.equals(srcRoot.location())) {
                if (InteropStream.isNoComponentRootClone(tgtP)) {
                    VersionHistory tgtBCFVH = tgtBCF.getVersionHistory();
                    if (InteropStream.getProperty((Resource)tgtBCFVH, PN_CLONE) == null) {
                        tgtBCFVH.setProperty(PN_CLONE, (Object)(NO_CLONE_PREFIX + tgtBCFVH.getResourceIdentifier()));
                        tgtBCFVH.doWriteProperties(nowork);
                    }
                    ControllableFolder controllableFolder = tgtP.controllableFolder(tgtBCF.location().child(lastSegment));
                    break block14;
                } else {
                    ResourceList children = (ResourceList)InteropStream.doReadProperty((Resource)tgtBCF, ControllableFolder.CHILD_LIST, f);
                    if (isRoot && !children.isEmpty()) {
                        tgtBCF = (ControllableFolder)tgtBCF.doReadProperties(f.nest(PR_PATH));
                        String path = InteropStream.getFriendlyPathname((Resource)tgtBCF, 0, nowork);
                        String msg = f.format(Messages.getString("InteropStream.ERROR_DEST_MUST_BE_EMPTY"), new Object[]{path});
                        throw new WvcmException(msg, WvcmException.ReasonCode.CANNOT_OVERWRITE);
                    }
                    ControllableFolder controllableFolder = tgtBCF;
                    srcRoot = (ControllableResource)srcRoot.doReadProperties(f.nest(PR_VH_CLONE));
                    InteropStream.linkClones((Resource)controllableFolder.getVersionHistory(), (Resource)srcRoot.getVersionHistory(), f);
                    return controllableFolder;
                }
            }
            Location srcParentLoc = srcRoot.location().parent();
            ControllableFolder srcParent = srcP.controllableFolder(srcParentLoc);
            ControllableResource tgtParent = InteropStream.createTgtCloneRoot(false, tgtBCF, tgtWorkspace, (ControllableResource)srcParent, srcBCFLoc, f);
            Location tgtRootLoc = tgtParent.location().child(lastSegment);
            if (srcRootWithCloneInfo instanceof ControllableFolder) {
                ControllableFolder controllableFolder = tgtP.controllableFolder(tgtRootLoc);
            } else {
                ControllableResource controllableResource2 = tgtP.controllableResource(tgtRootLoc);
            }
        }
        try {
            InteropStream.forceAbortWvcmException(var10_17.provider(), 17, f);
            ControllableResource tgtRootTmp = (ControllableResource)var10_17.doReadProperties(f.nest(PR_PATH));
            String path = InteropStream.getFriendlyPathname((Resource)tgtRootTmp, 0, nowork);
            String msg = f.format(Messages.getString("InteropStream.ERROR_CLONE_PARENT_IS_FILE"), new Object[]{path});
            throw new WvcmException(msg, WvcmException.ReasonCode.CANNOT_OVERWRITE);
        }
        catch (WvcmException e) {
            void var10_20;
            if (!e.getReasonCode().equals((Object)WvcmException.ReasonCode.NOT_FOUND)) {
                throw e;
            }
            if (tgtCloneVH != null) {
                Version tgtPredecessor = (Version)InteropStream.doReadProperty((Resource)tgtCloneVH, VersionHistory.ROOT_VERSION, nowork);
                f.notifyActive(f.format(Messages.getString("InteropStream.MSG_RESTORING_ROOT"), new Object[]{lastSegment}));
                ControllableResource controllableResource = var10_17.doCreateVersionControlledResource(tgtPredecessor, nowork);
                return var10_20;
            }
            var10_17.doCreateResource(f.nest(75));
            if (!(var10_17 instanceof ControllableFolder)) {
                Version srcVersion = (Version)InteropStream.doReadProperty((Resource)srcRoot, ControllableResource.CHECKED_IN, nowork);
                InteropStream.copyVersionToCR((ControllableResource)var10_17, srcVersion, true, nowork);
            }
            ControllableResource controllableResource = var10_17.doVersionControl(f.nest(PR_VH_CLONE, 100));
            InteropStream.linkClones((Resource)controllableResource.getVersionHistory(), (Resource)srcRootWithCloneInfo.getVersionHistory(), f);
            return var10_20;
        }
    }

    private static ControllableResource bringoverTgtClone(Workspace tgtWorkspace, Stream tgtStream, InteropStreamSegment tgtSegment, ControllableResource srcCloneRoot, Workspace srcWorkspace, Feedback f) throws WvcmException {
        WorkspaceProvider tgtP = tgtWorkspace.workspaceProvider();
        WorkspaceProvider srcP = srcWorkspace.workspaceProvider();
        ControllableResource tgtCloneRoot = null;
        boolean isOverwrite = false;
        VersionHistory srcVH = srcCloneRoot.getVersionHistory();
        String tgtCloneVHPath = InteropStream.lookupClonePath(srcVH, tgtP);
        if (tgtCloneVHPath != null && tgtCloneVHPath.startsWith(NO_CLONE_PREFIX)) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_ONLY_ONE_SYNCHRONIZED_PROJECT"), WvcmException.ReasonCode.FORBIDDEN);
        }
        VersionHistory tgtCloneVH = InteropStream.lookupClone(srcVH, tgtP, tgtCloneVHPath);
        if (tgtCloneVH != null) {
            isOverwrite = true;
            tgtCloneRoot = InteropStream.doFindCRInWorkspace(tgtWorkspace, tgtCloneVH, f.nest(PR_CFG_WS_VH_CLONE));
        }
        if (tgtCloneRoot == null) {
            Configuration srcConfig = srcCloneRoot.getConfiguration();
            ControllableFolder tgtBCF = InteropStream.getTgtBaselineControlledFolder(tgtWorkspace, srcConfig, f.nest(PR_VH_CLONE));
            Location srcBCFPath = srcConfig.getRootFolder().getPathnameLocation();
            ControllableResource srcRoot = srcP.controllableResource(srcCloneRoot.getPathnameLocation());
            tgtCloneRoot = InteropStream.createTgtCloneRoot(true, tgtBCF, tgtWorkspace, srcRoot, srcBCFPath, f.nest(10));
            tgtCloneRoot = (ControllableResource)tgtCloneRoot.doReadProperties(f.nest(PR_CFG_WS_VH_CLONE));
        }
        List<ControllableResource> tgtRoots = InteropStream.getSyncRoots(tgtWorkspace, tgtSegment, f.nest(PR_PATH));
        HashSet<String> tgtRootPaths = new HashSet<String>();
        for (ControllableResource tgtRoot : tgtRoots) {
            if (tgtRoot == null) continue;
            tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
        }
        InteropStream.bringoverTree(tgtCloneRoot, tgtStream, tgtRootPaths, srcCloneRoot, f.nest(90));
        InteropStream.commitChanges(srcCloneRoot, tgtWorkspace, tgtStream, isOverwrite, f.nest(100));
        return tgtCloneRoot;
    }

    private static ControllableResource findCloneRoot(ControllableResource cr, Workspace ws, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        VersionHistory vh = (VersionHistory)InteropStream.doReadProperty((Resource)cr, ControllableResource.VERSION_HISTORY, nowork);
        ControllableResource rootCR = InteropStream.doFindCRInWorkspace(ws, vh, (Feedback)f.getPropertyRequestForResult());
        if (rootCR == null) {
            cr = (ControllableResource)cr.doReadProperties(f.nest(PR_PATH));
            String name = InteropStream.getFriendlyPathname((Resource)cr, 200, nowork);
            Version ver = InteropStream.doFindVersionInWorkspace(ws, vh, nowork);
            String msg = ver != null && ver instanceof SymbolicLinkVersion ? Messages.getString("InteropStream.ERROR_SYMLINK_CANNOT_BE_A_ROOT") : Messages.getString("InteropStream.ERROR_ROOT_NOT_FOUND");
            throw new WvcmException(f.format(msg, new Object[]{name}), (Resource)cr, WvcmException.ReasonCode.CONFLICT);
        }
        if (rootCR.getConfiguration() == null) {
            throw new WvcmException(Messages.getString("InteropStream.ERROR_ROOT_MUST_BE_IN_CONFIGURATION"), (Resource)rootCR, WvcmException.ReasonCode.CONFLICT);
        }
        return rootCR;
    }

    private void internalDeleteSyncRoots(boolean isThis, Collection<VersionHistory> deletedSyncRoots, Feedback f) throws WvcmException {
        if (deletedSyncRoots.size() == 0) {
            return;
        }
        HashSet<String> dsrPaths = new HashSet<String>(deletedSyncRoots.size());
        for (VersionHistory dvh : deletedSyncRoots) {
            dsrPaths.add(dvh.location().string());
        }
        String[] thisSyncRootPaths = this.thisSegment().get_syncRootPaths();
        String[] otherSyncRootPaths = this.otherSegment().get_syncRootPaths();
        String[] compareSyncRootPaths = isThis ? thisSyncRootPaths : otherSyncRootPaths;
        ArrayList<String> newThisSyncRootList = new ArrayList<String>();
        ArrayList<String> newOtherSyncRootList = new ArrayList<String>();
        int i = 0;
        while (i < compareSyncRootPaths.length) {
            if (!dsrPaths.contains(compareSyncRootPaths[i])) {
                newThisSyncRootList.add(thisSyncRootPaths[i]);
                newOtherSyncRootList.add(otherSyncRootPaths[i]);
            }
            ++i;
        }
        int newSize = newThisSyncRootList.size();
        String[] newThisSyncRootPaths = new String[newSize];
        String[] newOtherSyncRootPaths = new String[newSize];
        int i2 = 0;
        while (i2 < newSize) {
            newThisSyncRootPaths[i2] = (String)newThisSyncRootList.get(i2);
            newOtherSyncRootPaths[i2] = (String)newOtherSyncRootList.get(i2);
            ++i2;
        }
        this.thisSegment().set_syncRootPaths(newThisSyncRootPaths);
        this.otherSegment().set_syncRootPaths(newOtherSyncRootPaths);
        HashSet<VersionHistory> otherComponents = new HashSet<VersionHistory>();
        List<ControllableResource> otherRoots = this.otherSyncRoots(this.otherSyncWs(), f.nest(PR_CONFIG_VH, 70));
        for (ControllableResource otherRoot : otherRoots) {
            otherComponents.add(otherRoot.getConfiguration().getVersionHistory());
        }
        ArrayList<String> newBaselines = new ArrayList<String>();
        ResourceList<Baseline> oldBaselines = this.getSentoverBaselines(f.nest(PR_VH, 100));
        for (Baseline b : oldBaselines) {
            if (!otherComponents.contains(b.getVersionHistory())) continue;
            newBaselines.add(b.getResourceIdentifier());
        }
        String[] baselineNames = newBaselines.toArray(new String[newBaselines.size()]);
        this.otherSegment().set_sentoverBaselinePaths(baselineNames);
    }

    private void deleteAllSyncRoots() {
        this.thisSegment().set_syncRootPaths(new String[0]);
        this.otherSegment().set_syncRootPaths(new String[0]);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void internalSetCloneRoot(boolean isImport, InteropStreamSegment srcSegment, Workspace srcWorkspace, InteropStreamSegment tgtSegment, Workspace tgtWorkspace, Stream tgtStream, String[] syncRootPaths, Feedback f) throws WvcmException {
        block22: {
            nowork = f.nest();
            fcrNoWork = f.nest(InteropStream.PR_CFG_RF_WS_VH_CLONE);
            srcP = srcSegment.provider();
            size = syncRootPaths.length;
            processedSyncRootPaths = new ArrayList<String>(size);
            processedSrcRootNames = new ArrayList<String>(size);
            processedTgtRootNames = new ArrayList<String>(size);
            otherConfigurations = new HashSet<Configuration>();
            exceptions = new ArrayList<WvcmException>();
            try {
                InteropStream.forceAbortWvcmException((Provider)srcP, 18, f);
                factor = InteropStream.FB_LOOP_FACTOR(0, 80, size);
                i = 0;
                while (i < size) {
                    base = InteropStream.FB_BASE(0, 80, i, size);
                    srcCFPath = syncRootPaths[i];
                    try {
                        InteropStream.forceAbortWvcmException((Provider)srcP, 19, f);
                        srcCR = srcP.controllableResource(srcP.location(srcCFPath));
                        srcCloneRoot = InteropStream.findCloneRoot(srcCR, srcWorkspace, fcrNoWork);
                        f.notifyPercentComplete(base + 4 / factor);
                        tgtCloneRoot = InteropStream.bringoverTgtClone(tgtWorkspace, tgtStream, tgtSegment, srcCloneRoot, srcWorkspace, f.nest(base + 100 / factor));
                        processedSyncRootPaths.add(srcCFPath);
                        processedSrcRootNames.add(srcCloneRoot.getVersionHistory().location().string());
                        processedTgtRootNames.add(tgtCloneRoot.getVersionHistory().location().string());
                        if (isImport) {
                            otherConfigurations.add(srcCloneRoot.getConfiguration());
                        } else {
                            otherConfigurations.add(tgtCloneRoot.getConfiguration());
                        }
                    }
                    catch (WvcmException e) {
                        exceptions.add(e);
                    }
                    ++i;
                }
            }
            finally {
                numberProcessed = processedSrcRootNames.size();
                if (numberProcessed <= 0) break block22;
                oldSize = srcSegment.numSyncRoots();
                oldSrcRootPaths = new HashSet<String>(oldSize);
                path /* !! */  = srcSegment.get_syncRootPaths();
                errSyncRootPaths = path /* !! */ .length;
                newTgtRootNames = 0;
                ** while (newTgtRootNames < errSyncRootPaths)
            }
lbl-1000:
            // 1 sources

            {
                oldPath = path /* !! */ [newTgtRootNames];
                oldSrcRootPaths.add(oldPath);
                ++newTgtRootNames;
                continue;
            }
lbl56:
            // 1 sources

            newSrcRootNames = new ArrayList<String>();
            newTgtRootNames = new ArrayList<String>();
            i = 0;
            while (i < numberProcessed) {
                if (!oldSrcRootPaths.contains(processedSrcRootNames.get(i))) {
                    newSrcRootNames.add((String)processedSrcRootNames.get(i));
                    newTgtRootNames.add((String)processedTgtRootNames.get(i));
                }
                ++i;
            }
            if (newSrcRootNames.size() > 0) {
                newSrcRootPaths = new String[oldSize + numberProcessed];
                newTgtRootPaths = new String[oldSize + numberProcessed];
                i = 0;
                while (i < oldSize) {
                    newSrcRootPaths[i] = srcSegment.get_syncRootPaths()[i];
                    newTgtRootPaths[i] = tgtSegment.get_syncRootPaths()[i];
                    ++i;
                }
                i = 0;
                while (i < numberProcessed) {
                    newSrcRootPaths[i + oldSize] = (String)processedSrcRootNames.get(i);
                    newTgtRootPaths[i + oldSize] = (String)processedTgtRootNames.get(i);
                    ++i;
                }
                srcSegment.set_syncRootPaths(newSrcRootPaths);
                tgtSegment.set_syncRootPaths(newTgtRootPaths);
            }
            if (numberProcessed == this._newSyncRootPaths.length) {
                this._newSyncRootPaths = null;
            } else {
                errSyncRootPaths = new ArrayList<String[]>();
                var35_55 = this._newSyncRootPaths;
                var34_57 = this._newSyncRootPaths.length;
                var33_53 = 0;
                while (var33_53 < var34_57) {
                    path /* !! */  = var35_55[var33_53];
                    if (!processedSyncRootPaths.contains(path /* !! */ )) {
                        errSyncRootPaths.add(path /* !! */ );
                    }
                    ++var33_53;
                }
                this._newSyncRootPaths = errSyncRootPaths.size() == 0 ? null : errSyncRootPaths.toArray(new String[errSyncRootPaths.size()]);
            }
            this.updateISMetadata(nowork);
        }
        this.addBroughtover(isImport, otherConfigurations, f.nest(90));
        if (isImport) {
            thisInternalWs = this.thisInternalWs();
            thisInternalWs.doUpdate(InteropStream.makeList(this.thisCloneStream()), f.nest(95));
            thisInternalWs.doMerge(InteropStream.makeList(this.thisSyncStream()), InteropStream.MF_NO_CHECKOUTS_UPDATE, f.nest(100));
        }
        if (exceptions.size() > 0) {
            msg = Messages.getString("InteropStream.ERROR_ADD_SYNC_FILES_FAILED");
            if (isImport) {
                thisCloneWs = this.thisCloneWs();
                thisCloneWs.doCheckinAll(Messages.getString("InteropStream.MSG_FAILED_IMPORT"), null, nowork);
                InteropStream.updateStreamWithWorkspace(this.thisCloneStream(), thisCloneWs, nowork);
            }
            if (exceptions.size() == 1) {
                throw (WvcmException)exceptions.get(0);
            }
            e = new WvcmException(msg, null, WvcmException.ReasonCode.CONFLICT, (Throwable)exceptions.get(0), (Throwable[])exceptions.toArray(new WvcmException[exceptions.size()]));
            throw e;
        }
    }

    private void internalSetCloneRoots(Feedback f) throws WvcmException {
        boolean isImport;
        if (this._operation.equals((Object)InteropStreamOperation.EXPORT)) {
            isImport = false;
        } else if (this._operation.equals((Object)InteropStreamOperation.IMPORT)) {
            isImport = true;
        } else {
            throw new WvcmException("Illegal operation: " + (Object)((Object)this._operation), WvcmException.ReasonCode.FORBIDDEN);
        }
        if (isImport) {
            this.internalSetCloneRoot(isImport, this.otherSegment(), this.otherSyncWs(), this.thisSegment(), this.thisCloneWs(), this.thisCloneStream(), this._newSyncRootPaths, f.nest(100));
        } else {
            Feedback nowork = f.nest();
            this.set_state(InteropStreamState.SENDOVER_ACTIVE);
            this.updateISMetadata(nowork);
            this.internalSetCloneRoot(isImport, this.thisSegment(), this.thisCloneWs(), this.otherSegment(), this.otherSyncWs(), this.otherSyncStream(), this._newSyncRootPaths, f.nest(100));
            this.set_state(InteropStreamState.OPERATION_ACTIVE);
            this.updateISMetadata(nowork);
        }
    }

    private void desync(String desyncVal, Feedback f) throws WvcmException {
        if (!this._operation.equals((Object)InteropStreamOperation.EXPORT)) {
            throw new WvcmException("Can only DESYNC Jazz files", WvcmException.ReasonCode.CONFLICT);
        }
        WorkspaceProvider thisP = this.thisProvider();
        this.lockInteropStream(f);
        try {
            InteropStream.forceAbortWvcmException((Provider)thisP, 20, f);
            this.internalSetSyncState(InteropStreamState.OPERATION_ACTIVE, f);
            String[] stringArray = this._newSyncRootPaths;
            int n = this._newSyncRootPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String thisRootPath = stringArray[n2];
                try {
                    InteropStream.forceAbortWvcmException((Provider)thisP, 21, f);
                    ControllableResource root = thisP.controllableResource(thisP.location(thisRootPath));
                    root = (ControllableResource)root.doReadProperties(f.nest(PR_PATH_VH_CLONE));
                    String name = InteropStream.getFriendlyPathname((Resource)root, 0, f);
                    if (desyncVal.equals(DESYNC_COMPONENT)) {
                        root = (ControllableResource)root.doReadProperties(f.nest(PR_CONFIG_VH_CLONE));
                        root = root.getConfiguration();
                        name = f.format(Messages.getString("InteropStream.MSG_COMPONENT_OF"), new Object[]{name});
                    }
                    VersionHistory vh = root.getVersionHistory();
                    String msg = f.format(Messages.getString("InteropStream.MSG_NOT_CURRENTLY_SYNCHRONIZED"), new Object[]{name});
                    if (InteropStream.getProperty((Resource)vh, PN_CLONE) != null) {
                        vh.removeProperty(PN_CLONE);
                        vh.doWriteProperties(f);
                        msg = f.format(Messages.getString("InteropStream.MSG_DESYNCHRONIZED"), new Object[]{name});
                    }
                    f.notifyActive(msg);
                }
                catch (WvcmException e) {
                    String msg = f.format(Messages.getString("InteropStream.ERROR_TRYING_TO_DESYNCHRONIZE"), new Object[]{e.getMessage()});
                    f.notifyWarning(msg);
                }
                ++n2;
            }
            this._newSyncRootPaths = null;
            this.thisSegment().put_initArgs(IA_DESYNC, EMPTY_STRING);
            this.set_state(InteropStreamState.OK);
            this.updateISMetadata(f);
        }
        finally {
            this.unlockInteropStream(f);
        }
    }

    private void internalPostOperation(InteropStreamOperation operation, List<ControllableResource> roots) {
        this._operation = operation;
        this._newSyncRootPaths = null;
        if (roots != null) {
            this._newSyncRootPaths = new String[roots.size()];
            int i = 0;
            while (i < roots.size()) {
                this._newSyncRootPaths[i] = roots.get(i).location().string();
                ++i;
            }
        }
        this.set_state(InteropStreamState.OPERATION_PENDING);
    }

    private void postOperation(InteropStreamOperation operation, List<ControllableResource> roots, Feedback f) throws WvcmException {
        this.lockInteropStream(f);
        try {
            InteropStream.forceAbortWvcmException((Provider)this.thisProvider(), 22, f);
            this.internalPostOperation(operation, roots);
            this.updateISMetadata(f.nest(40));
        }
        finally {
            this.unlockInteropStream(f.nest(100));
        }
    }

    public String toString() {
        try {
            InteropStream.forceWvcmException((Provider)this.thisProvider(), 23);
            return (String)InteropStream.doReadProperty((Resource)this.thisSyncStream(), Stream.DISPLAY_NAME, null);
        }
        catch (WvcmException wvcmException) {
            return this.unparse();
        }
    }

    public InteropStreamSegment thisSegment() {
        return this._thisSegment;
    }

    public InteropStreamSegment otherSegment() {
        return this._otherSegment;
    }

    public InteropStreamState get_state() {
        return this.thisSegment().get_state();
    }

    private void set_state(InteropStreamState state) {
        this.thisSegment().set_state(state);
    }

    public InteropStreamOperation get_operation() {
        if (this.get_state().equals((Object)InteropStreamState.OPERATION_PENDING) && this._newSyncRootPaths == null) {
            return InteropStreamOperation.SYNCHRONIZE;
        }
        return this._operation;
    }

    public String[] get_unprocessedArguments() {
        if (this._newSyncRootPaths != null) {
            return (String[])this._newSyncRootPaths.clone();
        }
        return null;
    }

    public long lastAttemptedSyncDate() {
        return this._lastAttemptedSyncDate;
    }

    public long lastSyncDate() {
        return this._lastSyncDate;
    }

    public WorkspaceProvider thisProvider() throws WvcmException {
        return this.thisSegment().provider();
    }

    public WorkspaceProvider otherProvider() throws WvcmException {
        return this.otherSegment().provider();
    }

    public Stream thisCloneStream() throws WvcmException {
        return this.thisSegment().cloneStream();
    }

    public Workspace thisCloneWs() throws WvcmException {
        return this.thisSegment().cloneWs();
    }

    public Stream thisSyncStream() throws WvcmException {
        return this.thisSegment().syncStream();
    }

    public Workspace thisSyncWs() throws WvcmException {
        return this.thisSegment().syncWs();
    }

    public Stream thisInternalStream() throws WvcmException {
        return this.thisSegment().internalStream();
    }

    public Workspace thisInternalWs() throws WvcmException {
        return this.thisSegment().internalWs();
    }

    public Workspace thisMergeWs() throws WvcmException {
        WorkspaceProvider p = this.thisProvider();
        String wsPath = (String)this.thisProvider().initArgs().get(IA_MERGE_WORKSPACE);
        if (wsPath == null) {
            return null;
        }
        return p.workspace(p.location(wsPath));
    }

    public List<ControllableResource> thisSyncRoots(Workspace ws, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        List<ControllableResource> roots = this.getPrunedSyncRoots(true, ws, f);
        return roots;
    }

    public Stream otherSyncStream() throws WvcmException {
        return this.otherSegment().syncStream();
    }

    public Workspace otherSyncWs() throws WvcmException {
        return this.otherSegment().syncWs();
    }

    public List<ControllableResource> otherSyncRoots(Workspace ws, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        List<ControllableResource> roots = this.getPrunedSyncRoots(false, ws, f);
        return roots;
    }

    public static InteropStream getInteropStream(Stream syncStream, Feedback feedback) throws WvcmException {
        if (syncStream == null) {
            return null;
        }
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Stream stream = (Stream)syncStream.doReadProperties(f.nest(PR_IS));
        return InteropStream.parse(InteropStream.getProperty((Resource)stream, PN_INTEROP_STREAM), syncStream.provider().callback(), f);
    }

    public void initialize(Stream otherStream, Feedback feedback) throws WvcmException {
        long syncDate;
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        Stream otherSyncStream = otherStream;
        this.otherSegment().set_syncStreamPath(otherSyncStream.location().string());
        String otherSyncStreamName = (String)InteropStream.doReadProperty((Resource)otherSyncStream, Stream.DISPLAY_NAME, nowork);
        f.notifyPercentComplete(10);
        String otherWsName = this.createOtherWorkspaceName(otherSyncStreamName, nowork);
        Workspace otherSyncWs = InteropStream.createWorkspace(otherWsName, false, otherSyncStream, true, nowork);
        f.notifyPercentComplete(30);
        otherSyncWs.doMerge(InteropStream.makeList(otherSyncStream), null, nowork);
        f.notifyPercentComplete(40);
        this.otherSegment().set_syncWsPath(otherSyncWs.location().string());
        f.notifyPercentComplete(60);
        HashMap<String, String> otherInitArgs = new HashMap<String, String>();
        InteropStream.setHasCloneInfo(otherInitArgs, false);
        otherInitArgs.put(IA_OTHER_WORKSPACE_NAME, EMPTY_STRING);
        otherInitArgs.put(IA_OTHER_STREAM_LOCATION, otherStream.location().string());
        otherInitArgs.put(IA_WORKSPACE_PATH, otherSyncWs.location().string());
        otherInitArgs.put(IA_FORCE_EXCEPTION, EMPTY_STRING);
        this.otherSegment().putAll_initArgs(otherInitArgs);
        HashMap<String, String> thisInitArgs = new HashMap<String, String>();
        InteropStream.setHasCloneInfo(thisInitArgs, true);
        thisInitArgs.put(IA_DESYNC, EMPTY_STRING);
        thisInitArgs.put(IA_FORCE_EXCEPTION, EMPTY_STRING);
        this.thisSegment().putAll_initArgs(thisInitArgs);
        WorkspaceProvider thisP = this.thisProvider();
        Stream thisSyncStream = InteropStream.createStream(otherSyncStreamName, thisP, null, f.nest(PR_WORKSPACE));
        this.thisSegment().set_syncStreamPath(thisSyncStream.location().string());
        Workspace thisSyncWs = thisSyncStream.getWorkspace();
        this.thisSegment().set_syncWsPath(thisSyncWs.location().string());
        f.notifyPercentComplete(70);
        String internalWsName = f.format(INTERNAL_WORKSPACE_NAME, new Object[]{otherSyncStreamName});
        Workspace thisInternalWs = InteropStream.createWorkspace(internalWsName, true, thisSyncStream, true, f.nest(PR_STREAM));
        this.thisSegment().set_internalWsPath(thisInternalWs.location().string());
        Stream thisInternalStream = thisInternalWs.getStream();
        this.thisSegment().set_internalStreamPath(thisInternalStream.location().string());
        f.notifyPercentComplete(80);
        String cloneWsName = f.format(CLONE_WORKSPACE_NAME, new Object[]{otherSyncStreamName});
        Workspace thisCloneWs = InteropStream.createWorkspace(cloneWsName, true, thisSyncStream, true, f.nest(PR_STREAM));
        this.thisSegment().set_cloneWsPath(thisCloneWs.location().string());
        Stream thisCloneStream = thisCloneWs.getStream();
        this.thisSegment().set_cloneStreamPath(thisCloneStream.location().string());
        f.notifyPercentComplete(90);
        this._minorVersion = CURRENT_MINOR_VERSION;
        this._lastAttemptedSyncDate = syncDate = new Date().getTime();
        this._lastSyncDate = syncDate;
        this.updateISMetadata(nowork);
        f.notifyPercentComplete(100);
    }

    public void delete(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.thisSyncStream().doUnbindAll(f.nest(20));
        try {
            InteropStream.forceAbortWvcmException((Provider)this.thisProvider(), 24, f);
            this.otherSyncWs().doUnbindAll(f);
        }
        catch (WvcmException e) {
            f.notifyWarning(e.getLocalizedMessage());
        }
    }

    public InteropStream refresh(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Stream stream = (Stream)this.thisSyncStream().doReadProperties(f.nest(PR_IS, 50));
        String interopStreamValue = InteropStream.getProperty((Resource)stream, PN_INTEROP_STREAM);
        String[] field = interopStreamValue.split(TERMINATOR1, -1);
        long stateId = Long.parseLong(InteropStream.getStateIdField(field));
        if (stateId == this._stateId) {
            return this;
        }
        InteropStream result = InteropStream.parse(interopStreamValue, this.thisProvider().callback(), f);
        f.notifyPercentComplete(100);
        return result;
    }

    public void updateThisInitArgs(Map<String, String> newInitArgs, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.lockInteropStream(f);
        try {
            this.thisSegment().putAll_initArgs(newInitArgs);
            this.updateISMetadata(f);
        }
        finally {
            this.unlockInteropStream(f);
        }
    }

    public void updateOtherInitArgs(Map<String, String> newInitArgs, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.lockInteropStream(f);
        try {
            this.otherSegment().putAll_initArgs(newInitArgs);
            this.updateISMetadata(f);
        }
        finally {
            this.unlockInteropStream(f);
        }
    }

    public void setSyncPending(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.lockInteropStream(f);
        try {
            this.internalSetSyncState(InteropStreamState.OPERATION_PENDING, f);
        }
        finally {
            this.unlockInteropStream(f);
        }
    }

    public void setSyncFailed(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.lockInteropStream(f);
        try {
            this.internalSetSyncState(InteropStreamState.OPERATION_ERROR, f);
        }
        finally {
            this.unlockInteropStream(f);
        }
    }

    public void newOtherSyncStream(Stream otherStream, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.lockInteropStream(nowork);
        try {
            this.otherSegment().set_syncStreamPath(otherStream.location().string());
            String streamName = (String)InteropStream.doReadProperty((Resource)otherStream, Stream.DISPLAY_NAME, nowork);
            String wsName = this.createOtherWorkspaceName(streamName, nowork);
            Workspace otherWs = this.newInteropStreamWs(wsName, this.otherSegment(), this.otherSyncWs(), false, this.otherSyncStream(), f.nest(50));
            this.otherSegment().set_syncWsPath(otherWs.location().string());
            List<ControllableResource> roots = this.otherSyncRoots(this.otherSyncWs(), f.nest(90));
            this.internalPostOperation(InteropStreamOperation.IMPORT, roots);
            this.deleteAllSyncRoots();
            this.updateISMetadata(nowork);
        }
        finally {
            this.unlockInteropStream(f.nest(100));
        }
    }

    public void newOtherSyncWs(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.lockInteropStream(nowork);
        try {
            String streamName = (String)InteropStream.doReadProperty((Resource)this.otherSyncStream(), Stream.DISPLAY_NAME, nowork);
            String wsName = this.createOtherWorkspaceName(streamName, f);
            Workspace ws = this.newInteropStreamWs(wsName, this.otherSegment(), this.otherSyncWs(), false, this.otherSyncStream(), f.nest(95));
            this.otherSegment().set_syncWsPath(ws.location().string());
            this.updateISMetadata(nowork);
        }
        finally {
            this.unlockInteropStream(nowork);
            f.notifyPercentComplete(100);
        }
    }

    public void newThisCloneWs(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.lockInteropStream(nowork);
        try {
            String streamName = (String)InteropStream.doReadProperty((Resource)this.otherSyncStream(), Stream.DISPLAY_NAME, nowork);
            String wsName = f.format(INTERNAL_WORKSPACE_NAME, new Object[]{streamName});
            Workspace internalWs = this.newInteropStreamWs(wsName, this.thisSegment(), this.thisInternalWs(), true, this.thisSyncStream(), f.nest(PR_STREAM, 50));
            this.thisSegment().set_internalWsPath(internalWs.location().string());
            this.thisSegment().set_internalStreamPath(internalWs.getStream().location().string());
            wsName = f.format(CLONE_WORKSPACE_NAME, new Object[]{streamName});
            Workspace cloneWs = this.newInteropStreamWs(wsName, this.thisSegment(), this.thisCloneWs(), true, this.thisSyncStream(), f.nest(PR_STREAM, 95));
            this.thisSegment().set_cloneWsPath(cloneWs.location().string());
            this.thisSegment().set_cloneStreamPath(cloneWs.getStream().location().string());
            this.updateISMetadata(nowork);
            Workspace mergeWs = this.thisMergeWs();
            try {
                InteropStream.forceAbortWvcmException((Provider)this.thisProvider(), 25, f);
                mergeWs.setSourceList(InteropStream.makeList(this.thisCloneStream()));
                mergeWs.doWriteProperties(feedback);
            }
            catch (WvcmException wvcmException) {
                String mergeWsName = (String)InteropStream.doReadProperty((Resource)mergeWs, Workspace.DISPLAY_NAME, feedback);
                String msg = f.format(Messages.getString("InteropStream.WARNING_CANNOT_UPDATE_MERGEWS"), new Object[]{mergeWsName});
                f.notifyWarning(msg);
            }
        }
        finally {
            this.unlockInteropStream(f);
            f.notifyPercentComplete(100);
        }
    }

    public Workspace newThisMergeWs(String name, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        WorkspaceProvider thisP = this.thisProvider();
        Location loc = thisP.rootLocation().child(name);
        Workspace ws = thisP.workspace(loc);
        Stream stream = this.thisSyncStream();
        ws.setIsolatedTarget(stream);
        ResourceList streamList = thisP.resourceList((Resource[])new Stream[]{this.thisCloneStream()});
        ws.setSourceList(streamList);
        this.lockInteropStream(f.nest(10));
        try {
            ws = ws.doCreateGeneratedResource(f.nest(50));
            this.thisSegment().put_initArgs(IA_MERGE_WORKSPACE, ws.getResourceIdentifier());
            this.updateISMetadata(f.nest(55));
            ws.doUpdate(InteropStream.makeList(stream), f.nest(90));
            Workspace workspace = ws;
            return workspace;
        }
        finally {
            this.unlockInteropStream(f.nest(100));
        }
    }

    public void deleteThisSyncRoots(Collection<VersionHistory> thisSyncRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.lockInteropStream(f.nest(10));
        try {
            this.internalDeleteSyncRoots(true, thisSyncRoots, f.nest(90));
            this.updateISMetadata(f.nest(95));
        }
        finally {
            this.unlockInteropStream(f.nest(100));
        }
    }

    public void deleteOtherSyncRoots(Collection<VersionHistory> otherSyncRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.lockInteropStream(f.nest(10));
        try {
            this.internalDeleteSyncRoots(false, otherSyncRoots, f.nest(90));
            this.updateISMetadata(f.nest(95));
        }
        finally {
            this.unlockInteropStream(f.nest(100));
        }
    }

    public void importCloneRoots(List<ControllableResource> otherRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropStreamOperation.IMPORT, otherRoots, f);
    }

    public void exportCloneRoots(List<ControllableResource> thisRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropStreamOperation.EXPORT, thisRoots, f);
    }

    public void onlySync(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropStreamOperation.SYNCHRONIZE, null, f);
    }

    /*
     * Exception decompiling
     */
    public void sync(Feedback feedback) throws WvcmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class ChildException {
        public volatile Throwable ex = null;

        private ChildException() {
        }
    }

    private static class ContentReader
    extends Thread {
        private PipedOutputStream _pouts;
        private Resource _resource;
        private Feedback _feedback;
        private ChildException _childException;

        public ContentReader(Resource resource, PipedOutputStream pouts, ChildException childException, Feedback f) {
            this._resource = resource;
            this._pouts = pouts;
            this._childException = childException;
            this._feedback = f;
            this.start();
        }

        public void run() {
            try {
                try {
                    InteropStream.forceAbortWvcmException(this._resource.provider(), 7, this._feedback);
                    this._resource.doReadContent((OutputStream)this._pouts, this._feedback);
                }
                catch (Exception e) {
                    this._childException.ex = e;
                    try {
                        if (InteropStream.shouldForceException(this._resource.provider(), 8)) {
                            throw new IOException("Abort");
                        }
                        this._pouts.close();
                    }
                    catch (IOException e2) {
                        throw new RuntimeException("Could not close output stream", e2);
                    }
                }
            }
            finally {
                try {
                    if (InteropStream.shouldForceException(this._resource.provider(), 8)) {
                        throw new IOException("Abort");
                    }
                    this._pouts.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close output stream", e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InteropStreamOperation {
        INITIALIZE,
        SYNCHRONIZE,
        EXPORT,
        IMPORT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InteropStreamState {
        OK,
        MERGE_NEEDED,
        OPERATION_PENDING,
        OPERATION_ACTIVE,
        SENDOVER_ACTIVE,
        OPERATION_ERROR,
        SENDOVER_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LineSeparator {
        UNSPECIFIED,
        LF,
        CR,
        CRLF;

    }
}

