/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.wiki.transformer;

import com.ibm.team.apt.internal.common.wiki.transformer.ILexerInput;
import com.ibm.team.apt.internal.common.wiki.transformer.Symbol;
import com.ibm.team.apt.internal.common.wiki.transformer.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lexer {
    public static final int ESCAPE_CHAR = 126;
    private Node fDictTree;
    private ILexerInput fInput;
    private final Stack<Symbol> fHistory = new Stack();

    public Lexer() {
        this(Token.values());
    }

    public Lexer(Token ... tokens) {
        this.fDictTree = this.init(tokens);
    }

    protected Node init(Token[] tokens) {
        Node root = new Node(-1);
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            if (token.wiki != null) {
                char[] chars = token.wiki.toCharArray();
                int indexLast = chars.length - 1;
                Node current = root;
                int i = 0;
                while (i < chars.length) {
                    char ch = chars[i];
                    Node child = current.findChild(ch);
                    if (child == null) {
                        child = new Node(ch);
                        current.addChild(child);
                    }
                    if (i == indexLast) {
                        child.addToken(token);
                    }
                    current = child;
                    ++i;
                }
            }
            ++n2;
        }
        return root;
    }

    public void setInput(ILexerInput input) {
        this.fInput = input;
    }

    public Symbol nextSymbol() {
        return this.internalNextSymbol();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Symbol internalNextSymbol() {
        if (!this.fHistory.isEmpty()) {
            return this.fHistory.pop();
        }
        if (this.fInput.eof()) {
            return Symbol.EOF;
        }
        int read = this.fInput.read();
        if (read == -1) return Symbol.EOF;
        List<Token> result = this.checkDictTree(read);
        if (result != null) {
            return new Symbol((Object)result.get((int)0).wiki, result);
        }
        if (read != 126) return new Symbol((Object)Character.valueOf((char)read), Token.CHARACTER);
        if (!this.checkTokens(Token.WHITESPACE, Token.TAB, Token.LF, Token.CR, Token.CR_LF, Token.EOF).isEmpty()) return new Symbol((Object)Character.valueOf((char)read), Token.CHARACTER);
        read = this.fInput.read();
        if (read == -1) return Symbol.EOF;
        return new Symbol((Object)Character.valueOf((char)read), Token.CHARACTER);
    }

    private List<Token> checkDictTree(int ch) {
        Node child = this.fDictTree.findChild(ch);
        if (child == null) {
            return null;
        }
        return this.internalCheckDictTree(child);
    }

    private List<Token> internalCheckDictTree(Node node) {
        List result = null;
        int read = this.fInput.read();
        Node child = node.findChild(read);
        if (child != null) {
            result = this.internalCheckDictTree(child);
        }
        if (child == null || result == null) {
            this.fInput.unread(read);
        }
        if (result == null && node.fTokens != null) {
            result = node.fTokens;
        }
        return result;
    }

    public void returnSymbol(Symbol symbol) {
        this.fHistory.push(symbol);
    }

    private List<Token> checkTokens(Token ... tokens) {
        LinkedList<Token> result = new LinkedList<Token>();
        Token[] tokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            Token t = this.checkToken(token);
            if (t != null) {
                result.add(t);
            }
            ++n2;
        }
        return result;
    }

    private Token checkToken(Token token) {
        if (token.wiki == null) {
            return null;
        }
        int len = token.wiki.length();
        char[] cbuf = this.fInput.read(len);
        if (cbuf != null) {
            this.fInput.unread(cbuf);
            if (token.wiki.toCharArray().equals(cbuf)) {
                return token;
            }
        }
        return null;
    }

    private static class Node {
        private int fCharacter;
        private List<Token> fTokens;
        private Map<Integer, Node> fChildren;

        public Node(int ch) {
            this.fCharacter = ch;
            this.fChildren = new HashMap<Integer, Node>(8);
        }

        public void addToken(Token token) {
            if (this.fTokens == null) {
                this.fTokens = new ArrayList<Token>(5);
            }
            this.fTokens.add(token);
        }

        public void addChild(Node node) {
            this.fChildren.put(node.fCharacter, node);
        }

        public Node findChild(int ch) {
            Node node = this.fChildren.get(ch);
            return node;
        }
    }
}

