/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.preferences.ConfigurationPreferences;
import org.eclipse.core.internal.preferences.DefaultPreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.preferences.InstancePreferences;
import org.eclipse.core.internal.preferences.LookupOrder;
import org.eclipse.core.internal.preferences.PreferenceServiceRegistryHelper;
import org.eclipse.core.internal.preferences.PreferencesService$$Cold;
import org.eclipse.core.internal.preferences.PreferencesService$1;
import org.eclipse.core.internal.preferences.PreferencesService$4;
import org.eclipse.core.internal.preferences.PreferencesService$5;
import org.eclipse.core.internal.preferences.PreferencesService$7;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.preferences.StringPool;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.PreferenceFilterEntry;
import org.eclipse.core.runtime.preferences.PreferenceModifyListener;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferencesService
implements IPreferencesService {
    private static final long STRING_SHARING_INTERVAL = 300000L;
    private static final String[] DEFAULT_DEFAULT_LOOKUP_ORDER = new String[]{"project", "instance", "configuration", "default"};
    private static final char EXPORT_ROOT_PREFIX = '!';
    private static final char BUNDLE_VERSION_PREFIX = '@';
    private static final float EXPORT_VERSION = 3.0f;
    private static final String VERSION_KEY = "file_export_version";
    private static final String EMPTY_STRING = "";
    private static PreferencesService instance;
    static final RootPreferences root;
    private static final Map defaultsRegistry;
    private Object registryHelper = null;
    private Map defaultScopes = new HashMap();
    private long lastStringSharing = 0L;

    static {
        root = new RootPreferences();
        defaultsRegistry = Collections.synchronizedMap(new HashMap());
    }

    public static PreferencesService getDefault() {
        if (instance == null) {
            instance = new PreferencesService();
        }
        return instance;
    }

    static void log(IStatus iStatus) {
        RuntimeLog.log((IStatus)iStatus);
    }

    PreferencesService() {
        this.initializeDefaultScopes();
    }

    private void initializeDefaultScopes() {
        this.defaultScopes.put("default", new DefaultPreferences());
        ((EclipsePreferences)root).addChild("default", null);
        this.defaultScopes.put("instance", new InstancePreferences());
        ((EclipsePreferences)root).addChild("instance", null);
        this.defaultScopes.put("configuration", new ConfigurationPreferences());
        ((EclipsePreferences)root).addChild("configuration", null);
    }

    public IEclipsePreferences createNode(String string) {
        IScope iScope = (IScope)this.defaultScopes.get(string);
        if (iScope == null) {
            if (this.registryHelper == null) {
                return new EclipsePreferences(root, string);
            }
            return ((PreferenceServiceRegistryHelper)this.registryHelper).createNode(root, string);
        }
        return iScope.create(root, string);
    }

    public IEclipsePreferences getRootNode() {
        return root;
    }

    private boolean isLegacy(Properties properties) {
        return properties.getProperty(VERSION_KEY) == null;
    }

    public void setRegistryHelper(Object object) {
        if (this.registryHelper != null && this.registryHelper != object) {
            ((PreferenceServiceRegistryHelper)this.registryHelper).stop();
        }
        this.registryHelper = object;
    }

    void shareStrings() {
        long l = System.currentTimeMillis();
        if (l - this.lastStringSharing < 300000L) {
            return;
        }
        StringPool stringPool = new StringPool();
        ((EclipsePreferences)root).shareStrings(stringPool);
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            System.out.println("Preference string sharing saved: " + stringPool.getSavedStringCount());
        }
        this.lastStringSharing = l;
    }

    private static IStatus createStatusError(String string, Exception exception) throws  {
        return PreferencesService$$Cold.createStatusError(string, exception);
    }

    public void applyPreferences(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray) throws CoreException {
        if (iPreferenceFilterArray == null || iPreferenceFilterArray.length == 0) {
            return;
        }
        try {
            this.internalApply(iEclipsePreferences, iPreferenceFilterArray);
            try {
                this.getRootNode().node(iEclipsePreferences.absolutePath()).flush();
            }
            catch (BackingStoreException backingStoreException) {
                throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_saveProblems, backingStoreException));
            }
            this.lastStringSharing = 0L;
            this.shareStrings();
        }
        catch (BackingStoreException backingStoreException) {
            throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_applyProblems, backingStoreException));
        }
    }

    public IStatus applyPreferences(IExportedPreferences iExportedPreferences) throws CoreException {
        if (iExportedPreferences == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Applying exported preferences: " + ((EclipsePreferences)((Object)iExportedPreferences)).toDeepDebugString());
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.preferences", 0, PrefsMessages.preferences_applyProblems, null);
        IEclipsePreferences iEclipsePreferences = this.firePreApplyEvent(iExportedPreferences);
        PreferencesService$1 preferencesService$1 = new PreferencesService$1(this);
        try {
            iEclipsePreferences.accept(preferencesService$1);
        }
        catch (BackingStoreException backingStoreException) {
            throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_applyProblems, backingStoreException));
        }
        try {
            this.getRootNode().node(iEclipsePreferences.absolutePath()).flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_saveProblems, backingStoreException));
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Current list of all settings: " + ((EclipsePreferences)this.getRootNode()).toDeepDebugString());
        }
        this.lastStringSharing = 0L;
        this.shareStrings();
        return (IStatus)multiStatus;
    }

    private boolean containsKeys(IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
        return PreferencesService$$Cold.containsKeys(this, iEclipsePreferences);
    }

    private Properties convertFromLegacy(Properties properties) throws  {
        return PreferencesService$$Cold.convertFromLegacy(this, properties);
    }

    private IExportedPreferences convertFromProperties(Properties properties) throws  {
        return PreferencesService$$Cold.convertFromProperties(this, properties);
    }

    private Properties convertToProperties(IEclipsePreferences iEclipsePreferences, String[] stringArray) throws BackingStoreException {
        return PreferencesService$$Cold.convertToProperties(this, iEclipsePreferences, stringArray);
    }

    void copyFromTo(Preferences preferences, Preferences preferences2, String[] stringArray, int n) throws BackingStoreException {
        PreferencesService$$Cold.copyFromTo(this, preferences, preferences2, stringArray, n);
    }

    public WeakReference applyRuntimeDefaults(String string, WeakReference weakReference) {
        if (this.registryHelper == null) {
            return null;
        }
        return ((PreferenceServiceRegistryHelper)this.registryHelper).applyRuntimeDefaults(string, weakReference);
    }

    public void exportPreferences(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray, OutputStream outputStream) throws CoreException {
        if (iPreferenceFilterArray == null || iPreferenceFilterArray.length == 0) {
            return;
        }
        try {
            this.internalExport(iEclipsePreferences, iPreferenceFilterArray, outputStream);
        }
        catch (BackingStoreException backingStoreException) {
            throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_exportProblems, backingStoreException));
        }
    }

    public IStatus exportPreferences(IEclipsePreferences iEclipsePreferences, OutputStream outputStream, String[] stringArray) throws CoreException {
        if (iEclipsePreferences == null || outputStream == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        Properties properties = null;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        try {
            properties = this.convertToProperties(iEclipsePreferences, stringArray);
            if (((Hashtable)properties).isEmpty()) {
                return Status.OK_STATUS;
            }
            ((Hashtable)properties).put(VERSION_KEY, Float.toString(3.0f));
            ((Hashtable)properties).put(String.valueOf('!') + iEclipsePreferences.absolutePath(), EMPTY_STRING);
        }
        catch (BackingStoreException backingStoreException) {
            throw (Throwable)new CoreException(PreferencesService.createStatusError(((Throwable)backingStoreException).getMessage(), backingStoreException));
        }
        try {
            properties.store(outputStream, null);
        }
        catch (IOException iOException) {
            throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_exportProblems, iOException));
        }
        return Status.OK_STATUS;
    }

    private IEclipsePreferences firePreApplyEvent(IEclipsePreferences iEclipsePreferences) {
        if (this.registryHelper == null) {
            return iEclipsePreferences;
        }
        IEclipsePreferences[] iEclipsePreferencesArray = new IEclipsePreferences[]{iEclipsePreferences};
        PreferenceModifyListener[] preferenceModifyListenerArray = ((PreferenceServiceRegistryHelper)this.registryHelper).getModifyListeners();
        int n = 0;
        while (n < preferenceModifyListenerArray.length) {
            PreferenceModifyListener preferenceModifyListener = preferenceModifyListenerArray[n];
            PreferencesService$4 preferencesService$4 = new PreferencesService$4(this, iEclipsePreferencesArray, preferenceModifyListener);
            SafeRunner.run((ISafeRunnable)preferencesService$4);
            ++n;
        }
        return iEclipsePreferencesArray[0];
    }

    public String get(String string, String string2, Preferences[] preferencesArray) throws  {
        return PreferencesService$$Cold.get(this, string, string2, preferencesArray);
    }

    public boolean getBoolean(String string, String string2, boolean bl, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        return string3 == null ? bl : Boolean.valueOf(string3);
    }

    String getBundleName(String string) throws  {
        return PreferencesService$$Cold.getBundleName(this, string);
    }

    String getBundleVersion(String string) throws  {
        return PreferencesService$$Cold.getBundleVersion(this, string);
    }

    public byte[] getByteArray(String string, String string2, byte[] byArray, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        return string3 == null ? byArray : string3.getBytes();
    }

    public String[] getDefaultLookupOrder(String string, String string2) {
        LookupOrder lookupOrder = (LookupOrder)defaultsRegistry.get(this.getRegistryKey(string, string2));
        return lookupOrder == null ? null : lookupOrder.getOrder();
    }

    public double getDouble(String string, String string2, double d, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        if (string3 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public float getFloat(String string, String string2, float f, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        if (string3 == null) {
            return f;
        }
        try {
            return Float.parseFloat(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public int getInt(String string, String string2, int n, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        if (string3 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getLong(String string, String string2, long l, IScopeContext[] iScopeContextArray) {
        String string3 = this.get(EclipsePreferences.decodePath(string2)[1], null, this.getNodes(string, string2, iScopeContextArray));
        if (string3 == null) {
            return l;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public String[] getLookupOrder(String string, String string2) {
        String[] stringArray = this.getDefaultLookupOrder(string, string2);
        if (stringArray == null && string2 != null) {
            stringArray = this.getDefaultLookupOrder(string, null);
        }
        if (stringArray == null) {
            stringArray = DEFAULT_DEFAULT_LOOKUP_ORDER;
        }
        return stringArray;
    }

    private Preferences[] getNodes(String string, String string2, IScopeContext[] iScopeContextArray) throws  {
        return PreferencesService$$Cold.getNodes(this, string, string2, iScopeContextArray);
    }

    private String getRegistryKey(String string, String string2) throws  {
        return PreferencesService$$Cold.getRegistryKey(this, string, string2);
    }

    String getScope(String string) throws  {
        return PreferencesService$$Cold.getScope(this, string);
    }

    public String getString(String string, String string2, String string3, IScopeContext[] iScopeContextArray) {
        return this.get(EclipsePreferences.decodePath(string2)[1], string3, this.getNodes(string, string2, iScopeContextArray));
    }

    public IStatus importPreferences(InputStream inputStream) throws CoreException {
        return PreferencesService$$Cold.importPreferences(this, inputStream);
    }

    private void internalApply(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray) throws BackingStoreException {
        ArrayList<IEclipsePreferences> arrayList = new ArrayList<IEclipsePreferences>();
        int n = 0;
        while (n < iPreferenceFilterArray.length) {
            arrayList.add(this.trimTree(iEclipsePreferences, iPreferenceFilterArray[n]));
            ++n;
        }
        IEclipsePreferences iEclipsePreferences2 = this.mergeTrees(arrayList.toArray(new IEclipsePreferences[arrayList.size()]));
        iEclipsePreferences2 = this.firePreApplyEvent(iEclipsePreferences2);
        PreferencesService$5 preferencesService$5 = new PreferencesService$5(this);
        iEclipsePreferences2.accept(preferencesService$5);
    }

    private void internalExport(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray, OutputStream outputStream) throws BackingStoreException, CoreException {
        ArrayList<IEclipsePreferences> arrayList = new ArrayList<IEclipsePreferences>();
        int n = 0;
        while (n < iPreferenceFilterArray.length) {
            arrayList.add(this.trimTree(iEclipsePreferences, iPreferenceFilterArray[n]));
            ++n;
        }
        IEclipsePreferences iEclipsePreferences2 = this.mergeTrees(arrayList.toArray(new IEclipsePreferences[arrayList.size()]));
        this.exportPreferences(iEclipsePreferences2, outputStream, null);
    }

    private boolean internalMatches(IEclipsePreferences iEclipsePreferences, IPreferenceFilter iPreferenceFilter) throws BackingStoreException {
        String[] stringArray = iPreferenceFilter.getScopes();
        if (stringArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        String string = iEclipsePreferences.absolutePath();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            Map map = iPreferenceFilter.getMapping(string2);
            if (map == null) {
                if (iEclipsePreferences.parent() == null && iEclipsePreferences.nodeExists(string2)) {
                    return this.containsKeys((IEclipsePreferences)iEclipsePreferences.node(string2));
                }
                if (this.scopeMatches(string2, iEclipsePreferences) && this.containsKeys(iEclipsePreferences)) {
                    return true;
                }
            } else {
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    PreferenceFilterEntry[] preferenceFilterEntryArray;
                    String string3 = (String)iterator.next();
                    String string4 = String.valueOf('/') + string2 + '/' + string3;
                    if (!string4.startsWith(string)) continue;
                    String string5 = string4.substring(string.length());
                    if (!iEclipsePreferences.nodeExists(string5 = EclipsePreferences.makeRelative(string5))) continue;
                    try {
                        preferenceFilterEntryArray = (PreferenceFilterEntry[])map.get(string3);
                    }
                    catch (ClassCastException classCastException) {
                        PreferencesService.log(PreferencesService.createStatusError(PrefsMessages.preferences_classCastFilterEntry, classCastException));
                        continue;
                    }
                    Preferences preferences = iEclipsePreferences.node(string5);
                    if (preferenceFilterEntryArray == null) {
                        return preferences.keys().length != 0 || preferences.childrenNames().length != 0;
                    }
                    int n2 = 0;
                    while (n2 < preferenceFilterEntryArray.length) {
                        if (preferenceFilterEntryArray[n2] != null && preferences.get(preferenceFilterEntryArray[n2].getKey(), null) != null) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return false;
    }

    private IPreferenceFilter[] internalMatches(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray) throws BackingStoreException {
        ArrayList<IPreferenceFilter> arrayList = new ArrayList<IPreferenceFilter>();
        int n = 0;
        while (n < iPreferenceFilterArray.length) {
            if (this.internalMatches(iEclipsePreferences, iPreferenceFilterArray[n])) {
                arrayList.add(iPreferenceFilterArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IPreferenceFilter[arrayList.size()]);
    }

    public IPreferenceFilter[] matches(IEclipsePreferences iEclipsePreferences, IPreferenceFilter[] iPreferenceFilterArray) throws CoreException {
        if (iPreferenceFilterArray == null || iPreferenceFilterArray.length == 0) {
            return new IPreferenceFilter[0];
        }
        try {
            return this.internalMatches(iEclipsePreferences, iPreferenceFilterArray);
        }
        catch (BackingStoreException backingStoreException) {
            throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_matching, backingStoreException));
        }
    }

    private IEclipsePreferences mergeTrees(IEclipsePreferences[] iEclipsePreferencesArray) throws BackingStoreException {
        return PreferencesService$$Cold.mergeTrees(this, iEclipsePreferencesArray);
    }

    public IExportedPreferences readPreferences(InputStream inputStream) throws CoreException {
        if (inputStream == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Reading preferences from stream...");
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_importProblems, iOException));
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        if (((Hashtable)properties).isEmpty()) {
            throw (Throwable)new CoreException(PreferencesService.createStatusError(PrefsMessages.preferences_invalidFileFormat, null));
        }
        if (this.isLegacy(properties)) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Read legacy preferences file, converting to 3.0 format...");
            }
            properties = this.convertFromLegacy(properties);
        } else {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Read preferences file.");
            }
            ((Hashtable)properties).remove(VERSION_KEY);
        }
        return this.convertFromProperties(properties);
    }

    private boolean scopeMatches(String string, IEclipsePreferences iEclipsePreferences) throws  {
        return PreferencesService$$Cold.scopeMatches(this, string, iEclipsePreferences);
    }

    public void setDefaultLookupOrder(String string, String string2, String[] stringArray) {
        String string3 = this.getRegistryKey(string, string2);
        if (stringArray == null) {
            defaultsRegistry.remove(string3);
        } else {
            LookupOrder lookupOrder = new LookupOrder(stringArray);
            defaultsRegistry.put(string3, lookupOrder);
        }
    }

    private IEclipsePreferences trimTree(IEclipsePreferences iEclipsePreferences, IPreferenceFilter iPreferenceFilter) throws BackingStoreException {
        IEclipsePreferences iEclipsePreferences2 = (IEclipsePreferences)ExportedPreferences.newRoot().node(iEclipsePreferences.absolutePath());
        String[] stringArray = iPreferenceFilter.getScopes();
        if (stringArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        String string = iEclipsePreferences.absolutePath();
        int n = 0;
        while (n < stringArray.length) {
            block10: {
                Map map;
                String string2;
                block8: {
                    block9: {
                        string2 = stringArray[n];
                        map = iPreferenceFilter.getMapping(string2);
                        if (map != null) break block8;
                        if (iEclipsePreferences.parent() != null || !iEclipsePreferences.nodeExists(string2)) break block9;
                        this.copyFromTo(iEclipsePreferences.node(string2), iEclipsePreferences2.node(string2), null, -1);
                        break block10;
                    }
                    if (!this.scopeMatches(string2, iEclipsePreferences)) break block10;
                    this.copyFromTo(iEclipsePreferences, iEclipsePreferences2, null, -1);
                    break block10;
                }
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    PreferenceFilterEntry[] preferenceFilterEntryArray;
                    String string3 = (String)iterator.next();
                    String string4 = String.valueOf('/') + string2 + '/' + string3;
                    if (!string4.startsWith(string)) continue;
                    String string5 = string4.substring(string.length());
                    if (!iEclipsePreferences.nodeExists(string5 = EclipsePreferences.makeRelative(string5))) continue;
                    try {
                        preferenceFilterEntryArray = (PreferenceFilterEntry[])map.get(string3);
                    }
                    catch (ClassCastException classCastException) {
                        PreferencesService.log(PreferencesService.createStatusError(PrefsMessages.preferences_classCastFilterEntry, classCastException));
                        continue;
                    }
                    String[] stringArray2 = null;
                    if (preferenceFilterEntryArray != null) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int n2 = 0;
                        while (n2 < preferenceFilterEntryArray.length) {
                            if (preferenceFilterEntryArray[n2] != null) {
                                arrayList.add(preferenceFilterEntryArray[n2].getKey());
                            }
                            ++n2;
                        }
                        stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                    }
                    this.copyFromTo(iEclipsePreferences.node(string5), iEclipsePreferences2.node(string5), stringArray2, stringArray2 == null ? -1 : 0);
                }
            }
            ++n;
        }
        return iEclipsePreferences2;
    }

    IStatus validatePluginVersions(String string, PluginVersionIdentifier pluginVersionIdentifier, PluginVersionIdentifier pluginVersionIdentifier2) throws  {
        return PreferencesService$$Cold.validatePluginVersions(this, string, pluginVersionIdentifier, pluginVersionIdentifier2);
    }

    public IStatus validateVersions(IPath iPath) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.equinox.preferences", 1, PrefsMessages.preferences_validate, null);
        PreferencesService$7 preferencesService$7 = new PreferencesService$7(this, multiStatus);
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(iPath.toFile()));
            IExportedPreferences iExportedPreferences = this.readPreferences(bufferedInputStream);
            iExportedPreferences.accept(preferencesService$7);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CoreException coreException) {
            multiStatus.add(PreferencesService.createStatusError(PrefsMessages.preferences_validationException, (Exception)((Object)coreException)));
        }
        catch (BackingStoreException backingStoreException) {
            multiStatus.add(PreferencesService.createStatusError(PrefsMessages.preferences_validationException, backingStoreException));
        }
        return (IStatus)multiStatus;
    }
}

