/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.InstancePreferences$$Cold;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.service.datalocation.Location;

public class InstancePreferences
extends EclipsePreferences {
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;
    private IPath location;
    private static Set loadedNodes = new HashSet();
    private static boolean initialized = false;
    private static IPath baseLocation;

    public InstancePreferences() {
        this(null, null);
    }

    private InstancePreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        this.initializeChildren();
        String string2 = this.absolutePath();
        this.segmentCount = EclipsePreferences.getSegmentCount(string2);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = EclipsePreferences.getSegment(string2, 1);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (initialized || this.parent == null) {
            return;
        }
        try {
            InstancePreferences instancePreferences = this;
            synchronized (instancePreferences) {
                String[] stringArray = this.computeChildren(InstancePreferences.getBaseLocation());
                int n = 0;
                while (n < stringArray.length) {
                    this.addChild(stringArray[n], null);
                    ++n;
                }
            }
        }
        finally {
            initialized = true;
        }
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new InstancePreferences(eclipsePreferences, string);
    }

    private static IPath getBaseLocation() {
        Location location;
        if (baseLocation == null && (location = PreferencesOSGiUtils.getDefault().getInstanceLocation()) != null && (location.isSet() || location.allowsDefault())) {
            baseLocation = MetaDataKeeper.getMetaArea().getStateLocation("org.eclipse.core.runtime");
        }
        return baseLocation;
    }

    protected void loadLegacy() throws  {
        InstancePreferences$$Cold.loadLegacy(this);
    }

    protected IPath getLocation() {
        if (this.location == null) {
            this.location = this.computeLocation(InstancePreferences.getBaseLocation(), this.qualifier);
        }
        return this.location;
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences iEclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                iEclipsePreferences = (IEclipsePreferences)iEclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = iEclipsePreferences;
        }
        return this.loadLevel;
    }
}

