/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.internal.preferences.EclipsePreferences$$Cold;
import org.eclipse.core.internal.preferences.EclipsePreferences$1;
import org.eclipse.core.internal.preferences.EclipsePreferences$2;
import org.eclipse.core.internal.preferences.ImmutableMap;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.StringPool;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences$INodeChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences$IPreferenceChangeListener;
import org.eclipse.core.runtime.preferences.IEclipsePreferences$NodeChangeEvent;
import org.eclipse.core.runtime.preferences.IEclipsePreferences$PreferenceChangeEvent;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EclipsePreferences
implements IEclipsePreferences,
IScope {
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String PREFS_FILE_EXTENSION = "prefs";
    protected static final IEclipsePreferences[] EMPTY_NODE_ARRAY = new IEclipsePreferences[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected static final String VERSION_KEY = "eclipse.preferences.version";
    protected static final String VERSION_VALUE = "1";
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    protected static final String DOUBLE_SLASH = "//";
    protected static final String EMPTY_STRING = "";
    private String cachedPath;
    protected Map children;
    protected boolean dirty = false;
    protected boolean loading = false;
    protected final String name;
    protected final EclipsePreferences parent;
    protected ImmutableMap properties = ImmutableMap.EMPTY;
    protected boolean removed = false;
    private ListenerList nodeChangeListeners;
    private ListenerList preferenceChangeListeners;
    public static boolean DEBUG_PREFERENCE_GENERAL = false;
    public static boolean DEBUG_PREFERENCE_SET = false;
    public static boolean DEBUG_PREFERENCE_GET = false;
    protected static final String debugPluginName = "org.eclipse.equinox.preferences";

    static {
        DEBUG_PREFERENCE_GENERAL = PreferencesOSGiUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.preferences/general", false);
        DEBUG_PREFERENCE_SET = PreferencesOSGiUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.preferences/set", false);
        DEBUG_PREFERENCE_GET = PreferencesOSGiUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.preferences/get", false);
    }

    public EclipsePreferences() {
        this(null, null);
    }

    protected EclipsePreferences(EclipsePreferences eclipsePreferences, String string) {
        this.parent = eclipsePreferences;
        this.name = string;
    }

    public String absolutePath() {
        if (this.cachedPath == null) {
            String string;
            this.cachedPath = this.parent == null ? PATH_SEPARATOR : ((string = this.parent.absolutePath()).length() == 1 ? String.valueOf(string) + this.name() : String.valueOf(string) + PATH_SEPARATOR + this.name());
        }
        return this.cachedPath;
    }

    protected synchronized IEclipsePreferences addChild(String string, IEclipsePreferences iEclipsePreferences) {
        if (this.children == null) {
            this.children = Collections.synchronizedMap(new HashMap());
        }
        this.children.put(string, iEclipsePreferences == null ? string : iEclipsePreferences);
        return iEclipsePreferences;
    }

    protected void checkRemoved() {
        if (this.removed) {
            throw (Throwable)new IllegalStateException(NLS.bind((String)PrefsMessages.preferences_removedNode, (Object)this.name));
        }
    }

    public String[] childrenNames() {
        this.checkRemoved();
        return this.internalChildNames();
    }

    protected String[] internalChildNames() {
        Map map = this.children;
        if (map == null || map.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return map.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] computeChildren(IPath iPath) {
        if (iPath == null) {
            return EMPTY_STRING_ARRAY;
        }
        IPath iPath2 = iPath.append(DEFAULT_PREFERENCES_DIRNAME);
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = iPath2.toFile();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                String string;
                if (fileArray[n].isFile() && (string = fileArray[n].getName()).endsWith(".prefs")) {
                    String string2 = string.substring(0, string.length() - ".prefs".length());
                    arrayList.add(string2);
                }
                ++n;
            }
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    protected IPath computeLocation(IPath iPath, String string) {
        return iPath == null ? null : iPath.append(DEFAULT_PREFERENCES_DIRNAME).append(string).addFileExtension(PREFS_FILE_EXTENSION);
    }

    protected static void convertFromProperties(EclipsePreferences eclipsePreferences, Properties properties, boolean bl) {
        String string = properties.getProperty(VERSION_KEY);
        if (string != null) {
            VERSION_VALUE.equals(string);
        }
        ((Hashtable)properties).remove(VERSION_KEY);
        Iterator iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            String[] stringArray = EclipsePreferences.decodePath(string2);
            String string4 = stringArray[0];
            string4 = EclipsePreferences.makeRelative(string4);
            String string5 = stringArray[1];
            if (DEBUG_PREFERENCE_SET) {
                PrefsMessages.message("Setting preference: " + string4 + '/' + string5 + '=' + string3);
            }
            EclipsePreferences eclipsePreferences2 = (EclipsePreferences)eclipsePreferences.internalNode(string4, false, null);
            String string6 = eclipsePreferences2.internalPut(string5, string3);
            if (!bl || string3.equals(string6)) continue;
            eclipsePreferences.firePreferenceEvent(string5, string6, string3);
        }
        PreferencesService.getDefault().shareStrings();
    }

    public IEclipsePreferences create(IEclipsePreferences iEclipsePreferences, String string) {
        return this.create((EclipsePreferences)iEclipsePreferences, string, null);
    }

    protected boolean isLoading() {
        return this.loading;
    }

    protected void setLoading(boolean bl) {
        this.loading = bl;
    }

    public IEclipsePreferences create(EclipsePreferences eclipsePreferences, String string, Object object) {
        EclipsePreferences eclipsePreferences2;
        block8: {
            eclipsePreferences2 = this.internalCreate(eclipsePreferences, string, object);
            eclipsePreferences.addChild(string, eclipsePreferences2);
            IEclipsePreferences iEclipsePreferences = eclipsePreferences2.getLoadLevel();
            if (iEclipsePreferences == null) {
                return eclipsePreferences2;
            }
            if (eclipsePreferences2 != iEclipsePreferences) {
                return eclipsePreferences2;
            }
            if (this.isAlreadyLoaded(eclipsePreferences2) || eclipsePreferences2.isLoading()) {
                return eclipsePreferences2;
            }
            try {
                try {
                    eclipsePreferences2.setLoading(true);
                    eclipsePreferences2.loadLegacy();
                    eclipsePreferences2.load();
                    eclipsePreferences2.loaded();
                    eclipsePreferences2.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    IPath iPath = eclipsePreferences2.getLocation();
                    String string2 = NLS.bind((String)PrefsMessages.preferences_loadException, (Object)(iPath == null ? EMPTY_STRING : iPath.toString()));
                    Status status = new Status(4, debugPluginName, 4, string2, (Throwable)backingStoreException);
                    RuntimeLog.log((IStatus)((IStatus)status));
                    eclipsePreferences2.setLoading(false);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                eclipsePreferences2.setLoading(false);
                throw throwable;
            }
            eclipsePreferences2.setLoading(false);
        }
        return eclipsePreferences2;
    }

    public void flush() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences iEclipsePreferences = this.getLoadLevel();
        if (iEclipsePreferences == null) {
            String[] stringArray = this.childrenNames();
            int n = 0;
            while (n < stringArray.length) {
                this.node(stringArray[n]).flush();
                ++n;
            }
            return;
        }
        if (this != iEclipsePreferences) {
            iEclipsePreferences.flush();
            return;
        }
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        try {
            this.save();
        }
        catch (BackingStoreException backingStoreException) {
            this.dirty = true;
            throw (Throwable)backingStoreException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEclipsePreferences getChild(String string, Object object, boolean bl) {
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            block9: {
                Object v;
                block8: {
                    block7: {
                        if (this.children != null) break block7;
                        return null;
                    }
                    v = this.children.get(string);
                    if (v != null) break block8;
                    return null;
                }
                if (v instanceof IEclipsePreferences) {
                    return (IEclipsePreferences)v;
                }
                if (bl) break block9;
                return null;
            }
        }
        return this.addChild(string, this.create(this, string, object));
    }

    protected IEclipsePreferences[] getChildren(boolean bl) {
        ArrayList<IEclipsePreferences> arrayList = new ArrayList<IEclipsePreferences>();
        String[] stringArray = this.internalChildNames();
        int n = 0;
        while (n < stringArray.length) {
            IEclipsePreferences iEclipsePreferences = this.getChild(stringArray[n], null, bl);
            if (iEclipsePreferences != null) {
                arrayList.add(iEclipsePreferences);
            }
            ++n;
        }
        return arrayList.toArray(EMPTY_NODE_ARRAY);
    }

    protected IEclipsePreferences getLoadLevel() {
        return null;
    }

    protected IPath getLocation() {
        return null;
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new EclipsePreferences(eclipsePreferences, string);
    }

    protected IEclipsePreferences internalNode(String string, boolean bl, Object object) {
        this.checkRemoved();
        if (string.length() == 0) {
            return this;
        }
        if (string.charAt(0) == '/') {
            return (IEclipsePreferences)this.calculateRoot().node(string.substring(1));
        }
        int n = string.indexOf(47);
        String string2 = n == -1 ? string : string.substring(0, n);
        boolean bl2 = false;
        IEclipsePreferences iEclipsePreferences = this.getChild(string2, object, true);
        if (iEclipsePreferences == null) {
            iEclipsePreferences = this.create(this, string2, object);
            bl2 = true;
        }
        if (bl2 && bl) {
            this.fireNodeEvent(new IEclipsePreferences$NodeChangeEvent(this, iEclipsePreferences), true);
        }
        return (IEclipsePreferences)iEclipsePreferences.node(n == -1 ? EMPTY_STRING : string.substring(n + 1));
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return true;
    }

    public String[] keys() {
        this.checkRemoved();
        return this.properties.keys();
    }

    protected void load() throws BackingStoreException {
        this.load(this.getLocation());
    }

    protected static Properties loadProperties(IPath iPath) throws BackingStoreException {
        Properties properties;
        block16: {
            if (DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Loading preferences from file: " + iPath);
            }
            BufferedInputStream bufferedInputStream = null;
            properties = new Properties();
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(iPath.toFile()));
                properties.load(bufferedInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (DEBUG_PREFERENCE_GENERAL) {
                    PrefsMessages.message("Preference file does not exist: " + iPath);
                }
                Properties properties2 = properties;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                return properties2;
            }
            catch (IOException iOException) {
                try {
                    String string = NLS.bind((String)PrefsMessages.preferences_loadException, (Object)iPath);
                    EclipsePreferences.log((IStatus)new Status(1, debugPluginName, 1, string, (Throwable)iOException));
                    throw (Throwable)new BackingStoreException(string);
                }
                catch (Throwable throwable) {
                    if (bufferedInputStream != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
            }
            if (bufferedInputStream == null) break block16;
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    protected void load(IPath iPath) throws BackingStoreException {
        if (iPath == null) {
            if (DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Unable to determine location of preference file for node: " + this.absolutePath());
            }
            return;
        }
        Properties properties = EclipsePreferences.loadProperties(iPath);
        EclipsePreferences.convertFromProperties(this, properties, false);
    }

    protected void loaded() {
    }

    protected void loadLegacy() {
    }

    public static void log(IStatus iStatus) {
        RuntimeLog.log((IStatus)iStatus);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String name() {
        return this.name;
    }

    public Preferences node(String string) {
        return this.internalNode(string, true, null);
    }

    protected void fireNodeEvent(IEclipsePreferences$NodeChangeEvent iEclipsePreferences$NodeChangeEvent, boolean bl) {
        if (this.nodeChangeListeners == null) {
            return;
        }
        Object[] objectArray = this.nodeChangeListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            IEclipsePreferences$INodeChangeListener iEclipsePreferences$INodeChangeListener = (IEclipsePreferences$INodeChangeListener)objectArray[n];
            EclipsePreferences$1 eclipsePreferences$1 = new EclipsePreferences$1(this, bl, iEclipsePreferences$INodeChangeListener, iEclipsePreferences$NodeChangeEvent);
            SafeRunner.run((ISafeRunnable)eclipsePreferences$1);
            ++n;
        }
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    protected void save() throws BackingStoreException {
        this.save(this.getLocation());
    }

    public void shareStrings(StringPool stringPool) {
        this.properties.shareStrings(stringPool);
        IEclipsePreferences[] iEclipsePreferencesArray = this.getChildren(false);
        int n = 0;
        while (n < iEclipsePreferencesArray.length) {
            if (iEclipsePreferencesArray[n] instanceof EclipsePreferences) {
                ((EclipsePreferences)iEclipsePreferencesArray[n]).shareStrings(stringPool);
            }
            ++n;
        }
    }

    public static String getSegment(String string, int n) {
        int n2 = string.indexOf(47) == 0 ? 1 : 0;
        int n3 = string.indexOf(47, n2);
        if (n3 == string.length() - 1) {
            n3 = -1;
        }
        int n4 = 0;
        while (n4 < n) {
            if (n3 == -1) {
                return null;
            }
            n2 = n3 + 1;
            n3 = string.indexOf(47, n2);
            ++n4;
        }
        if (n3 == -1) {
            n3 = string.length();
        }
        return string.substring(n2, n3);
    }

    public static int getSegmentCount(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf('/'));
        return stringTokenizer.countTokens();
    }

    public String toString() {
        return this.absolutePath();
    }

    public void accept(IPreferenceNodeVisitor iPreferenceNodeVisitor) throws BackingStoreException {
        EclipsePreferences$$Cold.accept(this, iPreferenceNodeVisitor);
    }

    public void addNodeChangeListener(IEclipsePreferences$INodeChangeListener iEclipsePreferences$INodeChangeListener) {
        this.checkRemoved();
        if (this.nodeChangeListeners == null) {
            this.nodeChangeListeners = new ListenerList();
        }
        this.nodeChangeListeners.add((Object)iEclipsePreferences$INodeChangeListener);
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Added preference node change listener: " + iEclipsePreferences$INodeChangeListener + " to: " + this.absolutePath());
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences$IPreferenceChangeListener iEclipsePreferences$IPreferenceChangeListener) {
        this.checkRemoved();
        if (this.preferenceChangeListeners == null) {
            this.preferenceChangeListeners = new ListenerList();
        }
        this.preferenceChangeListeners.add((Object)iEclipsePreferences$IPreferenceChangeListener);
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Added preference property change listener: " + iEclipsePreferences$IPreferenceChangeListener + " to: " + this.absolutePath());
        }
    }

    private IEclipsePreferences calculateRoot() throws  {
        return EclipsePreferences$$Cold.calculateRoot(this);
    }

    public void clear() throws  {
        EclipsePreferences$$Cold.clear(this);
    }

    protected Properties convertToProperties(Properties properties, String string) throws BackingStoreException {
        return EclipsePreferences$$Cold.convertToProperties(this, properties, string);
    }

    public String get(String string, String string2) throws  {
        return EclipsePreferences$$Cold.get(this, string, string2);
    }

    public boolean getBoolean(String string, boolean bl) throws  {
        return EclipsePreferences$$Cold.getBoolean(this, string, bl);
    }

    public byte[] getByteArray(String string, byte[] byArray) throws  {
        return EclipsePreferences$$Cold.getByteArray(this, string, byArray);
    }

    protected synchronized boolean childExists(String string) throws  {
        return EclipsePreferences$$Cold.childExists(this, string);
    }

    public double getDouble(String string, double d) throws  {
        return EclipsePreferences$$Cold.getDouble(this, string, d);
    }

    public float getFloat(String string, float f) throws  {
        return EclipsePreferences$$Cold.getFloat(this, string, f);
    }

    public int getInt(String string, int n) throws  {
        return EclipsePreferences$$Cold.getInt(this, string, n);
    }

    public long getLong(String string, long l) throws  {
        return EclipsePreferences$$Cold.getLong(this, string, l);
    }

    protected String internalGet(String string) throws  {
        return EclipsePreferences$$Cold.internalGet(this, string);
    }

    protected String internalPut(String string, String string2) throws  {
        return EclipsePreferences$$Cold.internalPut(this, string, string2);
    }

    protected void makeDirty() throws  {
        EclipsePreferences$$Cold.makeDirty(this);
    }

    public boolean nodeExists(String string) throws BackingStoreException {
        boolean bl;
        if (string.length() == 0) {
            return !this.removed;
        }
        this.checkRemoved();
        if (string.charAt(0) == '/') {
            return this.calculateRoot().nodeExists(string.substring(1));
        }
        int n = string.indexOf(47);
        boolean bl2 = bl = n == -1;
        if (bl) {
            return this.childExists(string);
        }
        String string2 = string.substring(0, n);
        if (!this.childExists(string2)) {
            return false;
        }
        IEclipsePreferences iEclipsePreferences = this.getChild(string2, null, true);
        if (iEclipsePreferences == null) {
            return false;
        }
        return iEclipsePreferences.nodeExists(string.substring(n + 1));
    }

    protected void firePreferenceEvent(String string, Object object, Object object2) {
        if (this.preferenceChangeListeners == null) {
            return;
        }
        Object[] objectArray = this.preferenceChangeListeners.getListeners();
        IEclipsePreferences$PreferenceChangeEvent iEclipsePreferences$PreferenceChangeEvent = new IEclipsePreferences$PreferenceChangeEvent(this, string, object, object2);
        int n = 0;
        while (n < objectArray.length) {
            IEclipsePreferences$IPreferenceChangeListener iEclipsePreferences$IPreferenceChangeListener = (IEclipsePreferences$IPreferenceChangeListener)objectArray[n];
            EclipsePreferences$2 eclipsePreferences$2 = new EclipsePreferences$2(this, iEclipsePreferences$IPreferenceChangeListener, iEclipsePreferences$PreferenceChangeEvent);
            SafeRunner.run((ISafeRunnable)eclipsePreferences$2);
            ++n;
        }
    }

    public void put(String string, String string2) throws  {
        EclipsePreferences$$Cold.put(this, string, string2);
    }

    public void putBoolean(String string, boolean bl) throws  {
        EclipsePreferences$$Cold.putBoolean(this, string, bl);
    }

    public void putByteArray(String string, byte[] byArray) throws  {
        EclipsePreferences$$Cold.putByteArray(this, string, byArray);
    }

    public void putDouble(String string, double d) throws  {
        EclipsePreferences$$Cold.putDouble(this, string, d);
    }

    public void putFloat(String string, float f) throws  {
        EclipsePreferences$$Cold.putFloat(this, string, f);
    }

    public void putInt(String string, int n) throws  {
        EclipsePreferences$$Cold.putInt(this, string, n);
    }

    public void putLong(String string, long l) throws  {
        EclipsePreferences$$Cold.putLong(this, string, l);
    }

    public void remove(String string) throws  {
        EclipsePreferences$$Cold.remove(this, string);
    }

    public void removeNode() throws BackingStoreException {
        EclipsePreferences$$Cold.removeNode(this);
    }

    protected void removeNode(IEclipsePreferences iEclipsePreferences) throws  {
        EclipsePreferences$$Cold.removeNode(this, iEclipsePreferences);
    }

    protected void removeNode(String string) throws  {
        EclipsePreferences$$Cold.removeNode(this, string);
    }

    public void removeNodeChangeListener(IEclipsePreferences$INodeChangeListener iEclipsePreferences$INodeChangeListener) {
        this.checkRemoved();
        if (this.nodeChangeListeners == null) {
            return;
        }
        this.nodeChangeListeners.remove((Object)iEclipsePreferences$INodeChangeListener);
        if (this.nodeChangeListeners.size() == 0) {
            this.nodeChangeListeners = null;
        }
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Removed preference node change listener: " + iEclipsePreferences$INodeChangeListener + " from: " + this.absolutePath());
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences$IPreferenceChangeListener iEclipsePreferences$IPreferenceChangeListener) {
        this.checkRemoved();
        if (this.preferenceChangeListeners == null) {
            return;
        }
        this.preferenceChangeListeners.remove((Object)iEclipsePreferences$IPreferenceChangeListener);
        if (this.preferenceChangeListeners.size() == 0) {
            this.preferenceChangeListeners = null;
        }
        if (DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Removed preference property change listener: " + iEclipsePreferences$IPreferenceChangeListener + " from: " + this.absolutePath());
        }
    }

    protected void save(IPath iPath) throws BackingStoreException {
        EclipsePreferences$$Cold.save(this, iPath);
    }

    public static String encodePath(String string, String string2) throws  {
        return EclipsePreferences$$Cold.encodePath(string, string2);
    }

    public static String makeRelative(String string) throws  {
        return EclipsePreferences$$Cold.makeRelative(string);
    }

    public static String[] decodePath(String string) throws  {
        return EclipsePreferences$$Cold.decodePath(string);
    }

    public void sync() throws BackingStoreException {
        EclipsePreferences$$Cold.sync(this);
    }

    public String toDeepDebugString() throws  {
        return EclipsePreferences$$Cold.toDeepDebugString(this);
    }
}

