/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ConfigurationPreferences
extends EclipsePreferences {
    private int segmentCount;
    private String qualifier;
    private IPath location;
    private IEclipsePreferences loadLevel;
    private static Set loadedNodes = new HashSet();
    private static boolean initialized = false;
    private static IPath baseLocation;

    static {
        URL uRL = PreferencesOSGiUtils.getDefault().getConfigurationLocation().getURL();
        if (uRL != null) {
            baseLocation = (IPath)new Path(uRL.getFile());
        }
    }

    public ConfigurationPreferences() {
        this(null, null);
    }

    private ConfigurationPreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        this.initializeChildren();
        String string2 = this.absolutePath();
        this.segmentCount = EclipsePreferences.getSegmentCount(string2);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = EclipsePreferences.getSegment(string2, 1);
        if (this.qualifier == null) {
            return;
        }
        if (baseLocation != null) {
            this.location = this.computeLocation(baseLocation, this.qualifier);
        }
    }

    protected IPath getLocation() {
        return this.location;
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences eclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                eclipsePreferences = (EclipsePreferences)eclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = eclipsePreferences;
        }
        return this.loadLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (initialized || this.parent == null) {
            return;
        }
        try {
            ConfigurationPreferences configurationPreferences = this;
            synchronized (configurationPreferences) {
                block10: {
                    if (baseLocation != null) break block10;
                    return;
                }
                String[] stringArray = this.computeChildren(baseLocation);
                int n = 0;
                while (n < stringArray.length) {
                    this.addChild(stringArray[n], null);
                    ++n;
                }
            }
        }
        finally {
            initialized = true;
        }
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new ConfigurationPreferences(eclipsePreferences, string);
    }
}

