/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal.dao;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class DateParser {
    private static final String[] fgPossibleDateFormats = new String[]{"EEE, dd MMM yy HH:mm:ss z", "EEE, dd MMM yyyy HH:mm:ss z", "EEE, dd MMM yy HH:mm:ss", "EEE, MMM dd yy HH:mm:ss", "MMM dd, yyyy HH:mm:ss a", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:sszzzz", "yyyy-MM-dd'T'HH:mm:ss z", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HHmmss.SSSz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm'Z'", "dd-mm-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss z", "dd MMM yyyy HH:mm:ss", "dd MMM yyyy HH:mm z", "yyyy-MM-dd"};
    private static final SimpleDateFormat[] fgDateFormats = new SimpleDateFormat[fgPossibleDateFormats.length];

    static {
        TimeZone gmtTZ = TimeZone.getTimeZone((String)"GMT");
        int i = 0;
        while (i < fgPossibleDateFormats.length) {
            DateParser.fgDateFormats[i] = new SimpleDateFormat(fgPossibleDateFormats[i], Locale.ENGLISH);
            fgDateFormats[i].setTimeZone(gmtTZ);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Date parseDate(String strdate) {
        if (strdate == null) return null;
        if (strdate.equals("")) {
            return null;
        }
        Date result = null;
        if ((strdate = strdate.trim()).length() > 10) {
            String dateEnd;
            if ((strdate.substring(strdate.length() - 5).indexOf("+") == 0 || strdate.substring(strdate.length() - 5).indexOf("-") == 0) && strdate.substring(strdate.length() - 5).indexOf(":") == 2) {
                String sign = strdate.substring(strdate.length() - 5, strdate.length() - 4);
                strdate = String.valueOf(strdate.substring(0, strdate.length() - 5)) + sign + "0" + strdate.substring(strdate.length() - 4);
            }
            if (!((dateEnd = strdate.substring(strdate.length() - 6)).indexOf("-") != 0 && dateEnd.indexOf("+") != 0 || dateEnd.indexOf(":") != 3 || "GMT".equals(strdate.substring(strdate.length() - 9, strdate.length() - 6)))) {
                String oldDate = strdate;
                String newEnd = String.valueOf(dateEnd.substring(0, 3)) + dateEnd.substring(4);
                strdate = String.valueOf(oldDate.substring(0, oldDate.length() - 6)) + newEnd;
            }
        }
        int i = 0;
        boolean wasException = false;
        Class<DateParser> clazz = DateParser.class;
        synchronized (DateParser.class) {
            while (true) {
                if (i >= fgDateFormats.length) {
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return result;
                }
                try {
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return fgDateFormats[i].parse(strdate);
                }
                catch (ParseException parseException) {
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException e) {
                    if (wasException) throw new RuntimeException(e);
                    DateParser.fgDateFormats[i] = new SimpleDateFormat(fgPossibleDateFormats[i], Locale.ENGLISH);
                    fgDateFormats[i].setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                    wasException = true;
                    continue;
                }
                ++i;
            }
        }
    }
}

