/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal.dao;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.feed.core.internal.FeedCorePlugin;
import com.ibm.team.feed.core.internal.dao.Messages;
import com.ibm.team.foundation.common.util.Adapters;
import com.ibm.team.foundation.rcp.core.IAuthenticatorChecker;
import com.ibm.team.repository.client.util.FormBasedAuth;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.Platform;

public class ConnectionManager {
    private static final Map<Object, String> ETAG_CACHE = new HashMap<Object, String>();
    private static final String HTTP_STATUS_NOT_MODIFIED = "304";
    private static final Map<Object, String> LAST_MODIFIED_CACHE = new HashMap<Object, String>();
    static final InputStream NOT_MODIFIED_SINCE = new InputStream(){

        public int read() {
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheConditionalGet(String channelUrl, String eTag, String lastModified) {
        Map<Object, String> map;
        if (eTag != null) {
            map = ETAG_CACHE;
            synchronized (map) {
                ETAG_CACHE.put(channelUrl, eTag);
            }
        }
        if (lastModified != null) {
            map = LAST_MODIFIED_CACHE;
            synchronized (map) {
                LAST_MODIFIED_CACHE.put(channelUrl, lastModified);
            }
        }
    }

    private static void cacheConditionalGet(String channelUrl, URLConnection urlCon) {
        String lastModified = null;
        String eTag = null;
        if (urlCon.getHeaderField("Last-Modified") != null) {
            lastModified = urlCon.getHeaderField("Last-Modified");
        }
        if (urlCon.getHeaderField("ETag") != null) {
            eTag = urlCon.getHeaderField("ETag");
        }
        ConnectionManager.cacheConditionalGet(channelUrl, eTag, lastModified);
    }

    private static InputStream compressConnection(URLConnection urlCon, InputStream inputStream) throws IOException {
        String contentEncoding = urlCon.getHeaderField("Content-Encoding") != null ? urlCon.getHeaderField("Content-Encoding") : null;
        boolean isGzipStream = false;
        if (!(contentEncoding != null && contentEncoding.equals("gzip") || inputStream != null && inputStream.markSupported())) {
            return inputStream;
        }
        if (contentEncoding != null && contentEncoding.equals("gzip")) {
            isGzipStream = true;
        } else if (inputStream != null && inputStream.markSupported()) {
            inputStream.mark(2);
            int id1 = inputStream.read();
            int id2 = inputStream.read();
            inputStream.reset();
            if (id1 == 31 && id2 == 139) {
                isGzipStream = true;
            }
        }
        if (isGzipStream) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static String getETag(String channelUrl) {
        if (ETAG_CACHE.containsKey(channelUrl)) {
            return ETAG_CACHE.get(channelUrl);
        }
        return null;
    }

    public static InputStream getInputStream(String channelUrl, String requestUrl) throws IOException {
        URL urlObj = new URL(requestUrl);
        IAuthenticatorChecker adapter = (IAuthenticatorChecker)Adapters.getAdapter((Object)urlObj, IAuthenticatorChecker.class);
        if (adapter != null) {
            adapter.ensureAuthenticatorRegistered();
        }
        URLConnection urlCon = urlObj.openConnection();
        ConnectionManager.setupLazySSLSupport(urlCon);
        ConnectionManager.setHeaders(channelUrl, urlCon);
        try {
            URLConnection newCon = FormBasedAuth.handleFormBasedAuthentication((URLConnection)urlCon, (String)requestUrl);
            if (newCon != null) {
                urlCon = newCon;
                ConnectionManager.setupLazySSLSupport(urlCon);
                ConnectionManager.setHeaders(channelUrl, urlCon);
            }
        }
        catch (IOException x) {
            throw x;
        }
        catch (Exception x) {
            FeedCorePlugin.getDefault().log("Authentication failed", x);
            String errorMessage = Messages.ConnectionManager_AUTHENTICATION_REQUIRED;
            throw new IOException(MessageFormat.format((String)errorMessage, (Object[])new String[]{requestUrl}));
        }
        ConnectionManager.cacheConditionalGet(channelUrl, urlCon);
        boolean disableConditionalGet = Boolean.valueOf(Platform.getDebugOption((String)"com.ibm.team.feed.core/disableConditionalGet"));
        if (!disableConditionalGet && urlCon.getHeaderField(0) != null && urlCon.getHeaderField(0).indexOf(HTTP_STATUS_NOT_MODIFIED) >= 0) {
            return NOT_MODIFIED_SINCE;
        }
        return ConnectionManager.compressConnection(urlCon, urlCon.getInputStream());
    }

    public static String getLastModified(String channelUrl) {
        if (LAST_MODIFIED_CACHE.containsKey(channelUrl)) {
            return LAST_MODIFIED_CACHE.get(channelUrl);
        }
        return null;
    }

    private static void setHeaders(String channelUrl, URLConnection urlCon) {
        urlCon.setRequestProperty("Accept-Encoding", "gzip, *");
        if (LAST_MODIFIED_CACHE.containsKey(channelUrl)) {
            urlCon.setRequestProperty("If-Modified-Since", ConnectionManager.getLastModified(channelUrl));
        }
        if (ETAG_CACHE.containsKey(channelUrl)) {
            urlCon.setRequestProperty("If-None-Match", ConnectionManager.getETag(channelUrl));
        }
    }

    public static void setupLazySSLSupport(URLConnection urlConnection) {
        if (!(urlConnection instanceof HttpsURLConnection)) {
            return;
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String urlHostname, SSLSession sslSession) {
                return true;
            }
        };
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {}
        if (sc != null) {
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sc.getSocketFactory());
        }
        ((HttpsURLConnection)urlConnection).setHostnameVerifier(hv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncacheConditionalGet(String channelUrl) {
        Map<Object, String> map = LAST_MODIFIED_CACHE;
        synchronized (map) {
            LAST_MODIFIED_CACHE.remove(channelUrl);
        }
        map = ETAG_CACHE;
        synchronized (map) {
            ETAG_CACHE.remove(channelUrl);
        }
    }
}

