/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.core.internal;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.internal.Feed;
import com.ibm.team.feed.core.internal.FeedCorePlugin;
import com.ibm.team.feed.core.internal.Messages;
import com.ibm.team.feed.core.internal.NewsItem;
import com.ibm.team.feed.core.internal.dao.FeedCreator;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.xml.sax.SAXException;

public class LoadManager {
    private static final String MESSAGE_DETAIL = Messages.LoadManager_DETAIL;
    public static final String MESSAGE_IO_ERROR = Messages.LoadManager_UNABLE_CONNECT;
    public static final String MESSAGE_FEED_PARSE_ERROR = Messages.LoadManager_UNABLE_INTERPRET;
    public static final String MESSAGE_MALFORMED_URL = Messages.LoadManager_INVALID_LINK;
    public static final String MESSAGE_AUTHENTICATION_ERROR = Messages.LoadManager_AUTH_REQUIRED;
    private static final Object ALL_CHANNELS_FAMILIY = new Object();
    private static final int MAX_JOBS = 3;
    private final FeedManager fNewsManager;
    private final Object fLock = new Object();
    private int fRunningJobs;
    private final Map<Channel, FeedCreator> fChannelToFeedParser = new HashMap<Channel, FeedCreator>();
    private final INewsManagerListener fNewsMgrListener = new INewsManagerListener(){

        public void channelAdded(ChannelEvent event) {
        }

        public void channelRemoved(ChannelEvent event) {
            Channel channel = event.getChannel();
            LoadManager.this.cancelChannel(channel);
        }
    };

    public LoadManager(FeedManager newsManager) {
        this.fNewsManager = newsManager;
        this.fNewsManager.addNewsManagerListener(this.fNewsMgrListener);
    }

    public void cancelChannel(Channel channel) {
        Job.getJobManager().cancel((Object)channel);
        this.fChannelToFeedParser.remove(channel);
    }

    public void loadChannel(final Channel channel) {
        Job.getJobManager().cancel((Object)channel);
        FoundationJob job = new FoundationJob(NLS.bind((String)Messages.LoadManager_LOADING_NEWS_FROM, (Object[])new Object[]{channel.getTitle()})){

            public boolean belongsTo(Object family) {
                return channel.equals(family) || family == ALL_CHANNELS_FAMILIY;
            }

            public IStatus runProtected(IProgressMonitor monitor) {
                IStatus status;
                channel.setIsLoading(true);
                FeedManager.getDefault().fireChannelStatusChangedEvent(new ChannelEvent(channel, true));
                try {
                    monitor.beginTask("", -1);
                    this.download(monitor);
                }
                finally {
                    monitor.done();
                }
                if (monitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                } else {
                    if (channel.getUpdateInterval() > 0) {
                        this.schedule(channel.getUpdateInterval() * 1000 * 60);
                    } else if (channel.getUpdateInterval() < 0) {
                        this.schedule(channel.getUpdateInterval() * -1 * 1000);
                    }
                    status = Status.OK_STATUS;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                channel.setIsLoading(false);
                FeedManager.getDefault().fireChannelStatusChangedEvent(new ChannelEvent(channel, true));
                return status;
            }

            public void download(IProgressMonitor monitor) {
                block14: {
                    Date now = new Date();
                    try {
                        FeedCreator feedParser = (FeedCreator)LoadManager.this.fChannelToFeedParser.get(channel);
                        if (feedParser == null) {
                            feedParser = new FeedCreator(channel);
                            LoadManager.this.fChannelToFeedParser.put(channel, feedParser);
                        }
                        Feed loadedFeed = feedParser.parseFeed(monitor);
                        if (channel.getTitle() == null || channel.getTitle().length() == 0 || Messages.LoadManager_NO_TITLE.equals(channel.getTitle()) || Messages.LoadManager_LOADING.equals(channel.getTitle())) {
                            channel.setTitle(loadedFeed.getTitle());
                            FeedManager.getDefault().fireChannelEditedEvent(new ChannelEvent(channel, true));
                        }
                        Map customFieldsOfFeed = channel.getCustomFields();
                        customFieldsOfFeed.clear();
                        if (loadedFeed.getCustomFields() != null) {
                            customFieldsOfFeed.putAll(loadedFeed.getCustomFields());
                        }
                        NewsItem[] loadedNewsItems = loadedFeed.getItems();
                        com.ibm.team.feed.core.model.NewsItem[] items = new com.ibm.team.feed.core.model.NewsItem[loadedNewsItems.length];
                        int a = 0;
                        while (a < loadedNewsItems.length) {
                            com.ibm.team.feed.core.model.NewsItem newEMFItem = FeedFactory.eINSTANCE.createNewsItem();
                            newEMFItem.setTitle(loadedNewsItems[a].getTitle());
                            newEMFItem.setLink(loadedNewsItems[a].getLink());
                            newEMFItem.setDescription(loadedNewsItems[a].getDescription());
                            newEMFItem.setGuid(loadedNewsItems[a].getGuid());
                            newEMFItem.setReceiveDate(now);
                            if (loadedNewsItems[a].getPublishDate() != null) {
                                newEMFItem.setPublishDate(loadedNewsItems[a].getPublishDate());
                            } else {
                                newEMFItem.setPublishDate(now);
                            }
                            if (loadedNewsItems[a].getCategory() != null) {
                                newEMFItem.setCategory(loadedNewsItems[a].getCategory());
                            } else {
                                newEMFItem.setCategory("Unknown");
                            }
                            Map customFieldsOfItem = newEMFItem.getCustomFields();
                            customFieldsOfItem.clear();
                            Map newCustomFieldsOfItem = loadedNewsItems[a].getCustomFields();
                            if (newCustomFieldsOfItem != null) {
                                customFieldsOfItem.putAll(newCustomFieldsOfItem);
                            }
                            items[a] = newEMFItem;
                            ++a;
                        }
                        LoadManager.this.fNewsManager.addNews(channel, items);
                        boolean errorCleared = channel.getLastError() != null;
                        channel.setLastError(null);
                        if (errorCleared) {
                            LoadManager.this.fNewsManager.fireChannelStatusChangedEvent(new ChannelEvent(channel));
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            FeedCorePlugin.getDefault().log(e);
                        }
                        if (channel.getTitle() == null || channel.getTitle().length() == 0 || Messages.LoadManager_LOADING.equals(channel.getTitle())) {
                            channel.setTitle(Messages.LoadManager_NO_TITLE);
                            FeedManager.getDefault().fireChannelEditedEvent(new ChannelEvent(channel, true));
                        }
                        String message = LoadManager.this.formatException(e);
                        String lastError = channel.getLastError();
                        boolean newError = lastError == null || !lastError.equals(message);
                        channel.setLastError(message);
                        if (!newError) break block14;
                        LoadManager.this.fNewsManager.fireChannelStatusChangedEvent(new ChannelEvent(channel));
                    }
                }
            }
        };
        job.setRule((ISchedulingRule)new BoundedSchedulingRule());
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
            private boolean fRunning = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = LoadManager.this.fLock;
                synchronized (object) {
                    if (this.fRunning) {
                        LoadManager loadManager = LoadManager.this;
                        loadManager.fRunningJobs = loadManager.fRunningJobs - 1;
                    }
                    this.fRunning = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void running(IJobChangeEvent event) {
                Object object = LoadManager.this.fLock;
                synchronized (object) {
                    if (!this.fRunning) {
                        LoadManager loadManager = LoadManager.this;
                        loadManager.fRunningJobs = loadManager.fRunningJobs + 1;
                    }
                    this.fRunning = true;
                }
            }
        });
        job.setSystem(true);
        job.schedule();
    }

    private String formatException(Exception e) {
        String message = "";
        message = e.getCause() != null && e.getCause().getMessage() != null ? e.getCause().getMessage() : (e.getMessage() != null ? e.getMessage() : (e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.toString()));
        if (message.indexOf("401") > 0) {
            return NLS.bind((String)"{0}<br><br>{1}{2}", (Object[])new Object[]{MESSAGE_AUTHENTICATION_ERROR, MESSAGE_DETAIL, message});
        }
        if (e instanceof MalformedURLException) {
            return NLS.bind((String)"{0}<br><br>{1}{2}", (Object[])new Object[]{MESSAGE_MALFORMED_URL, MESSAGE_DETAIL, message});
        }
        if (e instanceof SAXException) {
            return NLS.bind((String)"{0}<br><br>{1}{2}", (Object[])new Object[]{MESSAGE_FEED_PARSE_ERROR, MESSAGE_DETAIL, message});
        }
        if (e instanceof IOException) {
            return NLS.bind((String)"{0}<br><br>{1}{2}", (Object[])new Object[]{MESSAGE_IO_ERROR, MESSAGE_DETAIL, message});
        }
        return message;
    }

    public void dispose() {
        Job.getJobManager().cancel(ALL_CHANNELS_FAMILIY);
        FeedManager.getDefault().removeNewsManagerListener(this.fNewsMgrListener);
        this.fChannelToFeedParser.clear();
        try {
            long timeout = System.currentTimeMillis() + 4000L;
            while (System.currentTimeMillis() < timeout && Job.getJobManager().find(ALL_CHANNELS_FAMILIY).length > 0) {
                Thread.sleep(100L);
            }
        }
        catch (OperationCanceledException e) {
            FeedCorePlugin.getDefault().log(e);
        }
        catch (InterruptedException e) {
            FeedCorePlugin.getDefault().log(e);
        }
    }

    private class BoundedSchedulingRule
    implements ISchedulingRule {
        private BoundedSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isConflicting(ISchedulingRule rule) {
            if (rule == this) {
                return true;
            }
            if (!(rule instanceof BoundedSchedulingRule)) {
                return false;
            }
            Object object = LoadManager.this.fLock;
            synchronized (object) {
                return LoadManager.this.fRunningJobs >= 3;
            }
        }
    }
}

